/*
 * Decompiled with CFR 0.152.
 */
package org.myworldgis.util;

import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.Proxy;
import java.net.ProxySelector;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.List;
import org.apache.commons.httpclient.HostConfiguration;
import org.apache.commons.httpclient.HttpClient;
import org.apache.commons.httpclient.HttpConnectionManager;
import org.apache.commons.httpclient.HttpMethod;
import org.apache.commons.httpclient.HttpStatus;
import org.apache.commons.httpclient.MultiThreadedHttpConnectionManager;
import org.apache.commons.httpclient.params.HttpClientParams;

public final class HttpClientManager {
    private static HttpClientManager _instance = null;
    private HttpConnectionManager _connectionManager = new MultiThreadedHttpConnectionManager();
    private HttpClient _client = new HttpClient(this._connectionManager);

    public static HttpClientManager getInstance() {
        if (_instance == null) {
            _instance = new HttpClientManager("NetLogo GIS Extension");
        }
        return _instance;
    }

    public static String errorMsg(int statusCode, String url) {
        StringBuilder result = new StringBuilder();
        result.append("http result code ");
        result.append(statusCode);
        result.append(" (");
        result.append(HttpStatus.getStatusText((int)statusCode));
        result.append(")");
        if (url != null) {
            result.append(" (URL: ");
            result.append(url);
            result.append(")");
        }
        return result.toString();
    }

    private HttpClientManager(String userAgent) {
        HttpClientParams params = this._client.getParams();
        params.setParameter("http.socket.timeout", (Object)new Integer(30000));
        params.setParameter("http.protocol.allow-circular-redirects", (Object)Boolean.TRUE);
        params.setParameter("http.protocol.cookie-policy", (Object)"rfc2109");
        params.setParameter("http.useragent", (Object)(userAgent + "/HttpClientManager"));
        this._client.setParams(params);
    }

    public int execute(HttpMethod method) throws IOException {
        try {
            URI requestURI = new URI(method.getURI().getURI());
            List<Proxy> proxies = ProxySelector.getDefault().select(requestURI);
            if (proxies.size() == 0) {
                return this._client.executeMethod(method);
            }
            IOException exception = null;
            for (int i = 0; i < proxies.size(); ++i) {
                HostConfiguration hc = new HostConfiguration();
                InetSocketAddress addr = (InetSocketAddress)proxies.get(i).address();
                if (addr != null) {
                    hc.setProxy(addr.getHostName(), addr.getPort());
                }
                try {
                    return this._client.executeMethod(hc, method);
                }
                catch (IOException e) {
                    if (addr != null) {
                        ProxySelector.getDefault().connectFailed(requestURI, addr, e);
                    }
                    exception = e;
                    continue;
                }
            }
            throw exception;
        }
        catch (URISyntaxException e) {
            IOException ex = new IOException("error parsing uri: " + method.getURI().getURI());
            ex.initCause(e);
            throw ex;
        }
    }
}

