/*
 * Decompiled with CFR 0.152.
 */
package org.myworldgis.util;

import com.vividsolutions.jts.geom.Envelope;
import java.awt.Dimension;
import org.myworldgis.util.URLBuilder;

public class WMSUtils {
    public static String makeGetMapURL(String serverURL, Envelope viewBounds, Dimension pixelDimensions, String srs, String layers, ImageFormat imageFormat) {
        URLBuilder url = new URLBuilder(serverURL);
        url.setParameter("Service", "wms");
        url.setParameter("Version", "1.1.1");
        url.setParameter("Request", "GetMap");
        url.setParameter("SRS", srs);
        url.setParameter("Layers", layers);
        url.setParameter("BBOX", viewBounds);
        url.setParameter("Width", Integer.toString(Math.min(Math.max(pixelDimensions.width, 50), 2000)));
        url.setParameter("Height", Integer.toString(Math.min(Math.max(pixelDimensions.height, 50), 2000)));
        url.setParameter("Format", imageFormat.mimeType());
        url.setParameter("Styles", "");
        url.setParameter("Transparent", "TRUE");
        return url.toString();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum ImageFormat {
        JPEG("image/jpeg"),
        PNG("image/png"),
        GIF("image/gif");

        private final String _mimeType;

        private ImageFormat(String mimeType) {
            this._mimeType = mimeType;
        }

        public String mimeType() {
            return this._mimeType;
        }
    }
}

