/*
 * Decompiled with CFR 0.152.
 */
package org.myworldgis.wkt;

import java.text.ParseException;
import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public strictfp final class WKTElement {
    private final String _keyword;
    private List<Object> _contents;

    public WKTElement(String keyword) {
        this._keyword = keyword.toUpperCase();
        this._contents = new LinkedList<Object>();
    }

    public WKTElement(String keyword, List<Object> contents) {
        this._keyword = keyword.toUpperCase();
        this._contents = contents;
    }

    public WKTElement(String keyword, Object ... contents) {
        this._keyword = keyword.toUpperCase();
        this._contents = Arrays.asList(contents);
    }

    public String getKeyword() {
        return this._keyword;
    }

    public void addContent(Object newContent) {
        this._contents.add(newContent);
    }

    public Iterator<Object> iterator() {
        return Collections.unmodifiableCollection(this._contents).iterator();
    }

    public Number nextNumber(boolean required) throws ParseException {
        Iterator<Object> iterator = this._contents.iterator();
        while (iterator.hasNext()) {
            Object object = iterator.next();
            if (!(object instanceof Number)) continue;
            iterator.remove();
            return (Number)object;
        }
        if (required) {
            throw new ParseException("missing required number parameter", 0);
        }
        return null;
    }

    public String nextString(boolean required) throws ParseException {
        Iterator<Object> iterator = this._contents.iterator();
        while (iterator.hasNext()) {
            Object object = iterator.next();
            if (!(object instanceof String)) continue;
            iterator.remove();
            return (String)object;
        }
        if (required) {
            throw new ParseException("missing required string parameter", 0);
        }
        return null;
    }

    public WKTElement nextElement(String key, boolean required) throws ParseException {
        Iterator<Object> iterator = this._contents.iterator();
        while (iterator.hasNext()) {
            Object object = iterator.next();
            if (!(object instanceof WKTElement)) continue;
            WKTElement element = (WKTElement)object;
            if (element._contents == null || !element._keyword.equals(key)) continue;
            iterator.remove();
            return element;
        }
        if (required) {
            throw new ParseException("missing required element '" + key + "'", 0);
        }
        return null;
    }
}

