/*
 * Decompiled with CFR 0.152.
 */
package org.myworldgis.wkt;

import java.text.DecimalFormat;
import java.text.FieldPosition;
import java.text.Format;
import java.text.NumberFormat;
import java.text.ParseException;
import java.text.ParsePosition;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Locale;
import org.myworldgis.wkt.WKTElement;

public strictfp final class WKTFormat
extends Format {
    public static final NumberFormat NUMBER_FORMAT;
    static final long serialVersionUID = 1L;
    private static final WKTFormat _instance;
    private static final String OPEN_BRACKETS = "[(";
    private static final String QUOTE = "\"";
    private static final String CLOSE_BRACKETS = "])";
    private static final String SEPARATORS;

    public static WKTFormat getInstance() {
        return _instance;
    }

    private static int parseOptionalSeparator(String text, ParsePosition position, String separators) {
        int index;
        int length = text.length();
        for (index = position.getIndex(); index < length && Character.isWhitespace(text.charAt(index)); ++index) {
        }
        int separatorIndex = separators.indexOf(text.charAt(index));
        if (separatorIndex >= 0) {
            ++index;
        }
        position.setIndex(index);
        return separatorIndex;
    }

    public String formatWKT(WKTElement wkt) {
        StringBuffer str = new StringBuffer();
        str.append(wkt.getKeyword());
        Iterator<Object> iterator = wkt.iterator();
        if (iterator.hasNext()) {
            str.append(OPEN_BRACKETS.charAt(0));
            while (iterator.hasNext()) {
                Object obj = iterator.next();
                if (obj instanceof WKTElement) {
                    str.append(this.formatWKT((WKTElement)obj));
                } else if (obj instanceof String) {
                    str.append(QUOTE);
                    str.append((String)obj);
                    str.append(QUOTE);
                } else if (obj instanceof Number) {
                    NUMBER_FORMAT.format(obj, str, new FieldPosition(0));
                } else {
                    throw new IllegalArgumentException("unexpected type " + obj.getClass().getName());
                }
                if (!iterator.hasNext()) continue;
                str.append(SEPARATORS.charAt(0));
            }
            str.append(CLOSE_BRACKETS.charAt(0));
        }
        return str.toString();
    }

    public WKTElement parseWKT(String text, ParsePosition pos) throws ParseException {
        int keywordEnd;
        int keywordStart;
        int length = text.length();
        for (keywordStart = pos.getIndex(); keywordStart < length && Character.isWhitespace(text.charAt(keywordStart)); ++keywordStart) {
        }
        for (keywordEnd = keywordStart; keywordEnd < length && Character.isUnicodeIdentifierPart(text.charAt(keywordEnd)); ++keywordEnd) {
        }
        if (keywordEnd <= keywordStart) {
            throw new ParseException("empty keyword", keywordStart);
        }
        String keyword = text.substring(keywordStart, keywordEnd);
        pos.setIndex(keywordEnd);
        int openBracketType = WKTFormat.parseOptionalSeparator(text, pos, OPEN_BRACKETS);
        if (openBracketType < 0) {
            return new WKTElement(keyword);
        }
        LinkedList<Object> contents = new LinkedList<Object>();
        do {
            if (pos.getIndex() >= length) {
                throw new ParseException("unexpected end of input", length);
            }
            if (WKTFormat.parseOptionalSeparator(text, pos, QUOTE) >= 0) {
                int stringBegin = pos.getIndex();
                int stringEnd = text.indexOf(QUOTE, stringBegin);
                if (stringEnd <= stringBegin) {
                    throw new ParseException("expected closing quote", pos.getIndex());
                }
                contents.add(text.substring(stringBegin, stringEnd));
                pos.setIndex(stringEnd + 1);
                continue;
            }
            int numberBegin = pos.getIndex();
            if (!Character.isUnicodeIdentifierStart(text.charAt(numberBegin))) {
                Number number = NUMBER_FORMAT.parse(text, pos);
                if (number == null) {
                    throw new ParseException("unparseable number", pos.getErrorIndex());
                }
                contents.add(number);
                continue;
            }
            contents.add(this.parseWKT(text, pos));
        } while (WKTFormat.parseOptionalSeparator(text, pos, SEPARATORS) >= 0);
        int closeBracketType = WKTFormat.parseOptionalSeparator(text, pos, CLOSE_BRACKETS);
        if (closeBracketType == openBracketType) {
            return new WKTElement(keyword, contents);
        }
        throw new ParseException("invalid close bracket at position " + pos.getIndex() + " of '" + text + "'", pos.getIndex());
    }

    public StringBuffer format(Object obj, StringBuffer buf, FieldPosition pos) {
        buf.append(this.formatWKT((WKTElement)obj));
        return buf;
    }

    public Object parseObject(String str, ParsePosition pos) {
        try {
            return this.parseWKT(str, pos);
        }
        catch (ParseException e) {
            pos.setIndex(0);
            pos.setErrorIndex(e.getErrorOffset());
            return null;
        }
    }

    static {
        char decimalSeparator;
        NUMBER_FORMAT = NumberFormat.getInstance(Locale.US);
        NUMBER_FORMAT.setGroupingUsed(false);
        NUMBER_FORMAT.setMinimumFractionDigits(1);
        NUMBER_FORMAT.setMaximumFractionDigits(12);
        _instance = new WKTFormat();
        NumberFormat nf = NumberFormat.getInstance();
        SEPARATORS = nf instanceof DecimalFormat ? ((decimalSeparator = ((DecimalFormat)nf).getDecimalFormatSymbols().getDecimalSeparator()) == ',' ? ";," : ",;") : ",;";
    }
}

