/*
 * Decompiled with CFR 0.152.
 */
package org.nlogo.extensions.profiler;

import java.io.ByteArrayOutputStream;
import java.io.PrintStream;
import org.nlogo.api.Argument;
import org.nlogo.api.Context;
import org.nlogo.api.DefaultClassManager;
import org.nlogo.api.DefaultCommand;
import org.nlogo.api.DefaultReporter;
import org.nlogo.api.ExtensionException;
import org.nlogo.api.ExtensionManager;
import org.nlogo.api.LogoException;
import org.nlogo.api.Primitive;
import org.nlogo.api.PrimitiveManager;
import org.nlogo.api.Syntax;
import org.nlogo.api.Version;
import org.nlogo.extensions.profiler.QuickTracer;
import org.nlogo.nvm.ExtensionContext;
import org.nlogo.nvm.Tracer;

public class ProfilerExtension
extends DefaultClassManager {
    public void load(PrimitiveManager primManager) {
        primManager.addPrimitive("start", (Primitive)new ProfilerStart());
        primManager.addPrimitive("stop", (Primitive)new ProfilerStop());
        primManager.addPrimitive("reset", (Primitive)new ProfilerReset());
        primManager.addPrimitive("report", (Primitive)new ProfilerReport());
        primManager.addPrimitive("calls", (Primitive)new ProfilerProcedureCalls());
        primManager.addPrimitive("exclusive-time", (Primitive)new ProfilerProcedureExclusiveTime());
        primManager.addPrimitive("inclusive-time", (Primitive)new ProfilerProcedureInclusiveTime());
    }

    public void runOnce(ExtensionManager em) throws ExtensionException {
        QuickTracer tracer = new QuickTracer();
        ((org.nlogo.workspace.ExtensionManager)em).workspace().setProfilingTracer((Tracer)tracer);
        tracer.disable();
    }

    public void unload(ExtensionManager em) {
        ((org.nlogo.workspace.ExtensionManager)em).workspace().setProfilingTracer(null);
    }

    public static class ProfilerProcedureInclusiveTime
    extends DefaultReporter {
        public Syntax getSyntax() {
            return Syntax.reporterSyntax((int[])new int[]{Syntax.StringType()}, (int)Syntax.NumberType());
        }

        public Object report(Argument[] args, Context context) throws ExtensionException, LogoException {
            Tracer tracer = ((ExtensionContext)context).workspace().profilingTracer();
            if (tracer != null) {
                String arg0 = args[0].getString().toUpperCase();
                return (double)tracer.inclusiveTime(arg0) / 1000000.0;
            }
            return 0.0;
        }
    }

    public static class ProfilerProcedureExclusiveTime
    extends DefaultReporter {
        public Syntax getSyntax() {
            return Syntax.reporterSyntax((int[])new int[]{Syntax.StringType()}, (int)Syntax.NumberType());
        }

        public Object report(Argument[] args, Context context) throws ExtensionException, LogoException {
            Tracer tracer = ((ExtensionContext)context).workspace().profilingTracer();
            if (tracer != null) {
                String arg0 = args[0].getString().toUpperCase();
                return (double)tracer.exclusiveTime(arg0) / 1000000.0;
            }
            return 0.0;
        }
    }

    public static class ProfilerProcedureCalls
    extends DefaultReporter {
        public Syntax getSyntax() {
            return Syntax.reporterSyntax((int[])new int[]{Syntax.StringType()}, (int)Syntax.NumberType());
        }

        public Object report(Argument[] args, Context context) throws ExtensionException, LogoException {
            Tracer tracer = ((ExtensionContext)context).workspace().profilingTracer();
            if (tracer != null) {
                String arg0 = args[0].getString().toUpperCase();
                return (double)tracer.calls(arg0);
            }
            return 0.0;
        }
    }

    public static class ProfilerReport
    extends DefaultReporter {
        public Syntax getSyntax() {
            return Syntax.reporterSyntax((int)Syntax.ListType());
        }

        public Object report(Argument[] args, Context context) throws ExtensionException {
            Tracer tracer = ((ExtensionContext)context).workspace().profilingTracer();
            if (tracer != null) {
                ByteArrayOutputStream outArray = new ByteArrayOutputStream();
                PrintStream out = new PrintStream(outArray);
                tracer.dump(out);
                return outArray.toString();
            }
            return "";
        }
    }

    public static class ProfilerReset
    extends DefaultCommand {
        public Syntax getSyntax() {
            return Syntax.commandSyntax();
        }

        public void perform(Argument[] args, Context context) throws ExtensionException {
            Tracer tracer = ((ExtensionContext)context).workspace().profilingTracer();
            if (tracer != null) {
                tracer.reset();
            }
        }
    }

    public static class ProfilerStop
    extends DefaultCommand {
        public Syntax getSyntax() {
            return Syntax.commandSyntax();
        }

        public void perform(Argument[] args, Context context) throws ExtensionException {
            Tracer tracer = ((ExtensionContext)context).workspace().profilingTracer();
            if (tracer != null) {
                tracer.disable();
            }
        }
    }

    public static class ProfilerStart
    extends DefaultCommand {
        public Syntax getSyntax() {
            return Syntax.commandSyntax();
        }

        public void perform(Argument[] args, Context context) throws ExtensionException {
            if (!Version.useGenerator()) {
                throw new ExtensionException("The profiler extension requires the NetLogo bytecode generator, which is currently turned off. See the org.nlogo.noGenerator property.");
            }
            ((ExtensionContext)context).workspace().profilingTracer().enable();
        }
    }
}

