/*
 * Decompiled with CFR 0.152.
 */
package org.nlogo.extensions.profiler;

import java.io.PrintStream;
import java.util.Comparator;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Map;
import java.util.TreeSet;
import java.util.Vector;
import org.nlogo.extensions.profiler.CallRecord;
import org.nlogo.extensions.profiler.ProcedureCallRecord;
import org.nlogo.nvm.Activation;
import org.nlogo.nvm.Context;
import org.nlogo.nvm.Tracer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ProfilingTracer
extends Tracer {
    public boolean enabled = true;
    public Hashtable<String, Long> inclusiveTimes;
    public Hashtable<String, Long> exclusiveTimes;
    public Hashtable<String, Long> callCounts;
    private Hashtable<Activation, CallRecord> openRecords;
    private Vector callRoots;

    public ProfilingTracer() {
        this.reset();
    }

    public void openCallRecord(Context context, Activation activation) {
        if (!this.enabled) {
            return;
        }
        long startTime = System.nanoTime();
        ProcedureCallRecord record = new ProcedureCallRecord(activation.procedure, context.agent.toString(), null);
        record.startTime = startTime;
        ProcedureCallRecord parent = (ProcedureCallRecord)this.openRecords.get(activation.parent);
        if (parent != null) {
            record.caller = parent;
            parent.called.add(record);
        }
        this.openRecords.put(activation, record);
    }

    public void closeCallRecord(Context context, Activation activation) {
        if (!this.enabled) {
            return;
        }
        long stopTime = System.nanoTime();
        ProcedureCallRecord record = (ProcedureCallRecord)this.openRecords.get(activation);
        if (record == null) {
            if (Boolean.getBoolean("org.nlogo.profiler.verbose")) {
                System.err.println("Cannot find record for: " + activation.procedure.name);
            }
            return;
        }
        record.stopTime = stopTime;
        this.updateProcedureTimingData(record);
        this.openRecords.remove(activation);
        if (Boolean.getBoolean("org.nlogo.profiler.verbose")) {
            System.out.println(record);
        }
    }

    protected void updateProcedureTimingData(CallRecord record) {
        Long callCount = this.callCounts.get(record.name);
        if (callCount == null) {
            callCount = 0L;
        }
        this.callCounts.put(record.name, callCount + 1L);
        Long inclusiveTime = this.inclusiveTimes.get(record.name);
        if (inclusiveTime == null) {
            inclusiveTime = 0L;
        }
        this.inclusiveTimes.put(record.name, inclusiveTime + record.inclusiveTime());
        Long exclusiveTime = this.exclusiveTimes.get(record.name);
        if (exclusiveTime == null) {
            exclusiveTime = 0L;
        }
        this.exclusiveTimes.put(record.name, exclusiveTime + record.exclusiveTime());
    }

    public void reset() {
        this.openRecords = new Hashtable();
        this.inclusiveTimes = new Hashtable();
        this.exclusiveTimes = new Hashtable();
        this.callCounts = new Hashtable();
        this.callRoots = new Vector();
    }

    public void dump(PrintStream stream) {
        stream.println("BEGIN PROFILING DUMP");
        stream.println("Sorted by Exclusive Time");
        this.dumpSortedBy(this.exclusiveTimes, stream);
        stream.println("");
        stream.println("Sorted by Inclusive Time");
        this.dumpSortedBy(this.inclusiveTimes, stream);
        stream.println("");
        stream.println("Sorted by Number of Calls");
        this.dumpSortedBy(this.callCounts, stream);
        stream.println("END PROFILING DUMP");
    }

    public void dumpSortedBy(Hashtable<String, Long> sortOn, PrintStream stream) {
        TreeSet<Map.Entry> sortedSet = new TreeSet<Map.Entry>(new DescendingMapEntryComparator());
        sortedSet.addAll(sortOn.entrySet());
        stream.format("%-30s%10s %10s %10s %10s\n", "Name", "Calls", "Incl T(ms)", "Excl T(ms)", "Excl/calls");
        Iterator<Map.Entry> it = sortedSet.iterator();
        while (it.hasNext()) {
            this.dumpProcedure((String)it.next().getKey(), stream);
        }
    }

    void dumpProcedure(String name, PrintStream stream) {
        long calls = this.callCounts.get(name);
        double itime = this.inclusiveTimes.get(name).doubleValue();
        double etime = this.exclusiveTimes.get(name).doubleValue();
        stream.format("%-30s%10d %10.3f %10.3f %10.3f\n", name, calls, itime / 1000000.0, etime / 1000000.0, etime / (double)calls / 1000000.0);
    }

    public long calls(String procedure) {
        Long count;
        if (this.callCounts != null && (count = this.callCounts.get(procedure)) != null) {
            return count;
        }
        return 0L;
    }

    public long inclusiveTime(String procedure) {
        Long t;
        if (this.inclusiveTimes != null && (t = this.inclusiveTimes.get(procedure)) != null) {
            return t;
        }
        return 0L;
    }

    public long exclusiveTime(String procedure) {
        Long t;
        if (this.exclusiveTimes != null && (t = this.exclusiveTimes.get(procedure)) != null) {
            return t;
        }
        return 0L;
    }

    public void enable() {
        this.enabled = true;
    }

    public void disable() {
        this.enabled = false;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    class DescendingMapEntryComparator
    implements Comparator<Map.Entry> {
        DescendingMapEntryComparator() {
        }

        @Override
        public int compare(Map.Entry e1, Map.Entry e2) {
            Long val1 = (Long)e1.getValue();
            Long val2 = (Long)e2.getValue();
            return val2.compareTo(val1);
        }
    }
}

