/*
 * Decompiled with CFR 0.152.
 */
package org.nlogo.extensions.profiler;

import java.io.PrintStream;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashMap;
import org.nlogo.nvm.Activation;
import org.nlogo.nvm.Context;
import org.nlogo.nvm.Procedure;
import org.nlogo.nvm.Tracer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class QuickTracer
extends Tracer {
    private boolean enabled;
    private HashMap<Procedure, Record> records;
    private HashMap<String, Procedure> procedureNames;
    private Record current;
    private Activation frame;
    private long resumetime;

    public QuickTracer() {
        this.reset();
    }

    private Record addProcedure(Procedure p, long t) {
        Record r = new Record();
        r.procedure = p;
        r.inclusive = 0L;
        r.exclusive = 0L;
        r.running = 1;
        r.invoketime = t;
        r.callcount = 0L;
        this.records.put(p, r);
        if (p != null) {
            this.procedureNames.put(p.name.toUpperCase(), p);
        }
        return r;
    }

    public void reset() {
        this.records = new HashMap();
        this.procedureNames = new HashMap();
        this.current = null;
        this.frame = null;
        this.enabled = false;
        this.addProcedure(null, 0L);
    }

    public void enable() {
        long t;
        this.current = this.records.get(null);
        this.frame = null;
        this.resumetime = t = System.nanoTime();
        this.current.invoketime = t;
        this.enabled = true;
    }

    public void disable() {
        if (this.enabled) {
            Record toplev = this.records.get(null);
            while (this.current != toplev) {
                this.closeCallRecord(null, this.frame);
            }
            long t = System.nanoTime();
            toplev.exclusive += t - this.resumetime;
            toplev.inclusive += t - toplev.invoketime;
            this.enabled = false;
            this.current = null;
        }
    }

    public void openCallRecord(Context context, Activation activation) {
        if (this.enabled) {
            long t = System.nanoTime();
            Procedure p = activation.procedure;
            Record r = this.records.get(p);
            if (r == null) {
                r = this.addProcedure(p, t);
            } else if (r.running++ == 0) {
                r.invoketime = t;
            }
            this.current.exclusive += t - this.resumetime;
            ++r.callcount;
            this.current = r;
            this.frame = activation;
            this.resumetime = t;
        }
    }

    public void closeCallRecord(Context context, Activation activation) {
        if (this.enabled) {
            long t = System.nanoTime();
            Record r = this.records.get(activation.procedure);
            if (r != null) {
                if (--r.running == 0) {
                    r.inclusive += t - r.invoketime;
                }
                this.current.exclusive += t - this.resumetime;
                this.frame = activation.parent;
                this.current = this.records.get(this.frame.procedure);
                if (this.current == null || this.current.running == 0) {
                    this.current = this.records.get(null);
                    this.frame = null;
                }
                this.resumetime = t;
            }
        }
    }

    public void dump(PrintStream s) {
        Record toplev = this.records.remove(null);
        Record[] recs = this.records.values().toArray(new Record[0]);
        s.println("BEGIN PROFILING DUMP");
        s.println("Sorted by Exclusive Time");
        s.format("%-30s%10s %10s %10s %10s\n", "Name", "Calls", "Incl T(ms)", "Excl T(ms)", "Excl/calls");
        this.dumpProcedures(s, recs, new ExclRecordComparator());
        s.println("");
        s.println("Sorted by Inclusive Time");
        this.dumpProcedures(s, recs, new InclRecordComparator());
        s.println("");
        s.println("Sorted by Number of Calls");
        this.dumpProcedures(s, recs, new CallsRecordComparator());
        s.println("END PROFILING DUMP");
        this.records.put(null, toplev);
    }

    private void dumpProcedures(PrintStream s, Record[] recs, Comparator<Record> c) {
        Arrays.sort(recs, c);
        for (int i = 0; i < recs.length; ++i) {
            this.dumpProcedure(s, recs[i]);
        }
    }

    private void dumpProcedure(PrintStream s, Record r) {
        s.format("%-30s%10d %10.3f %10.3f %10.3f\n", r.procedure.name, r.callcount, (double)r.inclusive / 1000000.0, (double)r.exclusive / 1000000.0, (double)r.exclusive / (double)r.callcount / 1000000.0);
    }

    public long calls(String procedure) {
        return this.findProcedure((String)procedure).callcount;
    }

    public long inclusiveTime(String procedure) {
        return this.findProcedure((String)procedure).inclusive;
    }

    public long exclusiveTime(String procedure) {
        return this.findProcedure((String)procedure).exclusive;
    }

    private Record findProcedure(String procedure) {
        Procedure proc = this.procedureNames.get(procedure);
        if (proc != null) {
            return this.records.get(proc);
        }
        return new Record();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class CallsRecordComparator
    implements Comparator<Record> {
        @Override
        public int compare(Record r1, Record r2) {
            if (r2.callcount > r1.callcount) {
                return 1;
            }
            if (r1.callcount > r2.callcount) {
                return -1;
            }
            return 0;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class InclRecordComparator
    implements Comparator<Record> {
        @Override
        public int compare(Record r1, Record r2) {
            if (r2.inclusive > r1.inclusive) {
                return 1;
            }
            if (r1.inclusive > r2.inclusive) {
                return -1;
            }
            return 0;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class ExclRecordComparator
    implements Comparator<Record> {
        @Override
        public int compare(Record r1, Record r2) {
            if (r2.exclusive > r1.exclusive) {
                return 1;
            }
            if (r1.exclusive > r2.exclusive) {
                return -1;
            }
            return 0;
        }
    }

    private static class Record {
        Procedure procedure;
        int running = 0;
        long inclusive = 0L;
        long exclusive = 0L;
        long invoketime = 0L;
        long callcount = 0L;

        private Record() {
        }
    }
}

