/*
 * Decompiled with CFR 0.152.
 */
package org.nlogo.extensions.sound;

import java.applet.Applet;
import java.applet.AudioClip;
import java.io.IOException;
import java.net.URL;
import java.util.Arrays;
import java.util.List;
import javax.sound.midi.InvalidMidiDataException;
import javax.sound.midi.MidiChannel;
import javax.sound.midi.MidiSystem;
import javax.sound.midi.MidiUnavailableException;
import javax.sound.midi.Soundbank;
import javax.sound.midi.Synthesizer;
import org.nlogo.api.DefaultClassManager;
import org.nlogo.api.ExtensionException;
import org.nlogo.api.ExtensionManager;
import org.nlogo.api.Primitive;
import org.nlogo.api.PrimitiveManager;
import org.nlogo.extensions.sound.Dump;
import org.nlogo.extensions.sound.ListDrums;
import org.nlogo.extensions.sound.ListInstruments;
import org.nlogo.extensions.sound.LoopSound;
import org.nlogo.extensions.sound.PlayDrum;
import org.nlogo.extensions.sound.PlayNote;
import org.nlogo.extensions.sound.PlayNoteLater;
import org.nlogo.extensions.sound.PlaySound;
import org.nlogo.extensions.sound.PlaySoundAndWait;
import org.nlogo.extensions.sound.PlaySoundLater;
import org.nlogo.extensions.sound.StartNote;
import org.nlogo.extensions.sound.StopInstrument;
import org.nlogo.extensions.sound.StopMusic;
import org.nlogo.extensions.sound.StopNote;
import org.nlogo.extensions.sound.StopSound;
import org.nlogo.util.Exceptions;

public class SoundExtension
extends DefaultClassManager {
    static final List DRUM_NAMES = Arrays.asList("ACOUSTIC BASS DRUM", "BASS DRUM 1", "SIDE STICK", "ACOUSTIC SNARE", "HAND CLAP", "ELECTRIC SNARE", "LOW FLOOR TOM", "CLOSED HI HAT", "HI FLOOR TOM", "PEDAL HI HAT", "LOW TOM", "OPEN HI HAT", "LOW MID TOM", "HI MID TOM", "CRASH CYMBAL 1", "HI TOM", "RIDE CYMBAL 1", "CHINESE CYMBAL", "RIDE BELL", "TAMBOURINE", "SPLASH CYMBAL", "COWBELL", "CRASH CYMBAL 2", "VIBRASLAP", "RIDE CYMBAL 2", "HI BONGO", "LOW BONGO", "MUTE HI CONGA", "OPEN HI CONGA", "LOW CONGA", "HI TIMBALE", "LOW TIMBALE", "HI AGOGO", "LOW AGOGO", "CABASA", "MARACAS", "SHORT WHISTLE", "LONG WHISTLE", "SHORT GUIRO", "LONG GUIRO", "CLAVES", "HI WOOD BLOCK", "LOW WOOD BLOCK", "MUTE CUICA", "OPEN CUICA", "MUTE TRIANGLE", "OPEN TRIANGLE");
    static final List INSTRUMENT_NAMES = Arrays.asList("ACOUSTIC GRAND PIANO", "BRIGHT ACOUSTIC PIANO", "ELECTRIC GRAND PIANO", "HONKY-TONK PIANO", "ELECTRIC PIANO 1", "ELECTRIC PIANO 2", "HARPSICHORD", "CLAVI", "CELESTA", "GLOCKENSPIEL", "MUSIC BOX", "VIBRAPHONE", "MARIMBA", "XYLOPHONE", "TUBULAR BELLS", "DULCIMER", "DRAWBAR ORGAN", "PERCUSSIVE ORGAN", "ROCK ORGAN", "CHURCH ORGAN", "REED ORGAN", "ACCORDION", "HARMONICA", "TANGO ACCORDION", "NYLON STRING GUITAR", "STEEL ACOUSTIC GUITAR", "JAZZ ELECTRIC GUITAR", "CLEAN ELECTRIC GUITAR", "MUTED ELECTRIC GUITAR", "OVERDRIVEN GUITAR", "DISTORTION GUITAR", "GUITAR HARMONICS", "ACOUSTIC BASS", "FINGERED ELECTRIC BASS", "PICKED ELECTRIC BASS", "FRETLESS BASS", "SLAP BASS 1", "SLAP BASS 2", "SYNTH BASS 1", "SYNTH BASS 2", "VIOLIN", "VIOLA", "CELLO", "CONTRABASS", "TREMOLO STRINGS", "PIZZICATO STRINGS", "ORCHESTRAL HARP", "TIMPANI", "STRING ENSEMBLE 1", "STRING ENSEMBLE 2", "SYNTH STRINGS 1", "SYNTH STRINGS 2", "CHOIR AAHS", "VOICE OOHS", "SYNTH VOICE", "ORCHESTRA HIT", "TRUMPET", "TROMBONE", "TUBA", "MUTED TRUMPET", "FRENCH HORN", "BRASS SECTION", "SYNTH BRASS 1", "SYNTH BRASS 2", "SOPRANO SAX", "ALTO SAX", "TENOR SAX", "BARITONE SAX", "OBOE", "ENGLISH HORN", "BASSOON", "CLARINET", "PICCOLO", "FLUTE", "RECORDER", "PAN FLUTE", "BLOWN BOTTLE", "SHAKUHACHI", "WHISTLE", "OCARINA", "SQUARE WAVE", "SAWTOOTH WAVE", "CALLIOPE", "CHIFF", "CHARANG", "VOICE", "FIFTHS", "BASS AND LEAD", "NEW AGE", "WARM", "POLYSYNTH", "CHOIR", "BOWED", "METAL", "HALO", "SWEEP", "RAIN", "SOUNDTRACK", "CRYSTAL", "ATMOSPHERE", "BRIGHTNESS", "GOBLINS", "ECHOES", "SCI-FI", "SITAR", "BANJO", "SHAMISEN", "KOTO", "KALIMBA", "BAG PIPE", "FIDDLE", "SHANAI", "TINKLE BELL", "AGOGO", "STEEL DRUMS", "WOODBLOCK", "TAIKO DRUM", "MELODIC TOM", "SYNTH DRUM", "REVERSE CYMBAL", "GUITAR FRET NOISE", "BREATH NOISE", "SEASHORE", "BIRD TWEET", "TELEPHONE RING", "HELICOPTER", "APPLAUSE", "GUNSHOT");
    private static final int PERCUSSION_CHANNEL = 9;
    private static Synthesizer synth;
    private static MidiChannel[] channels;
    private static int nextChannel;
    static AudioClip currentClip;

    public void load(PrimitiveManager primManager) {
        primManager.addPrimitive("drums", (Primitive)new ListDrums());
        primManager.addPrimitive("instruments", (Primitive)new ListInstruments());
        primManager.addPrimitive("loop-sound", (Primitive)new LoopSound());
        primManager.addPrimitive("play-drum", (Primitive)new PlayDrum());
        primManager.addPrimitive("play-note", (Primitive)new PlayNote());
        primManager.addPrimitive("play-note-later", (Primitive)new PlayNoteLater());
        primManager.addPrimitive("play-sound", (Primitive)new PlaySound());
        primManager.addPrimitive("play-sound-and-wait", (Primitive)new PlaySoundAndWait());
        primManager.addPrimitive("play-sound-later", (Primitive)new PlaySoundLater());
        primManager.addPrimitive("start-note", (Primitive)new StartNote());
        primManager.addPrimitive("stop-note", (Primitive)new StopNote());
        primManager.addPrimitive("stop-instrument", (Primitive)new StopInstrument());
        primManager.addPrimitive("stop-music", (Primitive)new StopMusic());
        primManager.addPrimitive("stop-sound", (Primitive)new StopSound());
        primManager.addPrimitive("__synth-dump", (Primitive)new Dump());
    }

    public void runOnce(ExtensionManager em) throws ExtensionException {
        try {
            synth = MidiSystem.getSynthesizer();
            synth.open();
            for (MidiChannel ch : channels = synth.getChannels()) {
                ch.programChange(0);
            }
            Soundbank soundbank = synth.getDefaultSoundbank();
            if (soundbank == null) {
                try {
                    soundbank = MidiSystem.getSoundbank(em.getFile("sound/soundbank-min.gm").getInputStream());
                }
                catch (IOException e) {
                    throw new ExtensionException("Failed to load soundbank: " + e.toString());
                }
                catch (InvalidMidiDataException e) {
                    throw new ExtensionException("Failed to load soundbank: " + e.toString());
                }
            }
            boolean bl = synth.loadAllInstruments(soundbank);
        }
        catch (MidiUnavailableException ex) {
            throw new ExtensionException("MIDI is not available");
        }
    }

    public void unload(ExtensionManager em) {
        if (synth != null) {
            synth.close();
        }
    }

    static void startNote(int instrument, int note, int velocity) {
        MidiChannel channel = SoundExtension.ensureChannel(instrument);
        channel.noteOn(note, velocity);
    }

    static void stopNote(int instrument, int note) {
        MidiChannel channel = SoundExtension.getChannel(instrument);
        if (channel != null) {
            channel.noteOff(note);
        }
    }

    static void stopNotes(int instrument) {
        MidiChannel channel = SoundExtension.getChannel(instrument);
        if (channel != null) {
            channel.setMute(true);
            channel.setMute(false);
        }
    }

    static void stopNotes() {
        channels[0].allNotesOff();
    }

    static void playNote(int instrument, int note, int velocity, int duration) {
        MidiChannel channel = SoundExtension.ensureChannel(instrument);
        channel.noteOn(note, velocity);
        if (duration > -1) {
            new StopNoteThread(channel, note, duration).start();
        }
    }

    static void playNoteLater(int instrument, int note, int velocity, int duration, int delay) {
        MidiChannel channel = SoundExtension.ensureChannel(instrument);
        new PlayNoteThread(channel, note, velocity, duration, delay).start();
    }

    static void playDrum(int drum, int velocity) {
        channels[9].noteOn(drum, velocity);
    }

    static void playSound(URL url) throws ExtensionException {
        new PlaySoundThread(url).start();
    }

    static void playSoundLater(URL url, int delay) throws ExtensionException {
        new PlaySoundThread(url, delay).start();
    }

    static void playSoundAndWait(URL url) throws ExtensionException {
        AudioClip clip = Applet.newAudioClip(url);
        clip.play();
    }

    static void loopSound(URL url) throws ExtensionException {
        currentClip = Applet.newAudioClip(url);
        currentClip.loop();
    }

    static void stopSound() throws ExtensionException {
        if (currentClip != null) {
            currentClip.stop();
            currentClip = null;
        }
    }

    static int getInstrument(String name) throws ExtensionException {
        int instrument = INSTRUMENT_NAMES.indexOf(name = name.toUpperCase().intern());
        if (instrument != -1) {
            return instrument;
        }
        throw new ExtensionException("No such instrument: " + name);
    }

    static int getDrum(String name) throws ExtensionException {
        int drum = DRUM_NAMES.indexOf(name = name.toUpperCase().intern());
        if (drum != -1) {
            return drum + 35;
        }
        throw new ExtensionException("No such drum: " + name);
    }

    static String dump() {
        StringBuilder s = new StringBuilder();
        for (int j = 0; j < channels.length; ++j) {
            String name;
            int instrument = channels[j].getProgram();
            String string = name = instrument > -1 ? "" + instrument + ". " + INSTRUMENT_NAMES.get(instrument) : "N/A";
            if (j == 9) {
                name = name + " <PERCUSSION>";
            }
            s.append("" + j + "\t" + name + "\n");
        }
        return s.toString();
    }

    private static MidiChannel getChannel(int instrument) {
        for (int j = 0; j < channels.length; ++j) {
            if (j == 9 || channels[j].getProgram() != instrument) continue;
            return channels[j];
        }
        return null;
    }

    private static MidiChannel ensureChannel(int instrument) {
        MidiChannel channel = SoundExtension.getChannel(instrument);
        if (channel != null) {
            return channel;
        }
        channel = channels[nextChannel];
        channel.allNotesOff();
        channel.programChange(instrument);
        if (++nextChannel == 9) {
            ++nextChannel;
        }
        if (nextChannel >= channels.length) {
            nextChannel = 0;
        }
        return channel;
    }

    static {
        nextChannel = 0;
        currentClip = null;
    }

    private static class StopNoteThread
    extends Thread {
        private MidiChannel channel;
        private int note;
        private int duration;

        StopNoteThread(MidiChannel channel, int note, int duration) {
            super("StopNoteThread");
            this.channel = channel;
            this.note = note;
            this.duration = duration;
        }

        public void run() {
            try {
                Thread.sleep(this.duration);
            }
            catch (InterruptedException e) {
                Exceptions.ignore((Throwable)e);
            }
            this.channel.noteOff(this.note);
        }
    }

    private static class PlayNoteThread
    extends Thread {
        private MidiChannel channel;
        private int note;
        private int velocity;
        private int duration;
        private int delay;

        PlayNoteThread(MidiChannel channel, int note, int velocity, int duration, int delay) {
            super("PlayNoteThread");
            this.channel = channel;
            this.note = note;
            this.velocity = velocity;
            this.duration = duration;
            this.delay = delay;
        }

        public void run() {
            try {
                Thread.sleep(this.delay);
            }
            catch (InterruptedException e) {
                Exceptions.ignore((Throwable)e);
            }
            this.channel.noteOn(this.note, this.velocity);
            if (this.duration > -1) {
                new StopNoteThread(this.channel, this.note, this.duration).start();
            }
        }
    }

    private static class PlaySoundThread
    extends Thread {
        private MidiChannel channel;
        private URL soundurl;
        private int delay;

        PlaySoundThread(URL soundurl) {
            super("PlaySoundThread");
            this.soundurl = soundurl;
            this.delay = 0;
        }

        PlaySoundThread(URL soundurl, int delay) {
            super("PlaySoundThread");
            this.soundurl = soundurl;
            this.delay = delay;
        }

        public void run() {
            try {
                AudioClip clip = Applet.newAudioClip(this.soundurl);
                Thread.sleep(this.delay);
                clip.play();
            }
            catch (InterruptedException e) {
                Exceptions.ignore((Throwable)e);
            }
        }
    }
}

