/*
 * Decompiled with CFR 0.152.
 */
package org.nlogo.agent;

import org.nlogo.agent.Topology;
import org.nlogo.api.AgentException;

final class HorizCylinder
extends Topology {
    strictfp double wrapX(double x) throws AgentException {
        double max = (double)this.world.maxPxcor() + 0.5;
        double min = (double)this.world.minPxcor() - 0.5;
        if (x >= max || x < min) {
            throw new AgentException("Cannot move turtle beyond the world's edge.");
        }
        return x;
    }

    strictfp double wrapY(double y) {
        return HorizCylinder.wrap(y, (double)this.world.minPycor() - 0.5, (double)this.world.maxPycor() + 0.5);
    }

    strictfp double distanceWrap(double dx, double dy, double x1, double y1, double x2, double y2) {
        double dy2 = y1 > y2 ? y2 + (double)this.world.worldHeight() - y1 : y2 - (double)this.world.worldHeight() - y1;
        dy = StrictMath.abs(dy2) < StrictMath.abs(dy) ? dy2 : dy;
        return this.world.rootsTable.gridRoot(dx * dx + dy * dy);
    }

    strictfp double towardsWrap(double headingX, double headingY) {
        if ((headingY = HorizCylinder.wrap(headingY, -((double)this.world.worldHeight()) / 2.0, (double)this.world.worldHeight() / 2.0)) == 0.0) {
            return headingX > 0.0 ? 90.0 : 270.0;
        }
        if (headingX == 0.0) {
            return headingY > 0.0 ? 0.0 : 180.0;
        }
        return (270.0 + StrictMath.toDegrees(Math.PI + StrictMath.atan2(-headingY, headingX))) % 360.0;
    }

    strictfp double shortestPathX(double x1, double x2) {
        return x2;
    }

    strictfp double shortestPathY(double y1, double y2) {
        double yprime = y1 > y2 ? y2 + (double)this.world.worldHeight() : y2 - (double)this.world.worldHeight();
        if (StrictMath.abs(y2 - y1) > StrictMath.abs(yprime - y1)) {
            y2 = yprime;
        }
        return y2;
    }
}

