/*
 * Decompiled with CFR 0.152.
 */
package org.nlogo.agent;

import java.util.Iterator;
import org.nlogo.agent.Agent;
import org.nlogo.agent.AgentSet;
import org.nlogo.agent.Topology;
import org.nlogo.agent.Turtle;
import org.nlogo.api.AgentException;
import org.nlogo.api.Dump;

public class Link
extends Agent
implements org.nlogo.api.Link {
    final Turtle end1;
    final Turtle end2;
    public static final Double DEFAULT_COLOR = 5.0;

    public strictfp Turtle end1() {
        return this.end1;
    }

    public strictfp Turtle end2() {
        return this.end2;
    }

    public strictfp double x1() {
        return this.end1.xcor();
    }

    public strictfp double y1() {
        return this.end1.ycor();
    }

    public strictfp double x2() {
        return this.world.topology.shortestPathX(this.end1.xcor(), this.end2.xcor());
    }

    public strictfp double y2() {
        return this.world.topology.shortestPathY(this.end1.ycor(), this.end2.ycor());
    }

    public strictfp double midpointX() {
        double x1 = this.x1();
        double x2 = this.x2();
        return Topology.wrap((x1 + x2) / 2.0, (double)this.world._minPxcor - 0.5, (double)this.world._maxPxcor + 0.5);
    }

    public strictfp double midpointY() {
        double y1 = this.y1();
        double y2 = this.y2();
        return Topology.wrap((y1 + y2) / 2.0, (double)this.world._minPycor - 0.5, (double)this.world._maxPycor + 0.5);
    }

    public strictfp double heading() {
        try {
            return this.world.protractor().towards(this.end1, this.end2, true);
        }
        catch (AgentException e) {
            return 0.0;
        }
    }

    public strictfp double lineThickness() {
        return (Double)this.variables[7];
    }

    public strictfp boolean isDirectedLink() {
        return ((AgentSet)this.variables[6]).isDirected();
    }

    public strictfp double linkDestinationSize() {
        return this.end2.size();
    }

    public strictfp double size() {
        return this.world.protractor().distance(this.end1, this.end2, true);
    }

    public strictfp String shape() {
        return (String)this.variables[8];
    }

    public strictfp Object color() {
        return this.variables[2];
    }

    public strictfp Object label() {
        return this.variables[3];
    }

    public strictfp boolean hasLabel() {
        return !(this.label() instanceof String) || ((String)this.label()).length() != 0;
    }

    public strictfp String labelString() {
        return Dump.logoObject(this.variables[3]);
    }

    public strictfp boolean hidden() {
        return (Boolean)this.variables[5];
    }

    public strictfp AgentSet getBreed() {
        return (AgentSet)this.variables[6];
    }

    public strictfp Object labelColor() {
        return this.variables[4];
    }

    public strictfp String toString() {
        return this.world.getLinkBreedSingular(this.getBreed()).toLowerCase() + " " + this.end1.id + " " + this.end2.id;
    }

    public strictfp int getBreedIndex() {
        AgentSet mybreed = this.getBreed();
        if (mybreed == this.world.links()) {
            return 0;
        }
        int j = 1;
        Iterator<Object> iter = this.world.program().linkBreeds().values().iterator();
        while (iter.hasNext()) {
            if (mybreed == (AgentSet)iter.next()) {
                return j;
            }
            ++j;
        }
        return 0;
    }

    public strictfp int compareTo(Agent a) {
        if (a == this) {
            return 0;
        }
        Link otherLink = (Link)a;
        if (this.end1.id < otherLink.end1.id) {
            return -1;
        }
        if (this.end1.id > otherLink.end1.id) {
            return 1;
        }
        if (this.end2.id < otherLink.end2.id) {
            return -1;
        }
        if (this.end2.id > otherLink.end2.id) {
            return 1;
        }
        if (this.getBreed() == otherLink.getBreed()) {
            return 0;
        }
        if (this.getBreed() == this.world.links()) {
            return -1;
        }
        if (otherLink.getBreed() == this.world.links()) {
            return 1;
        }
        return this.world.compareLinkBreeds(this.getBreed(), otherLink.getBreed());
    }
}

