/*
 * Decompiled with CFR 0.152.
 */
package org.nlogo.agent;

import org.nlogo.agent.Link;
import org.nlogo.agent.Observer;
import org.nlogo.agent.Patch;
import org.nlogo.agent.Turtle;
import org.nlogo.agent.World;
import org.nlogo.api.Agent;
import org.nlogo.api.AgentException;
import org.nlogo.api.I18N;

public class Protractor
implements org.nlogo.api.Protractor {
    private final World world;

    public strictfp double distanceToLink(Link link, double x, double y) {
        double ydiff;
        double xdiff;
        double[] p;
        double y2;
        double x2;
        double y1;
        double x1 = link.x1();
        if (this.inBounds(x1, y1 = link.y1(), x2 = link.x2(), y2 = link.y2(), (p = this.closestPoint(x, y, x1, y1, xdiff = x2 - x1, ydiff = y2 - y1))[0], p[1])) {
            return this.distance(p[0], p[1], x, y, true);
        }
        double tmpx = x;
        double tmpy = y;
        if (x2 < (double)this.world._minPxcor) {
            x -= (double)this.world._worldWidth;
        } else if (x2 > (double)this.world._maxPxcor) {
            x += (double)this.world._worldWidth;
        }
        p = this.closestPoint(x, y, x1, y1, xdiff, ydiff);
        if (this.inBounds(x1, y1, x2, y2, p[0], p[1])) {
            return this.distance(p[0], p[1], x, y, true);
        }
        if (y2 < (double)this.world._minPycor) {
            y -= (double)this.world._worldHeight;
        } else if (y2 > (double)this.world._maxPycor) {
            y += (double)this.world._worldHeight;
        }
        p = this.closestPoint(x, y, x1, y1, xdiff, ydiff);
        if (this.inBounds(x1, y1, x2, y2, p[0], p[1])) {
            return this.distance(p[0], p[1], x, y, true);
        }
        x = tmpx;
        y = tmpy;
        p = this.closestPoint(x, y, x1, y1, xdiff, ydiff);
        if (this.inBounds(x1, y1, x2, y2, p[0], p[1])) {
            return this.distance(p[0], p[1], x, y, true);
        }
        return StrictMath.min(this.distance(x1, y1, x, y, true), this.distance(x2, y2, x, y, true));
    }

    private strictfp double[] closestPoint(double x, double y, double x1, double y1, double xdiff, double ydiff) {
        double u = ((x - x1) * xdiff + (y - y1) * ydiff) / (xdiff * xdiff + ydiff * ydiff);
        double xprime = x1 + u * xdiff;
        double yprime = y1 + u * ydiff;
        return new double[]{xprime, yprime};
    }

    public strictfp boolean inBounds(double x1, double y1, double x2, double y2, double x, double y) {
        double left;
        double right;
        double bottom;
        double top;
        if (y1 > y2) {
            top = y1;
            bottom = y2;
        } else {
            top = y2;
            bottom = y1;
        }
        if (x1 > x2) {
            right = x1;
            left = x2;
        } else {
            right = x2;
            left = x1;
        }
        return x <= right && x >= left && y <= top && y >= bottom;
    }

    public strictfp double distance(Agent agent, double x2, double y2, boolean wrap) {
        double y1;
        double x1;
        if (agent instanceof Turtle) {
            Turtle turtle = (Turtle)agent;
            x1 = turtle.xcor();
            y1 = turtle.ycor();
        } else {
            if (agent instanceof Link) {
                return this.distanceToLink((Link)agent, x2, y2);
            }
            Patch patch = (Patch)agent;
            x1 = patch.pxcor;
            y1 = patch.pycor;
        }
        return this.distance(x1, y1, x2, y2, wrap);
    }

    public strictfp double distance(Agent agent1, Agent agent2, boolean wrap) {
        double y1;
        double x1;
        if (agent1 instanceof Turtle) {
            Turtle turtle = (Turtle)agent1;
            x1 = turtle.xcor();
            y1 = turtle.ycor();
        } else {
            Patch patch = (Patch)agent1;
            x1 = patch.pxcor;
            y1 = patch.pycor;
        }
        return this.distance(agent2, x1, y1, wrap);
    }

    public strictfp double distance(double x1, double y1, double x2, double y2, boolean wrap) {
        double distanceWrap;
        double dx = x2 - x1;
        double dy = y2 - y1;
        double distanceNoWrap = this.world.rootsTable.gridRoot(dx * dx + dy * dy);
        if (wrap && (distanceWrap = this.world.topology.distanceWrap(dx, dy, x1, y1, x2, y2)) < distanceNoWrap) {
            return distanceWrap;
        }
        return distanceNoWrap;
    }

    public strictfp double towards(Agent fromAgent, Agent toAgent, boolean wrap) throws AgentException {
        double y;
        double x;
        if (fromAgent == toAgent) {
            throw new AgentException(I18N.errorsJ().get("org.nlogo.agent.Protractor.noHeadingFromAgentToSelf"));
        }
        if (toAgent instanceof Turtle) {
            Turtle turtle = (Turtle)toAgent;
            x = turtle.xcor();
            y = turtle.ycor();
        } else if (toAgent instanceof Link) {
            Link link = (Link)toAgent;
            x = link.midpointX();
            y = link.midpointY();
        } else {
            Patch patch = (Patch)toAgent;
            x = patch.pxcor;
            y = patch.pycor;
        }
        return this.towards(fromAgent, x, y, wrap);
    }

    public strictfp double towards(Agent fromAgent, double toX, double toY, boolean wrap) throws AgentException {
        double fromY;
        double fromX;
        if (fromAgent instanceof Turtle) {
            Turtle turtle = (Turtle)fromAgent;
            fromX = turtle.xcor();
            fromY = turtle.ycor();
        } else if (fromAgent instanceof Observer) {
            Observer obs = (Observer)fromAgent;
            fromX = obs.oxcor();
            fromY = obs.oycor();
        } else if (fromAgent instanceof Patch) {
            Patch patch = (Patch)fromAgent;
            fromX = patch.pxcor;
            fromY = patch.pycor;
        } else {
            throw new IllegalStateException("In towards: fromAgent must not be a link");
        }
        return this.towards(fromX, fromY, toX, toY, wrap);
    }

    public strictfp double towards(double fromX, double fromY, double toX, double toY, boolean wrap) throws AgentException {
        if (fromX == toX && fromY == toY) {
            throw new AgentException(I18N.errorsJ().getN("org.nlogo.agent.Protractor.noHeadingFromPointToSelf", fromX, fromY));
        }
        double dx = toX - fromX;
        double dy = toY - fromY;
        if (wrap) {
            return this.world.topology.towardsWrap(dx, dy);
        }
        if (dx == 0.0) {
            return dy > 0.0 ? 0.0 : 180.0;
        }
        if (dy == 0.0) {
            return dx > 0.0 ? 90.0 : 270.0;
        }
        return (270.0 + StrictMath.toDegrees(Math.PI + StrictMath.atan2(-dy, dx))) % 360.0;
    }
}

