/*
 * Decompiled with CFR 0.152.
 */
package org.nlogo.agent;

import org.nlogo.agent.Topology;

class Torus
extends Topology {
    strictfp double wrapX(double x) {
        return Torus.wrap(x, (double)this.world.minPxcor() - 0.5, (double)this.world.maxPxcor() + 0.5);
    }

    strictfp double wrapY(double y) {
        return Torus.wrap(y, (double)this.world.minPycor() - 0.5, (double)this.world.maxPycor() + 0.5);
    }

    strictfp double distanceWrap(double dx, double dy, double x1, double y1, double x2, double y2) {
        double dx2 = x1 > x2 ? x2 + (double)this.world.worldWidth() - x1 : x2 - (double)this.world.worldWidth() - x1;
        dx = StrictMath.abs(dx2) < StrictMath.abs(dx) ? dx2 : dx;
        double dy2 = y1 > y2 ? y2 + (double)this.world.worldHeight() - y1 : y2 - (double)this.world.worldHeight() - y1;
        dy = StrictMath.abs(dy2) < StrictMath.abs(dy) ? dy2 : dy;
        return this.world.rootsTable.gridRoot(dx * dx + dy * dy);
    }

    strictfp double towardsWrap(double headingX, double headingY) {
        headingX = Torus.wrap(headingX, -((double)this.world.worldWidth()) / 2.0, (double)this.world.worldWidth() / 2.0);
        if ((headingY = Torus.wrap(headingY, -((double)this.world.worldHeight()) / 2.0, (double)this.world.worldHeight() / 2.0)) == 0.0) {
            return headingX > 0.0 ? 90.0 : 270.0;
        }
        if (headingX == 0.0) {
            return headingY > 0.0 ? 0.0 : 180.0;
        }
        return (270.0 + StrictMath.toDegrees(Math.PI + StrictMath.atan2(-headingY, headingX))) % 360.0;
    }

    strictfp double shortestPathX(double x1, double x2) {
        double xprime = x1 > x2 ? x2 + (double)this.world.worldWidth() : x2 - (double)this.world.worldWidth();
        if (StrictMath.abs(x2 - x1) > StrictMath.abs(xprime - x1)) {
            x2 = xprime;
        }
        return x2;
    }

    strictfp double shortestPathY(double y1, double y2) {
        double yprime = y1 > y2 ? y2 + (double)this.world.worldHeight() : y2 - (double)this.world.worldHeight();
        if (StrictMath.abs(y2 - y1) > StrictMath.abs(yprime - y1)) {
            y2 = yprime;
        }
        return y2;
    }
}

