/*
 * Decompiled with CFR 0.152.
 */
package org.nlogo.agent;

import org.nlogo.agent.Topology;
import org.nlogo.api.AgentException;

final class VertCylinder
extends Topology {
    strictfp double wrapX(double x) {
        return VertCylinder.wrap(x, (double)this.world.minPxcor() - 0.5, (double)this.world.maxPxcor() + 0.5);
    }

    strictfp double wrapY(double y) throws AgentException {
        double max = (double)this.world.maxPycor() + 0.5;
        double min = (double)this.world.minPycor() - 0.5;
        if (y >= max || y < min) {
            throw new AgentException("Cannot move turtle beyond the world's edge.");
        }
        return y;
    }

    strictfp double distanceWrap(double dx, double dy, double x1, double y1, double x2, double y2) {
        double dx2 = x1 > x2 ? x2 + (double)this.world.worldWidth() - x1 : x2 - (double)this.world.worldWidth() - x1;
        dx = StrictMath.abs(dx2) < StrictMath.abs(dx) ? dx2 : dx;
        return this.world.rootsTable.gridRoot(dx * dx + dy * dy);
    }

    strictfp double towardsWrap(double headingX, double headingY) {
        headingX = VertCylinder.wrap(headingX, -((double)this.world.worldWidth()) / 2.0, (double)this.world.worldWidth() / 2.0);
        if (headingY == 0.0) {
            return headingX > 0.0 ? 90.0 : 270.0;
        }
        if (headingX == 0.0) {
            return headingY > 0.0 ? 0.0 : 180.0;
        }
        return (270.0 + StrictMath.toDegrees(Math.PI + StrictMath.atan2(-headingY, headingX))) % 360.0;
    }

    strictfp double shortestPathX(double x1, double x2) {
        double xprime = x1 > x2 ? x2 + (double)this.world.worldWidth() : x2 - (double)this.world.worldWidth();
        if (StrictMath.abs(x2 - x1) > StrictMath.abs(xprime - x1)) {
            x2 = xprime;
        }
        return x2;
    }

    strictfp double shortestPathY(double y1, double y2) {
        return y2;
    }
}

