/*
 * Decompiled with CFR 0.152.
 */
package org.nlogo.agent;

import java.util.Map;
import org.nlogo.agent.Agent;
import org.nlogo.agent.AgentSet;
import org.nlogo.agent.HorizCylinder;
import org.nlogo.agent.Observer;
import org.nlogo.agent.Protractor;
import org.nlogo.agent.RootsTable;
import org.nlogo.agent.Topology;
import org.nlogo.agent.Torus;
import org.nlogo.agent.VertCylinder;
import org.nlogo.api.AgentException;
import org.nlogo.api.CompilerServices;
import org.nlogo.api.Program;
import org.nlogo.api.TrailDrawerInterface;

public class World
implements org.nlogo.api.World {
    public static final Double ZERO = 0.0;
    public static final Double ONE = 1.0;
    private double patchSize;
    TrailDrawerInterface trailDrawer;
    private final Map<Agent, Double> lineThicknesses;
    Topology topology;
    RootsTable rootsTable;
    protected Protractor _protractor;
    int _worldWidth;
    int _worldHeight;
    int _minPxcor;
    int _minPycor;
    int _maxPxcor;
    int _maxPycor;
    final Observer _observer;
    AgentSet _patches;
    AgentSet _turtles;
    AgentSet _links;
    int[] patchColors;
    boolean patchesAllBlack;
    private Program _program;
    private CompilerServices _compiler;

    public strictfp Protractor protractor() {
        return this._protractor;
    }

    public strictfp boolean wrappingAllowedInX() {
        return this.topology instanceof Torus || this.topology instanceof VertCylinder;
    }

    public strictfp boolean wrappingAllowedInY() {
        return this.topology instanceof Torus || this.topology instanceof HorizCylinder;
    }

    public strictfp double lineThickness(Agent agent) {
        Double size2 = this.lineThicknesses.get(agent);
        if (size2 != null) {
            return size2;
        }
        return 0.0;
    }

    public strictfp int worldWidth() {
        return this._worldWidth;
    }

    public strictfp int worldHeight() {
        return this._worldHeight;
    }

    public strictfp int minPxcor() {
        return this._minPxcor;
    }

    public strictfp int minPycor() {
        return this._minPycor;
    }

    public strictfp int maxPxcor() {
        return this._maxPxcor;
    }

    public strictfp int maxPycor() {
        return this._maxPycor;
    }

    public strictfp double wrapX(double x) throws AgentException {
        return this.topology.wrapX(x);
    }

    public strictfp double wrapY(double y) throws AgentException {
        return this.topology.wrapY(y);
    }

    public strictfp double wrap(double pos, double min, double max) {
        return Topology.wrap(pos, min, max);
    }

    public strictfp Observer observer() {
        return this._observer;
    }

    public strictfp AgentSet patches() {
        return this._patches;
    }

    public strictfp AgentSet turtles() {
        return this._turtles;
    }

    public strictfp AgentSet links() {
        return this._links;
    }

    public strictfp boolean patchesAllBlack() {
        return this.patchesAllBlack;
    }

    public strictfp int[] patchColors() {
        return this.patchColors;
    }

    public strictfp double patchSize() {
        return this.patchSize;
    }

    public strictfp Object getDrawing() {
        return this.trailDrawer.getDrawing();
    }

    public strictfp boolean sendPixels() {
        return this.trailDrawer.sendPixels();
    }

    public strictfp void markDrawingClean() {
        this.trailDrawer.sendPixels(false);
    }

    public strictfp String getBreedSingular(AgentSet breed) {
        if (breed == this._turtles) {
            return "TURTLE";
        }
        String breedName = breed.printName();
        for (Map.Entry<String, String> entry : this._program.breedsSingular().entrySet()) {
            if (!entry.getValue().equals(breedName)) continue;
            return entry.getKey();
        }
        return "TURTLE";
    }

    public strictfp String getLinkBreedSingular(AgentSet breed) {
        if (breed == this._links) {
            return "LINK";
        }
        String breedName = breed.printName();
        for (Map.Entry<String, String> entry : this._program.linkBreedsSingular().entrySet()) {
            if (!entry.getValue().equals(breedName)) continue;
            return entry.getKey();
        }
        return "LINK";
    }

    public strictfp int compareLinkBreeds(AgentSet breed1, AgentSet breed2) {
        for (AgentSet agentSet : this._program.linkBreeds().values()) {
            if (agentSet == breed1) {
                return -1;
            }
            if (agentSet != breed2) continue;
            return 1;
        }
        throw new IllegalStateException("neither of the breeds exist, that's bad");
    }

    public strictfp Program program() {
        return this._program;
    }

    public strictfp CompilerServices compiler() {
        return this._compiler;
    }
}

