/*
 * Decompiled with CFR 0.152.
 */
package org.nlogo.editor;

import java.awt.Color;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.awt.Shape;
import java.util.List;
import javax.swing.event.CaretEvent;
import javax.swing.event.CaretListener;
import javax.swing.text.BadLocationException;
import javax.swing.text.Highlighter;
import javax.swing.text.JTextComponent;
import javax.swing.text.PlainDocument;
import org.nlogo.editor.Colorizer;
import org.nlogo.editor.EditorArea;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
strictfp class BracketMatcher<TokenType>
implements CaretListener {
    private static final Color GOOD_COLOR = Color.GRAY;
    private static final Color BAD_COLOR = Color.RED;
    private final Colorizer<TokenType> colorizer;
    private String oldText = "";
    private List<TokenType> tokenTypes = null;
    private String oldLineText = "";
    private List<TokenType> lineTokenTypes = null;
    private final BracketHighlightPainter goodPainter;
    private final BracketHighlightPainter badPainter;

    BracketMatcher(Colorizer<TokenType> colorizer) {
        this.colorizer = colorizer;
        this.goodPainter = new BracketHighlightPainter(GOOD_COLOR);
        this.badPainter = new BracketHighlightPainter(BAD_COLOR);
    }

    @Override
    public void caretUpdate(CaretEvent e) {
        EditorArea source = (EditorArea)e.getSource();
        Highlighter highlighter = source.getHighlighter();
        this.removeOldHighlights(highlighter);
        int dot = e.getDot();
        if (dot != e.getMark() || dot == 0) {
            return;
        }
        try {
            int lineNumber;
            PlainDocument doc;
            int lineDot;
            String lineText = source.getLineText(dot);
            if (!lineText.equals(this.oldLineText)) {
                this.lineTokenTypes = this.colorizer.getCharacterTokenTypes(lineText);
                this.oldLineText = lineText;
            }
            if ((lineDot = dot - source.lineToStartOffset(doc = (PlainDocument)source.getDocument(), lineNumber = source.offsetToLine(doc, dot))) == 0 || !this.colorizer.isOpener(this.lineTokenTypes.get(lineDot - 1)) && !this.colorizer.isCloser(this.lineTokenTypes.get(lineDot - 1))) {
                return;
            }
            String text2 = source.getText();
            if (!text2.equals(this.oldText)) {
                this.tokenTypes = this.colorizer.getCharacterTokenTypes(text2);
                this.oldText = text2;
            }
            this.doHighlighting(highlighter, this.colorizer.isOpener(this.lineTokenTypes.get(lineDot - 1)), this.tokenTypes, dot);
        }
        catch (BadLocationException ex) {
            throw new IllegalStateException(ex);
        }
    }

    void focusLost(EditorArea<?> source) {
        this.removeOldHighlights(source.getHighlighter());
        this.oldText = "";
        this.tokenTypes = null;
        this.oldLineText = "";
        this.lineTokenTypes = null;
    }

    private void doHighlighting(Highlighter highlighter, boolean isOpener, List<TokenType> tokens, int dot) throws BadLocationException {
        if (isOpener) {
            int closer = this.findCloser(this.colorizer, tokens, dot - 1);
            if (closer != -1 && this.colorizer.isMatch(tokens.get(dot - 1), tokens.get(closer))) {
                this.highlightGood(highlighter, closer);
            }
        } else {
            int opener = this.findOpener(this.colorizer, tokens, dot - 1);
            if (opener != -1) {
                if (this.colorizer.isMatch(tokens.get(opener), tokens.get(dot - 1))) {
                    this.highlightGood(highlighter, opener);
                } else {
                    this.highlightBad(highlighter, opener);
                }
            } else {
                this.highlightBad(highlighter, dot - 1);
            }
        }
    }

    int findCloser(Colorizer<TokenType> colorizer, List<TokenType> tokens, int opener) {
        int parenCount = 1;
        for (int i = opener + 1; i < tokens.size(); ++i) {
            if (colorizer.isOpener(tokens.get(i))) {
                ++parenCount;
            } else if (colorizer.isCloser(tokens.get(i))) {
                --parenCount;
            }
            if (parenCount != 0) continue;
            return i;
        }
        return -1;
    }

    int findOpener(Colorizer<TokenType> colorizer, List<TokenType> tokens, int closer) {
        int parenCount = 1;
        for (int i = closer - 1; i >= 0; --i) {
            if (colorizer.isCloser(tokens.get(i))) {
                ++parenCount;
            } else if (colorizer.isOpener(tokens.get(i))) {
                --parenCount;
            }
            if (parenCount != 0) continue;
            return i;
        }
        return -1;
    }

    private void removeOldHighlights(Highlighter highlighter) {
        Highlighter.Highlight[] highlights = highlighter.getHighlights();
        for (int i = 0; i < highlights.length; ++i) {
            if (highlights[i].getPainter() != this.goodPainter && highlights[i].getPainter() != this.badPainter) continue;
            highlighter.removeHighlight(highlights[i]);
        }
    }

    private void highlightGood(Highlighter highlighter, int pos) throws BadLocationException {
        highlighter.addHighlight(pos, pos + 1, this.goodPainter);
    }

    private void highlightBad(Highlighter highlighter, int pos) throws BadLocationException {
        highlighter.addHighlight(pos, pos + 1, this.badPainter);
    }

    private strictfp class BracketHighlightPainter
    implements Highlighter.HighlightPainter {
        private final Color color;

        BracketHighlightPainter(Color color) {
            this.color = color;
        }

        public void paint(Graphics g, int p0, int p1, Shape bounds, JTextComponent c) {
            try {
                g.setColor(this.color);
                Rectangle rect = c.getUI().modelToView(c, p0).union(c.getUI().modelToView(c, p1));
                g.drawRect(rect.x, rect.y, rect.width - 1, rect.height - 1);
            }
            catch (BadLocationException ex) {
                throw new IllegalStateException(ex);
            }
        }
    }
}

