/*
 * Decompiled with CFR 0.152.
 */
package org.nlogo.editor;

import java.awt.event.MouseEvent;
import java.util.List;
import javax.swing.SwingUtilities;
import javax.swing.text.DefaultCaret;
import javax.swing.text.JTextComponent;
import org.nlogo.editor.BracketMatcher;
import org.nlogo.editor.Colorizer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
strictfp class DoubleClickCaret<TokenType>
extends DefaultCaret {
    private final Colorizer<TokenType> colorizer;
    private final BracketMatcher<TokenType> bracketMatcher;

    DoubleClickCaret(Colorizer<TokenType> colorizer, BracketMatcher<TokenType> bracketMatcher) {
        this.colorizer = colorizer;
        this.bracketMatcher = bracketMatcher;
    }

    @Override
    public void mouseClicked(MouseEvent e) {
        if (!e.isConsumed() && SwingUtilities.isLeftMouseButton(e) && e.getClickCount() == 2) {
            JTextComponent source = (JTextComponent)e.getSource();
            if (!this.handleDoubleClick(source, this.colorizer.getCharacterTokenTypes(source.getText()), source.getUI().viewToModel(source, e.getPoint()))) {
                super.mouseClicked(e);
            }
        } else {
            super.mouseClicked(e);
        }
    }

    public int getMousePosition(MouseEvent e) {
        JTextComponent source = (JTextComponent)e.getSource();
        return source.getUI().viewToModel(source, e.getPoint());
    }

    private boolean handleDoubleClick(JTextComponent textComponent, List<TokenType> tokens, int dot) {
        int opener;
        if (dot < tokens.size() && this.colorizer.isOpener(tokens.get(dot))) {
            int closer = this.bracketMatcher.findCloser(this.colorizer, tokens, dot);
            if (closer != -1 && this.colorizer.isMatch(tokens.get(dot), tokens.get(closer))) {
                textComponent.select(dot, closer + 1);
                return true;
            }
        } else if (dot > 0 && this.colorizer.isCloser(tokens.get(dot - 1)) && (opener = this.bracketMatcher.findOpener(this.colorizer, tokens, dot - 1)) != -1 && this.colorizer.isMatch(tokens.get(opener), tokens.get(dot - 1))) {
            textComponent.select(opener, dot);
            return true;
        }
        return false;
    }
}

