/*
 * Decompiled with CFR 0.152.
 */
package org.nlogo.hubnet.mirroring;

import java.io.DataInputStream;
import java.io.IOException;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.SortedMap;
import java.util.TreeMap;
import org.nlogo.api.AgentException;
import org.nlogo.api.AgentSet;
import org.nlogo.api.Color;
import org.nlogo.api.Link;
import org.nlogo.api.LogoList;
import org.nlogo.api.Observer;
import org.nlogo.api.Patch;
import org.nlogo.api.Perspective;
import org.nlogo.api.PerspectiveJ;
import org.nlogo.api.Program;
import org.nlogo.api.Protractor;
import org.nlogo.api.ShapeList;
import org.nlogo.api.TrailDrawerInterface;
import org.nlogo.api.Turtle;
import org.nlogo.api.World;
import org.nlogo.hubnet.mirroring.Agent;
import org.nlogo.hubnet.mirroring.AgentData;
import org.nlogo.hubnet.mirroring.AgentPerspective;
import org.nlogo.hubnet.mirroring.ClearOverride;
import org.nlogo.hubnet.mirroring.LinkData;
import org.nlogo.hubnet.mirroring.Overridable;
import org.nlogo.hubnet.mirroring.PatchData;
import org.nlogo.hubnet.mirroring.SendOverride;
import org.nlogo.hubnet.mirroring.TurtleData;
import scala.collection.Iterator;
import scala.collection.JavaConversions;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public strictfp class ClientWorld
implements World {
    private final boolean printErrors;
    SortedMap<TurtleKey, TurtleData> sortedTurtles;
    Map<Long, TurtleKey> turtleKeys;
    Map<Long, TurtleData> uninitializedTurtles = new HashMap<Long, TurtleData>();
    SortedMap<LinkKey, LinkData> sortedLinks;
    Map<Long, LinkKey> linkKeys;
    Map<Long, LinkData> uninitializedLinks = new HashMap<Long, LinkData>();
    public PatchData[] patches;
    private int[] patchColors;
    private int minPxcor = -1;
    private int maxPxcor = -1;
    private int minPycor = -1;
    private int maxPycor = -1;
    private boolean shapes;
    private TrailDrawerInterface trailDrawer;
    private int fontSize;
    private double patchSize = 13.0;
    private boolean xWrap;
    private boolean yWrap;
    private PerspectiveMode perspectiveMode = PerspectiveMode.SERVER;
    public Perspective perspective = PerspectiveJ.OBSERVE();
    public AgentData targetAgent;
    public double radius;
    private int viewWidth;
    private int viewHeight;
    private final Map<Overridable, Map<Integer, Object>> overrideMap = new HashMap<Overridable, Map<Integer, Object>>();

    @Override
    public int[] patchColors() {
        return this.patchColors;
    }

    public ClientWorld() {
        this(true);
    }

    public ClientWorld(boolean printErrors) {
        this.printErrors = printErrors;
        this.sortedTurtles = new TreeMap<TurtleKey, TurtleData>(new TurtleKeyComparator());
        this.turtleKeys = new HashMap<Long, TurtleKey>();
        this.sortedLinks = new TreeMap<LinkKey, LinkData>(new LinkKeyComparator());
        this.linkKeys = new HashMap<Long, LinkKey>();
    }

    public void reset() {
        this.sortedTurtles = new TreeMap<TurtleKey, TurtleData>(new TurtleKeyComparator());
        this.turtleKeys = new HashMap<Long, TurtleKey>();
        this.sortedLinks = new TreeMap<LinkKey, LinkData>(new LinkKeyComparator());
        this.linkKeys = new HashMap<Long, LinkKey>();
    }

    public ClientWorld(int numPatches, boolean printErrors) {
        this(printErrors);
        this.createPatches(numPatches);
    }

    public double ticks() {
        throw new UnsupportedOperationException();
    }

    public void setWorldSize(int minx, int maxx, int miny, int maxy) {
        this.minPxcor = minx;
        this.maxPxcor = maxx;
        this.minPycor = miny;
        this.maxPycor = maxy;
        this.createPatches(this.worldWidth() * this.worldHeight());
    }

    private void createPatches(int numPatches) {
        this.patches = new PatchData[numPatches];
        this.patchColors = new int[numPatches];
        for (int i = 0; i < this.patches.length; ++i) {
            this.patches[i] = new PatchData(i, 31, 0, 0, 0.0, "", 0.0);
            this.patches[i].patchColors = this.patchColors;
        }
    }

    public void setTrailDrawer(TrailDrawerInterface trailDrawer) {
        this.trailDrawer = trailDrawer;
    }

    public Iterable<TurtleData> getTurtles() {
        return this.sortedTurtles.values();
    }

    public Iterable<LinkData> getLinks() {
        return this.sortedLinks.values();
    }

    public PatchData[] getPatches() {
        return this.patches;
    }

    public int fontSize() {
        return (int)((double)this.fontSize * this.zoom());
    }

    @Override
    public int minPxcor() {
        return this.minPxcor;
    }

    @Override
    public int maxPxcor() {
        return this.maxPxcor;
    }

    @Override
    public int minPycor() {
        return this.minPycor;
    }

    @Override
    public int maxPycor() {
        return this.maxPycor;
    }

    @Override
    public int worldWidth() {
        return this.maxPxcor - this.minPxcor + 1;
    }

    @Override
    public int worldHeight() {
        return this.maxPycor - this.minPycor + 1;
    }

    public boolean shapesOn() {
        return this.shapes;
    }

    @Override
    public double wrapX(double x) throws AgentException {
        double max = (double)this.maxPxcor + 0.5;
        double min = (double)this.minPxcor - 0.5;
        if (!this.xWrap) {
            if (x >= max || x < min) {
                throw new AgentException("Cannot move turtle beyond the world's edge.");
            }
            return x;
        }
        return this.wrap(x, min, max);
    }

    @Override
    public double wrapY(double y) throws AgentException {
        double max = (double)this.maxPycor + 0.5;
        double min = (double)this.minPycor - 0.5;
        if (!this.yWrap) {
            if (y >= max || y < min) {
                throw new AgentException("Cannot move turtle beyond the world's edge.");
            }
            return y;
        }
        return this.wrap(y, min, max);
    }

    @Override
    public double wrap(double pos, double min, double max) {
        if (pos >= max) {
            return min + (pos - max) % (max - min);
        }
        if (pos < min) {
            double result2 = (min - pos) % (max - min);
            return result2 == 0.0 ? min : max - result2;
        }
        return pos;
    }

    public void patchSize(double patchSize) {
        this.patchSize = patchSize;
    }

    @Override
    public double patchSize() {
        return this.perspectiveMode == PerspectiveMode.SERVER ? this.patchSize : (double)StrictMath.max(this.viewWidth, this.viewHeight) / (this.radius * 2.0 + 1.0);
    }

    public double zoom() {
        return this.patchSize() / this.patchSize;
    }

    @Override
    public boolean wrappingAllowedInX() {
        return this.xWrap;
    }

    @Override
    public boolean wrappingAllowedInY() {
        return this.yWrap;
    }

    @Override
    public boolean patchesAllBlack() {
        return false;
    }

    void updatePatch(PatchData patch) {
        if (patch.id() >= (long)this.patches.length) {
            this.handleError("ERROR: received update for non-existent patch (" + patch.stringRep() + ").");
            return;
        }
        PatchData bufPatch = this.patches[(int)patch.id()];
        if (bufPatch == null && !patch.isComplete()) {
            this.handleError("ERROR: received incremental update for non-existent patch (" + patch.stringRep() + ").");
        }
        bufPatch.updateFrom(patch);
        this.patchColors[(int)patch.id()] = Color.getARGBIntByRGBAList((LogoList)bufPatch.pcolor());
    }

    void updateTurtle(TurtleData turtle) {
        Long simpleKey = turtle.id();
        TurtleKey sortedKey = this.turtleKeys.get(simpleKey);
        if (turtle.isDead()) {
            if (sortedKey == null) {
                this.handleError("ERROR: received death message for non-existent turtle (" + turtle.stringRep() + ").");
                return;
            }
            this.sortedTurtles.remove(sortedKey);
            this.turtleKeys.remove(simpleKey);
            return;
        }
        TurtleData bufTurtle = null;
        if (sortedKey == null && (bufTurtle = this.uninitializedTurtles.get(simpleKey)) != null) {
            sortedKey = new TurtleKey(turtle.id(), turtle.getBreedIndex());
            this.sortedTurtles.put(sortedKey, bufTurtle);
            this.turtleKeys.put(simpleKey, sortedKey);
            this.uninitializedTurtles.remove(simpleKey);
        }
        if (sortedKey != null) {
            bufTurtle = (TurtleData)this.sortedTurtles.get(sortedKey);
        }
        if (bufTurtle == null) {
            if (turtle.isComplete()) {
                sortedKey = new TurtleKey(turtle.id(), turtle.getBreedIndex());
                this.sortedTurtles.put(sortedKey, turtle);
                this.turtleKeys.put(simpleKey, sortedKey);
            } else {
                this.handleError("ERROR: received incremental update for non-existent turtle (" + turtle.stringRep() + ").");
            }
            return;
        }
        bufTurtle.updateFrom(turtle);
        if (bufTurtle.getBreedIndex() != sortedKey.breedIndex) {
            this.sortedTurtles.remove(sortedKey);
            sortedKey = new TurtleKey(bufTurtle.id(), turtle.getBreedIndex());
            this.sortedTurtles.put(sortedKey, bufTurtle);
            this.turtleKeys.put(simpleKey, sortedKey);
        }
    }

    void updateLink(LinkData link) {
        Long simpleKey = link.id;
        LinkKey sortedKey = this.linkKeys.get(simpleKey);
        if (link.isDead()) {
            if (sortedKey == null) {
                this.handleError("ERROR: received death message for non-existent link ( " + link.stringRep() + " ).");
                return;
            }
            this.sortedLinks.remove(sortedKey);
            this.linkKeys.remove(simpleKey);
            return;
        }
        LinkData bufLink = null;
        if (sortedKey == null && (bufLink = this.uninitializedLinks.get(simpleKey)) != null) {
            sortedKey = new LinkKey(link.id, link.end1, link.end2, link.getBreedIndex());
            this.linkKeys.put(simpleKey, sortedKey);
            this.sortedLinks.put(sortedKey, link);
            this.uninitializedLinks.remove(simpleKey);
        }
        if (sortedKey != null) {
            bufLink = (LinkData)this.sortedLinks.get(sortedKey);
        }
        if (bufLink == null) {
            if (link.isComplete()) {
                sortedKey = new LinkKey(link.id, link.end1, link.end2, link.getBreedIndex());
                this.linkKeys.put(simpleKey, sortedKey);
                this.sortedLinks.put(sortedKey, link);
            } else {
                this.handleError("ERROR: received incremental update for non-existent turtle (" + link.stringRep() + ").");
            }
        } else {
            bufLink.updateFrom(link);
            if (link.isComplete() || bufLink.getBreedIndex() != sortedKey.breedIndex) {
                this.sortedLinks.remove(sortedKey);
                sortedKey = new LinkKey(link.id, link.end1, link.end2, link.getBreedIndex());
                this.sortedLinks.put(sortedKey, bufLink);
                this.linkKeys.put(simpleKey, sortedKey);
            }
        }
    }

    public void updateFrom(DataInputStream is) throws IOException {
        int i;
        int numToRead;
        short mask = is.readShort();
        boolean reallocatePatches = false;
        if ((mask & 1) == 1) {
            int minx = is.readInt();
            reallocatePatches = reallocatePatches || minx != this.minPxcor;
            this.minPxcor = minx;
        }
        if ((mask & 2) == 2) {
            int miny = is.readInt();
            reallocatePatches = reallocatePatches || miny != this.minPycor;
            this.minPycor = miny;
        }
        if ((mask & 0x10) == 16) {
            int maxx = is.readInt();
            reallocatePatches = reallocatePatches || maxx != this.maxPxcor;
            this.maxPxcor = maxx;
        }
        if ((mask & 0x20) == 32) {
            int maxy = is.readInt();
            reallocatePatches = reallocatePatches || maxy != this.maxPycor;
            this.maxPycor = maxy;
        }
        if (reallocatePatches) {
            this.createPatches(this.worldWidth() * this.worldHeight());
        }
        if ((mask & 4) == 4) {
            this.shapes = is.readBoolean();
        }
        if ((mask & 8) == 8) {
            this.fontSize = is.readInt();
        }
        if ((mask & 0x400) == 1024) {
            this.xWrap = is.readBoolean();
        }
        if ((mask & 0x800) == 2048) {
            this.yWrap = is.readBoolean();
        }
        if ((mask & 0x1000) == 4096) {
            this.updateServerPerspective(new AgentPerspective(is));
        }
        if ((mask & 0x80) == 128) {
            numToRead = is.readInt();
            for (i = 0; i < numToRead; ++i) {
                this.updatePatch(new PatchData(is));
            }
        }
        if ((mask & 0x40) == 64) {
            numToRead = is.readInt();
            for (i = 0; i < numToRead; ++i) {
                this.updateTurtle(new TurtleData(is));
            }
        }
        if ((mask & 0x100) == 256) {
            numToRead = is.readInt();
            for (i = 0; i < numToRead; ++i) {
                this.updateLink(new LinkData(is));
            }
        }
        if ((mask & 0x200) == 512) {
            this.trailDrawer.readImage(is);
        }
    }

    private void handleError(Object o) {
        if (this.printErrors) {
            System.err.println("@ " + new Date() + " : ");
            System.err.println(o.toString());
        }
    }

    TurtleData getTurtleDataByWho(long who) {
        TurtleKey key = this.turtleKeys.get(who);
        if (key != null) {
            return (TurtleData)this.sortedTurtles.get(key);
        }
        return null;
    }

    LinkData getLink(Long id) {
        LinkKey key = this.linkKeys.get(id);
        if (key == null) {
            LinkData link = this.uninitializedLinks.get(id);
            if (link == null) {
                link = new LinkData(id);
                this.uninitializedLinks.put(id, link);
            }
            return link;
        }
        return (LinkData)this.sortedLinks.get(key);
    }

    TurtleData getTurtle(Long id) {
        TurtleKey key = this.turtleKeys.get(id);
        if (key == null) {
            TurtleData turtle = this.uninitializedTurtles.get(id);
            if (turtle == null) {
                turtle = new TurtleData(id);
                this.uninitializedTurtles.put(id, turtle);
            }
            return turtle;
        }
        return (TurtleData)this.sortedTurtles.get(key);
    }

    public boolean serverMode() {
        return this.perspectiveMode == PerspectiveMode.SERVER;
    }

    public void updateServerPerspective(AgentPerspective p) {
        if (this.perspectiveMode == PerspectiveMode.SERVER) {
            this.perspective = Perspective.load(p.perspective);
            this.radius = p.radius;
            this.targetAgent = this.getAgent(p.agent);
        }
    }

    public void updateClientPerspective(AgentPerspective p) {
        this.perspective = Perspective.load(p.perspective);
        this.perspectiveMode = p.serverMode ? PerspectiveMode.SERVER : PerspectiveMode.CLIENT;
        this.targetAgent = this.getAgent(p.agent);
        this.radius = p.radius;
    }

    public double followOffsetX() {
        if (this.targetAgent == null || this.perspective != PerspectiveJ.FOLLOW() && this.perspective != PerspectiveJ.RIDE()) {
            return 0.0;
        }
        if (this.perspectiveMode == PerspectiveMode.CLIENT) {
            return this.targetAgent.xcor() - (this.viewWidth() - 1.0) / 2.0 - (double)this.minPxcor;
        }
        return this.targetAgent.xcor() - ((double)this.minPxcor - 0.5 + (double)this.worldWidth() / 2.0);
    }

    public double followOffsetY() {
        AgentData agent = this.targetAgent();
        if (agent == null || this.perspective != PerspectiveJ.FOLLOW() && this.perspective != PerspectiveJ.RIDE()) {
            return 0.0;
        }
        if (this.perspectiveMode == PerspectiveMode.CLIENT) {
            return this.targetAgent.ycor() + (this.viewHeight() - 1.0) / 2.0 - (double)this.maxPycor;
        }
        return this.targetAgent.ycor() - ((double)this.minPycor - 0.5 + (double)this.worldHeight() / 2.0);
    }

    public AgentData targetAgent() {
        return this.targetAgent;
    }

    public void viewWidth(int viewWidth) {
        this.viewWidth = viewWidth;
    }

    public void viewHeight(int viewHeight) {
        this.viewHeight = viewHeight;
    }

    public double viewWidth() {
        return (double)this.viewWidth / this.patchSize();
    }

    public double viewHeight() {
        return (double)this.viewHeight / this.patchSize();
    }

    AgentData getAgent(Agent agent) {
        if (agent.type == Agent.AgentType.TURTLE) {
            return this.getTurtle(agent.id);
        }
        if (agent.type == Agent.AgentType.PATCH) {
            return this.patches[(int)agent.id];
        }
        if (agent.type == Agent.AgentType.LINK) {
            return this.getLink(agent.id);
        }
        return null;
    }

    public void clearOverrides() {
        this.overrideMap.clear();
    }

    public void updateOverrides(SendOverride list) {
        block4: {
            block5: {
                block3: {
                    if (list.type != Agent.AgentType.TURTLE) break block3;
                    for (Long id : JavaConversions.setAsJavaSet(list.overrides().keySet())) {
                        this.addOverride(this.getTurtle(id), list.variable, list.overrides().apply(id));
                    }
                    break block4;
                }
                if (list.type != Agent.AgentType.PATCH) break block5;
                for (Long id : JavaConversions.setAsJavaSet(list.overrides().keySet())) {
                    this.addOverride(this.patches[id.intValue()], list.variable, list.overrides().apply(id));
                }
                break block4;
            }
            if (list.type != Agent.AgentType.LINK) break block4;
            for (Long id : JavaConversions.setAsJavaSet(list.overrides().keySet())) {
                this.addOverride(this.getLink(id), list.variable, list.overrides().apply(id));
            }
        }
    }

    private void addOverride(Overridable rider, int variable, Object value) {
        Map<Integer, Object> map2 = this.overrideMap.get(rider);
        if (map2 == null) {
            map2 = new HashMap<Integer, Object>();
            this.overrideMap.put(rider, map2);
        }
        map2.put(variable, value);
    }

    public void updateOverrides(ClearOverride list) {
        block4: {
            block5: {
                block3: {
                    if (list.type != Agent.AgentType.TURTLE) break block3;
                    for (Long id : JavaConversions.seqAsJavaList(list.agents())) {
                        this.removeOverride(this.getTurtle(id), list.variable);
                    }
                    break block4;
                }
                if (list.type != Agent.AgentType.PATCH) break block5;
                for (Long id : JavaConversions.seqAsJavaList(list.agents())) {
                    this.removeOverride(this.patches[id.intValue()], list.variable);
                }
                break block4;
            }
            if (list.type != Agent.AgentType.LINK) break block4;
            for (Long id : JavaConversions.seqAsJavaList(list.agents())) {
                this.removeOverride(this.getLink(id), list.variable);
            }
        }
    }

    private void removeOverride(Overridable rider, int variable) {
        Map<Integer, Object> map2 = this.overrideMap.get(rider);
        if (map2 != null) {
            map2.remove(variable);
        }
    }

    public void applyOverrides() {
        for (Overridable rider : this.overrideMap.keySet()) {
            Map<Integer, Object> overrides = this.overrideMap.get(rider);
            for (Integer var : overrides.keySet()) {
                rider.set(var, overrides.get(var));
            }
        }
    }

    public void rollbackOverrides() {
        for (Overridable rider : this.overrideMap.keySet()) {
            rider.rollback();
        }
    }

    @Override
    public AgentSet links() {
        throw new UnsupportedOperationException();
    }

    @Override
    public AgentSet turtles() {
        throw new UnsupportedOperationException();
    }

    @Override
    public AgentSet patches() {
        throw new UnsupportedOperationException();
    }

    public Program program() {
        throw new UnsupportedOperationException();
    }

    public ShapeList turtleShapeList() {
        throw new UnsupportedOperationException();
    }

    public ShapeList linkShapeList() {
        throw new UnsupportedOperationException();
    }

    public int patchesWithLabels() {
        throw new UnsupportedOperationException();
    }

    public Patch getPatch(int i) {
        throw new UnsupportedOperationException();
    }

    public Patch getPatchAt(double x, double y) {
        throw new UnsupportedOperationException();
    }

    @Override
    public Observer observer() {
        throw new UnsupportedOperationException();
    }

    @Override
    public Object getDrawing() {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean sendPixels() {
        throw new UnsupportedOperationException();
    }

    @Override
    public void markDrawingClean() {
        throw new UnsupportedOperationException();
    }

    public Protractor protractor() {
        throw new UnsupportedOperationException();
    }

    public double wrappedObserverX(double x) {
        throw new UnsupportedOperationException();
    }

    public double wrappedObserverY(double y) {
        throw new UnsupportedOperationException();
    }

    public void markPatchColorsClean() {
        throw new UnsupportedOperationException();
    }

    public void markPatchColorsDirty() {
        throw new UnsupportedOperationException();
    }

    public boolean patchColorsDirty() {
        throw new UnsupportedOperationException();
    }

    public Patch fastGetPatchAt(int x, int y) {
        throw new UnsupportedOperationException();
    }

    public int getVariablesArraySize(Link link, AgentSet breed) {
        throw new UnsupportedOperationException();
    }

    public String linksOwnNameAt(int i) {
        throw new UnsupportedOperationException();
    }

    public int getVariablesArraySize(Turtle turtle, AgentSet breed) {
        throw new UnsupportedOperationException();
    }

    public String turtlesOwnNameAt(int i) {
        throw new UnsupportedOperationException();
    }

    public String breedsOwnNameAt(AgentSet breed, int i) {
        throw new UnsupportedOperationException();
    }

    public Iterator<Object> allStoredValues() {
        throw new UnsupportedOperationException();
    }

    public boolean mayHavePartiallyTransparentObjects() {
        return false;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private strictfp static class LinkKeyComparator
    implements Comparator<LinkKey> {
        private LinkKeyComparator() {
        }

        @Override
        public int compare(LinkKey key1, LinkKey key2) {
            if (key1.end1 == key2.end1) {
                if (key1.end2 == key2.end2) {
                    if (key1.breedIndex == key2.breedIndex) {
                        return (int)(key1.id - key2.id);
                    }
                    return key1.breedIndex - key2.breedIndex;
                }
                return (int)(key1.end2 - key2.end2);
            }
            return (int)(key1.end1 - key2.end1);
        }
    }

    strictfp static class LinkKey {
        long id;
        long end1;
        long end2;
        int breedIndex;

        public LinkKey(long id, long end1, long end2, int breedIndex) {
            this.id = id;
            this.end1 = end1;
            this.end2 = end2;
            this.breedIndex = breedIndex;
        }

        public boolean equals(Object o) {
            return this.id == ((LinkKey)o).id;
        }

        public int hashCode() {
            return (int)this.id;
        }

        public String toString() {
            return "(" + this.id + " " + this.breedIndex + ")";
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private strictfp static class TurtleKeyComparator
    implements Comparator<TurtleKey> {
        private TurtleKeyComparator() {
        }

        @Override
        public int compare(TurtleKey tk1, TurtleKey tk2) {
            if (tk1.breedIndex == tk2.breedIndex) {
                return (int)(tk1.who - tk2.who);
            }
            return tk1.breedIndex - tk2.breedIndex;
        }
    }

    private strictfp static class TurtleKey {
        long who;
        int breedIndex;

        public TurtleKey(long who, int breedIndex) {
            this.who = who;
            this.breedIndex = breedIndex;
        }

        public boolean equals(Object o) {
            return this.who == ((TurtleKey)o).who && this.breedIndex == ((TurtleKey)o).breedIndex;
        }

        public int hashCode() {
            return (int)((long)(this.breedIndex * 1000) + this.who);
        }

        public String toString() {
            return "(" + this.who + " " + this.breedIndex + ")";
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public strictfp static enum PerspectiveMode {
        SERVER,
        CLIENT;

    }
}

