/*
 * Decompiled with CFR 0.152.
 */
package org.nlogo.render;

import java.awt.Color;
import java.awt.Image;
import org.nlogo.api.Constants;
import org.nlogo.api.GraphicsInterface;
import org.nlogo.api.Link;
import org.nlogo.api.World;
import org.nlogo.render.AbstractTopologyRenderer;
import org.nlogo.render.Drawable;
import org.nlogo.render.LinkDrawer;

public strictfp class HorizCylinderRenderer
extends AbstractTopologyRenderer {
    public HorizCylinderRenderer(World world) {
        super(world);
    }

    public void fillBackground(GraphicsInterface g) {
        if (this.viewOffsetX != 0.0) {
            this.fillWith(g, Constants.ViewBackground());
        }
    }

    public void wrapDrawable(Drawable obj, GraphicsInterface g, double xcor, double ycor, double turtleSize, double cellSize) {
        double size2 = turtleSize * cellSize + obj.adjustSize(turtleSize, cellSize);
        double offset = size2 / 2.0;
        double x = this.graphicsX(xcor, cellSize) - offset;
        double y = this.graphicsY(ycor, cellSize) - offset;
        g.push();
        g.translate(x, y);
        this.draw(obj, g, x, y, 0.0, 0.0, size2);
        if (y + size2 > (double)this.height) {
            this.draw(obj, g, x, y, 0.0, this.height, size2);
        }
        if (y < 0.0) {
            this.draw(obj, g, x, y, 0.0, -this.height, size2);
        }
        g.pop();
    }

    public void drawLabelHelper(GraphicsInterface g, double xcor, double ycor, String label, Object color, double patchSize, double size2) {
        double x = this.graphicsX(xcor + 0.5 * size2, patchSize);
        double y = this.graphicsY(ycor - 0.5 * size2, patchSize);
        int labelHeight = g.getFontMetrics().getHeight();
        g.setColor(org.nlogo.api.Color.getColor(color));
        this.drawLabel(label, g, x, y, 0.0, 0.0, patchSize);
        if (y > (double)this.height) {
            this.drawLabel(label, g, x, y, 0.0, this.height, patchSize);
        }
        if (y - (double)labelHeight < 0.0) {
            this.drawLabel(label, g, x, y, 0.0, -this.height, size2);
        }
    }

    public void paintAllPatchesBlack(GraphicsInterface g) {
        g.setColor(Color.BLACK);
        g.fillRect(this.worldAndViewPreMultipliedX, 0, this.width, this.height);
    }

    public void paintViewImage(GraphicsInterface g, Image image) {
        super.paintViewImage(g, image);
        int y = this.worldAndViewPreMultipliedY;
        if (this.worldAndViewPreMultipliedY > 0) {
            y = this.worldAndViewPreMultipliedY - this.height;
        } else if (this.worldAndViewPreMultipliedY < 0) {
            y = this.worldAndViewPreMultipliedY + this.height;
        }
        if (y != 0) {
            g.drawImage(image, this.worldAndViewPreMultipliedX, y, this.width, this.height);
        }
    }

    public void drawLink(GraphicsInterface g, Link link, LinkDrawer.LinkDrawable drawable, double patchSize, Color color, double lineThickness) {
        double x1 = this.graphicsX(link.x1(), patchSize);
        double y1 = this.graphicsY(link.y1(), patchSize);
        double x2 = this.graphicsX(link.x2(), patchSize);
        double y2 = this.graphicsY(link.y2(), patchSize);
        int lineWidth = (int)StrictMath.max(1.0, lineThickness * patchSize);
        g.setStroke(lineWidth);
        g.setColor(color);
        drawable.draw(g, link, color, x1, y1, x2, y2, patchSize, lineThickness);
        if (y2 + (double)lineWidth > (double)this.height) {
            drawable.draw(g, link, color, x1, y1 - (double)this.height, x2, y2 - (double)this.height, patchSize, lineThickness);
        }
        if (y2 - (double)lineWidth < 0.0) {
            drawable.draw(g, link, color, x1, y1 + (double)this.height, x2, y2 + (double)this.height, patchSize, lineThickness);
        }
    }

    public void drawLine(GraphicsInterface g, double startX, double startY, double endX, double endY, double penSize) {
        double x1 = this.graphicsXNoOffset(startX, this.world.patchSize());
        double y1 = this.graphicsYNoOffset(startY, this.world.patchSize());
        double x2 = this.graphicsXNoOffset(endX, this.world.patchSize());
        double y2 = this.graphicsYNoOffset(endY, this.world.patchSize());
        double size2 = penSize / 2.0;
        g.drawLine(x1, y1, x2, y2);
        if (penSize > 1.0) {
            if (y2 + size2 > (double)this.width) {
                g.drawLine(x1, y1 - (double)this.height, x2, y2 - (double)this.height);
            } else if (y1 - size2 < 0.0) {
                g.drawLine(x1, y1 + (double)this.height, x2, y2 + (double)this.height);
            }
        }
    }

    public double graphicsY(double ycor, double patchSize, double viewOffsetY) {
        return patchSize * (-ycor + (double)this.world.maxPycor() + 0.5 + viewOffsetY);
    }
}

