/*
 * Decompiled with CFR 0.152.
 */
package org.nlogo.render;

import java.awt.Color;
import org.nlogo.api.GraphicsInterface;
import org.nlogo.api.ShapeList;
import org.nlogo.api.Turtle;
import org.nlogo.render.Drawable;
import org.nlogo.render.TopologyRenderer;
import org.nlogo.render.TurtleShapeManager;
import org.nlogo.render.VectorShapeDrawable;
import org.nlogo.shape.VectorShape;

public strictfp class TurtleDrawer {
    final TurtleShapeManager shapes;

    public TurtleDrawer(ShapeList shapeList) {
        this.shapes = new TurtleShapeManager(shapeList);
    }

    public void drawTurtle(GraphicsInterface g, TopologyRenderer topology, Turtle turtle, double patchSize) {
        if (!turtle.hidden()) {
            if (turtle.size() * patchSize >= 3.0) {
                this.drawTurtleShape(g, topology, turtle, patchSize);
            } else {
                topology.drawWrappedRect(g, org.nlogo.api.Color.getColor(turtle.color()), 0.0f, turtle.xcor(), turtle.ycor(), turtle.size(), patchSize, true);
            }
            if (turtle.hasLabel()) {
                this.drawTurtleLabel(g, topology, turtle, patchSize);
            }
        }
    }

    void drawTurtleShape(GraphicsInterface g, TopologyRenderer topology, Turtle turtle, double patchSize) {
        Drawable d = this.getShapeFromCacheOrCreateDrawable(turtle, patchSize, this.shapes.getShape(turtle));
        topology.wrapDrawable(d, g, turtle.xcor(), turtle.ycor(), turtle.size(), patchSize);
    }

    private Drawable getShapeFromCacheOrCreateDrawable(Turtle turtle, double patchSize, VectorShape shape2) {
        if (this.shapes.useCache(turtle, patchSize) && !shape2.isTooSimpleToCache()) {
            Color turtleColor = org.nlogo.api.Color.getColor(turtle.color());
            Color fgColor = shape2.fgRecolorable() ? turtleColor : new Color(255, 255, 255, turtleColor.getAlpha());
            return this.shapes.getCachedShape(shape2, fgColor, turtle.heading(), turtle.size());
        }
        return new VectorShapeDrawable(shape2, org.nlogo.api.Color.getColor(turtle.color()), patchSize, (int)turtle.heading(), turtle.lineThickness(), turtle.size());
    }

    private void drawTurtleLabel(GraphicsInterface g, TopologyRenderer topology, Turtle turtle, double patchSize) {
        topology.drawLabelHelper(g, turtle.xcor(), turtle.ycor(), turtle.labelString(), turtle.labelColor(), patchSize, turtle.size());
    }
}

