/*
 * Decompiled with CFR 0.152.
 */
package org.nlogo.render;

import java.awt.Color;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.Map;
import java.util.Queue;
import org.nlogo.api.ShapeList;
import org.nlogo.api.Turtle;
import org.nlogo.render.CacheKey;
import org.nlogo.render.CachedShape;
import org.nlogo.shape.VectorShape;

public strictfp class TurtleShapeManager {
    private final Queue<CacheKey> cacheQueue = new LinkedList<CacheKey>();
    private final Map<CacheKey, CachedShape> shapeCache = new HashMap<CacheKey, CachedShape>();
    final ShapeList shapeList;
    private int cellSize;
    private int pixelCount = 0;
    private int angleStep;
    private int numAngleSteps;

    TurtleShapeManager(ShapeList shapeList) {
        this.shapeList = shapeList;
    }

    void resetCache(double patchSize) {
        this.shapeCache.clear();
        this.cacheQueue.clear();
        this.pixelCount = 0;
        this.cellSize = (int)StrictMath.floor(patchSize);
        if (this.cellSize == 0) {
            this.angleStep = 1;
        } else {
            this.angleStep = 30 / this.cellSize;
            if (this.angleStep == 0) {
                this.angleStep = 1;
            }
        }
        this.numAngleSteps = 360 / this.angleStep;
    }

    boolean useCache(Turtle turtle, double patchSize) {
        double turtleSize = turtle.size();
        return patchSize == (double)this.cellSize && (turtleSize == 1.0 || turtleSize == 1.5 || turtleSize == 2.0) && turtle.lineThickness() == 0.0;
    }

    VectorShape getShape(Turtle turtle) {
        return (VectorShape)this.shapeList.shape(turtle.shape());
    }

    CachedShape getCachedShape(VectorShape shape2, Color color, double angle, double size2) {
        int angleIndex;
        if (shape2.isRotatable()) {
            angleIndex = (int)StrictMath.rint(angle / (double)this.angleStep);
            if (angleIndex == this.numAngleSteps) {
                angleIndex = 0;
            }
            angle = angleIndex * this.angleStep;
        } else {
            angleIndex = 0;
            angle = 0.0;
        }
        CacheKey key = new CacheKey(color.getRGB(), angleIndex, shape2, size2);
        CachedShape cached = this.shapeCache.get(key);
        if (cached != null) {
            return cached;
        }
        while (this.pixelCount >= 0x200000) {
            this.discardOldestShape();
        }
        CachedShape newShape = new CachedShape(shape2, this.cellSize, (int)angle, size2, color);
        this.shapeCache.put(key, newShape);
        this.cacheQueue.add(key);
        this.pixelCount += newShape.getPixelCount();
        return newShape;
    }

    private void discardOldestShape() {
        CacheKey oldKey = this.cacheQueue.remove();
        this.pixelCount -= this.shapeCache.get(oldKey).getPixelCount();
        this.shapeCache.remove(oldKey);
    }
}

