/*
 * Decompiled with CFR 0.152.
 */
package org.nlogo.shape;

import java.awt.Color;
import java.awt.Point;
import java.awt.Rectangle;
import java.io.Serializable;
import java.util.List;
import org.nlogo.api.GraphicsInterface;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public strictfp abstract class Element
implements Serializable,
Cloneable {
    static final long serialVersionUID = 0L;
    protected boolean filled = false;
    protected boolean marked = false;
    protected boolean selected = false;
    protected Color c;

    public boolean filled() {
        return this.filled;
    }

    public boolean marked() {
        return this.marked;
    }

    public void setMarked(boolean marked) {
        this.marked = marked;
    }

    public Color getColor() {
        return this.c;
    }

    public void setColor(Color c) {
        this.c = c;
    }

    public Color getColor(Color turtleColor) {
        return this.marked && turtleColor != null ? turtleColor : (turtleColor == null || this.c.getAlpha() == turtleColor.getAlpha() ? this.c : new Color(this.c.getRed(), this.c.getGreen(), this.c.getBlue(), turtleColor.getAlpha()));
    }

    public Element(Color c) {
        this.c = c;
    }

    public abstract Rectangle getBounds();

    public abstract String toString();

    public abstract String toReadableString();

    public abstract void setFilled(boolean var1);

    public abstract void modify(Point var1, Point var2);

    public abstract void draw(GraphicsInterface var1, Color var2, double var3, double var5);

    public abstract void rotateLeft();

    public abstract void rotateRight();

    public abstract void flipHorizontal();

    public abstract void flipVertical();

    public abstract void setModifiedPoint(Point var1);

    public Object clone() {
        try {
            return super.clone();
        }
        catch (CloneNotSupportedException ex) {
            throw new IllegalStateException(ex);
        }
    }

    public abstract void reshapeElement(Point var1, Point var2);

    public abstract Point[] getHandles();

    public abstract boolean contains(Point var1);

    public abstract void moveElement(int var1, int var2);

    boolean shouldSave() {
        return true;
    }

    protected Rectangle createRect(Point start, Point end) {
        return new Rectangle(StrictMath.min(start.x, end.x), StrictMath.min(start.y, end.y), StrictMath.abs(start.x - end.x), StrictMath.abs(start.y - end.y));
    }

    protected int getElt(int i, List<Integer> v) {
        return v.get(i);
    }

    protected Point rotatePoint(Point point, Point pivot, int angle) {
        point = new Point(point.x, 2 * pivot.y - point.y);
        double radius = this.distance(point, pivot);
        if (radius == 0.0) {
            return point;
        }
        double newAngle = StrictMath.atan((double)(point.y - pivot.y) / (double)(point.x - pivot.x));
        if (point.x < pivot.x) {
            newAngle += Math.PI;
        }
        if (newAngle < 0.0) {
            newAngle += Math.PI * 2;
        }
        double newx = (double)pivot.x + radius * StrictMath.cos(newAngle -= Math.PI * 2 * (double)angle / 360.0);
        double newy = (double)pivot.y + radius * StrictMath.sin(newAngle);
        newy = (double)(2 * pivot.y) - newy;
        return new Point((int)StrictMath.rint(newx), (int)StrictMath.rint(newy));
    }

    protected double distance(Point center, Point circum) {
        return StrictMath.sqrt(StrictMath.pow(center.y - circum.y, 2.0) + StrictMath.pow(center.x - circum.x, 2.0));
    }

    public static int round(double d) {
        return (int)StrictMath.rint(d);
    }

    protected static int ceiling(double d) {
        return (int)StrictMath.ceil(d);
    }

    protected int min(int[] array) {
        int min = array[0];
        for (int i = 1; i < array.length; ++i) {
            if (array[i] >= min) continue;
            min = array[i];
        }
        return min;
    }

    protected int max(int[] array) {
        int max = array[0];
        for (int i = 1; i < array.length; ++i) {
            if (array[i] <= max) continue;
            max = array[i];
        }
        return max;
    }

    public void select() {
        this.selected = true;
    }

    public void deselect() {
        this.selected = false;
    }

    public boolean selected() {
        return this.selected;
    }
}

