/*
 * Decompiled with CFR 0.152.
 */
package org.nlogo.shape;

import java.awt.Color;
import java.awt.Shape;
import java.awt.geom.AffineTransform;
import java.awt.geom.QuadCurve2D;
import java.io.Serializable;
import java.util.StringTokenizer;
import org.nlogo.api.GraphicsInterface;

public strictfp class LinkLine
implements Serializable,
Cloneable {
    static final long serialVersionUID = 0L;
    private float[] dashes;
    private double xcor = 0.0;
    private boolean isVisible = false;
    public static final float[][] dashChoices = new float[][]{{0.0f, 1.0f}, {1.0f, 0.0f}, {2.0f, 2.0f}, {4.0f, 4.0f}, {4.0f, 4.0f, 2.0f, 2.0f}};

    public int dashIndex() {
        for (int i = 0; i < dashChoices.length; ++i) {
            if (this.dashes != dashChoices[i]) continue;
            return i;
        }
        return 1;
    }

    public LinkLine() {
        this.dashes = dashChoices[1];
    }

    public LinkLine(double xcor, boolean visible) {
        this.xcor = xcor;
        this.isVisible = visible;
        this.dashes = dashChoices[visible ? 1 : 0];
    }

    public boolean isStraightPlainLine() {
        return this.isVisible && this.xcor == 0.0 && this.dashes.length == 2 && this.dashes[0] == 1.0f && this.dashes[1] == 0.0f;
    }

    public boolean isVisible() {
        return this.isVisible;
    }

    public void setVisible(boolean isVisible) {
        this.isVisible = isVisible;
    }

    public void paint(GraphicsInterface g, Color color, double cellSize, float strokeWidth, Shape shape2) {
        g.setColor(color);
        g.setStroke(strokeWidth, this.dashes);
        g.draw(shape2);
    }

    public Shape getShape(double x1, double y1, double x2, double y2, double curviness, double size2, double cellSize, float stroke) {
        double ycomp = (x1 - x2) / size2;
        double xcomp = (y2 - y1) / size2;
        AffineTransform trans = AffineTransform.getTranslateInstance(xcomp * this.xcor * (double)stroke, ycomp * this.xcor * (double)stroke);
        double midX = (x1 + x2) / 2.0 + curviness * xcomp;
        double midY = (y1 + y2) / 2.0 + curviness * ycomp;
        return trans.createTransformedShape(new QuadCurve2D.Double(x1, y1, midX, midY, x2, y2));
    }

    public float[] getDashes() {
        return this.dashes;
    }

    public void setDashiness(float[] dashes) {
        this.dashes = dashes;
    }

    public void setDashes(String str) {
        StringTokenizer tokenizer = new StringTokenizer(str);
        this.dashes = new float[tokenizer.countTokens()];
        int i = 0;
        while (tokenizer.hasMoreTokens()) {
            this.dashes[i] = Float.parseFloat(tokenizer.nextToken());
            ++i;
        }
    }

    public String dashinessString() {
        String result2 = "";
        for (int i = 0; i < this.dashes.length; ++i) {
            if (result2.length() > 0) {
                result2 = result2 + " ";
            }
            result2 = result2 + this.dashes[i];
        }
        return result2;
    }

    public double xcor() {
        return this.xcor;
    }

    public Object clone() {
        LinkLine line;
        try {
            line = (LinkLine)super.clone();
        }
        catch (CloneNotSupportedException ex) {
            throw new IllegalStateException(ex);
        }
        line.dashes = new float[this.dashes.length];
        System.arraycopy(this.dashes, 0, line.dashes, 0, this.dashes.length);
        return line;
    }

    public String toString() {
        return this.xcor + " " + (this.isVisible ? "1" : "0") + " " + this.dashinessString();
    }

    public String toReadableString() {
        return "Link Line with xcor = " + this.xcor + " " + this.isVisible + " " + this.dashinessString();
    }

    private static int getDashIndex(float[] d2) {
        boolean success = false;
        for (int i = 0; i < dashChoices.length; ++i) {
            if (d2.length != dashChoices[i].length) continue;
            for (int j = 0; j < d2.length; ++j) {
                success = d2[j] == dashChoices[i][j];
            }
            if (!success) continue;
            return i;
        }
        return 1;
    }

    public static int parseLine(String[] shapes, String version, LinkLine line, int index2) {
        StringTokenizer tokenizer = new StringTokenizer(shapes[index2]);
        line.xcor = Double.parseDouble(tokenizer.nextToken());
        boolean bl = line.isVisible = Integer.parseInt(tokenizer.nextToken()) != 0;
        if (line.isVisible) {
            float[] d = new float[tokenizer.countTokens()];
            int i = 0;
            while (tokenizer.hasMoreTokens()) {
                d[i] = Float.parseFloat(tokenizer.nextToken());
                ++i;
            }
            line.dashes = dashChoices[LinkLine.getDashIndex(d)];
        } else {
            line.dashes = dashChoices[0];
        }
        return ++index2;
    }
}

