/*
 * Decompiled with CFR 0.152.
 */
package org.nlogo.shape;

import java.awt.Color;
import java.awt.Point;
import java.util.StringTokenizer;
import org.nlogo.api.Constants;
import org.nlogo.api.GraphicsInterface;
import org.nlogo.shape.Element;

public strictfp class Rectangle
extends Element
implements Cloneable {
    static final long serialVersionUID = 0L;
    protected Point upperLeft;
    protected Point upperRight;
    protected Point lowerRight;
    protected Point lowerLeft;
    protected int xmin;
    protected int xmax;
    protected int ymin;
    protected int ymax;
    private String modifiedPoint;

    public Rectangle(Point start, Point end, Color color) {
        super(color);
        this.upperLeft = new Point(start);
        this.upperRight = new Point(end.x, start.y);
        this.lowerLeft = new Point(start.x, end.y);
        this.lowerRight = new Point(end);
    }

    public void setFilled(boolean fill2) {
        this.filled = fill2;
    }

    public Object clone() {
        Rectangle newRect = (Rectangle)super.clone();
        newRect.upperLeft = (Point)newRect.upperLeft.clone();
        newRect.upperRight = (Point)newRect.upperRight.clone();
        newRect.lowerLeft = (Point)newRect.lowerLeft.clone();
        newRect.lowerRight = (Point)newRect.lowerRight.clone();
        return newRect;
    }

    public java.awt.Rectangle getBounds() {
        this.setMaxsAndMins();
        return new java.awt.Rectangle(this.xmin, this.ymin, this.xmax - this.xmin, this.ymax - this.ymin);
    }

    public boolean contains(Point p) {
        return this.getBounds().contains(p);
    }

    public void modify(Point start, Point last) {
        int width = StrictMath.abs(start.x - last.x);
        int height = StrictMath.abs(start.y - last.y);
        this.upperLeft.x = StrictMath.min(start.x, last.x);
        this.upperLeft.y = StrictMath.min(start.y, last.y);
        this.upperRight.x = this.upperLeft.x + width;
        this.upperRight.y = this.upperLeft.y;
        this.lowerRight.x = this.upperLeft.x + width;
        this.lowerRight.y = this.upperLeft.y + height;
        this.lowerLeft.x = this.upperLeft.x;
        this.lowerLeft.y = this.upperLeft.y + height;
    }

    public void reshapeElement(Point oldPoint, Point newPoint) {
        if (this.modifiedPoint.equals("upperLeft")) {
            this.upperLeft = newPoint;
            this.lowerLeft.x = newPoint.x;
            this.upperRight.y = newPoint.y;
        }
        if (this.modifiedPoint.equals("upperRight")) {
            this.upperRight = newPoint;
            this.lowerRight.x = newPoint.x;
            this.upperLeft.y = newPoint.y;
        }
        if (this.modifiedPoint.equals("lowerRight")) {
            this.lowerRight = newPoint;
            this.upperRight.x = newPoint.x;
            this.lowerLeft.y = newPoint.y;
        }
        if (this.modifiedPoint.equals("lowerLeft")) {
            this.lowerLeft = newPoint;
            this.upperLeft.x = newPoint.x;
            this.lowerRight.y = newPoint.y;
        }
        this.xmin = this.upperLeft.x;
        this.xmax = this.upperRight.x;
        this.ymin = this.upperLeft.y;
        this.ymax = this.lowerLeft.y;
    }

    public void moveElement(int xOffset, int yOffset) {
        this.upperLeft.x += xOffset;
        this.upperLeft.y += yOffset;
        this.upperRight.x += xOffset;
        this.upperRight.y += yOffset;
        this.lowerLeft.x += xOffset;
        this.lowerLeft.y += yOffset;
        this.lowerRight.x += xOffset;
        this.lowerRight.y += yOffset;
    }

    public Point[] getHandles() {
        int[] xcoords = new int[]{this.upperLeft.x, this.upperRight.x, this.lowerRight.x, this.lowerLeft.x};
        int[] ycoords = new int[]{this.upperLeft.y, this.upperRight.y, this.lowerRight.y, this.lowerLeft.y};
        Point[] handles = new Point[4];
        for (int i = 0; i < xcoords.length; ++i) {
            handles[i] = new Point(xcoords[i], ycoords[i]);
        }
        return handles;
    }

    public void setMaxsAndMins() {
        int[] xcoords = new int[]{this.upperLeft.x, this.upperRight.x, this.lowerRight.x, this.lowerLeft.x};
        int[] ycoords = new int[]{this.upperLeft.y, this.upperRight.y, this.lowerRight.y, this.lowerLeft.y};
        this.xmin = this.min(xcoords);
        this.xmax = this.max(xcoords);
        this.ymin = this.min(ycoords);
        this.ymax = this.max(ycoords);
    }

    public void draw(GraphicsInterface g, Color turtleColor, double scale, double angle) {
        g.setColor(this.getColor(turtleColor));
        if (this.filled) {
            g.fillRect(this.upperLeft.x, this.upperLeft.y, this.upperRight.x - this.upperLeft.x, this.lowerLeft.y - this.upperLeft.y, scale, angle);
        } else {
            g.drawRect(this.upperLeft.x, this.upperLeft.y, this.upperRight.x - this.upperLeft.x, this.lowerLeft.y - this.upperLeft.y, scale, angle);
        }
    }

    public void rotateLeft() {
        Point temp = this.lowerLeft;
        this.lowerLeft = this.upperLeft;
        this.upperLeft = this.upperRight;
        this.upperRight = this.lowerRight;
        this.lowerRight = temp;
        int temp2 = this.upperLeft.x;
        this.upperLeft.x = this.upperLeft.y;
        this.upperLeft.y = Constants.ShapeWidth() - temp2;
        temp2 = this.upperRight.x;
        this.upperRight.x = this.upperRight.y;
        this.upperRight.y = Constants.ShapeWidth() - temp2;
        temp2 = this.lowerLeft.x;
        this.lowerLeft.x = this.lowerLeft.y;
        this.lowerLeft.y = Constants.ShapeWidth() - temp2;
        temp2 = this.lowerRight.x;
        this.lowerRight.x = this.lowerRight.y;
        this.lowerRight.y = Constants.ShapeWidth() - temp2;
    }

    public void rotateRight() {
        Point temp = this.upperLeft;
        this.upperLeft = this.lowerLeft;
        this.lowerLeft = this.lowerRight;
        this.lowerRight = this.upperRight;
        this.upperRight = temp;
        int temp2 = this.upperLeft.x;
        this.upperLeft.x = Constants.ShapeWidth() - this.upperLeft.y;
        this.upperLeft.y = temp2;
        temp2 = this.lowerLeft.x;
        this.lowerLeft.x = Constants.ShapeWidth() - this.lowerLeft.y;
        this.lowerLeft.y = temp2;
        temp2 = this.upperRight.x;
        this.upperRight.x = Constants.ShapeWidth() - this.upperRight.y;
        this.upperRight.y = temp2;
        temp2 = this.lowerRight.x;
        this.lowerRight.x = Constants.ShapeWidth() - this.lowerRight.y;
        this.lowerRight.y = temp2;
    }

    public void flipHorizontal() {
        Point temp = this.upperLeft;
        this.upperLeft = this.upperRight;
        this.upperRight = temp;
        temp = this.lowerLeft;
        this.lowerLeft = this.lowerRight;
        this.lowerRight = temp;
        this.upperLeft.x = Constants.ShapeWidth() - this.upperLeft.x;
        this.upperRight.x = Constants.ShapeWidth() - this.upperRight.x;
        this.lowerLeft.x = Constants.ShapeWidth() - this.lowerLeft.x;
        this.lowerRight.x = Constants.ShapeWidth() - this.lowerRight.x;
    }

    public void flipVertical() {
        Point temp = this.upperLeft;
        this.upperLeft = this.lowerLeft;
        this.lowerLeft = temp;
        temp = this.lowerRight;
        this.lowerRight = this.upperRight;
        this.upperRight = temp;
        this.upperLeft.y = Constants.ShapeWidth() - this.upperLeft.y;
        this.upperRight.y = Constants.ShapeWidth() - this.upperRight.y;
        this.lowerLeft.y = Constants.ShapeWidth() - this.lowerLeft.y;
        this.lowerRight.y = Constants.ShapeWidth() - this.lowerRight.y;
    }

    public String toReadableString() {
        return "Type: Rectangle, color: " + this.c + ",\n bounds: " + this.getBounds();
    }

    public String toString() {
        return "Rectangle " + this.c.getRGB() + " " + this.filled + " " + this.marked + " " + this.upperLeft.x + " " + this.upperLeft.y + " " + this.lowerRight.x + " " + this.lowerRight.y;
    }

    public static Rectangle parseRectangle(String text2) {
        StringTokenizer tokenizer = new StringTokenizer(text2);
        tokenizer.nextToken();
        String color = tokenizer.nextToken();
        boolean b1 = tokenizer.nextToken().equals("true");
        boolean b2 = tokenizer.nextToken().equals("true");
        int x1 = Integer.valueOf(tokenizer.nextToken());
        int y1 = Integer.valueOf(tokenizer.nextToken());
        int x2 = Integer.valueOf(tokenizer.nextToken());
        int y2 = Integer.valueOf(tokenizer.nextToken());
        if (x1 == x2 && y1 == y2) {
            return null;
        }
        Rectangle rect = new Rectangle(new Point(x1, y1), new Point(x2, y2), Color.decode(color));
        rect.setFilled(b1);
        rect.setMarked(b2);
        return rect;
    }

    public void setModifiedPoint(Point modified) {
        if (modified.equals(this.upperLeft)) {
            this.modifiedPoint = "upperLeft";
        } else if (modified.equals(this.upperRight)) {
            this.modifiedPoint = "upperRight";
        } else if (modified.equals(this.lowerRight)) {
            this.modifiedPoint = "lowerRight";
        } else if (modified.equals(this.lowerLeft)) {
            this.modifiedPoint = "lowerLeft";
        }
    }

    public int getX() {
        return this.upperLeft.x;
    }

    public int getY() {
        return this.upperLeft.y;
    }

    public int getWidth() {
        return this.lowerRight.x - this.upperLeft.x;
    }

    public int getHeight() {
        return this.lowerRight.y - this.upperLeft.y;
    }

    public Point[] getCorners() {
        return new Point[]{this.upperLeft, this.lowerRight};
    }
}

