/*
 * Decompiled with CFR 0.152.
 */
package org.nlogo.shape;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Observable;
import org.nlogo.api.Color;
import org.nlogo.api.Constants;
import org.nlogo.api.GraphicsInterface;
import org.nlogo.api.Shape;
import org.nlogo.api.ShapeList;
import org.nlogo.api.VersionHistory;
import org.nlogo.shape.Circle;
import org.nlogo.shape.Element;
import org.nlogo.shape.Line;
import org.nlogo.shape.Polygon;
import org.nlogo.shape.Rectangle;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public strictfp class VectorShape
extends Observable
implements Serializable,
Cloneable,
Shape {
    static final long serialVersionUID = 0L;
    protected String name = "";
    protected int editableColorIndex;
    protected List<Element> elementList = new ArrayList<Element>();
    protected boolean rotatable = true;
    private Recolorable fgRecolorable = Recolorable.UNKNOWN;
    public static final int TURTLE_WIDTH = 25;
    public static final int CLOSE_ENOUGH = 10;
    public static final int NUM_GRID_LINES = 20;

    public void setName(String name) {
        this.name = name;
    }

    @Override
    public String getName() {
        return this.name;
    }

    public void setEditableColorIndex(int editableColorIndex) {
        this.editableColorIndex = editableColorIndex;
    }

    public int getEditableColorIndex() {
        return this.editableColorIndex;
    }

    public Object clone() {
        VectorShape newShape;
        try {
            newShape = (VectorShape)super.clone();
        }
        catch (CloneNotSupportedException ex) {
            throw new IllegalStateException(ex);
        }
        newShape.elementList = new ArrayList<Element>();
        for (Element e : this.elementList) {
            newShape.elementList.add((Element)e.clone());
        }
        return newShape;
    }

    public void setOutline() {
        for (Element e : this.elementList) {
            e.setFilled(false);
        }
    }

    public List<Element> getElements() {
        return this.elementList;
    }

    public void setRotatable(boolean rotatable) {
        this.rotatable = rotatable;
    }

    public boolean isRotatable() {
        return this.rotatable;
    }

    public boolean fgRecolorable() {
        if (this.fgRecolorable == Recolorable.UNKNOWN) {
            this.fgRecolorable = Recolorable.FALSE;
            java.awt.Color editableColor = new java.awt.Color(Color.getARGBByIndex(this.editableColorIndex));
            int n = this.elementList.size();
            for (int i = 0; i < n; ++i) {
                if (!this.element(i).getColor().equals(editableColor)) continue;
                this.fgRecolorable = Recolorable.TRUE;
                break;
            }
        }
        return this.fgRecolorable == Recolorable.TRUE;
    }

    public void markRecolorableElements(java.awt.Color editableColor, int editableColorIndex) {
        this.editableColorIndex = editableColorIndex;
        this.fgRecolorable = Recolorable.FALSE;
        for (int i = 0; i < this.elementList.size(); ++i) {
            if (this.element(i).getColor().equals(editableColor)) {
                this.element(i).setMarked(true);
                this.fgRecolorable = Recolorable.TRUE;
                continue;
            }
            this.element(i).setMarked(false);
        }
    }

    public boolean isTooSimpleToCache() {
        switch (this.elementList.size()) {
            case 0: {
                return true;
            }
            case 1: {
                Element element = this.element(0);
                return !(element instanceof Polygon);
            }
        }
        return false;
    }

    protected Element element(int i) {
        return this.elementList.get(i);
    }

    public void remove(Element element) {
        boolean removed = this.elementList.remove(element);
        if (removed) {
            this.setChanged();
            this.notifyObservers();
        }
    }

    public void changed() {
        this.setChanged();
        this.notifyObservers();
    }

    public void removeLast() {
        if (!this.elementList.isEmpty()) {
            int lastIndex = this.elementList.size() - 1;
            this.elementList.remove(lastIndex);
            this.setChanged();
            this.notifyObservers();
        }
    }

    public void removeAll() {
        if (!this.elementList.isEmpty()) {
            this.elementList.clear();
            this.setChanged();
            this.notifyObservers();
        }
    }

    public void add(Element element) {
        this.elementList.add(element);
        if (element instanceof Rectangle) {
            ((Rectangle)element).setMaxsAndMins();
        }
        this.setChanged();
        this.notifyObservers();
    }

    public void addAtPosition(int index2, Element element) {
        this.elementList.add(index2, element);
        this.setChanged();
        this.notifyObservers();
    }

    public void rotateLeft() {
        for (int i = 0; i < this.elementList.size(); ++i) {
            this.element(i).rotateLeft();
        }
    }

    public void rotateRight() {
        for (int i = 0; i < this.elementList.size(); ++i) {
            this.element(i).rotateRight();
        }
    }

    public void flipHorizontal() {
        for (int i = 0; i < this.elementList.size(); ++i) {
            this.element(i).flipHorizontal();
        }
    }

    public void flipVertical() {
        for (int i = 0; i < this.elementList.size(); ++i) {
            this.element(i).flipVertical();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void paint(GraphicsInterface g, java.awt.Color turtleColor, double x, double y, double size2, double cellSize, int angle, double lineThickness) {
        g.push();
        double scale = size2 * cellSize;
        if (!this.isRotatable()) {
            angle = 0;
        }
        try {
            if (angle != 0) {
                g.rotate((double)angle / 180.0 * Math.PI, x, y, scale);
            }
            g.translate(x, y);
            g.scale(scale, scale, Constants.ShapeWidth());
            g.setStrokeFromLineThickness(lineThickness, scale, cellSize, Constants.ShapeWidth());
            for (int i = 0; i < this.elementList.size(); ++i) {
                this.element(i).draw(g, turtleColor, scale, angle);
            }
        }
        finally {
            g.pop();
        }
    }

    public void paint(GraphicsInterface g, java.awt.Color turtleColor, int x, int y, double cellSize, int angle) {
        this.paint(g, turtleColor, x, y, 1.0, cellSize, angle, 0.0);
    }

    public String toReadableString() {
        String ret = "Shape " + this.name + ":\n";
        for (int i = 0; i < this.elementList.size(); ++i) {
            ret = ret + this.elementList.get(i).toString();
        }
        return ret;
    }

    public String toString() {
        String ret = this.name + "\n" + this.rotatable + "\n" + this.editableColorIndex;
        for (int i = 0; i < this.elementList.size(); ++i) {
            Element elt = this.elementList.get(i);
            if (!elt.shouldSave()) continue;
            ret = ret + "\n" + elt.toString();
        }
        return ret;
    }

    public void addElement(String line) {
        this.addElement(line, false);
    }

    public void addElement(String line, boolean translateClassicColorToNewColors) {
        Element element = null;
        if (line.startsWith("Line")) {
            element = Line.parseLine(line);
        } else if (line.startsWith("Rectangle")) {
            element = Rectangle.parseRectangle(line);
        } else if (line.startsWith("Circle")) {
            element = Circle.parseCircle(line);
        } else if (line.startsWith("Polygon")) {
            element = Polygon.parsePolygon(line);
        } else {
            throw new IllegalStateException("Invalid shape format in file: " + line);
        }
        if (element != null) {
            if (translateClassicColorToNewColors) {
                element.setColor(new java.awt.Color(Color.translateSavedColor(element.getColor().getRGB())));
            }
            this.add(element);
        }
    }

    public static List<Shape> parseShapes(String[] shapes, String version) {
        int index2;
        ArrayList<Shape> ret = new ArrayList<Shape>();
        for (index2 = 0; shapes.length > index2 && 0 == VectorShape.getString(shapes, index2).length(); ++index2) {
        }
        while (shapes.length > index2) {
            try {
                VectorShape shape2 = new VectorShape();
                index2 = VectorShape.parseShape(shapes, version, shape2, index2);
                ret.add(shape2);
            }
            catch (IllegalStateException e) {
                continue;
            }
            ++index2;
        }
        return ret;
    }

    public static int parseShape(String[] shapes, String version, VectorShape shape2, int index2) {
        boolean translateColors;
        shape2.setName(VectorShape.getString(shapes, index2++));
        if (shape2.getName().indexOf("StarLogoT") != -1) {
            throw new IllegalStateException("found StarLogoT version instead of shape");
        }
        shape2.setRotatable(VectorShape.getString(shapes, index2++).equals("true"));
        int rgb = Integer.valueOf(VectorShape.getString(shapes, index2++));
        boolean bl = translateColors = version != null && (VersionHistory.olderThan30pre5(version) || VersionHistory.olderThan3DPreview3(version));
        if (translateColors) {
            rgb = Color.translateSavedColor(rgb);
        }
        shape2.setEditableColorIndex(rgb);
        while (0 != VectorShape.getString(shapes, index2).length()) {
            shape2.addElement(VectorShape.getString(shapes, index2++), translateColors);
        }
        return index2;
    }

    static String getString(String[] v, int index2) {
        if (null != v && v.length > index2) {
            return v[index2];
        }
        return "";
    }

    public static VectorShape getDefaultShape() {
        VectorShape result2 = new VectorShape();
        result2.setName(ShapeList.DefaultShapeName());
        result2.setRotatable(true);
        result2.setEditableColorIndex(0);
        result2.addElement("Polygon -7500403 true true 150 5 40 250 150 205 260 250");
        return result2;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private strictfp static enum Recolorable {
        UNKNOWN,
        TRUE,
        FALSE;

    }
}

