/*
 * Decompiled with CFR 0.152.
 */
package org.nlogo.swing;

import ch.randelshofer.quaqua.QuaquaManager;
import java.awt.Color;
import java.io.File;
import java.io.IOException;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.InputMap;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.KeyStroke;
import javax.swing.UIManager;
import javax.swing.UnsupportedLookAndFeelException;
import javax.swing.border.Border;

public final class Utils {
    private static final Border WIDGET_BORDER = BorderFactory.createCompoundBorder(BorderFactory.createMatteBorder(1, 1, 0, 0, Color.GRAY), BorderFactory.createRaisedBevelBorder());
    private static final Border WIDGET_PRESSED_BORDER = BorderFactory.createCompoundBorder(BorderFactory.createMatteBorder(1, 1, 0, 0, Color.GRAY), BorderFactory.createLoweredBevelBorder());

    public static strictfp void setSystemLookAndFeel() {
        try {
            UIManager.put("Slider.paintValue", Boolean.FALSE);
            if (System.getProperty("os.name").startsWith("Mac")) {
                Utils.preloadQuaquaNativeLibraries();
                UIManager.setLookAndFeel(QuaquaManager.getLookAndFeelClassName());
            } else if (System.getProperty("os.name").startsWith("Windows")) {
                UIManager.setLookAndFeel(UIManager.getSystemLookAndFeelClassName());
            } else if (System.getProperty("swing.defaultlaf") == null) {
                try {
                    UIManager.setLookAndFeel("com.sun.java.swing.plaf.nimbus.NimbusLookAndFeel");
                }
                catch (Exception e) {
                    UIManager.setLookAndFeel(UIManager.getSystemLookAndFeelClassName());
                }
            }
        }
        catch (UnsupportedLookAndFeelException ex) {
            throw new IllegalStateException(ex);
        }
        catch (IllegalAccessException ex) {
            throw new IllegalStateException(ex);
        }
        catch (ClassNotFoundException ex) {
            throw new IllegalStateException(ex);
        }
        catch (InstantiationException ex) {
            throw new IllegalStateException(ex);
        }
    }

    private static strictfp void preloadQuaquaNativeLibraries() {
        try {
            String libraryName = QuaquaManager.getOS() >= 5 && QuaquaManager.getProperty("os.arch").equals("x86_64") ? "quaqua64" : "quaqua";
            System.load(new File(".").getCanonicalPath() + "/lib/Mac OS X/lib" + libraryName + ".jnilib");
            System.setProperty("Quaqua.jniIsPreloaded", "true");
        }
        catch (IOException ex) {
        }
        catch (UnsatisfiedLinkError unsatisfiedLinkError) {
            // empty catch block
        }
    }

    public static strictfp Border createWidgetBorder() {
        return WIDGET_BORDER;
    }

    public static strictfp Border createWidgetPressedBorder() {
        return WIDGET_PRESSED_BORDER;
    }

    public static strictfp void addEscKeyAction(JDialog dialog, Action action) {
        Utils.addEscKeyAction(dialog.getRootPane(), action);
    }

    public static strictfp void addEscKeyAction(JComponent component, Action action) {
        Utils.addEscKeyAction(component, component.getInputMap(2), action);
    }

    public static strictfp void addEscKeyAction(JComponent component, InputMap inputMap, Action action) {
        inputMap.put(KeyStroke.getKeyStroke(27, 0, false), "ESC_ACTION");
        component.getActionMap().put("ESC_ACTION", action);
    }
}

