/*
 * Decompiled with CFR 0.152.
 */
package org.nlogo.window;

import java.awt.Component;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import javax.swing.JOptionPane;
import org.nlogo.api.Version;
import org.nlogo.swing.BrowserLauncher;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
strictfp final class QuickHelp<TokenType> {
    private static boolean quickHelpLoaded = false;
    private static Map<String, String> quickHelpWords;
    private static Map<String, String> quickHelpWords3d;

    private QuickHelp() {
        throw new IllegalStateException();
    }

    private static Map<String, String> loadHelp(String path) {
        String[] lines = QuickHelp.getResourceAsStringArray(path);
        HashMap<String, String> words = new HashMap<String, String>();
        for (int i = 0; i < lines.length; ++i) {
            String anchor = lines[i].substring(0, lines[i].indexOf(32));
            String file = lines[i].substring(lines[i].indexOf(32) + 1);
            words.put(anchor, file);
        }
        return words;
    }

    private static void openDictionary(Component comp, String theWord, Map<String, String> words) {
        String theFile = words.get(theWord);
        BrowserLauncher.openURL(comp, "docs/dict/" + theFile, true);
    }

    public static void doHelp(Component comp, String token) {
        if (!quickHelpLoaded) {
            quickHelpWords = QuickHelp.loadHelp("/system/dict.txt");
            quickHelpWords3d = Version.is3D() ? QuickHelp.loadHelp("/system/dict3d.txt") : new HashMap<String, String>();
            quickHelpLoaded = true;
        }
        if (token == null) {
            return;
        }
        if (quickHelpWords3d.containsKey(token = token.toLowerCase())) {
            QuickHelp.openDictionary(comp, token, quickHelpWords3d);
        } else if (quickHelpWords.containsKey(token)) {
            QuickHelp.openDictionary(comp, token, quickHelpWords);
        } else if (0 == JOptionPane.showConfirmDialog(comp, token.toUpperCase() + " could not be found in the NetLogo Dictionary.\n" + "Would you like to open the full NetLogo Dictionary?", "NetLogo", 0)) {
            BrowserLauncher.openURL(comp, "docs/index2.html", true);
        }
    }

    public static String[] getResourceAsStringArray(String path) {
        try {
            String line;
            ArrayList<String> result2 = new ArrayList<String>();
            InputStream stream = QuickHelp.class.getResourceAsStream(path);
            BufferedReader in = new BufferedReader(new InputStreamReader(stream));
            while ((line = in.readLine()) != null) {
                result2.add(line);
            }
            return result2.toArray(new String[0]);
        }
        catch (IOException ex) {
            throw new IllegalStateException(ex);
        }
    }
}

