/*
 * Decompiled with CFR 0.152.
 */
package scala.collection.mutable;

import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.Arrays;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.None$;
import scala.Option;
import scala.PartialFunction;
import scala.Predef$;
import scala.Serializable;
import scala.Some;
import scala.Tuple2;
import scala.collection.GenTraversableOnce;
import scala.collection.GenTraversableOnce$class;
import scala.collection.Iterator;
import scala.collection.Iterator$;
import scala.collection.Iterator$class;
import scala.collection.Seq;
import scala.collection.Traversable;
import scala.collection.TraversableOnce$class;
import scala.collection.immutable.IndexedSeq;
import scala.collection.immutable.List;
import scala.collection.immutable.Map;
import scala.collection.immutable.Set;
import scala.collection.immutable.Stream;
import scala.collection.mutable.Buffer;
import scala.collection.mutable.FlatHashTable;
import scala.collection.mutable.FlatHashTable$;
import scala.collection.mutable.HashTable$;
import scala.collection.mutable.StringBuilder;
import scala.reflect.ClassManifest;
import scala.runtime.BoxesRunTime;

public abstract class FlatHashTable$class {
    public static int capacity(FlatHashTable $this, int expectedSize) {
        return expectedSize == 0 ? 1 : HashTable$.MODULE$.powerOfTwo(expectedSize);
    }

    private static int initialCapacity(FlatHashTable $this) {
        return $this.capacity(FlatHashTable$.MODULE$.initialSize());
    }

    public static void init(FlatHashTable $this, ObjectInputStream in, Function1 f) {
        in.defaultReadObject();
        $this._loadFactor_$eq(in.readInt());
        Predef$.MODULE$.assert($this._loadFactor() > 0);
        int size2 = in.readInt();
        $this.tableSize_$eq(0);
        Predef$.MODULE$.assert(size2 >= 0);
        $this.table_$eq(new Object[$this.capacity(FlatHashTable$.MODULE$.sizeForThreshold(size2, $this._loadFactor()))]);
        $this.threshold_$eq(FlatHashTable$.MODULE$.newThreshold($this._loadFactor(), Predef$.MODULE$.refArrayOps($this.table()).size()));
        boolean smDefined = in.readBoolean();
        if (smDefined) {
            $this.sizeMapInit($this.table().length);
        } else {
            $this.sizemap_$eq(null);
        }
        for (int index2 = 0; index2 < size2; ++index2) {
            Object elem = in.readObject();
            f.apply(elem);
            $this.addEntry(elem);
        }
    }

    public static void serializeTo(FlatHashTable $this, ObjectOutputStream out$1) {
        out$1.defaultWriteObject();
        out$1.writeInt($this._loadFactor());
        out$1.writeInt($this.tableSize());
        out$1.writeBoolean($this.isSizeMapDefined());
        $this.iterator().foreach(new Serializable($this, out$1){
            public static final long serialVersionUID;
            public final ObjectOutputStream out$1;

            static {
                long l = serialVersionUID = 0L;
            }

            public final void apply(Object object) {
                this.out$1.writeObject(object);
            }
            {
                this.out$1 = flatHashTable;
            }
        });
    }

    /*
     * WARNING - void declaration
     */
    public static boolean containsEntry(FlatHashTable $this, Object elem) {
        int h = $this.index($this.elemHashCode(elem));
        Object entry = $this.table()[h];
        void y1;
        void x1;
        Object object;
        Object object2;
        while (entry != null && !((object2 = entry) == (object = elem) ? true : (x1 == null ? false : (x1 instanceof Number ? BoxesRunTime.equalsNumObject((Number)x1, y1) : (x1 instanceof Character ? BoxesRunTime.equalsCharObject((Character)x1, y1) : x1.equals(y1)))))) {
            h = (h + 1) % $this.table().length;
            entry = $this.table()[h];
        }
        return entry != null;
    }

    /*
     * WARNING - void declaration
     */
    public static boolean addEntry(FlatHashTable $this, Object elem) {
        int h = $this.index($this.elemHashCode(elem));
        Object entry = $this.table()[h];
        while (true) {
            void y1;
            void x1;
            if (entry == null) {
                $this.table()[h] = elem;
                $this.tableSize_$eq($this.tableSize() + 1);
                $this.nnSizeMapAdd(h);
                if ($this.tableSize() >= $this.threshold()) {
                    FlatHashTable$class.growTable($this);
                }
                return true;
            }
            Object object = entry;
            Object object2 = elem;
            if (object == object2 ? true : (x1 == null ? false : (x1 instanceof Number ? BoxesRunTime.equalsNumObject((Number)x1, y1) : (x1 instanceof Character ? BoxesRunTime.equalsCharObject((Character)x1, y1) : x1.equals(y1))))) {
                return false;
            }
            h = (h + 1) % $this.table().length;
            entry = $this.table()[h];
        }
    }

    /*
     * WARNING - void declaration
     */
    public static Option removeEntry(FlatHashTable $this, Object elem) {
        int h = $this.index($this.elemHashCode(elem));
        Object entry = $this.table()[h];
        while (entry != null) {
            void y1;
            void x1;
            Object object = entry;
            Object object2 = elem;
            if (object == object2 ? true : (x1 == null ? false : (x1 instanceof Number ? BoxesRunTime.equalsNumObject((Number)x1, y1) : (x1 instanceof Character ? BoxesRunTime.equalsCharObject((Character)x1, y1) : x1.equals(y1))))) {
                int h0 = h;
                int h1 = (h0 + 1) % $this.table().length;
                while (true) {
                    if ($this.table()[h1] == null) {
                        $this.table()[h0] = null;
                        $this.tableSize_$eq($this.tableSize() - 1);
                        $this.nnSizeMapRemove(h0);
                        return new Some<Object>(entry);
                    }
                    int h2 = $this.index($this.elemHashCode($this.table()[h1]));
                    if (h2 != h1 && FlatHashTable$class.precedes$1($this, h2, h0)) {
                        $this.table()[h0] = $this.table()[h1];
                        h0 = h1;
                    }
                    h1 = (h1 + 1) % $this.table().length;
                }
            }
            h = (h + 1) % $this.table().length;
            entry = $this.table()[h];
        }
        return None$.MODULE$;
    }

    public static Iterator iterator(FlatHashTable $this) {
        return new Iterator<A>($this){
            private int i;
            private final FlatHashTable $outer;

            public Iterator<A> seq() {
                return Iterator$class.seq(this);
            }

            public boolean isEmpty() {
                return Iterator$class.isEmpty(this);
            }

            public boolean isTraversableAgain() {
                return Iterator$class.isTraversableAgain(this);
            }

            public boolean hasDefiniteSize() {
                return Iterator$class.hasDefiniteSize(this);
            }

            public Iterator<A> take(int n) {
                return Iterator$class.take(this, n);
            }

            public Iterator<A> drop(int n) {
                return Iterator$class.drop(this, n);
            }

            public Iterator<A> slice(int from2, int until) {
                return Iterator$class.slice(this, from2, until);
            }

            public <B> Iterator<B> map(Function1<A, B> f) {
                return Iterator$class.map(this, f);
            }

            public <B> Iterator<B> $plus$plus(Function0<GenTraversableOnce<B>> that) {
                return Iterator$class.$plus$plus(this, that);
            }

            public <B> Iterator<B> flatMap(Function1<A, GenTraversableOnce<B>> f) {
                return Iterator$class.flatMap(this, f);
            }

            public Iterator<A> filter(Function1<A, Object> p) {
                return Iterator$class.filter(this, p);
            }

            public Iterator<A> takeWhile(Function1<A, Object> p) {
                return Iterator$class.takeWhile(this, p);
            }

            public <B> Object zip(Iterator<B> that) {
                return Iterator$class.zip(this, that);
            }

            public <U> void foreach(Function1<A, U> f) {
                Iterator$class.foreach(this, f);
            }

            public boolean forall(Function1<A, Object> p) {
                return Iterator$class.forall(this, p);
            }

            public boolean exists(Function1<A, Object> p) {
                return Iterator$class.exists(this, p);
            }

            public Option<A> find(Function1<A, Object> p) {
                return Iterator$class.find(this, p);
            }

            public int indexWhere(Function1<A, Object> p) {
                return Iterator$class.indexWhere(this, p);
            }

            public <B> Object patch(int from2, Iterator<B> patchElems, int replaced) {
                return Iterator$class.patch(this, from2, patchElems, replaced);
            }

            public <B> void copyToArray(Object xs, int start, int len) {
                Iterator$class.copyToArray(this, xs, start, len);
            }

            public Traversable<A> toTraversable() {
                return Iterator$class.toTraversable(this);
            }

            public Iterator<A> toIterator() {
                return Iterator$class.toIterator(this);
            }

            public Stream<A> toStream() {
                return Iterator$class.toStream(this);
            }

            public String toString() {
                return Iterator$class.toString(this);
            }

            public int size() {
                return TraversableOnce$class.size(this);
            }

            public boolean nonEmpty() {
                return TraversableOnce$class.nonEmpty(this);
            }

            public <B> Option<B> collectFirst(PartialFunction<A, B> pf) {
                return TraversableOnce$class.collectFirst(this, pf);
            }

            public <B> B $div$colon(B z, Function2<B, A, B> op) {
                return (B)TraversableOnce$class.$div$colon(this, z, op);
            }

            public <B> B foldLeft(B z, Function2<B, A, B> op) {
                return (B)TraversableOnce$class.foldLeft(this, z, op);
            }

            public <B> void copyToBuffer(Buffer<B> dest) {
                TraversableOnce$class.copyToBuffer(this, dest);
            }

            public <B> void copyToArray(Object xs, int start) {
                TraversableOnce$class.copyToArray(this, xs, start);
            }

            public <B> Object toArray(ClassManifest<B> evidence$1) {
                return TraversableOnce$class.toArray(this, evidence$1);
            }

            public List<A> toList() {
                return TraversableOnce$class.toList(this);
            }

            public Seq<A> toSeq() {
                return TraversableOnce$class.toSeq(this);
            }

            public <B> IndexedSeq<B> toIndexedSeq() {
                return TraversableOnce$class.toIndexedSeq(this);
            }

            public <B> Buffer<B> toBuffer() {
                return TraversableOnce$class.toBuffer(this);
            }

            public <B> Set<B> toSet() {
                return TraversableOnce$class.toSet(this);
            }

            public <T, U> Map<T, U> toMap(Predef$.less.colon.less<A, Tuple2<T, U>> ev) {
                return TraversableOnce$class.toMap(this, ev);
            }

            public String mkString(String start, String sep, String end) {
                return TraversableOnce$class.mkString(this, start, sep, end);
            }

            public String mkString(String sep) {
                return TraversableOnce$class.mkString(this, sep);
            }

            public String mkString() {
                return TraversableOnce$class.mkString(this);
            }

            public StringBuilder addString(StringBuilder b, String start, String sep, String end) {
                return TraversableOnce$class.addString(this, b, start, sep, end);
            }

            private int i() {
                return this.i;
            }

            private void i_$eq(int n) {
                this.i = n;
            }

            public boolean hasNext() {
                while (this.i() < this.$outer.table().length && this.$outer.table()[this.i()] == null) {
                    this.i_$eq(this.i() + 1);
                }
                return this.i() < this.$outer.table().length;
            }

            public A next() {
                Object object;
                if (this.hasNext()) {
                    this.i_$eq(this.i() + 1);
                    object = this.$outer.table()[this.i() - 1];
                } else {
                    object = Iterator$.MODULE$.empty().next();
                }
                return object;
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
                GenTraversableOnce$class.$init$(this);
                TraversableOnce$class.$init$(this);
                Iterator$class.$init$(this);
                this.i = 0;
            }
        };
    }

    private static void growTable(FlatHashTable $this) {
        Object[] oldtable = $this.table();
        $this.table_$eq(new Object[$this.table().length * 2]);
        $this.tableSize_$eq(0);
        $this.nnSizeMapReset($this.table().length);
        $this.threshold_$eq(FlatHashTable$.MODULE$.newThreshold($this._loadFactor(), $this.table().length));
        for (int i = 0; i < oldtable.length; ++i) {
            Object entry = oldtable[i];
            if (entry == null) continue;
            $this.addEntry(entry);
        }
    }

    public static void nnSizeMapAdd(FlatHashTable $this, int h) {
        if ($this.sizemap() != null) {
            int p = h >> $this.sizeMapBucketBitSize();
            int[] nArray = $this.sizemap();
            nArray[p] = nArray[p] + 1;
        }
    }

    public static void nnSizeMapRemove(FlatHashTable $this, int h) {
        if ($this.sizemap() != null) {
            int[] nArray = $this.sizemap();
            int n = h >> $this.sizeMapBucketBitSize();
            nArray[n] = nArray[n] - 1;
        }
    }

    public static void nnSizeMapReset(FlatHashTable $this, int tableLength) {
        if ($this.sizemap() != null) {
            int nsize = $this.calcSizeMapSize(tableLength);
            if ($this.sizemap().length != nsize) {
                $this.sizemap_$eq(new int[nsize]);
            } else {
                Arrays.fill($this.sizemap(), 0);
            }
        }
    }

    public static final int totalSizeMapBuckets(FlatHashTable $this) {
        return ($this.table().length - 1) / $this.sizeMapBucketSize() + 1;
    }

    public static int calcSizeMapSize(FlatHashTable $this, int tableLength) {
        return (tableLength >> $this.sizeMapBucketBitSize()) + 1;
    }

    public static void sizeMapInit(FlatHashTable $this, int tableLength) {
        $this.sizemap_$eq(new int[$this.calcSizeMapSize(tableLength)]);
    }

    public static void sizeMapInitAndRebuild(FlatHashTable $this) {
        $this.sizeMapInit($this.table().length);
        int totalbuckets = $this.totalSizeMapBuckets();
        int tableidx = 0;
        Object[] tbl = $this.table();
        int tableuntil = Predef$.MODULE$.intWrapper($this.sizeMapBucketSize()).min(tbl.length);
        for (int bucketidx = 0; bucketidx < totalbuckets; ++bucketidx) {
            int currbucketsz = 0;
            while (tableidx < tableuntil) {
                if (tbl[tableidx] != null) {
                    ++currbucketsz;
                }
                ++tableidx;
            }
            $this.sizemap()[bucketidx] = currbucketsz;
            tableuntil += $this.sizeMapBucketSize();
        }
    }

    public static boolean isSizeMapDefined(FlatHashTable $this) {
        return $this.sizemap() != null;
    }

    public static boolean alwaysInitSizeMap(FlatHashTable $this) {
        return false;
    }

    public static final int index(FlatHashTable $this, int hcode) {
        int improved = $this.improve(hcode);
        int ones = $this.table().length - 1;
        return improved >>> 32 - Integer.bitCount(ones) & ones;
    }

    public static void initWithContents(FlatHashTable $this, FlatHashTable.Contents c) {
        if (c != null) {
            $this._loadFactor_$eq(c.loadFactor());
            $this.table_$eq(c.table());
            $this.tableSize_$eq(c.tableSize());
            $this.threshold_$eq(c.threshold());
            $this.sizemap_$eq(c.sizemap());
        }
        if ($this.alwaysInitSizeMap() && $this.sizemap() == null) {
            $this.sizeMapInitAndRebuild();
        }
    }

    private static final boolean precedes$1(FlatHashTable $this, int i, int j) {
        int d = $this.table().length >> 1;
        return i <= j ? j - i < d : i - j > d;
    }

    public static void $init$(FlatHashTable $this) {
        $this._loadFactor_$eq(FlatHashTable$.MODULE$.defaultLoadFactor());
        $this.table_$eq(new Object[FlatHashTable$class.initialCapacity($this)]);
        $this.tableSize_$eq(0);
        $this.threshold_$eq(FlatHashTable$.MODULE$.newThreshold($this._loadFactor(), FlatHashTable$class.initialCapacity($this)));
        $this.sizemap_$eq(null);
    }
}

