/*
 * Decompiled with CFR 0.152.
 */
package org.nlogo.agent;

import org.nlogo.agent.Agent;
import org.nlogo.agent.ArrayAgentSet;
import org.nlogo.agent.Link;
import org.nlogo.agent.Observer;
import org.nlogo.agent.Patch;
import org.nlogo.agent.Turtle;
import org.nlogo.agent.World;
import org.nlogo.api.LogoList;
import org.nlogo.util.MersenneTwisterFast;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public strictfp abstract class AgentSet
implements org.nlogo.api.AgentSet {
    private final byte agentBit;
    final Class<? extends Agent> type;
    final World world;
    private boolean isDirected = false;
    private boolean isUndirected = false;
    final boolean removableAgents;
    final String printName;

    public byte getAgentBit() {
        return this.agentBit;
    }

    public Class<? extends Agent> type() {
        return this.type;
    }

    @Override
    public World world() {
        return this.world;
    }

    public boolean isDirected() {
        return this.isDirected;
    }

    public boolean isUndirected() {
        return this.isUndirected;
    }

    public void setDirected(boolean directed) {
        this.isDirected = directed;
        this.isUndirected = !directed;
    }

    public void clearDirected() {
        this.isDirected = false;
        this.isUndirected = false;
    }

    @Override
    public abstract int count();

    AgentSet(Class<? extends Agent> type, World world, String printName, boolean removableAgents) {
        this.type = type;
        this.world = world;
        this.printName = printName;
        this.removableAgents = removableAgents;
        if (type == Patch.class) {
            this.agentBit = (byte)4;
        } else if (type == Turtle.class) {
            this.agentBit = (byte)2;
        } else if (type == Link.class) {
            this.agentBit = (byte)8;
        } else if (type == Observer.class) {
            this.agentBit = 1;
        } else {
            throw new IllegalStateException("unknown type: " + type);
        }
    }

    @Override
    public boolean equalAgentSets(org.nlogo.api.AgentSet otherSet) {
        return this == otherSet || this.type == otherSet.type() && this.count() == otherSet.count() && this.equalAgentSetsHelper(otherSet);
    }

    abstract boolean equalAgentSetsHelper(org.nlogo.api.AgentSet var1);

    @Override
    public String printName() {
        return this.printName;
    }

    public abstract boolean isEmpty();

    public abstract Agent agent(long var1);

    abstract Agent getAgent(Object var1);

    public abstract void add(Agent var1);

    abstract void remove(Object var1);

    abstract void clear();

    public abstract boolean contains(Agent var1);

    public abstract Agent randomOne(int var1, int var2);

    abstract Agent[] randomTwo(int var1, int var2, int var3);

    abstract Agent[] randomSubsetGeneral(int var1, int var2, MersenneTwisterFast var3);

    public AgentSet randomSubset(int resultSize, int precomputedCount, MersenneTwisterFast randomerizer) {
        Agent[] result = resultSize == 0 ? new Agent[]{} : (resultSize == 1 ? new Agent[]{this.randomOne(precomputedCount, randomerizer.nextInt(precomputedCount))} : (resultSize == 2 ? this.randomTwo(precomputedCount, randomerizer.nextInt(precomputedCount), randomerizer.nextInt(precomputedCount - 1)) : this.randomSubsetGeneral(resultSize, precomputedCount, randomerizer)));
        return new ArrayAgentSet(this.type, result, this.world);
    }

    public abstract LogoList toLogoList();

    public abstract Agent[] toArray();

    public abstract Iterator iterator();

    public abstract Iterator shufflerator(MersenneTwisterFast var1);

    @Override
    public Iterable<org.nlogo.api.Agent> agents() {
        return new Iterable<org.nlogo.api.Agent>(){
            Iterator it;
            {
                this.it = AgentSet.this.iterator();
            }

            @Override
            public java.util.Iterator<org.nlogo.api.Agent> iterator() {
                return new java.util.Iterator<org.nlogo.api.Agent>(){

                    @Override
                    public boolean hasNext() {
                        return it.hasNext();
                    }

                    @Override
                    public Agent next() {
                        return it.next();
                    }

                    @Override
                    public void remove() {
                        throw new UnsupportedOperationException();
                    }
                };
            }
        };
    }

    public static interface Iterator {
        public boolean hasNext();

        public Agent next();

        public void remove();
    }
}

