/*
 * Decompiled with CFR 0.152.
 */
package org.nlogo.agent;

import java.io.BufferedReader;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.BitSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.nlogo.agent.Agent;
import org.nlogo.agent.AgentSet;
import org.nlogo.agent.ImportLexer;
import org.nlogo.agent.Link;
import org.nlogo.agent.Observer;
import org.nlogo.agent.Patch;
import org.nlogo.agent.Turtle;
import org.nlogo.agent.World;
import org.nlogo.api.AgentException;
import org.nlogo.api.AgentVariables;
import org.nlogo.api.Color;
import org.nlogo.api.ExtensionException;
import org.nlogo.api.ImportErrorHandler;
import org.nlogo.api.ImporterUser;
import org.nlogo.api.LogoException;
import org.nlogo.api.Perspective;
import org.nlogo.api.PlotInterface;
import org.nlogo.api.PlotPenInterface;
import org.nlogo.api.WorldDimensions;
import scala.Option;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public strictfp class Importer
implements ImportErrorHandler {
    final ImporterUser importerUser;
    final ErrorHandler errorHandler;
    final World world;
    final StringReader stringReader;
    Set<Object> shapesNotToImport;
    Set<String> breedsNotToImport;
    List<String> someBreedOwns;
    List<String> someLinkBreedOwns;
    static final String SCREEN_EDGE_X_HEADER = "SCREEN-EDGE-X";
    static final String SCREEN_EDGE_Y_HEADER = "SCREEN-EDGE-Y";
    static final String MIN_PXCOR_HEADER = "MIN-PXCOR";
    static final String MAX_PXCOR_HEADER = "MAX-PXCOR";
    static final String MIN_PYCOR_HEADER = "MIN-PYCOR";
    static final String MAX_PYCOR_HEADER = "MAX-PYCOR";
    static final String PERSPECTIVE_HEADER = "PERSPECTIVE";
    static final String SUBJECT_HEADER = "SUBJECT";
    static final String NEXT_INDEX_HEADER = "NEXTINDEX";
    static final String DIRECTED_LINKS_HEADER = "DIRECTED-LINKS";
    static final String TICKS_HEADER = "TICKS";
    boolean needToResize = false;
    private boolean olderThan40beta2 = false;
    BitSet varsToImport;
    String[] builtInVars;
    boolean tooManyValuesForSection = false;
    boolean convertPenDown = false;
    boolean convertTopology = false;
    boolean importLinks = true;
    int TURTLE_BREED;
    Map<Class<? extends Agent>, List<String>> specialVariables;
    Map<Class<? extends Agent>, List<String>> essentialVarHeadersToImport;
    int lineNum = 0;
    String nextLine;
    private String[] nextLineFields;
    private static final int REQUIRED_SECTIONS = 3;
    private final String[] sentinels = new String[]{"GLOBALS", "TURTLES", "PATCHES", "LINKS", "DRAWING", "OUTPUT", "PLOTS", "EXTENSIONS", "DONE"};
    private final int numSentinels = this.sentinels.length - 1;
    private int currentSentinel = 0;
    BufferedReader lines;
    static final String NO_DETAILS = "";

    void setupVarsToImport(int size2) {
        this.varsToImport = new BitSet(size2);
        for (int j = 0; j < size2; ++j) {
            this.varsToImport.set(j);
        }
    }

    public Importer(ErrorHandler errorHandler, World world, ImporterUser importerUser, StringReader stringReader) {
        this.errorHandler = errorHandler;
        this.world = world;
        this.importerUser = importerUser;
        this.stringReader = stringReader;
        this.TURTLE_BREED = 8;
        this.shapesNotToImport = new HashSet<Object>();
        this.breedsNotToImport = new HashSet<String>();
        this.someBreedOwns = this.getAllBreedVars();
        this.someLinkBreedOwns = this.getAllLinkBreedVars();
        this.specialVariables = this.fillSpecialVariables();
    }

    void checkVersion(String versionNumber) throws AbortingImportException {
        if (versionNumber.startsWith("1.") || versionNumber.startsWith("2.0") || versionNumber.startsWith("2.1") || versionNumber.startsWith("2.2pre1") || versionNumber.startsWith("2.2pre2")) {
            this.convertPenDown = true;
            this.convertTopology = true;
            this.importLinks = false;
        } else if (versionNumber.startsWith("3.0")) {
            this.convertTopology = true;
            this.importLinks = false;
        }
        if (versionNumber.startsWith("1.") || versionNumber.startsWith("2.") || versionNumber.startsWith("3.")) {
            this.importLinks = false;
        }
        if (versionNumber.startsWith("1.") || versionNumber.startsWith("2.") || versionNumber.startsWith("3.") || versionNumber.startsWith("4.0pre") || versionNumber.startsWith("4.0alpha") || versionNumber.startsWith("4.0beta1")) {
            this.olderThan40beta2 = true;
        }
    }

    public void importWorld(BufferedReader fileBuff) throws IOException {
        this.lines = fileBuff;
        try {
            while (this.hasMoreLines(false)) {
                String versionHeader;
                String[] line = this.nextLine();
                if (line[0].startsWith(versionHeader = "export-world data (NetLogo ")) {
                    String versionNumber = line[0].substring(versionHeader.length());
                    this.checkVersion(versionNumber);
                }
                if (!line[0].trim().equals("RANDOM STATE")) continue;
                this.hasMoreLines(false);
                line = this.nextLine();
                this.world.mainRNG.load(line[0]);
            }
            this.essentialVarHeadersToImport = this.fillEssentialVarsToImport();
            this.world.clearAll();
            this.importAgents(Observer.class);
            this.importAgents(Turtle.class);
            this.importAgents(Patch.class);
            this.checkForBlankTurtles();
            if (this.importLinks) {
                this.importAgents(Link.class);
            }
            if (this.nextLine != null && this.nextLine.indexOf("DRAWING") != -1) {
                this.importDrawing();
            }
            if (this.nextLine != null && this.nextLine.indexOf("OUTPUT") != -1) {
                this.importOutputArea();
            }
            if (this.needToResize) {
                this.importerUser.resizeView();
            }
            this.importPlots();
            this.importExtensionData();
        }
        catch (AbortingImportException aix) {
            this.world.clearAll();
            if (aix.errorType != ImportError.ERROR_GIVEN) {
                this.showError(aix);
            }
        }
        catch (InvalidDataException e) {
            this.errorHandler.showError("Error Importing Drawing", "Invalid data length, the drawing will not be imported", false);
        }
    }

    void importPlots() throws IOException {
        if (this.hasMoreLines(false)) {
            String[] line = this.nextLine();
            String currentPlot2 = line[0];
            if (currentPlot2.length() > 0) {
                this.importerUser.currentPlot(currentPlot2);
            }
            while (this.hasMoreLines(false)) {
                line = this.nextLine();
                try {
                    String plotName = (String)this.getTokenValue(line[0], false, false);
                    PlotInterface plot2 = this.importerUser.getPlot(plotName);
                    if (plot2 == null) {
                        this.errorHandler.showError("Error Importing Plots", "The plot \"" + plotName + "\" does not exist.", false);
                        while (this.hasMoreLines(false)) {
                        }
                        return;
                    }
                    int numPens = this.importIntro(plot2);
                    this.importPens(plot2, numPens);
                    this.importPoints(plot2);
                    plot2.makeDirty();
                }
                catch (ClassCastException e) {
                    throw new AbortingImportException(ImportError.ILLEGAL_CLASS_CAST_ERROR, NO_DETAILS);
                }
            }
        }
    }

    int importIntro(PlotInterface plot2) throws IOException {
        if (this.hasMoreLines(false) && this.hasMoreLines(false)) {
            String[] line = this.nextLine();
            plot2.xMin_$eq(this.readNumber(line[0]));
            plot2.xMax_$eq(this.readNumber(line[1]));
            plot2.yMin_$eq(this.readNumber(line[2]));
            plot2.yMax_$eq(this.readNumber(line[3]));
            plot2.autoPlotOn_$eq(this.readBoolean(line[4]));
            plot2.currentPen_$eq(this.readString(line[5]));
            plot2.legendIsOpen_$eq(this.readBoolean(line[6]));
            return (int)this.readNumber(line[7]);
        }
        return 0;
    }

    void importPens(PlotInterface plot2, int numPens) throws IOException {
        if (this.hasMoreLines(false)) {
            for (int i = 0; i < numPens; ++i) {
                if (!this.hasMoreLines(false)) continue;
                String[] line = this.nextLine();
                Object value = this.getTokenValue(line[0], false, false);
                if (value instanceof Junk) {
                    return;
                }
                Option<PlotPenInterface> penMaybe = plot2.getPen((String)value);
                if (penMaybe.isDefined()) {
                    PlotPenInterface pen = penMaybe.get();
                    pen.isDown_$eq(this.readBoolean(line[1]));
                    pen.mode_$eq((int)this.readNumber(line[2]));
                    pen.interval_$eq(this.readNumber(line[3]));
                    pen.color_$eq(Color.getARGBbyPremodulatedColorNumber(this.readNumber(line[4])));
                    pen.x_$eq(this.readNumber(line[5]));
                    continue;
                }
                this.errorHandler.showError("Error Importing Plots", "The pen \"" + value + "\" does not exist.", false);
                while (this.hasMoreLines(false)) {
                    this.nextLine();
                }
            }
        }
    }

    void importPoints(PlotInterface plot2) throws IOException {
        if (this.hasMoreLines(false)) {
            String[] line = this.nextLine();
            String[] pens = new String[(line.length - 1) / 4 + 1];
            for (int i = 0; i < pens.length; ++i) {
                pens[i] = this.readString(line[i * 4]);
            }
            if (this.hasMoreLines(false)) {
                while (this.hasMoreLines(true)) {
                    String[] data = this.nextLine();
                    for (int i = 0; i < pens.length; ++i) {
                        Option<PlotPenInterface> penMaybe = plot2.getPen(pens[i]);
                        if (penMaybe.isDefined()) {
                            PlotPenInterface pen = penMaybe.get();
                            if (data[i * 4].length() <= 0) continue;
                            try {
                                pen.plot(this.readNumber(data[i * 4]), this.readNumber(data[i * 4 + 1]), Color.getARGBbyPremodulatedColorNumber((int)this.readNumber(data[i * 4 + 2])), this.readBoolean(data[i * 4 + 3]));
                            }
                            catch (ClassCastException e) {
                                this.errorHandler.showError("Import Error", "Error while importing " + plot2.name() + ", this point will be skipped.", false);
                            }
                            continue;
                        }
                        this.errorHandler.showError("Error Importing Plots", "The pen \"" + pens[i] + "\" does not exist.", false);
                    }
                }
            }
        }
    }

    private double readNumber(String line) {
        Object value = this.getTokenValue(line, false, false);
        if (!(value instanceof Junk)) {
            return (Double)value;
        }
        return 0.0;
    }

    private boolean readBoolean(String line) {
        Object value = this.getTokenValue(line, false, false);
        if (!(value instanceof Junk)) {
            return (Boolean)value;
        }
        return false;
    }

    private String readString(String line) {
        Object value = this.getTokenValue(line, false, false);
        if (!(value instanceof Junk)) {
            return (String)value;
        }
        return null;
    }

    void importOutputArea() throws IOException {
        StringBuilder outputString = new StringBuilder();
        while (this.hasMoreLines(false)) {
            String[] fields = this.nextLine();
            for (int i = 0; i < fields.length; ++i) {
                outputString.append(fields[i]);
            }
        }
        if (outputString.length() > 0) {
            this.importerUser.setOutputAreaContents((String)this.getTokenValue(outputString.toString(), false, false));
        } else {
            this.importerUser.setOutputAreaContents(NO_DETAILS);
        }
    }

    void importDrawing() throws IOException {
        if (this.hasMoreLines(false)) {
            Double patchSize = Double.valueOf(this.nextLine()[0]);
            this.importerUser.patchSize(patchSize);
            this.importerUser.resizeView();
            this.needToResize = false;
            int width = (int)(patchSize * (double)this.world.worldWidth());
            int height = (int)(patchSize * (double)this.world.worldHeight());
            StringBuilder colorString = new StringBuilder(width * height * 32);
            try {
                while (this.hasMoreLines(false)) {
                    String[] line = this.nextLine();
                    for (int i = 0; i < line.length; ++i) {
                        colorString.append(this.stringReader.readFromString(line[i].replaceAll(",", NO_DETAILS)));
                    }
                }
                int[] colors = Importer.fromHexString(colorString.toString());
                if (colors.length != width * height * 4) {
                    throw new InvalidDataException("The data was not the correct length for the size of the world");
                }
                this.world.trailDrawer.setColors(colors);
            }
            catch (StringReaderException e) {
                throw new InvalidDataException("invalid drawing data: drawing will not be imported");
            }
        }
    }

    public void importExtensionData() {
        try {
            if (this.hasMoreLines(false)) {
                String[] line = this.nextLine();
                String extensionName = line[0];
                while (this.hasMoreLines(false)) {
                    ArrayList<String[]> lines2 = new ArrayList<String[]>();
                    while (!this.importerUser.isExtensionName((line = this.nextLine())[0])) {
                        lines2.add(line);
                        if (this.hasMoreLines(false)) continue;
                    }
                    this.importerUser.importExtensionData(extensionName, lines2, this);
                    extensionName = line[0];
                }
            }
        }
        catch (ExtensionException e) {
            this.errorHandler.showError("Error Importing Extension Data", e.getMessage(), false);
        }
        catch (IOException e) {
            this.errorHandler.showError("Error Importing Extension Data", e.getMessage(), false);
        }
    }

    void importAgents(Class<? extends Agent> agentClass) throws IOException {
        this.tooManyValuesForSection = false;
        this.builtInVars = this.getImplicitVariables(agentClass);
        String[] headers = this.getHeaders(agentClass);
        this.setupVarsToImport(headers.length);
        while (this.hasMoreLines(false)) {
            String[] line = this.nextLine();
            this.importOneAgent(agentClass, line, headers);
        }
    }

    void importOneAgent(Class<? extends Agent> agentClass, String[] line, String[] headers) {
        Map<String, Object> varVals = this.getVarVals(headers, line, agentClass);
        if (agentClass == Observer.class) {
            this.setScreenDimensions(varVals);
        }
        varVals = this.getVarVals(headers, line, agentClass);
        Agent agent = this.nextAgent(agentClass, varVals);
        for (int i = 0; i < headers.length; ++i) {
            Object value;
            String header2 = headers[i];
            if (this.isSpecialVariable(agentClass, header2)) {
                this.handleSpecialVariable(agent, header2, varVals, i);
                continue;
            }
            int varIndex = this.getVarIndex(agent, header2, i);
            if (varIndex == -1 || (value = varVals.get(header2)) == null) continue;
            this.setVarVal(agent, varIndex, header2, value);
        }
    }

    Agent nextAgent(Class<? extends Agent> agentClass, Map<String, Object> varVals) {
        if (agentClass == Observer.class) {
            return this.world.observer();
        }
        if (agentClass == Turtle.class) {
            AgentSet breed = this.getTurtleBreed(varVals, this.builtInVars[this.TURTLE_BREED]);
            long id = this.getTurtleId(varVals, this.builtInVars[0]);
            Turtle turtle2 = this.world.getOrCreateTurtle(id);
            turtle2.setBreed(breed);
            return turtle2;
        }
        if (agentClass == Patch.class) {
            return this.getPatch(varVals);
        }
        if (agentClass == Link.class) {
            AgentSet breed = this.getLinkBreed(varVals, this.builtInVars[6]);
            Turtle end1 = this.getLinkEnd(varVals, this.builtInVars[0]);
            Turtle end2 = this.getLinkEnd(varVals, this.builtInVars[1]);
            return this.world.getOrCreateLink(end1, end2, breed);
        }
        return null;
    }

    void handleSpecialVariable(Agent agent, String header2, Map<String, Object> varVals, int headerIndex) {
        try {
            if (!(agent instanceof Observer)) {
                int varIndex = this.getVarIndex(agent, header2, headerIndex);
                if (varIndex != -1) {
                    if (agent instanceof Turtle) {
                        this.handleSpecialTurtleVariable((Turtle)agent, varVals.get(header2), varIndex);
                    } else if (agent instanceof Patch) {
                        this.handleSpecialPatchVariable((Patch)agent, varVals.get(header2), varIndex);
                    } else if (agent instanceof Link) {
                        this.handleSpecialLinkVariable((Link)agent, varVals.get(header2), varIndex, header2);
                    }
                }
            } else {
                this.handleSpecialObserverVariable((Observer)agent, varVals.get(header2), header2);
            }
        }
        catch (ImportException ix) {
            this.showError(ix);
        }
    }

    void handleSpecialObserverVariable(Observer observer, Object val, String header2) {
        if (header2.equals(PERSPECTIVE_HEADER)) {
            observer.perspective(Perspective.load(((Double)val).intValue()));
        } else if (header2.equals(SUBJECT_HEADER) && val instanceof Agent) {
            observer.targetAgent((Agent)val);
        } else if (header2.equals(NEXT_INDEX_HEADER)) {
            this.world.nextTurtleIndex(((Double)val).longValue());
        } else if (header2.equals(DIRECTED_LINKS_HEADER)) {
            String str = (String)val;
            if (!str.equals("NEITHER")) {
                this.world.links().setDirected(str.equals("DIRECTED"));
            }
        } else if (header2.equals(TICKS_HEADER)) {
            this.world.tickCounter.ticks_$eq((Double)val);
        }
    }

    void handleSpecialTurtleVariable(Turtle turtle2, Object val, int varIndex) {
        switch (varIndex) {
            case 5: {
                this.setTurtleShape(turtle2, val, this.builtInVars[5], varIndex);
                break;
            }
            case 6: {
                this.setVarVal(turtle2, varIndex, this.builtInVars[6], this.getLabel(val));
                break;
            }
            case 0: 
            case 8: {
                break;
            }
            default: {
                throw new IllegalStateException();
            }
        }
    }

    void handleSpecialLinkVariable(Link link, Object val, int varIndex, String header2) {
        switch (varIndex) {
            case 3: {
                this.setVarVal(link, varIndex, this.builtInVars[3], this.getLabel(val));
                break;
            }
            case 0: 
            case 1: 
            case 6: {
                break;
            }
            default: {
                throw new IllegalStateException();
            }
        }
    }

    void handleSpecialPatchVariable(Patch patch2, Object val, int varIndex) {
        switch (varIndex) {
            case 3: {
                this.setVarVal(patch2, varIndex, this.builtInVars[3], this.getLabel(val));
                break;
            }
            case 0: 
            case 1: {
                break;
            }
            default: {
                throw new IllegalStateException();
            }
        }
    }

    String[] getHeaders(Class<? extends Agent> agentClass) throws IOException {
        if (!this.hasMoreLines(false)) {
            String abortingError = "No " + this.printName(agentClass) + " headers have been imported. " + "Globals, Turtles, and Patches must be in the same import file.";
            throw new AbortingImportException(ImportError.UNEXPECTED_EOF_ERROR, abortingError);
        }
        String[] mixedCaseHeaders = this.nextLine();
        ArrayList<String> headers = new ArrayList<String>();
        for (int i = 0; i < mixedCaseHeaders.length; ++i) {
            if (mixedCaseHeaders[i].trim().equals(NO_DETAILS)) continue;
            if (this.convertPenDown && mixedCaseHeaders[i].equalsIgnoreCase("PEN-DOWN?")) {
                headers.add("PEN-MODE");
                continue;
            }
            headers.add(mixedCaseHeaders[i].toUpperCase());
        }
        String[] headersArr = headers.toArray(new String[headers.size()]);
        this.varHeadersImported(agentClass, headersArr, true);
        this.varHeadersImported(agentClass, headersArr, false);
        return headersArr;
    }

    List<String> getOptionalHeaders(Class<? extends Agent> agentClass) {
        if (this.convertPenDown && agentClass == Turtle.class) {
            return Arrays.asList("PEN-SIZE", "PEN-COLOR");
        }
        if (this.olderThan40beta2 && agentClass == Link.class) {
            return Arrays.asList("SHAPE", "TIE-MODE");
        }
        if (agentClass == Link.class) {
            return Arrays.asList("TIE-MODE");
        }
        return null;
    }

    Map<String, Object> getVarVals(String[] headersArr, String[] values2, Class<? extends Agent> agentClass) {
        int i;
        HashMap<String, Object> varVals = new HashMap<String, Object>();
        if (!this.tooManyValuesForSection && values2.length > headersArr.length) {
            for (i = headersArr.length; i < values2.length; ++i) {
                if (values2[i].equals(NO_DETAILS)) continue;
                this.tooManyValuesForSection = true;
                this.showError(new ImportException(ImportError.TOO_MANY_VALUES_ERROR, "Too Many Values For Agent", "There are a total of " + headersArr.length + " " + this.printName(agentClass) + " variables declared in this " + "model (including built-in " + (agentClass == Turtle.class || agentClass == Link.class ? "and breed " : NO_DETAILS) + "variables).  The import-world file has at least one agent " + "in the " + this.printSectionName() + " section with more than this number of values.", "All the extra values will be ignored for this section."));
            }
        }
        for (i = 0; i < headersArr.length; ++i) {
            Junk value;
            boolean linkBreedVar;
            boolean turtleBreedVar = agentClass == Turtle.class && headersArr[i].equals(this.builtInVars[this.TURTLE_BREED]);
            boolean bl = linkBreedVar = agentClass == Link.class && headersArr[i].equals(this.builtInVars[6]);
            if (this.convertPenDown && headersArr[i].equals("PEN-MODE")) {
                if (values2[i].equalsIgnoreCase("FALSE")) {
                    values2[i] = "\"up\"";
                } else if (values2[i].equals("TRUE")) {
                    values2[i] = "\"down\"";
                }
            }
            Junk junk = value = values2[i].equals(NO_DETAILS) ? new Junk() : this.getTokenValue(values2[i], turtleBreedVar, linkBreedVar);
            if (this.essentialVarHeadersToImport.get(agentClass).contains(headersArr[i]) && value instanceof Junk) {
                String abortingError = "A " + this.printName(agentClass) + " with the essential variable " + headersArr[i] + " cannot be imported since the agent's value in the import" + " file for " + headersArr[i] + " could not be imported.";
                throw new AbortingImportException(ImportError.UNIMPORTED_ESSENTIAL_VAR_ERROR, abortingError);
            }
            varVals.put(headersArr[i], value);
        }
        return varVals;
    }

    boolean validBreed(String breed) {
        return this.world.getBreed(breed.toUpperCase()) != null || breed.equalsIgnoreCase("TURTLES") || breed.equalsIgnoreCase("PATCHES") || breed.equalsIgnoreCase("LINKS");
    }

    Object getTokenValue(String valueString, boolean turtleBreedVar, boolean linkBreedVar) {
        try {
            return this.stringReader.readFromString(valueString);
        }
        catch (StringReaderException ex) {
            if (turtleBreedVar) {
                if (!this.breedsNotToImport.contains(valueString)) {
                    this.breedsNotToImport.add(valueString);
                    this.showError(new ImportException(ImportError.ILLEGAL_BREED_ERROR, "Illegal Breed", ex.getMessage(), "all turtles with this breed will be made as regular turtles"));
                }
                return this.world.turtles();
            }
            if (linkBreedVar) {
                if (!this.breedsNotToImport.contains(valueString)) {
                    this.breedsNotToImport.add(valueString);
                    this.showError(new ImportException(ImportError.ILLEGAL_BREED_ERROR, "Illegal Link Breed", ex.getMessage(), "all links with this breed will be made as regular links"));
                }
                return this.world.links();
            }
            this.showError(new ImportException(ImportError.PARSING_ERROR, "Parsing Error", "error parsing the values:\n" + valueString, "the import will continue if it can, but values for this agent's variables will be set to an appropriate default", ex.getMessage()));
            return new Junk();
        }
    }

    int getVarIndex(Agent agent, String header2, int headerIndex) {
        Class<? extends Agent> agentClass = agent.getAgentClass();
        int varIndex = Arrays.asList(this.builtInVars).indexOf(header2);
        String agentType = this.printName(agentClass);
        if (varIndex == -1) {
            if (agentClass == Observer.class) {
                varIndex = this.world.observerOwnsIndexOf(header2);
            } else if (agentClass == Patch.class) {
                varIndex = this.world.patchesOwnIndexOf(header2);
            } else if (agentClass == Turtle.class ? (varIndex = this.world.turtlesOwnIndexOf(header2)) == -1 && (varIndex = this.getBreedVarIndex((Turtle)agent, header2)) == -1 && this.someBreedOwns.contains(header2) : agentClass == Link.class && (varIndex = this.world.linksOwnIndexOf(header2)) == -1 && (varIndex = this.getLinkBreedVarIndex((Link)agent, header2)) == -1 && this.someLinkBreedOwns.contains(header2)) {
                return -1;
            }
        }
        if (this.varsToImport.get(headerIndex) && varIndex == -1) {
            this.varsToImport.clear(headerIndex);
            this.showError(new ImportException(ImportError.ILLEGAL_AGENT_VAR_ERROR, "Illegal " + agentType + " Variable", "the " + agentType + " variable " + header2 + " does not " + "exist in this model.", "the import will continue but this variable will be ignored."));
        }
        return varIndex;
    }

    int getBreedVarIndex(Turtle turtle2, String header2) {
        if (turtle2.getBreed() != this.world.turtles() && this.world.breedOwns(turtle2.getBreed(), header2)) {
            return this.world.breedsOwnIndexOf(turtle2.getBreed(), header2);
        }
        return -1;
    }

    int getLinkBreedVarIndex(Link link, String header2) {
        if (link.getBreed() != this.world.links() && this.world.linkBreedOwns(link.getBreed(), header2)) {
            return this.world.linkBreedsOwnIndexOf(link.getBreed(), header2);
        }
        return -1;
    }

    void setVarVal(Agent agent, int index, String header2, Object value) {
        try {
            if (value instanceof Junk) {
                value = World.ZERO;
            }
            agent.setVariable(index, value);
        }
        catch (AgentException ae) {
            this.showError(new ImportException(ImportError.SETTING_VAR_ERROR, "Error Setting Value", "could not set " + agent + "'s variable " + header2 + " to " + value, "the import will continue, but the variable will be set to an appropriate default."));
        }
        catch (LogoException ae) {
            this.showError(new ImportException(ImportError.SETTING_VAR_ERROR, "Error Setting Value", "could not set " + agent + "'s variable " + header2 + " to " + value, "the import will continue, but the variable will be set to an appropriate default."));
        }
    }

    Patch getPatch(Map<String, Object> varVals) {
        try {
            int pxcor = ((Double)varVals.get(this.builtInVars[0])).intValue();
            int pycor = ((Double)varVals.get(this.builtInVars[1])).intValue();
            if (!this.world.validPatchCoordinates(pxcor, pycor)) {
                String abortingError = "Illegal Patch Coordinate- pxcor and pycor must be in range.";
                throw new AbortingImportException(ImportError.ILLEGAL_PCOR_ERROR, abortingError);
            }
            return this.world.fastGetPatchAt(pxcor, pycor);
        }
        catch (ClassCastException cce) {
            String abortingError = "Illegal Patch Coordinate- pxcor and pycor must be integers.";
            throw new AbortingImportException(ImportError.ILLEGAL_CLASS_CAST_ERROR, abortingError);
        }
    }

    long getTurtleId(Map<String, Object> varVals, String whoHeaderName) {
        try {
            return ((Double)varVals.get(whoHeaderName)).longValue();
        }
        catch (ClassCastException cce) {
            String abortingError = "Illegal Who- a turtle's who must be an integer.";
            throw new AbortingImportException(ImportError.ILLEGAL_CLASS_CAST_ERROR, abortingError);
        }
    }

    long getLinkId(Map<String, Object> varVals, String whoHeaderName) {
        try {
            return ((Double)varVals.get(whoHeaderName)).longValue();
        }
        catch (ClassCastException cce) {
            String abortingError = "Illegal lwho- a link's who must be an integer.";
            throw new AbortingImportException(ImportError.ILLEGAL_CLASS_CAST_ERROR, abortingError);
        }
    }

    Turtle getLinkEnd(Map<String, Object> varVals, String headerName) {
        try {
            return (Turtle)varVals.get(headerName);
        }
        catch (ClassCastException cce) {
            String abortingError = "Illegal End a link's end points must be a turtle.";
            throw new AbortingImportException(ImportError.ILLEGAL_CLASS_CAST_ERROR, abortingError);
        }
    }

    void setTurtleShape(Turtle turtle2, Object shape2, String header2, int varIndex) {
        try {
            turtle2.setVariable(varIndex, shape2);
        }
        catch (AgentException ae) {
            if (!this.shapesNotToImport.contains(shape2)) {
                this.shapesNotToImport.add(shape2);
                throw new ImportException(ImportError.ILLEGAL_SHAPE_ERROR, "Illegal Shape", ae.getMessage(), "setting " + turtle2 + "'s shape to its breed's default shape");
            }
            this.setVarVal(turtle2, varIndex, header2, this.world.turtleBreedShapes.breedShape(turtle2.getBreed()));
        }
    }

    AgentSet getTurtleBreed(Map<String, Object> varVals, String breedHeaderName) {
        if (varVals.containsKey(breedHeaderName)) {
            return (AgentSet)varVals.get(breedHeaderName);
        }
        return this.world.turtles();
    }

    AgentSet getLinkBreed(Map<String, Object> varVals, String breedHeaderName) {
        if (varVals.containsKey(breedHeaderName)) {
            return (AgentSet)varVals.get(breedHeaderName);
        }
        return this.world.links();
    }

    Object getLabel(Object val) {
        if (val instanceof Junk) {
            return NO_DETAILS;
        }
        return val;
    }

    void setScreenDimensions(Map<String, Object> varVals) {
        try {
            int maxy;
            int miny;
            int maxx;
            int minx;
            if (!this.convertTopology) {
                minx = ((Double)varVals.get(MIN_PXCOR_HEADER)).intValue();
                maxx = ((Double)varVals.get(MAX_PXCOR_HEADER)).intValue();
                miny = ((Double)varVals.get(MIN_PYCOR_HEADER)).intValue();
                maxy = ((Double)varVals.get(MAX_PYCOR_HEADER)).intValue();
            } else {
                int sex = ((Double)varVals.get(SCREEN_EDGE_X_HEADER)).intValue();
                int sey = ((Double)varVals.get(SCREEN_EDGE_Y_HEADER)).intValue();
                minx = -sex;
                maxx = sex;
                miny = -sey;
                maxy = sey;
            }
            if (minx != this.world.minPxcor() || maxx != this.world.maxPxcor() || miny != this.world.minPycor() || maxy != this.world.maxPycor()) {
                this.importerUser.setDimensions(new WorldDimensions(minx, maxx, miny, maxy));
                this.needToResize = true;
            }
        }
        catch (ClassCastException cce) {
            String abortingError = "Illegal Screen dimension- max-px/ycor, min-px/ycor must be numbers.";
            throw new AbortingImportException(ImportError.ILLEGAL_CLASS_CAST_ERROR, abortingError);
        }
    }

    List<String> getAllBreedVars() {
        ArrayList<String> allBreedOwns = new ArrayList<String>();
        Map<String, Object> breeds = this.world.getBreeds();
        if (breeds != null) {
            for (AgentSet agentSet : breeds.values()) {
                List<String> breedOwns = this.world.program().breedsOwn().get(agentSet.printName());
                if (breedOwns == null) continue;
                for (int i = 0; i < breedOwns.size(); ++i) {
                    allBreedOwns.add(breedOwns.get(i));
                }
            }
        }
        return allBreedOwns;
    }

    List<String> getAllLinkBreedVars() {
        ArrayList<String> allBreedOwns = new ArrayList<String>();
        Map<String, Object> breeds = this.world.getLinkBreeds();
        if (breeds != null) {
            for (AgentSet agentSet : breeds.values()) {
                List<String> breedOwns = this.world.program().linkBreedsOwn().get(agentSet.printName());
                if (breedOwns == null) continue;
                for (int i = 0; i < breedOwns.size(); ++i) {
                    allBreedOwns.add(breedOwns.get(i));
                }
            }
        }
        return allBreedOwns;
    }

    Map<Class<? extends Agent>, List<String>> fillSpecialVariables() {
        HashMap<Class<? extends Agent>, List<String>> result = new HashMap<Class<? extends Agent>, List<String>>();
        List<String> specialObserverVars = this.stringArrayToList(this.getSpecialObserverVariables());
        List<String> specialTurtleVars = this.stringArrayToList(this.getSpecialTurtleVariables());
        List<String> specialPatchVars = this.stringArrayToList(this.getSpecialPatchVariables());
        List<String> specialLinkVars = this.stringArrayToList(this.getSpecialLinkVariables());
        result.put(Observer.class, specialObserverVars);
        result.put(Turtle.class, specialTurtleVars);
        result.put(Patch.class, specialPatchVars);
        result.put(Link.class, specialLinkVars);
        return result;
    }

    private List<String> stringArrayToList(String[] vars) {
        ArrayList<String> list = new ArrayList<String>(vars.length);
        for (int i = 0; i < vars.length; ++i) {
            list.add(vars[i]);
        }
        return list;
    }

    String[] getSpecialObserverVariables() {
        return new String[]{MIN_PXCOR_HEADER, MAX_PXCOR_HEADER, MIN_PYCOR_HEADER, MAX_PYCOR_HEADER, SCREEN_EDGE_X_HEADER, SCREEN_EDGE_Y_HEADER, PERSPECTIVE_HEADER, SUBJECT_HEADER, NEXT_INDEX_HEADER, DIRECTED_LINKS_HEADER, TICKS_HEADER};
    }

    String[] getSpecialTurtleVariables() {
        String[] vars = AgentVariables.getImplicitTurtleVariables(false);
        return new String[]{vars[0], vars[8], vars[6], vars[5]};
    }

    String[] getSpecialPatchVariables() {
        String[] vars = AgentVariables.getImplicitPatchVariables(false);
        return new String[]{vars[0], vars[1], vars[3]};
    }

    String[] getSpecialLinkVariables() {
        String[] vars = AgentVariables.getImplicitLinkVariables();
        return new String[]{vars[6], vars[3], vars[0], vars[1]};
    }

    boolean isSpecialVariable(Class<? extends Agent> agentClass, String header2) {
        return this.specialVariables.get(agentClass).contains(header2);
    }

    Map<Class<? extends Agent>, List<String>> fillEssentialVarsToImport() {
        HashMap<Class<? extends Agent>, List<String>> result = new HashMap<Class<? extends Agent>, List<String>>();
        List<String> essentialObserverVarHeaders = !this.convertTopology ? this.stringArrayToList(this.getEssentialObserverVars()) : this.stringArrayToList(this.getEssentialObserverVarsOld());
        List<String> essentialTurtleVarHeaders = this.stringArrayToList(this.getEssentialTurtleVariables());
        List<String> essentialPatchVarHeaders = this.stringArrayToList(this.getEssentialPatchVariables());
        List<String> essentialLinkVarHeaders = this.stringArrayToList(this.getEssentialLinkVariables());
        result.put(Observer.class, essentialObserverVarHeaders);
        result.put(Turtle.class, essentialTurtleVarHeaders);
        result.put(Patch.class, essentialPatchVarHeaders);
        result.put(Link.class, essentialLinkVarHeaders);
        return result;
    }

    String[] getEssentialObserverVars() {
        return new String[]{MIN_PXCOR_HEADER, MAX_PXCOR_HEADER, MIN_PYCOR_HEADER, MAX_PYCOR_HEADER};
    }

    String[] getEssentialObserverVarsOld() {
        return new String[]{SCREEN_EDGE_X_HEADER, SCREEN_EDGE_Y_HEADER};
    }

    String[] getEssentialTurtleVariables() {
        return new String[]{AgentVariables.getImplicitTurtleVariables(false)[0]};
    }

    String[] getEssentialPatchVariables() {
        String[] vars = AgentVariables.getImplicitPatchVariables(false);
        return new String[]{vars[0], vars[1]};
    }

    String[] getEssentialLinkVariables() {
        String[] vars = AgentVariables.getImplicitLinkVariables();
        return new String[]{vars[0], vars[1]};
    }

    void varHeadersImported(Class<? extends Agent> agentClass, String[] headers, boolean essentialHeaders) {
        List<String> headersToCheckFor = essentialHeaders ? this.essentialVarHeadersToImport.get(agentClass) : Arrays.asList(this.builtInVars);
        List<String> optionalHeaders = this.getOptionalHeaders(agentClass);
        for (int i = 0; i < headersToCheckFor.size(); ++i) {
            String header2 = headersToCheckFor.get(i);
            boolean foundHeader = false;
            for (int j = 0; j < headers.length; ++j) {
                if (!header2.equals(headers[j])) continue;
                foundHeader = true;
                break;
            }
            if (foundHeader) continue;
            if (essentialHeaders) {
                String abortingError = header2 + " is not in the list of variables to be imported " + "from the import file in the " + this.printSectionName() + " section. " + "This variable is essential to a model.";
                throw new AbortingImportException(ImportError.UNDECLARED_ESSENTIAL_VAR_ERROR, abortingError);
            }
            if (optionalHeaders != null && optionalHeaders.contains(header2)) continue;
            this.showError(new ImportException(ImportError.UNDECLARED_AGENT_VAR_ERROR, "Implicit Variable Not Declared", "the " + this.printName(agentClass) + " variable " + header2 + " was not declared.", "the import will continue but all agents with this variable will have it set to an appropriate default."));
        }
    }

    String[] getImplicitVariables(Class<? extends Agent> agentClass) {
        if (agentClass == Observer.class) {
            return AgentVariables.getImplicitObserverVariables();
        }
        if (agentClass == Turtle.class) {
            return AgentVariables.getImplicitTurtleVariables(this.world.program().is3D());
        }
        if (agentClass == Patch.class) {
            return AgentVariables.getImplicitPatchVariables(this.world.program().is3D());
        }
        if (agentClass == Link.class) {
            return AgentVariables.getImplicitLinkVariables();
        }
        throw new IllegalStateException();
    }

    public boolean hasMoreLines(boolean returnBlankLines) throws IOException {
        this.nextLine = this.lines.readLine();
        ++this.lineNum;
        if (this.nextLine == null) {
            if (this.currentSentinel != this.numSentinels) {
                if (this.sentinels[this.currentSentinel].equals("DRAWING") || this.sentinels[this.currentSentinel].equals("LINKS") || this.sentinels[this.currentSentinel].equals("OUTPUT") || this.sentinels[this.currentSentinel].equals("PLOTS") || this.sentinels[this.currentSentinel].equals("EXTENSIONS")) {
                    ++this.currentSentinel;
                    return false;
                }
                String abortingError = "No " + this.sentinels[this.currentSentinel] + " have been imported.  Globals, Turtles, and Patches " + "must be in the same import file.";
                throw new AbortingImportException(ImportError.UNEXPECTED_EOF_ERROR, abortingError);
            }
            return false;
        }
        if (this.nextLine.equals(NO_DETAILS)) {
            if (returnBlankLines) {
                return false;
            }
            return this.hasMoreLines(false);
        }
        try {
            this.nextLineFields = ImportLexer.lex(this.nextLine);
        }
        catch (ImportLexer.LexerException le) {
            throw new AbortingImportException(ImportError.CSV_LEXING_ERROR, "At line " + this.lineNum + ": " + le.getMessage());
        }
        if (this.nextLineFields.length <= 0) {
            if (returnBlankLines) {
                return true;
            }
            return this.hasMoreLines(returnBlankLines);
        }
        if (this.nextLineFields[0].toUpperCase().startsWith(this.sentinels[this.currentSentinel])) {
            ++this.currentSentinel;
            return false;
        }
        if (this.anotherSentinelEquals(this.nextLineFields[0].toUpperCase())) {
            if (this.currentSentinel < 3) {
                String abortingError = "The agents are in the wrong order in the import file. The global variables should be first, followed by the turtles, followed by the patches.  Found " + this.nextLineFields[0] + " but needed " + this.sentinels[this.currentSentinel];
                throw new AbortingImportException(ImportError.FILE_STRUCTURE_ERROR, abortingError);
            }
            return false;
        }
        return true;
    }

    boolean anotherSentinelEquals(String line) {
        int i;
        for (i = 0; i < this.currentSentinel; ++i) {
            if (!line.equals(this.sentinels[i])) continue;
            return true;
        }
        for (i = this.currentSentinel + 1; i < this.numSentinels; ++i) {
            if (!line.equals(this.sentinels[i])) continue;
            return true;
        }
        return false;
    }

    String[] nextLine() {
        return this.nextLineFields;
    }

    public String next() {
        return this.nextLine;
    }

    String printSectionName() {
        return this.currentSentinel > 0 ? this.sentinels[this.currentSentinel - 1] : "UNKNOWN";
    }

    String printName(Class<? extends Agent> agentClass) {
        if (agentClass == Observer.class) {
            return "Global";
        }
        if (agentClass == Turtle.class) {
            return "Turtle";
        }
        if (agentClass == Patch.class) {
            return "Patch";
        }
        if (agentClass == Link.class) {
            return "Link";
        }
        return NO_DETAILS;
    }

    void checkForBlankTurtles() {
        AgentSet.Iterator iter2 = this.world.turtles().iterator();
        while (iter2.hasNext()) {
            Turtle turtle2 = (Turtle)iter2.next();
            if (turtle2.getBreed() != null) continue;
            String abortingError = turtle2.toString() + " was referenced in an agentset or agent " + "but was not defined in the TURTLES section.";
            throw new AbortingImportException(ImportError.BLANK_TURTLE_ERROR, abortingError);
        }
    }

    void showError(ImportException ix) {
        if (ix.type.compareTo(ImportError.LAST_NONFATAL_ERROR) > 0) {
            throw new AbortingImportException(ImportError.UNKNOWN_ERROR, "An unknown error has occurred. The import will now abort.");
        }
        if (!this.errorHandler.showError("Warning: " + ix.title, "Error Importing at Line " + this.lineNum + ": " + ix.message + "\n\nAction to be Taken: " + ix.action, false)) {
            throw new AbortingImportException(ImportError.ERROR_GIVEN, NO_DETAILS);
        }
    }

    @Override
    public void showError(String title, String message, String defaultAction) {
        this.showError(new ImportException(ImportError.PARSING_ERROR, title, message, defaultAction));
    }

    void showError(AbortingImportException aix) {
        this.errorHandler.showError(aix.title, aix.details, true);
    }

    Object readFromString(String s) throws StringReaderException {
        return this.stringReader.readFromString(s);
    }

    private static int[] fromHexString(String s) throws InvalidDataException {
        int stringLength = s.length();
        int[] ints = new int[stringLength / 8];
        if (stringLength % 8 == 0) {
            int i = 0;
            int j = 0;
            while (j < stringLength / 8) {
                ints[j] = Importer.charToNibble(s.charAt(i++)) << 28;
                int n = j;
                ints[n] = ints[n] | Importer.charToNibble(s.charAt(i++)) << 24;
                int n2 = j;
                ints[n2] = ints[n2] | Importer.charToNibble(s.charAt(i++)) << 20;
                int n3 = j;
                ints[n3] = ints[n3] | Importer.charToNibble(s.charAt(i++)) << 16;
                int n4 = j;
                ints[n4] = ints[n4] | Importer.charToNibble(s.charAt(i++)) << 12;
                int n5 = j;
                ints[n5] = ints[n5] | Importer.charToNibble(s.charAt(i++)) << 8;
                int n6 = j;
                ints[n6] = ints[n6] | Importer.charToNibble(s.charAt(i++)) << 4;
                int n7 = j++;
                ints[n7] = ints[n7] | Importer.charToNibble(s.charAt(i++));
            }
        } else {
            throw new InvalidDataException("The data must be a multiple of 4 to covert from Hex string to ints");
        }
        return ints;
    }

    private static int charToNibble(char c) {
        if ('0' <= c && c <= '9') {
            return c - 48;
        }
        if ('a' <= c && c <= 'f') {
            return c - 97 + 10;
        }
        if ('A' <= c && c <= 'F') {
            return c - 65 + 10;
        }
        throw new IllegalArgumentException("Invalid hex character: " + c);
    }

    strictfp static class InvalidDataException
    extends IOException {
        public InvalidDataException(String message) {
            super(message);
        }
    }

    strictfp class Junk {
        Junk() {
        }
    }

    public static interface ErrorHandler {
        public boolean showError(String var1, String var2, boolean var3);
    }

    public strictfp static class StringReaderException
    extends Exception {
        public StringReaderException(String message) {
            super(message);
        }
    }

    public static interface StringReader {
        public Object readFromString(String var1) throws StringReaderException;
    }

    strictfp class AbortingImportException
    extends RuntimeException {
        ImportError errorType;
        public String title;
        public String details;

        public AbortingImportException(ImportError errorType, String details) {
            super("Fatal Error Type:" + (Object)((Object)errorType));
            this.errorType = errorType;
            this.title = "Fatal Error- " + this.getErrorMessage();
            this.details = details + "\n\nThe import will now abort.";
        }

        String getErrorMessage() {
            String message;
            switch (this.errorType) {
                case ERROR_GIVEN: {
                    message = "Error Already Given";
                    break;
                }
                case ILLEGAL_CLASS_CAST_ERROR: {
                    message = "Illegal Type Cast";
                    break;
                }
                case UNEXPECTED_EOF_ERROR: {
                    message = "Unexpected End of File";
                    break;
                }
                case FILE_STRUCTURE_ERROR: {
                    message = "Incorrect Structure For Import File";
                    break;
                }
                case UNDECLARED_ESSENTIAL_VAR_ERROR: {
                    message = "Essential Variable Not Declared";
                    break;
                }
                case UNIMPORTED_ESSENTIAL_VAR_ERROR: {
                    message = "Essential Variable Not Imported";
                    break;
                }
                case BLANK_TURTLE_ERROR: {
                    message = "Referenced Turtle Not Defined";
                    break;
                }
                case CSV_LEXING_ERROR: {
                    message = "Invalid CSV File";
                    break;
                }
                case IMPORT_3D_ERROR: {
                    message = "You cannot import a 2D world into 3D NetLogo";
                    break;
                }
                default: {
                    message = "Unknown Fatal Error";
                }
            }
            return message;
        }
    }

    strictfp class ImportException
    extends RuntimeException {
        public ImportError type;
        public String message;
        public String action;
        public String title;

        public ImportException(ImportError errorType, String errorTitle, String errorMessage, String defaultAction) {
            super(errorTitle + "- Error Type: " + (Object)((Object)errorType));
            this.type = errorType;
            this.title = errorTitle;
            this.message = errorMessage;
            this.action = defaultAction;
        }

        public ImportException(ImportError errorType, String errorTitle, String errorMessage, String defaultAction, String additionalInfo) {
            this(errorType, errorTitle, errorMessage, defaultAction);
            this.message = this.message + "\n\nAdditional Information: " + additionalInfo;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    strictfp static enum ImportError {
        ILLEGAL_AGENT_VAR_ERROR,
        ILLEGAL_SHAPE_ERROR,
        ILLEGAL_BREED_ERROR,
        PARSING_ERROR,
        SETTING_VAR_ERROR,
        UNDECLARED_AGENT_VAR_ERROR,
        TOO_MANY_VALUES_ERROR,
        LAST_NONFATAL_ERROR,
        ILLEGAL_CLASS_CAST_ERROR,
        UNEXPECTED_EOF_ERROR,
        ERROR_GIVEN,
        FILE_STRUCTURE_ERROR,
        UNDECLARED_ESSENTIAL_VAR_ERROR,
        UNIMPORTED_ESSENTIAL_VAR_ERROR,
        BLANK_TURTLE_ERROR,
        CSV_LEXING_ERROR,
        ILLEGAL_PCOR_ERROR,
        IMPORT_3D_ERROR,
        UNKNOWN_ERROR;

    }
}

