/*
 * Decompiled with CFR 0.152.
 */
package org.nlogo.agent;

import java.io.IOException;
import java.util.Map;
import org.nlogo.agent.Drawing3D;
import org.nlogo.agent.Importer;
import org.nlogo.agent.Patch;
import org.nlogo.agent.Turtle;
import org.nlogo.agent.World;
import org.nlogo.agent.World3D;
import org.nlogo.api.AgentVariables;
import org.nlogo.api.ImporterUser;
import org.nlogo.api.WorldDimensions3D;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public strictfp class Importer3D
extends Importer {
    static final String MIN_PZCOR_HEADER = "MIN-PZCOR";
    static final String MAX_PZCOR_HEADER = "MAX-PZCOR";

    public Importer3D(Importer.ErrorHandler errorHandler, World world, ImporterUser importerUser, Importer.StringReader stringReader) {
        super(errorHandler, world, importerUser, stringReader);
        this.TURTLE_BREED = 11;
    }

    @Override
    void checkVersion(String versionNumber) throws Importer.AbortingImportException {
        if (!versionNumber.startsWith("3-D") && !versionNumber.startsWith("3D")) {
            throw new Importer.AbortingImportException(Importer.ImportError.IMPORT_3D_ERROR, "");
        }
    }

    @Override
    void importDrawing() throws IOException {
        Drawing3D drawing = ((World3D)this.world).drawing;
        while (this.hasMoreLines(false)) {
            String[] line = this.nextLine();
            if (line[0].equalsIgnoreCase("x0")) continue;
            if (line[0].equalsIgnoreCase("shape")) {
                while (this.hasMoreLines(false)) {
                    line = this.nextLine();
                    if (line[1].equalsIgnoreCase("x1")) {
                        while (this.hasMoreLines(false)) {
                            try {
                                line = this.nextLine();
                                drawing.addStamp(line[0], (Double)this.stringReader.readFromString(line[1]), (Double)this.stringReader.readFromString(line[2]), (Double)this.stringReader.readFromString(line[3]), (Double)this.stringReader.readFromString(line[4]), (Double)this.stringReader.readFromString(line[5]), (Double)this.stringReader.readFromString(line[6]), this.stringReader.readFromString(line[7]), (Double)this.stringReader.readFromString(line[8]), (Boolean)this.stringReader.readFromString(line[9]), (Double)this.stringReader.readFromString(line[10]), (Double)this.stringReader.readFromString(line[11]), (Double)this.stringReader.readFromString(line[12]));
                            }
                            catch (Importer.StringReaderException ex) {
                                throw new Importer.AbortingImportException(Importer.ImportError.ILLEGAL_CLASS_CAST_ERROR, "Coordinates in the drawing must be doubles");
                            }
                        }
                        return;
                    }
                    try {
                        drawing.addStamp(line[0], (Double)this.stringReader.readFromString(line[1]), (Double)this.stringReader.readFromString(line[2]), (Double)this.stringReader.readFromString(line[3]), (Double)this.stringReader.readFromString(line[4]), (Double)this.stringReader.readFromString(line[5]), (Double)this.stringReader.readFromString(line[6]), (Double)this.stringReader.readFromString(line[7]), (double)((Double)this.stringReader.readFromString(line[8])), (Double)this.stringReader.readFromString(line[9]));
                    }
                    catch (Importer.StringReaderException ex) {
                        throw new Importer.AbortingImportException(Importer.ImportError.ILLEGAL_CLASS_CAST_ERROR, "Coordinates in the drawing must be doubles");
                    }
                }
            }
            try {
                drawing.addLine((Double)this.stringReader.readFromString(line[0]), (Double)this.stringReader.readFromString(line[1]), (Double)this.stringReader.readFromString(line[2]), (Double)this.stringReader.readFromString(line[3]), (Double)this.stringReader.readFromString(line[4]), (Double)this.stringReader.readFromString(line[5]), (Double)this.stringReader.readFromString(line[6]), this.stringReader.readFromString(line[7]));
            }
            catch (Importer.StringReaderException ex) {
                throw new Importer.AbortingImportException(Importer.ImportError.ILLEGAL_CLASS_CAST_ERROR, "Coordinates in the drawing must be doubles");
            }
        }
    }

    @Override
    void handleSpecialTurtleVariable(Turtle turtle2, Object val, int varIndex) {
        switch (varIndex) {
            case 8: {
                this.setTurtleShape(turtle2, val, this.builtInVars[8], varIndex);
                break;
            }
            case 9: {
                this.setVarVal(turtle2, varIndex, this.builtInVars[9], this.getLabel(val));
                break;
            }
            case 0: 
            case 11: {
                break;
            }
            default: {
                throw new IllegalStateException();
            }
        }
    }

    @Override
    void handleSpecialPatchVariable(Patch patch2, Object val, int varIndex) {
        switch (varIndex) {
            case 4: {
                this.setVarVal(patch2, varIndex, this.builtInVars[4], this.getLabel(val));
                break;
            }
            case 0: 
            case 1: 
            case 2: {
                break;
            }
            default: {
                throw new IllegalStateException();
            }
        }
    }

    @Override
    Patch getPatch(Map<String, Object> varVals) {
        try {
            World3D w = (World3D)this.world;
            int pxcor = ((Double)varVals.get(this.builtInVars[0])).intValue();
            int pycor = ((Double)varVals.get(this.builtInVars[1])).intValue();
            int pzcor = ((Double)varVals.get(this.builtInVars[2])).intValue();
            if (!w.validPatchCoordinates(pxcor, pycor, pzcor)) {
                String abortingError = "Illegal Patch Coordinate- pxcor, pycor and pzcor must be in range.";
                throw new Importer.AbortingImportException(Importer.ImportError.ILLEGAL_PCOR_ERROR, abortingError);
            }
            return w.fastGetPatchAt(pxcor, pycor, pzcor);
        }
        catch (ClassCastException cce) {
            String abortingError = "Illegal Patch Coordinate- pxcor and pycor must be integers.";
            throw new Importer.AbortingImportException(Importer.ImportError.ILLEGAL_CLASS_CAST_ERROR, abortingError);
        }
    }

    @Override
    void setScreenDimensions(Map<String, Object> varVals) {
        try {
            int maxz;
            int minz;
            int maxy;
            int miny;
            int maxx;
            int minx;
            if (!this.convertTopology) {
                minx = ((Double)varVals.get("MIN-PXCOR")).intValue();
                maxx = ((Double)varVals.get("MAX-PXCOR")).intValue();
                miny = ((Double)varVals.get("MIN-PYCOR")).intValue();
                maxy = ((Double)varVals.get("MAX-PYCOR")).intValue();
                minz = ((Double)varVals.get(MIN_PZCOR_HEADER)).intValue();
                maxz = ((Double)varVals.get(MAX_PZCOR_HEADER)).intValue();
            } else {
                int sex = ((Double)varVals.get("SCREEN-EDGE-X")).intValue();
                int sey = ((Double)varVals.get("SCREEN-EDGE-Y")).intValue();
                minx = -sex;
                maxx = sex;
                miny = -sey;
                maxy = sey;
                maxz = 0;
                minz = 0;
            }
            World3D w = (World3D)this.world;
            if (minx != this.world.minPxcor() || maxx != this.world.maxPxcor() || miny != this.world.minPycor() || maxy != this.world.maxPycor() || minz != w.minPzcor() || maxz != w.maxPzcor()) {
                this.importerUser.setDimensions(new WorldDimensions3D(minx, maxx, miny, maxy, minz, maxz));
                this.needToResize = true;
            }
        }
        catch (ClassCastException cce) {
            String abortingError = "Illegal Screen dimension- max-px/y/zcor, min-px/y/zcor must be numbers.";
            throw new Importer.AbortingImportException(Importer.ImportError.ILLEGAL_CLASS_CAST_ERROR, abortingError);
        }
    }

    @Override
    String[] getSpecialObserverVariables() {
        return new String[]{"MIN-PXCOR", "MAX-PXCOR", "MIN-PYCOR", "MAX-PYCOR", MIN_PZCOR_HEADER, MAX_PZCOR_HEADER, "PERSPECTIVE", "SUBJECT", "NEXTINDEX", "DIRECTED-LINKS", "TICKS"};
    }

    @Override
    String[] getSpecialTurtleVariables() {
        String[] vars = AgentVariables.getImplicitTurtleVariables(true);
        return new String[]{vars[0], vars[11], vars[9], vars[8]};
    }

    @Override
    String[] getSpecialPatchVariables() {
        String[] vars = AgentVariables.getImplicitPatchVariables(true);
        return new String[]{vars[0], vars[1], vars[2], vars[4]};
    }

    @Override
    String[] getEssentialObserverVars() {
        return new String[]{"MIN-PXCOR", "MAX-PXCOR", "MIN-PYCOR", "MAX-PYCOR", MIN_PZCOR_HEADER, MAX_PZCOR_HEADER};
    }

    @Override
    String[] getEssentialPatchVariables() {
        String[] vars = AgentVariables.getImplicitPatchVariables(true);
        return new String[]{vars[0], vars[1], vars[2]};
    }
}

