/*
 * Decompiled with CFR 0.152.
 */
package org.nlogo.agent;

import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.nlogo.agent.Link;
import org.nlogo.agent.LinkManager;
import org.nlogo.agent.Protractor3D;
import org.nlogo.agent.TieManager;
import org.nlogo.agent.Turtle;
import org.nlogo.agent.Turtle3D;
import org.nlogo.agent.World3D;
import org.nlogo.api.AgentException;
import org.nlogo.api.Matrix3D;
import org.nlogo.api.Vect;
import org.nlogo.util.Exceptions;

public strictfp class TieManager3D
extends TieManager {
    World3D world3D;
    private Set<Turtle3D> seenTurtles = new HashSet<Turtle3D>();

    TieManager3D(World3D world3D, LinkManager linkManager) {
        super(world3D, linkManager);
        this.world3D = world3D;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void turtleMoved(Turtle3D root, double newX, double newY, double newZ, double originalXcor, double originalYcor, double originalZcor) {
        boolean weroot = false;
        try {
            if (this.seenTurtles.isEmpty()) {
                this.seenTurtles.add(root);
                weroot = true;
            }
            List<Turtle> myTies = this.tiedTurtles(root);
            Iterator<Turtle> i = myTies.iterator();
            while (i.hasNext()) {
                Turtle3D t = (Turtle3D)i.next();
                if (t.id == -1L || this.seenTurtles.contains(t)) {
                    i.remove();
                    continue;
                }
                this.seenTurtles.add(t);
            }
            if (!myTies.isEmpty()) {
                double changex = newX - originalXcor;
                double changey = newY - originalYcor;
                double changez = newZ - originalZcor;
                for (Turtle t : myTies) {
                    Turtle3D t2 = (Turtle3D)t;
                    t2.xyandzcor(t2.xcor + changex, t2.ycor + changey, t2.zcor + changez);
                }
            }
        }
        finally {
            if (weroot) {
                this.seenTurtles.clear();
            }
        }
    }

    void turtleTurned(Turtle root, double newHeading, double originalHeading) {
        Turtle3D t = (Turtle3D)root;
        this.turtleOrientationChanged(t, newHeading, t.pitch(), t.roll(), originalHeading, t.pitch(), t.roll());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void turtleOrientationChanged(Turtle3D root, double newHeading, double newPitch, double newRoll, double oldHeading, double oldPitch, double oldRoll) {
        block15: {
            boolean weroot = false;
            try {
                if (this.seenTurtles.isEmpty()) {
                    this.seenTurtles.add(root);
                    weroot = true;
                }
                List<Turtle> myTies = this.tiedTurtles(root);
                Iterator<Turtle> i = myTies.iterator();
                while (i.hasNext()) {
                    Turtle3D t = (Turtle3D)i.next();
                    if (t.id == -1L || this.seenTurtles.contains(t)) {
                        i.remove();
                        continue;
                    }
                    this.seenTurtles.add(t);
                }
                if (myTies.isEmpty()) break block15;
                Matrix3D htrans = new Matrix3D();
                Matrix3D ptrans = new Matrix3D();
                Matrix3D rtrans = new Matrix3D();
                double dh = Turtle.subtractHeadings(newHeading, oldHeading);
                double dp = Turtle.subtractHeadings(newPitch, oldPitch);
                double dr = Turtle.subtractHeadings(newRoll, oldRoll);
                htrans.zrot(-dh);
                Vect[] vects = Vect.toVectors(newHeading, oldPitch, 0.0);
                ptrans.vrot(0.0, 0.0, 0.0, vects[1].x(), vects[1].y(), vects[1].z(), StrictMath.toRadians(dp));
                vects = Vect.toVectors(newHeading, newPitch, oldRoll);
                rtrans.vrot(0.0, 0.0, 0.0, vects[0].x(), vects[0].y(), vects[0].z(), StrictMath.toRadians(dr));
                double[] out = new double[3];
                for (Turtle t1 : myTies) {
                    try {
                        Turtle3D t = (Turtle3D)t1;
                        Link link = this.linkManager.findLink(root, t, this.world3D.links(), true);
                        boolean rigid = link.mode().equals("fixed");
                        double[] leaf = ((Protractor3D)this.world3D.protractor()).towardsVector(root.xcor(), root.ycor(), root.zcor(), t.xcor(), t.ycor(), t.zcor(), true);
                        htrans.transform(leaf, out, 1);
                        ptrans.transform(out, out, 1);
                        rtrans.transform(out, out, 1);
                        double nx = t.xcor + (out[0] - leaf[0]);
                        double ny = t.ycor + (out[1] - leaf[1]);
                        double nz = t.zcor + (out[2] - leaf[2]);
                        Set<Turtle3D> snapshot = this.seenTurtles;
                        try {
                            if (rigid) {
                                snapshot = new HashSet<Turtle3D>(this.seenTurtles);
                            }
                            t.xyandzcor(nx, ny, nz);
                        }
                        finally {
                            if (rigid) {
                                this.seenTurtles = snapshot;
                            }
                        }
                        Vect[] hvs = new Vect[2];
                        if (!rigid) continue;
                        hvs = Vect.toVectors(t.heading(), t.pitch(), t.roll());
                        hvs[0] = hvs[0].transform(htrans);
                        hvs[1] = hvs[1].transform(htrans);
                        hvs[0] = hvs[0].transform(ptrans);
                        hvs[1] = hvs[1].transform(ptrans);
                        hvs[0] = hvs[0].transform(rtrans);
                        hvs[1] = hvs[1].transform(rtrans);
                        leaf = Vect.toAngles(hvs[0], hvs[1]);
                        t.headingPitchAndRoll(leaf[0], leaf[1], leaf[2]);
                    }
                    catch (AgentException ex) {
                        Exceptions.ignore(ex);
                    }
                }
            }
            finally {
                if (weroot) {
                    this.seenTurtles.clear();
                }
            }
        }
    }
}

