/*
 * Decompiled with CFR 0.152.
 */
package org.nlogo.agent;

import org.nlogo.agent.Agent;
import org.nlogo.agent.AgentSet;
import org.nlogo.agent.ArrayAgentSet;
import org.nlogo.agent.Patch;
import org.nlogo.agent.Patch3D;
import org.nlogo.agent.PatchException;
import org.nlogo.agent.Topology3D;
import org.nlogo.agent.Torus;
import org.nlogo.agent.World3D;
import org.nlogo.api.AgentException;

public strictfp final class Torus3D
extends Torus
implements Topology3D {
    public Torus3D(World3D world) {
        super(world);
    }

    public double distanceWrap(double dx, double dy, double dz, double x1, double y1, double z1, double x2, double y2, double z2) {
        double dx2 = x1 > x2 ? x2 + (double)this.world.worldWidth() - x1 : x2 - (double)this.world.worldWidth() - x1;
        dx = StrictMath.abs(dx2) < StrictMath.abs(dx) ? dx2 : dx;
        double dy2 = y1 > y2 ? y2 + (double)this.world.worldHeight() - y1 : y2 - (double)this.world.worldHeight() - y1;
        dy = StrictMath.abs(dy2) < StrictMath.abs(dy) ? dy2 : dy;
        double dz2 = z1 > z2 ? z2 + (double)((World3D)this.world).worldDepth() - z1 : z2 - (double)((World3D)this.world).worldDepth() - z1;
        dz = StrictMath.abs(dz2) < StrictMath.abs(dz) ? dz2 : dz;
        return StrictMath.sqrt(dx * dx + dy * dy + dz * dz);
    }

    public double towardsPitchWrap(double dx, double dy, double dz) {
        dx = Torus3D.wrap(dx, -((double)this.world.worldWidth()) / 2.0, (double)this.world.worldWidth() / 2.0);
        dy = Torus3D.wrap(dy, -((double)this.world.worldHeight()) / 2.0, (double)this.world.worldHeight() / 2.0);
        dz = Torus3D.wrap(dz, -((double)((World3D)this.world).worldDepth()) / 2.0, (double)((World3D)this.world).worldDepth() / 2.0);
        return (360.0 + StrictMath.toDegrees(StrictMath.atan(dz / StrictMath.sqrt(dx * dx + dy * dy)))) % 360.0;
    }

    public Patch getPatchAt(double xc, double yc, double zc) throws AgentException {
        return ((World3D)this.world).getPatchAt(xc, yc, zc);
    }

    public void diffuse(double diffuseparam, int vn) throws AgentException, PatchException {
        World3D w = (World3D)this.world;
        int xx = w.worldWidth();
        int xx2 = xx * 2;
        int yy = w.worldHeight();
        int yy2 = yy * 2;
        int zz = w.worldDepth();
        int zz2 = zz * 2;
        double[][][] scratch = w.getPatchScratch3d();
        int x = 0;
        int y = 0;
        int z = 0;
        try {
            for (z = 0; z < zz; ++z) {
                for (y = 0; y < yy; ++y) {
                    for (x = 0; x < xx; ++x) {
                        scratch[x][y][z] = ((Number)w.fastGetPatchAt((int)this.wrapX(x), (int)this.wrapY(y), (int)this.wrapZ(z)).getPatchVariable(vn)).doubleValue();
                    }
                }
            }
        }
        catch (ClassCastException ex) {
            throw new PatchException(w.fastGetPatchAt((int)this.wrapX(x), (int)this.wrapY(y), (int)this.wrapZ(z)));
        }
        for (z = zz; z < zz2; ++z) {
            for (y = yy; y < yy2; ++y) {
                for (x = xx; x < xx2; ++x) {
                    double sum2 = scratch[(x - 1) % xx][(y - 1) % yy][z % zz];
                    sum2 += scratch[(x - 1) % xx][y % yy][z % zz];
                    sum2 += scratch[(x - 1) % xx][(y + 1) % yy][z % zz];
                    sum2 += scratch[x % xx][(y - 1) % yy][z % zz];
                    sum2 += scratch[x % xx][(y + 1) % yy][z % zz];
                    sum2 += scratch[(x + 1) % xx][(y - 1) % yy][z % zz];
                    sum2 += scratch[(x + 1) % xx][y % yy][z % zz];
                    sum2 += scratch[(x + 1) % xx][(y + 1) % yy][z % zz];
                    sum2 += scratch[(x - 1) % xx][(y - 1) % yy][(z - 1) % zz];
                    sum2 += scratch[(x - 1) % xx][y % yy][(z - 1) % zz];
                    sum2 += scratch[(x - 1) % xx][(y + 1) % yy][(z - 1) % zz];
                    sum2 += scratch[x % xx][(y - 1) % yy][(z - 1) % zz];
                    sum2 += scratch[x % xx][(y + 1) % yy][(z - 1) % zz];
                    sum2 += scratch[(x + 1) % xx][(y - 1) % yy][(z - 1) % zz];
                    sum2 += scratch[(x + 1) % xx][y % yy][(z - 1) % zz];
                    sum2 += scratch[(x + 1) % xx][(y + 1) % yy][(z - 1) % zz];
                    sum2 += scratch[x % xx][y % yy][(z - 1) % zz];
                    sum2 += scratch[(x - 1) % xx][(y - 1) % yy][(z + 1) % zz];
                    sum2 += scratch[(x - 1) % xx][y % yy][(z + 1) % zz];
                    sum2 += scratch[(x - 1) % xx][(y + 1) % yy][(z + 1) % zz];
                    sum2 += scratch[x % xx][(y - 1) % yy][(z + 1) % zz];
                    sum2 += scratch[x % xx][(y + 1) % yy][(z + 1) % zz];
                    sum2 += scratch[(x + 1) % xx][(y - 1) % yy][(z + 1) % zz];
                    sum2 += scratch[(x + 1) % xx][y % yy][(z + 1) % zz];
                    sum2 += scratch[(x + 1) % xx][(y + 1) % yy][(z + 1) % zz];
                    double oldval = scratch[x - xx][y - yy][z - zz];
                    double newval = oldval * (1.0 - diffuseparam) + (sum2 += scratch[x % xx][y % yy][(z + 1) % zz]) / 26.0 * diffuseparam;
                    if (newval == oldval) continue;
                    w.getPatchAt(x - xx, y - yy, z - zz).setPatchVariable(vn, (Object)newval);
                }
            }
        }
    }

    public AgentSet getNeighbors3d(Patch3D source2) {
        return new ArrayAgentSet(Patch.class, new Agent[]{this.getPatchNorth(source2), this.getPatchEast(source2), this.getPatchSouth(source2), this.getPatchWest(source2), this.getPatchNorthEast(source2), this.getPatchSouthEast(source2), this.getPatchSouthWest(source2), this.getPatchNorthWest(source2), this.getPatchUp(source2), this.getPatchDown(source2), this.getPNU(source2), this.getPEU(source2), this.getPSU(source2), this.getPWU(source2), this.getPNEU(source2), this.getPSEU(source2), this.getPSWU(source2), this.getPNWU(source2), this.getPND(source2), this.getPED(source2), this.getPSD(source2), this.getPWD(source2), this.getPNED(source2), this.getPSED(source2), this.getPSWD(source2), this.getPNWD(source2)}, this.world);
    }

    public AgentSet getNeighbors6(Patch3D source2) {
        return new ArrayAgentSet(Patch.class, new Agent[]{this.getPatchNorth(source2), this.getPatchEast(source2), this.getPatchSouth(source2), this.getPatchWest(source2), this.getPatchUp(source2), this.getPatchDown(source2)}, this.world);
    }

    public Patch getPNU(Patch3D source2) {
        return this.getPatchNorth(this.getPatchUp(source2));
    }

    public Patch getPEU(Patch3D source2) {
        return this.getPatchEast(this.getPatchUp(source2));
    }

    public Patch getPSU(Patch3D source2) {
        return this.getPatchSouth(this.getPatchUp(source2));
    }

    public Patch getPWU(Patch3D source2) {
        return this.getPatchWest(this.getPatchUp(source2));
    }

    public Patch getPNEU(Patch3D source2) {
        return this.getPatchNorthEast(this.getPatchUp(source2));
    }

    public Patch getPSEU(Patch3D source2) {
        return this.getPatchSouthEast(this.getPatchUp(source2));
    }

    public Patch getPSWU(Patch3D source2) {
        return this.getPatchSouthWest(this.getPatchUp(source2));
    }

    public Patch getPNWU(Patch3D source2) {
        return this.getPatchNorthWest(this.getPatchUp(source2));
    }

    public Patch getPND(Patch3D source2) {
        return this.getPatchNorth(this.getPatchDown(source2));
    }

    public Patch getPED(Patch3D source2) {
        return this.getPatchEast(this.getPatchDown(source2));
    }

    public Patch getPSD(Patch3D source2) {
        return this.getPatchSouth(this.getPatchDown(source2));
    }

    public Patch getPWD(Patch3D source2) {
        return this.getPatchWest(this.getPatchDown(source2));
    }

    public Patch getPNED(Patch3D source2) {
        return this.getPatchNorthEast(this.getPatchDown(source2));
    }

    public Patch getPSED(Patch3D source2) {
        return this.getPatchSouthEast(this.getPatchDown(source2));
    }

    public Patch getPSWD(Patch3D source2) {
        return this.getPatchSouthWest(this.getPatchDown(source2));
    }

    public Patch getPNWD(Patch3D source2) {
        return this.getPatchNorthWest(this.getPatchDown(source2));
    }

    public double observerZ() {
        return this.world.observer().ozcor();
    }

    public double wrapZ(double z) {
        World3D w = (World3D)this.world;
        return Torus3D.wrap(z, (double)w.minPzcor() - 0.5, (double)w.maxPzcor() + 0.5);
    }

    Patch getPatchUp(Patch3D source2) {
        World3D w = (World3D)this.world;
        if (source2.pzcor == w.maxPzcor()) {
            return w.fastGetPatchAt(source2.pxcor, source2.pycor, w.minPzcor());
        }
        return w.fastGetPatchAt(source2.pxcor, source2.pycor, source2.pzcor + 1);
    }

    Patch getPatchDown(Patch3D source2) {
        World3D w = (World3D)this.world;
        if (source2.pzcor == w.minPzcor()) {
            return w.fastGetPatchAt(source2.pxcor, source2.pycor, w.maxPzcor());
        }
        return w.fastGetPatchAt(source2.pxcor, source2.pycor, source2.pzcor - 1);
    }

    public double shortestPathZ(double z1, double z2) {
        double depth = ((World3D)this.world).worldDepth();
        double zprime = z1 > z2 ? z2 + depth : z2 - depth;
        if (StrictMath.abs(z2 - z1) > StrictMath.abs(zprime - z1)) {
            z2 = zprime;
        }
        return z2;
    }
}

