/*
 * Decompiled with CFR 0.152.
 */
package org.nlogo.agent;

import java.util.Map;
import java.util.TreeMap;
import org.nlogo.agent.Agent;
import org.nlogo.agent.AgentSet;
import org.nlogo.agent.Link;
import org.nlogo.agent.Turtle;
import org.nlogo.agent.World;
import org.nlogo.api.LogoList;
import org.nlogo.api.SimpleChangeEventPublisher;
import org.nlogo.util.MersenneTwisterFast;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public strictfp class TreeAgentSet
extends AgentSet {
    final Map<Object, Agent> agents = new TreeMap<Object, Agent>();
    public final SimpleChangeEventPublisher simpleChangeEventPublisher = new SimpleChangeEventPublisher();
    private long nextIndex = 0L;

    @Override
    public int count() {
        return this.agents.size();
    }

    @Override
    public boolean isEmpty() {
        return this.agents.isEmpty();
    }

    @Override
    boolean equalAgentSetsHelper(org.nlogo.api.AgentSet otherSet) {
        for (org.nlogo.api.Agent a : otherSet.agents()) {
            if (this.contains((Agent)a)) continue;
            return false;
        }
        return true;
    }

    public TreeAgentSet(Class<? extends Agent> type, String printName, World world) {
        super(type, world, printName, true);
    }

    @Override
    public Agent agent(long i) {
        Double index = i;
        if (this.type == Turtle.class || this.type == Link.class) {
            Agent agent = this.agents.get(index);
            if (agent == null) {
                return null;
            }
            if (agent.id == -1L) {
                this.agents.remove(index);
                return null;
            }
            return agent;
        }
        return this.agents.get(index);
    }

    @Override
    Agent getAgent(Object id) {
        return this.agents.get(id);
    }

    @Override
    public void add(Agent agent) {
        if (agent.getAgentClass() != this.type) {
            throw new IllegalStateException();
        }
        this.agents.put(agent.agentKey(), agent);
        this.nextIndex = StrictMath.max(this.nextIndex, agent.id + 1L);
        this.simpleChangeEventPublisher.publish();
    }

    @Override
    public void remove(Object key) {
        this.agents.remove(key);
        this.simpleChangeEventPublisher.publish();
    }

    @Override
    void clear() {
        this.agents.clear();
        this.simpleChangeEventPublisher.publish();
    }

    @Override
    public boolean contains(Agent agent) {
        return this.agents.containsValue(agent);
    }

    @Override
    public Agent randomOne(int precomputedCount, int random) {
        AgentSet.Iterator iter = this.iterator();
        for (int i = 0; i < random; ++i) {
            iter.next();
        }
        return iter.next();
    }

    @Override
    Agent[] randomTwo(int precomputedCount, int random1, int random2) {
        Agent[] result = new Agent[2];
        if (random2 >= random1) {
            ++random2;
        } else {
            int tmp = random1;
            random1 = random2;
            random2 = tmp;
        }
        if ((long)precomputedCount == this.nextIndex) {
            result[0] = this.agents.get(random1);
            result[1] = this.agents.get(random2);
        } else {
            AgentSet.Iterator iter = this.iterator();
            int i = 0;
            while (i++ < random1) {
                iter.next();
            }
            result[0] = iter.next();
            while (i++ < random2) {
                iter.next();
            }
            result[1] = iter.next();
        }
        return result;
    }

    @Override
    Agent[] randomSubsetGeneral(int resultSize, int precomputedCount, MersenneTwisterFast randomerator) {
        Agent[] result = new Agent[resultSize];
        AgentSet.Iterator iter = this.iterator();
        int i = 0;
        int j = 0;
        while (j < resultSize) {
            Agent next = iter.next();
            if (randomerator.nextInt(precomputedCount - i) < resultSize - j) {
                result[j] = next;
                ++j;
            }
            ++i;
        }
        return result;
    }

    @Override
    public LogoList toLogoList() {
        return LogoList.fromJava(this.agents.values());
    }

    @Override
    public Agent[] toArray() {
        return this.agents.values().toArray(new Agent[this.agents.size()]);
    }

    public String toString() {
        StringBuilder s = new StringBuilder("TreeAgentSet");
        s = s.append("\n...... type: ");
        s = s.append(this.type == null ? "null" : this.type.toString());
        s = s.append("\n...... count(): " + this.count());
        s = s.append("\n...... agents: ");
        AgentSet.Iterator iter = this.iterator();
        while (iter.hasNext()) {
            s = s.append("\n" + iter.next().toString());
        }
        return s.toString();
    }

    @Override
    public AgentSet.Iterator iterator() {
        return new Iterator();
    }

    @Override
    public AgentSet.Iterator shufflerator(MersenneTwisterFast random) {
        return new Shufflerator(random);
    }

    private strictfp class Shufflerator
    extends Iterator {
        private int i;
        private final Agent[] copy;
        private Agent next;
        private final MersenneTwisterFast random;

        Shufflerator(MersenneTwisterFast random) {
            this.i = 0;
            this.copy = TreeAgentSet.this.agents.values().toArray(new Agent[TreeAgentSet.this.agents.size()]);
            this.random = random;
            this.fetch();
        }

        public boolean hasNext() {
            return this.next != null;
        }

        public Agent next() {
            Agent result = this.next;
            this.fetch();
            return result;
        }

        private void fetch() {
            if (this.i >= this.copy.length) {
                this.next = null;
            } else {
                if (this.i < this.copy.length - 1) {
                    int r = this.i + this.random.nextInt(this.copy.length - this.i);
                    this.next = this.copy[r];
                    this.copy[r] = this.copy[this.i];
                } else {
                    this.next = this.copy[this.i];
                }
                ++this.i;
            }
        }
    }

    public strictfp class Iterator
    implements AgentSet.Iterator {
        java.util.Iterator<Agent> iter;

        public Iterator() {
            this.iter = TreeAgentSet.this.agents.values().iterator();
        }

        public boolean hasNext() {
            return this.iter.hasNext();
        }

        public Agent next() {
            return this.iter.next();
        }

        public void remove() {
            throw new UnsupportedOperationException("remove() not supported");
        }
    }
}

