/*
 * Decompiled with CFR 0.152.
 */
package org.nlogo.agent;

import java.util.List;
import org.nlogo.agent.Agent;
import org.nlogo.agent.Agent3D;
import org.nlogo.agent.AgentSet;
import org.nlogo.agent.Observer;
import org.nlogo.agent.Patch;
import org.nlogo.agent.Patch3D;
import org.nlogo.agent.Protractor3D;
import org.nlogo.agent.TieManager3D;
import org.nlogo.agent.Topology;
import org.nlogo.agent.Topology3D;
import org.nlogo.agent.Turtle;
import org.nlogo.agent.World;
import org.nlogo.agent.World3D;
import org.nlogo.api.AgentException;
import org.nlogo.api.AgentVariables;
import org.nlogo.api.Color;
import org.nlogo.api.Constants;
import org.nlogo.api.Dump;
import org.nlogo.api.I18N;
import org.nlogo.api.LogoList;
import org.nlogo.api.Vect;
import org.nlogo.util.Exceptions;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public strictfp final class Turtle3D
extends Turtle
implements Agent3D,
org.nlogo.api.Turtle3D {
    public static final int VAR_WHO3D = 0;
    public static final int VAR_COLOR3D = 1;
    public static final int VAR_HEADING3D = 2;
    public static final int VAR_PITCH3D = 3;
    public static final int VAR_ROLL3D = 4;
    public static final int VAR_XCOR3D = 5;
    public static final int VAR_YCOR3D = 6;
    public static final int VAR_ZCOR3D = 7;
    static final int VAR_SHAPE3D = 8;
    public static final int VAR_LABEL3D = 9;
    private static final int VAR_LABELCOLOR3D = 10;
    static final int VAR_BREED3D = 11;
    private static final int VAR_HIDDEN3D = 12;
    private static final int VAR_SIZE3D = 13;
    private static final int VAR_PENSIZE3D = 14;
    private static final int VAR_PENMODE3D = 15;
    double zcor;

    void initvars(Number xcor, Number ycor, AgentSet breed) {
        this.LAST_PREDEFINED_VAR = 15;
        this.NUMBER_PREDEFINED_VARS = this.LAST_PREDEFINED_VAR + 1;
        this.variables[1] = Color.BoxedBlack();
        this.heading = 0.0;
        this.variables[2] = World.ZERO;
        this.xcor = xcor.doubleValue();
        if (xcor instanceof Double) {
            this.variables[5] = xcor;
        }
        this.ycor = ycor.doubleValue();
        if (ycor instanceof Double) {
            this.variables[6] = ycor;
        }
        this.variables[8] = this.world.turtleBreedShapes.breedShape(breed);
        this.variables[9] = "";
        this.variables[10] = Color.BoxedWhite();
        this.variables[11] = breed;
        this.variables[12] = Boolean.FALSE;
        this.variables[13] = World.ONE;
        this.variables[14] = World.ONE;
        this.variables[15] = "up";
    }

    public Turtle3D(World3D world, AgentSet breed, Number xcor, Number ycor, Number zcor) {
        this(world, breed, xcor, ycor, zcor, true);
    }

    private Turtle3D(World3D world, AgentSet breed, Number xcor, Number ycor, Number zcor, boolean getId) {
        super(world);
        this.variables = new Object[world.getVariablesArraySize(this, (org.nlogo.api.AgentSet)breed)];
        if (getId) {
            this.id(world.newTurtleId());
            world.turtles().add(this);
        }
        this.initvars(xcor, ycor, breed);
        for (int i = this.LAST_PREDEFINED_VAR + 1; i < this.variables.length; ++i) {
            this.variables[i] = World.ZERO;
        }
        if (breed != world.turtles()) {
            breed.add(this);
        }
        this.variables[3] = World.ZERO;
        this.variables[4] = World.ZERO;
        this.zcor = zcor.doubleValue();
        if (zcor instanceof Double) {
            this.variables[7] = zcor;
        }
        this.getPatchHere().addTurtle(this);
    }

    Turtle3D(World world) {
        super(world);
    }

    Turtle3D(World world, long id) {
        this((World3D)world, world.turtles(), World.ZERO, World.ZERO, World.ZERO, false);
        this.id(id);
        world.turtles().add(this);
    }

    @Override
    public Turtle hatch() {
        Turtle3D child = new Turtle3D(this.world);
        child.heading = this.heading;
        child.xcor = this.xcor;
        child.ycor = this.ycor;
        child.zcor = this.zcor;
        child.variables = (Object[])this.variables.clone();
        child.id(this.world.newTurtleId());
        this.world.turtles().add(child);
        if (this.getBreed() != this.world.turtles()) {
            this.getBreed().add(child);
        }
        child.getPatchHere().addTurtle(child);
        return child;
    }

    @Override
    public Patch getPatchAtOffsets(double dx, double dy) throws AgentException {
        Patch3D target = ((World3D)this.world).getPatchAt(this.xcor + dx, this.ycor + dy, this.zcor);
        if (target == null) {
            throw new AgentException("Cannot get patch beyond limits of current world.");
        }
        return target;
    }

    @Override
    public Patch3D getPatchAtOffsets(double dx, double dy, double dz) throws AgentException {
        Patch3D target = ((World3D)this.world).getPatchAt(this.xcor + dx, this.ycor + dy, this.zcor + dz);
        if (target == null) {
            throw new AgentException("Cannot get patch beyond limits of current world.");
        }
        return target;
    }

    public Patch getPatchAtPoint(List<Double> point) throws AgentException {
        double dx = point.get(0);
        double dy = point.get(1);
        double dz = point.size() == 3 ? point.get(2) : 0.0;
        return this.getPatchAtOffsets(dx, dy, dz);
    }

    @Override
    public void jump(double distance) {
        double pitchRadians = StrictMath.toRadians(this.pitch());
        double sin = StrictMath.sin(pitchRadians);
        double distProj = distance * StrictMath.cos(pitchRadians);
        if (StrictMath.abs(sin) < Constants.Infinitesimal()) {
            sin = 0.0;
        }
        if (StrictMath.abs(distProj) < Constants.Infinitesimal()) {
            distProj = 0.0;
        }
        double headingRadians = StrictMath.toRadians(this.heading());
        double cosProj = StrictMath.cos(headingRadians);
        double sinProj = StrictMath.sin(headingRadians);
        if (StrictMath.abs(cosProj) < Constants.Infinitesimal()) {
            cosProj = 0.0;
        }
        if (StrictMath.abs(sinProj) < Constants.Infinitesimal()) {
            sinProj = 0.0;
        }
        this.xyandzcor(this.xcor + distProj * sinProj, this.ycor + distProj * cosProj, this.zcor + distance * sin);
    }

    @Override
    public Patch getPatchHere() {
        if (this.currentPatch == null) {
            this.currentPatch = ((World3D)this.world).getPatchAtWrap(this.xcor, this.ycor, this.zcor);
        }
        return this.currentPatch;
    }

    @Override
    public Object getTurtleVariable(int vn) {
        switch (vn) {
            case 0: {
                if (this.variables[0] != null) break;
                this.variables[0] = (double)this.id;
                break;
            }
            case 2: {
                if (this.variables[2] != null) break;
                this.variables[2] = this.heading;
                break;
            }
            case 5: {
                if (this.variables[5] != null) break;
                this.variables[5] = this.xcor;
                break;
            }
            case 6: {
                if (this.variables[6] != null) break;
                this.variables[6] = this.ycor;
                break;
            }
            case 7: {
                if (this.variables[7] != null) break;
                this.variables[7] = this.zcor;
                break;
            }
        }
        return this.variables[vn];
    }

    @Override
    public double getTurtleVariableDouble(int vn) {
        switch (vn) {
            case 2: {
                return this.heading;
            }
            case 3: {
                return this.pitch();
            }
            case 4: {
                return this.roll();
            }
            case 5: {
                return this.xcor;
            }
            case 6: {
                return this.ycor;
            }
            case 7: {
                return this.zcor;
            }
            case 13: {
                return this.size();
            }
            case 14: {
                return this.penSize();
            }
        }
        throw new IllegalArgumentException(vn + " is not a double variable");
    }

    @Override
    public void setTurtleVariable(int vn, double value) throws AgentException {
        switch (vn) {
            case 2: {
                this.heading(value);
                break;
            }
            case 5: {
                this.xcor(value);
                break;
            }
            case 6: {
                this.ycor(value);
                break;
            }
            case 13: {
                this.size(value);
                break;
            }
            case 14: {
                this.penSize(value);
                break;
            }
            case 3: {
                this.pitch(value);
                break;
            }
            case 4: {
                this.roll(value);
                break;
            }
            case 7: {
                this.zcor(value);
                break;
            }
            case 0: {
                throw new AgentException("you can't change a turtle's who number");
            }
            default: {
                throw new IllegalArgumentException(vn + " is not a double variable");
            }
        }
    }

    @Override
    public void setTurtleVariable(int vn, Object value) throws AgentException {
        if (vn > this.LAST_PREDEFINED_VAR) {
            this.variables[vn] = value;
        } else {
            switch (vn) {
                case 1: {
                    if (value instanceof Double) {
                        this.colorDouble((Double)value);
                        break;
                    }
                    if (value instanceof LogoList) {
                        this.color((LogoList)value, 1);
                        break;
                    }
                    this.wrongTypeForVariable(AgentVariables.getImplicitTurtleVariables(true)[vn], Double.class, value);
                    break;
                }
                case 2: {
                    if (value instanceof Double) {
                        this.heading((Double)value);
                        break;
                    }
                    this.wrongTypeForVariable(AgentVariables.getImplicitTurtleVariables(true)[vn], Double.class, value);
                    break;
                }
                case 5: {
                    if (value instanceof Double) {
                        this.xcor((Double)value);
                        break;
                    }
                    this.wrongTypeForVariable(AgentVariables.getImplicitTurtleVariables(true)[vn], Double.class, value);
                    break;
                }
                case 6: {
                    if (value instanceof Double) {
                        this.ycor((Double)value);
                        break;
                    }
                    this.wrongTypeForVariable(AgentVariables.getImplicitTurtleVariables(true)[vn], Double.class, value);
                    break;
                }
                case 8: {
                    if (value instanceof String) {
                        String newShape = this.world.checkTurtleShapeName((String)value);
                        if (newShape == null) {
                            throw new AgentException("\"" + (String)value + "\" is not a currently defined shape");
                        }
                        this.shape(newShape);
                        break;
                    }
                    this.wrongTypeForVariable(AgentVariables.getImplicitTurtleVariables(true)[vn], String.class, value);
                    break;
                }
                case 9: {
                    this.label(value);
                    break;
                }
                case 10: {
                    if (value instanceof Number) {
                        this.labelColor(((Number)value).doubleValue());
                        break;
                    }
                    if (value instanceof LogoList) {
                        this.labelColor((LogoList)value, 10);
                        break;
                    }
                    this.wrongTypeForVariable(AgentVariables.getImplicitTurtleVariables(true)[vn], Double.class, value);
                    break;
                }
                case 11: {
                    if (value instanceof AgentSet) {
                        AgentSet breed = (AgentSet)value;
                        if (breed != this.world.turtles() && !this.world.isBreed(breed)) {
                            throw new AgentException(I18N.errorsJ().get("org.nlogo.agent.Turtle.cantSetBreedToNonBreedAgentSet"));
                        }
                        this.setBreed(breed);
                        break;
                    }
                    this.wrongTypeForVariable(AgentVariables.getImplicitTurtleVariables(true)[vn], AgentSet.class, value);
                    break;
                }
                case 12: {
                    if (value instanceof Boolean) {
                        this.hidden((Boolean)value);
                        break;
                    }
                    this.wrongTypeForVariable(AgentVariables.getImplicitTurtleVariables(true)[vn], Boolean.class, value);
                    break;
                }
                case 13: {
                    if (value instanceof Number) {
                        this.size(((Number)value).doubleValue());
                        break;
                    }
                    this.wrongTypeForVariable(AgentVariables.getImplicitTurtleVariables(true)[vn], Double.class, value);
                    break;
                }
                case 15: {
                    if (value instanceof String) {
                        this.penMode((String)value);
                        break;
                    }
                    this.wrongTypeForVariable(AgentVariables.getImplicitTurtleVariables(true)[vn], String.class, value);
                    break;
                }
                case 14: {
                    if (value instanceof Number) {
                        this.penSize(((Number)value).doubleValue());
                        break;
                    }
                    this.wrongTypeForVariable(AgentVariables.getImplicitTurtleVariables(true)[vn], Double.class, value);
                    break;
                }
                case 0: {
                    throw new AgentException("you can't change a turtle's ID number");
                }
                case 3: {
                    if (value instanceof Number) {
                        this.pitch(((Number)value).doubleValue());
                        break;
                    }
                    this.wrongTypeForVariable(AgentVariables.getImplicitTurtleVariables(true)[vn], Double.class, value);
                    break;
                }
                case 4: {
                    if (value instanceof Number) {
                        this.roll(((Number)value).doubleValue());
                        break;
                    }
                    this.wrongTypeForVariable(AgentVariables.getImplicitTurtleVariables(true)[vn], Double.class, value);
                    break;
                }
                case 7: {
                    if (value instanceof Double) {
                        this.zcor((Double)value);
                        break;
                    }
                    this.wrongTypeForVariable(AgentVariables.getImplicitTurtleVariables(true)[vn], Double.class, value);
                    break;
                }
                default: {
                    return;
                }
            }
        }
    }

    @Override
    public double pitch() {
        return (Double)this.variables[3];
    }

    public void pitch(double pitch) {
        double originalPitch = this.pitch();
        if (pitch < 0.0 || pitch >= 360.0) {
            pitch = (pitch % 360.0 + 360.0) % 360.0;
        }
        this.variables[3] = pitch;
        if (this == this.world.observer().targetAgent()) {
            this.world.observer().updatePosition();
        }
        if (this.world.tieManager.tieCount > 0) {
            this.turtleOrientationChanged(this.heading, pitch, this.roll(), this.heading, originalPitch, this.roll());
        }
    }

    @Override
    public double roll() {
        return (Double)this.variables[4];
    }

    public void roll(double roll) {
        double originalRoll = this.roll();
        if (roll < 0.0 || roll >= 360.0) {
            roll = (roll % 360.0 + 360.0) % 360.0;
        }
        this.variables[4] = roll;
        if (this == this.world.observer().targetAgent()) {
            this.world.observer().updatePosition();
        }
        if (this.world.tieManager.tieCount > 0) {
            this.turtleOrientationChanged(this.heading(), this.pitch(), roll, this.heading(), this.pitch(), originalRoll);
        }
    }

    public void headingPitchAndRoll(double heading, double pitch, double roll) {
        double originalHeading = this.heading();
        double originalPitch = this.pitch();
        double originalRoll = this.roll();
        if (roll < 0.0 || roll >= 360.0) {
            roll = (roll % 360.0 + 360.0) % 360.0;
        }
        if (pitch < 0.0 || pitch >= 360.0) {
            pitch = (pitch % 360.0 + 360.0) % 360.0;
        }
        if (heading < 0.0 || heading >= 360.0) {
            heading = (heading % 360.0 + 360.0) % 360.0;
        }
        this.variables[3] = pitch;
        this.variables[4] = roll;
        this.heading = heading;
        this.variables[2] = null;
        if (this == this.world.observer().targetAgent()) {
            this.world.observer().updatePosition();
        }
        if (this.world.tieManager.tieCount > 0) {
            this.turtleOrientationChanged(heading, pitch, roll, originalHeading, originalPitch, originalRoll);
        }
    }

    @Override
    void drawLine(double x0, double y0, double x1, double y1) {
        if (this.penMode().equals("down") && (x0 != x1 || y0 != y1)) {
            ((World3D)this.world).drawLine(x0, y0, this.zcor, x1, y1, this.zcor, this.color(), this.penSize());
        }
    }

    void drawLine(double x0, double y0, double z0, double x1, double y1, double z1) {
        if (this.penMode().equals("down") && (x0 != x1 || y0 != y1 || z0 != z1)) {
            ((World3D)this.world).drawLine(x0, y0, z0, x1, y1, z1, this.color(), this.penSize());
        }
    }

    public double shortestPathZ(double z) {
        if (!this.penMode().equals("down")) {
            return z;
        }
        World3D w = (World3D)this.world;
        z = ((Topology3D)((Object)this.world.getTopology())).wrapZ(z);
        double zprime = z > this.zcor ? z - (double)w.worldDepth() : z + (double)w.worldDepth();
        if (StrictMath.abs(z - this.zcor) > StrictMath.abs(zprime - this.zcor)) {
            z = zprime;
        }
        return z;
    }

    @Override
    public void moveTo(Agent otherAgent) throws AgentException {
        double z;
        double y;
        double x;
        if (otherAgent instanceof Turtle) {
            Turtle3D t = (Turtle3D)otherAgent;
            x = t.xcor();
            y = t.ycor();
            z = t.zcor();
        } else {
            Patch3D p = (Patch3D)otherAgent;
            x = p.pxcor;
            y = p.pycor;
            z = p.pzcor;
        }
        this.xyandzcor(this.shortestPathX(x), this.shortestPathY(y), this.shortestPathZ(z));
    }

    @Override
    public void moveToPatchCenter() {
        Patch3D p = (Patch3D)this.getPatchHere();
        double x = p.pxcor;
        double y = p.pycor;
        double z = p.pzcor;
        double oldX = this.xcor;
        double oldY = this.ycor;
        double oldZ = this.zcor;
        this.drawLine(oldX, oldY, oldZ, x, y, z);
        if (x != oldX || y != oldY || z != oldZ) {
            this.xcor = x;
            this.ycor = y;
            this.zcor = z;
            this.variables[5] = p.variables[0];
            this.variables[6] = p.variables[1];
            this.variables[7] = p.variables[2];
            Observer observer = this.world.observer();
            if (this == observer.targetAgent()) {
                observer.updatePosition();
            }
            if (this.world.tieManager.tieCount > 0) {
                ((TieManager3D)this.world.tieManager).turtleMoved(this, x, y, z, oldX, oldY, oldZ);
            }
        }
    }

    @Override
    public void xcor(double xcor) throws AgentException {
        Observer observer;
        Patch originalPatch = this.getPatchHere();
        double oldX = this.xcor;
        this.drawLine(oldX, this.ycor, this.shortestPathX(xcor), this.ycor);
        this.xcor = this.world.getTopology().wrapX(xcor);
        this.variables[5] = null;
        this.currentPatch = null;
        Patch targetPatch = this.getPatchHere();
        if (originalPatch != targetPatch) {
            originalPatch.removeTurtle(this);
            targetPatch.addTurtle(this);
        }
        if (this == (observer = this.world.observer()).targetAgent()) {
            observer.updatePosition();
        }
        if (this.world.tieManager.tieCount > 0) {
            this.turtleMoved(xcor, this.ycor, this.zcor, oldX, this.ycor, this.zcor);
        }
    }

    @Override
    public void xcor(Double xcor) throws AgentException {
        Observer observer;
        Patch originalPatch = this.getPatchHere();
        double x = xcor;
        double wrapped = this.world.getTopology().wrapX(x);
        double oldX = this.xcor;
        this.drawLine(this.xcor, this.ycor, this.shortestPathX(x), this.ycor);
        this.xcor = wrapped;
        this.variables[5] = x == wrapped ? xcor : null;
        this.currentPatch = null;
        Patch targetPatch = this.getPatchHere();
        if (originalPatch != targetPatch) {
            originalPatch.removeTurtle(this);
            targetPatch.addTurtle(this);
        }
        if (this == (observer = this.world.observer()).targetAgent()) {
            observer.updatePosition();
        }
        if (this.world.tieManager.tieCount > 0) {
            this.turtleMoved(x, this.ycor, this.zcor, oldX, this.ycor, this.zcor);
        }
    }

    @Override
    public double zcor() {
        return this.zcor;
    }

    public void zcor(double zcor) {
        Patch originalPatch = this.getPatchHere();
        double oldZ = this.zcor;
        World3D w = (World3D)this.world;
        double z = Topology.wrap(zcor, (double)w.minPzcor() - 0.5, (double)w.maxPzcor() + 0.5);
        this.drawLine(this.xcor, this.ycor, this.zcor, this.xcor, this.ycor, this.shortestPathZ(zcor));
        this.zcor = z;
        this.variables[7] = null;
        this.currentPatch = null;
        Patch targetPatch = this.getPatchHere();
        if (originalPatch != targetPatch) {
            originalPatch.removeTurtle(this);
            targetPatch.addTurtle(this);
        }
        if (this.world.tieManager.tieCount > 0) {
            this.turtleMoved(this.xcor, this.ycor, zcor, this.xcor, this.ycor, oldZ);
        }
    }

    public void zcor(Double zcor) {
        Patch originalPatch = this.getPatchHere();
        double oldZ = this.zcor;
        double z = zcor;
        World3D w = (World3D)this.world;
        double wrapped = Topology.wrap(zcor, (double)w.minPzcor() - 0.5, (double)w.maxPzcor() + 0.5);
        this.drawLine(this.xcor, this.ycor, this.zcor, this.xcor, this.ycor, this.shortestPathZ(z));
        this.zcor = wrapped;
        this.variables[7] = z == wrapped ? zcor : null;
        this.currentPatch = null;
        Patch targetPatch = this.getPatchHere();
        if (originalPatch != targetPatch) {
            originalPatch.removeTurtle(this);
            targetPatch.addTurtle(this);
        }
        if (this.world.tieManager.tieCount > 0) {
            this.turtleMoved(this.xcor, this.ycor, z, this.xcor, this.ycor, oldZ);
        }
    }

    @Override
    public void ycor(double ycor) throws AgentException {
        Observer observer;
        Patch originalPatch = this.getPatchHere();
        double oldY = this.ycor;
        this.drawLine(this.xcor, oldY, this.xcor, this.shortestPathY(ycor));
        this.ycor = this.world.getTopology().wrapY(ycor);
        this.variables[6] = null;
        this.currentPatch = null;
        Patch targetPatch = this.getPatchHere();
        if (originalPatch != targetPatch) {
            originalPatch.removeTurtle(this);
            targetPatch.addTurtle(this);
        }
        if (this == (observer = this.world.observer()).targetAgent()) {
            observer.updatePosition();
        }
        if (this.world.tieManager.tieCount > 0) {
            this.turtleMoved(this.xcor, ycor, this.zcor, this.xcor, oldY, this.zcor);
        }
    }

    @Override
    public void ycor(Double ycor) throws AgentException {
        Observer observer;
        Patch originalPatch = this.getPatchHere();
        double oldY = this.ycor;
        double y = ycor;
        double wrapped = this.world.getTopology().wrapY(y);
        this.drawLine(this.xcor, this.ycor, this.xcor, this.shortestPathY(y));
        this.ycor = wrapped;
        this.variables[6] = y == wrapped ? ycor : null;
        this.currentPatch = null;
        Patch targetPatch = this.getPatchHere();
        if (originalPatch != targetPatch) {
            originalPatch.removeTurtle(this);
            targetPatch.addTurtle(this);
        }
        if (this == (observer = this.world.observer()).targetAgent()) {
            observer.updatePosition();
        }
        if (this.world.tieManager.tieCount > 0) {
            this.turtleMoved(this.xcor, y, this.zcor, this.xcor, oldY, this.zcor);
        }
    }

    @Override
    public void xandycor(double xcor, double ycor) throws AgentException {
        Observer observer;
        Patch originalPatch = this.getPatchHere();
        double oldX = this.xcor;
        double oldY = this.ycor;
        double newX = this.world.getTopology().wrapX(xcor);
        double newY = this.world.getTopology().wrapY(ycor);
        this.drawLine(this.xcor, this.ycor, xcor, ycor);
        this.xcor = newX;
        this.ycor = newY;
        this.variables[5] = null;
        this.variables[6] = null;
        this.currentPatch = null;
        Patch targetPatch = this.getPatchHere();
        if (originalPatch != targetPatch) {
            originalPatch.removeTurtle(this);
            targetPatch.addTurtle(this);
        }
        if (this == (observer = this.world.observer()).targetAgent()) {
            observer.updatePosition();
        }
        if (this.world.tieManager.tieCount > 0) {
            this.turtleMoved(xcor, ycor, this.zcor, oldX, oldY, this.zcor);
        }
    }

    @Override
    public void xandycor(Double xcor, Double ycor) throws AgentException {
        Observer observer;
        Patch originalPatch = this.getPatchHere();
        double oldX = this.xcor;
        double oldY = this.ycor;
        double x = xcor;
        double y = ycor;
        double wrappedX = this.world.getTopology().wrapX(x);
        double wrappedY = this.world.getTopology().wrapY(y);
        this.drawLine(this.xcor, this.ycor, x, y);
        this.xcor = wrappedX;
        this.ycor = wrappedY;
        this.variables[5] = x == wrappedX ? xcor : null;
        this.variables[6] = y == wrappedY ? ycor : null;
        this.currentPatch = null;
        Patch targetPatch = this.getPatchHere();
        if (originalPatch != targetPatch) {
            originalPatch.removeTurtle(this);
            targetPatch.addTurtle(this);
        }
        if (this == (observer = this.world.observer()).targetAgent()) {
            observer.updatePosition();
        }
        if (this.world.tieManager.tieCount > 0) {
            this.turtleMoved(x, y, this.zcor, oldX, oldY, this.zcor);
        }
    }

    public void xyandzcor(double xcor, double ycor, double zcor) {
        Observer observer;
        Patch originalPatch = this.getPatchHere();
        double oldX = this.xcor;
        double oldY = this.ycor;
        double oldZ = this.zcor;
        World3D w = (World3D)this.world;
        double newX = Topology.wrap(xcor, (double)w.minPxcor() - 0.5, (double)w.maxPxcor() + 0.5);
        double newY = Topology.wrap(ycor, (double)w.minPycor() - 0.5, (double)w.maxPycor() + 0.5);
        double newZ = Topology.wrap(zcor, (double)w.minPzcor() - 0.5, (double)w.maxPzcor() + 0.5);
        this.drawLine(this.xcor, this.ycor, this.zcor, xcor, ycor, zcor);
        this.xcor = newX;
        this.ycor = newY;
        this.zcor = newZ;
        this.variables[5] = null;
        this.variables[6] = null;
        this.variables[7] = null;
        this.currentPatch = null;
        Patch targetPatch = this.getPatchHere();
        if (originalPatch != targetPatch) {
            originalPatch.removeTurtle(this);
            targetPatch.addTurtle(this);
        }
        if (this == (observer = this.world.observer()).targetAgent()) {
            observer.updatePosition();
        }
        if (this.world.tieManager.tieCount > 0) {
            this.turtleMoved(xcor, ycor, zcor, oldX, oldY, oldZ);
        }
    }

    public void xyandzcor(Double xcor, Double ycor, Double zcor) {
        Observer observer;
        Patch originalPatch = this.getPatchHere();
        double oldX = this.xcor;
        double oldY = this.ycor;
        double oldZ = this.zcor;
        double x = xcor;
        double y = ycor;
        double z = zcor;
        World3D w = (World3D)this.world;
        double wrappedX = Topology.wrap(x, (double)w.minPxcor() - 0.5, (double)w.maxPxcor() + 0.5);
        double wrappedY = Topology.wrap(y, (double)w.minPycor() - 0.5, (double)w.maxPycor() + 0.5);
        double wrappedZ = Topology.wrap(z, (double)w.minPzcor() - 0.5, (double)w.maxPzcor() + 0.5);
        this.drawLine(this.xcor, this.ycor, this.zcor, x, y, z);
        this.xcor = wrappedX;
        this.ycor = wrappedY;
        this.zcor = wrappedZ;
        this.variables[5] = x == wrappedX ? xcor : null;
        this.variables[6] = y == wrappedY ? ycor : null;
        this.variables[7] = z == wrappedZ ? zcor : null;
        this.currentPatch = null;
        Patch targetPatch = this.getPatchHere();
        if (originalPatch != targetPatch) {
            originalPatch.removeTurtle(this);
            targetPatch.addTurtle(this);
        }
        if (this == (observer = this.world.observer()).targetAgent()) {
            observer.updatePosition();
        }
        if (this.world.tieManager.tieCount > 0) {
            this.turtleMoved(x, y, z, oldX, oldY, oldZ);
        }
    }

    @Override
    public void home() {
        this.xyandzcor(World.ZERO, World.ZERO, World.ZERO);
    }

    @Override
    public void face(Agent agent, boolean wrap) {
        double newPitch;
        double newHeading;
        try {
            newHeading = this.world.protractor().towards(this, agent, wrap);
        }
        catch (AgentException ex) {
            newHeading = this.heading();
        }
        try {
            newPitch = this.world.protractor().towardsPitch(this, agent, wrap);
        }
        catch (AgentException ex) {
            newPitch = this.pitch();
        }
        this.headingPitchAndRoll(newHeading, newPitch, this.roll());
    }

    public void face(double x, double y, double z, boolean wrap) {
        double newHeading = this.heading();
        double newPitch = this.pitch();
        try {
            newHeading = this.world.protractor().towards(this, x, y, wrap);
        }
        catch (AgentException ex) {
            Exceptions.ignore(ex);
        }
        try {
            newPitch = this.world.protractor().towardsPitch(this, x, y, z, wrap);
        }
        catch (AgentException ex) {
            Exceptions.ignore(ex);
        }
        this.headingPitchAndRoll(newHeading, newPitch, this.roll());
    }

    @Override
    public double dx() {
        return StrictMath.cos(StrictMath.toRadians(this.pitch())) * StrictMath.sin(StrictMath.toRadians(this.heading()));
    }

    @Override
    public double dy() {
        return StrictMath.cos(StrictMath.toRadians(this.pitch())) * StrictMath.cos(StrictMath.toRadians(this.heading()));
    }

    @Override
    public double dz() {
        return StrictMath.sin(StrictMath.toRadians(this.pitch()));
    }

    @Override
    public String shape() {
        return (String)this.variables[8];
    }

    @Override
    public void shape(String shape2) {
        this.variables[8] = shape2;
    }

    @Override
    public Object label() {
        return this.variables[9];
    }

    @Override
    public String labelString() {
        return Dump.logoObject(this.variables[9]);
    }

    @Override
    public void label(Object label) {
        this.variables[9] = label;
    }

    @Override
    public Object labelColor() {
        return this.variables[10];
    }

    @Override
    public void labelColor(double labelColor) {
        this.variables[10] = Color.modulateDouble(labelColor);
    }

    @Override
    public AgentSet getBreed() {
        return (AgentSet)this.variables[11];
    }

    @Override
    public void setBreed(AgentSet breed) {
        AgentSet oldBreed = null;
        if (this.variables[11] instanceof AgentSet) {
            oldBreed = (AgentSet)this.variables[11];
            if (breed == oldBreed) {
                return;
            }
            if (oldBreed != this.world.turtles()) {
                ((AgentSet)this.variables[11]).remove(this.agentKey());
            }
        }
        if (breed != this.world.turtles()) {
            breed.add(this);
        }
        this.variables[11] = breed;
        this.shape(this.world.turtleBreedShapes.breedShape(breed));
        this.realloc(false, oldBreed);
    }

    @Override
    public Patch getPatchAtHeadingAndDistance(double delta, double distance) throws AgentException {
        double[] angles = this.right(delta);
        return ((Protractor3D)this.world.protractor()).getPatchAtHeadingPitchAndDistance(this.xcor, this.ycor, this.zcor, angles[0], angles[1], distance);
    }

    @Override
    public void turnRight(double delta) {
        double[] angles = this.right(delta);
        this.headingPitchAndRoll(angles[0], angles[1], angles[2]);
    }

    public double[] right(double delta) {
        delta = -delta;
        Vect[] v = Vect.toVectors(this.heading, this.pitch(), this.roll());
        double sinDelta = StrictMath.sin(StrictMath.toRadians(delta));
        double cosDelta = StrictMath.cos(StrictMath.toRadians(delta));
        if (StrictMath.abs(sinDelta) < Constants.Infinitesimal()) {
            sinDelta = 0.0;
        }
        if (StrictMath.abs(cosDelta) < Constants.Infinitesimal()) {
            cosDelta = 0.0;
        }
        Vect turnForward = new Vect(-sinDelta, cosDelta, 0.0);
        Vect turnRight = new Vect(cosDelta, sinDelta, 0.0);
        Vect orthogonal = v[1].cross(v[0]);
        Vect forward = Vect.axisTransformation(turnForward, v[1], v[0], orthogonal);
        Vect right = Vect.axisTransformation(turnRight, v[1], v[0], orthogonal);
        return Vect.toAngles(forward, right);
    }

    @Override
    public boolean hidden() {
        return (Boolean)this.variables[12];
    }

    @Override
    public void hidden(boolean hidden) {
        this.variables[12] = hidden ? Boolean.TRUE : Boolean.FALSE;
    }

    @Override
    public double size() {
        return (Double)this.variables[13];
    }

    @Override
    public void size(double size2) {
        this.variables[13] = size2;
    }

    @Override
    public double penSize() {
        return (Double)this.variables[14];
    }

    @Override
    public void penSize(double penSize) {
        this.variables[14] = penSize;
    }

    @Override
    public String penMode() {
        return (String)this.variables[15];
    }

    @Override
    public void penMode(String penMode) {
        this.variables[15] = penMode;
    }

    private void turtleMoved(double newX, double newY, double newZ, double oldX, double oldY, double oldZ) {
        ((TieManager3D)this.world.tieManager).turtleMoved(this, newX, newY, newZ, oldX, oldY, oldZ);
    }

    private void turtleOrientationChanged(double newHeading, double newPitch, double newRoll, double oldHeading, double oldPitch, double oldRoll) {
        ((TieManager3D)this.world.tieManager).turtleOrientationChanged(this, newHeading, newPitch, newRoll, oldHeading, oldPitch, oldRoll);
    }
}

