/*
 * Decompiled with CFR 0.152.
 */
package org.nlogo.agent;

import org.nlogo.agent.Agent;
import org.nlogo.agent.AgentSet;
import org.nlogo.agent.ArrayAgentSet;
import org.nlogo.agent.Patch;
import org.nlogo.agent.PatchException;
import org.nlogo.agent.Topology;
import org.nlogo.agent.World;
import org.nlogo.api.AgentException;

strictfp final class VertCylinder
extends Topology {
    VertCylinder(World world) {
        super(world);
    }

    double wrapX(double x) {
        return VertCylinder.wrap(x, (double)this.world.minPxcor() - 0.5, (double)this.world.maxPxcor() + 0.5);
    }

    double wrapY(double y) throws AgentException {
        double max2 = (double)this.world.maxPycor() + 0.5;
        double min2 = (double)this.world.minPycor() - 0.5;
        if (y >= max2 || y < min2) {
            throw new AgentException("Cannot move turtle beyond the world's edge.");
        }
        return y;
    }

    double distanceWrap(double dx, double dy, double x1, double y1, double x2, double y2) {
        double dx2 = x1 > x2 ? x2 + (double)this.world.worldWidth() - x1 : x2 - (double)this.world.worldWidth() - x1;
        dx = StrictMath.abs(dx2) < StrictMath.abs(dx) ? dx2 : dx;
        return this.world.rootsTable.gridRoot(dx * dx + dy * dy);
    }

    double towardsWrap(double headingX, double headingY) {
        headingX = VertCylinder.wrap(headingX, -((double)this.world.worldWidth()) / 2.0, (double)this.world.worldWidth() / 2.0);
        if (headingY == 0.0) {
            return headingX > 0.0 ? 90.0 : 270.0;
        }
        if (headingX == 0.0) {
            return headingY > 0.0 ? 0.0 : 180.0;
        }
        return (270.0 + StrictMath.toDegrees(Math.PI + StrictMath.atan2(-headingY, headingX))) % 360.0;
    }

    Patch getPatchAt(double xc, double yc) throws AgentException {
        if (yc > (double)this.world.maxPycor() + 0.5 || yc < (double)this.world.minPycor() - 0.5) {
            return null;
        }
        return this.world.getPatchAt(xc, yc);
    }

    double shortestPathX(double x1, double x2) {
        double xprime = x1 > x2 ? x2 + (double)this.world.worldWidth() : x2 - (double)this.world.worldWidth();
        if (StrictMath.abs(x2 - x1) > StrictMath.abs(xprime - x1)) {
            x2 = xprime;
        }
        return x2;
    }

    double shortestPathY(double y1, double y2) {
        return y2;
    }

    void diffuse(double diffuseparam, int vn) throws AgentException, PatchException {
        int xx = this.world.worldWidth();
        int yy = this.world.worldHeight();
        int xx2 = xx * 2;
        int yy2 = yy * 2;
        double[][] scratch = this.world.getPatchScratch();
        double[][] scratch2 = new double[xx][yy];
        int x = 0;
        int y = 0;
        int minx = this.world.minPxcor();
        int miny = this.world.minPycor();
        try {
            for (y = 0; y < yy; ++y) {
                for (x = 0; x < xx; ++x) {
                    scratch[x][y] = (Double)this.world.fastGetPatchAt(x + minx, y + miny).getPatchVariable(vn);
                    scratch2[x][y] = 0.0;
                }
            }
        }
        catch (ClassCastException ex) {
            throw new PatchException(this.world.fastGetPatchAt((int)this.wrapX(x), (int)this.wrapY(y)));
        }
        for (y = yy; y < yy2; ++y) {
            for (x = xx; x < xx2; ++x) {
                double diffuseVal = scratch[x - xx][y - yy] / 8.0 * diffuseparam;
                if (y > yy && y < yy2 - 1) {
                    double[] dArray = scratch2[x - xx];
                    int n = y - yy;
                    dArray[n] = dArray[n] + (scratch[x - xx][y - yy] - 8.0 * diffuseVal);
                    double[] dArray2 = scratch2[(x - 1) % xx];
                    int n2 = (y - 1) % yy;
                    dArray2[n2] = dArray2[n2] + diffuseVal;
                    double[] dArray3 = scratch2[(x - 1) % xx];
                    int n3 = y % yy;
                    dArray3[n3] = dArray3[n3] + diffuseVal;
                    double[] dArray4 = scratch2[(x - 1) % xx];
                    int n4 = (y + 1) % yy;
                    dArray4[n4] = dArray4[n4] + diffuseVal;
                    double[] dArray5 = scratch2[x % xx];
                    int n5 = (y + 1) % yy;
                    dArray5[n5] = dArray5[n5] + diffuseVal;
                    double[] dArray6 = scratch2[x % xx];
                    int n6 = (y - 1) % yy;
                    dArray6[n6] = dArray6[n6] + diffuseVal;
                    double[] dArray7 = scratch2[(x + 1) % xx];
                    int n7 = (y - 1) % yy;
                    dArray7[n7] = dArray7[n7] + diffuseVal;
                    double[] dArray8 = scratch2[(x + 1) % xx];
                    int n8 = y % yy;
                    dArray8[n8] = dArray8[n8] + diffuseVal;
                    double[] dArray9 = scratch2[(x + 1) % xx];
                    int n9 = (y + 1) % yy;
                    dArray9[n9] = dArray9[n9] + diffuseVal;
                    continue;
                }
                if (y == yy) {
                    double[] dArray = scratch2[x - xx];
                    int n = y - yy;
                    dArray[n] = dArray[n] + (scratch[x - xx][y - yy] - 5.0 * diffuseVal);
                    double[] dArray10 = scratch2[(x - 1) % xx];
                    int n10 = y % yy;
                    dArray10[n10] = dArray10[n10] + diffuseVal;
                    double[] dArray11 = scratch2[(x - 1) % xx];
                    int n11 = (y + 1) % yy;
                    dArray11[n11] = dArray11[n11] + diffuseVal;
                    double[] dArray12 = scratch2[x % xx];
                    int n12 = (y + 1) % yy;
                    dArray12[n12] = dArray12[n12] + diffuseVal;
                    double[] dArray13 = scratch2[(x + 1) % xx];
                    int n13 = y % yy;
                    dArray13[n13] = dArray13[n13] + diffuseVal;
                    double[] dArray14 = scratch2[(x + 1) % xx];
                    int n14 = (y + 1) % yy;
                    dArray14[n14] = dArray14[n14] + diffuseVal;
                    continue;
                }
                double[] dArray = scratch2[x - xx];
                int n = y - yy;
                dArray[n] = dArray[n] + (scratch[x - xx][y - yy] - 5.0 * diffuseVal);
                double[] dArray15 = scratch2[(x - 1) % xx];
                int n15 = y % yy;
                dArray15[n15] = dArray15[n15] + diffuseVal;
                double[] dArray16 = scratch2[(x - 1) % xx];
                int n16 = (y - 1) % yy;
                dArray16[n16] = dArray16[n16] + diffuseVal;
                double[] dArray17 = scratch2[x % xx];
                int n17 = (y - 1) % yy;
                dArray17[n17] = dArray17[n17] + diffuseVal;
                double[] dArray18 = scratch2[(x + 1) % xx];
                int n18 = y % yy;
                dArray18[n18] = dArray18[n18] + diffuseVal;
                double[] dArray19 = scratch2[(x + 1) % xx];
                int n19 = (y - 1) % yy;
                dArray19[n19] = dArray19[n19] + diffuseVal;
            }
        }
        for (y = 0; y < yy; ++y) {
            for (x = 0; x < xx; ++x) {
                if (scratch2[x][y] == scratch[x][y]) continue;
                this.world.getPatchAtWrap(x + minx, y + miny).setPatchVariable(vn, (Object)scratch2[x][y]);
            }
        }
    }

    void diffuse4(double diffuseparam, int vn) throws AgentException, PatchException {
        int xx = this.world.worldWidth();
        int yy = this.world.worldHeight();
        int xx2 = xx * 2;
        int yy2 = yy * 2;
        double[][] scratch = this.world.getPatchScratch();
        double[][] scratch2 = new double[xx][yy];
        int x = 0;
        int y = 0;
        int minx = this.world.minPxcor();
        int miny = this.world.minPycor();
        try {
            for (y = 0; y < yy; ++y) {
                for (x = 0; x < xx; ++x) {
                    scratch[x][y] = (Double)this.world.fastGetPatchAt(x + minx, y + miny).getPatchVariable(vn);
                    scratch2[x][y] = 0.0;
                }
            }
        }
        catch (ClassCastException ex) {
            throw new PatchException(this.world.fastGetPatchAt((int)this.wrapX(x), (int)this.wrapY(y)));
        }
        for (y = yy; y < yy2; ++y) {
            for (x = xx; x < xx2; ++x) {
                double diffuseVal = scratch[x - xx][y - yy] / 4.0 * diffuseparam;
                if (y > yy && y < yy2 - 1) {
                    double[] dArray = scratch2[x - xx];
                    int n = y - yy;
                    dArray[n] = dArray[n] + (scratch[x - xx][y - yy] - 4.0 * diffuseVal);
                    double[] dArray2 = scratch2[(x - 1) % xx];
                    int n2 = y % yy;
                    dArray2[n2] = dArray2[n2] + diffuseVal;
                    double[] dArray3 = scratch2[x % xx];
                    int n3 = (y + 1) % yy;
                    dArray3[n3] = dArray3[n3] + diffuseVal;
                    double[] dArray4 = scratch2[x % xx];
                    int n4 = (y - 1) % yy;
                    dArray4[n4] = dArray4[n4] + diffuseVal;
                    double[] dArray5 = scratch2[(x + 1) % xx];
                    int n5 = y % yy;
                    dArray5[n5] = dArray5[n5] + diffuseVal;
                    continue;
                }
                if (y == yy) {
                    double[] dArray = scratch2[x - xx];
                    int n = y - yy;
                    dArray[n] = dArray[n] + (scratch[x - xx][y - yy] - 3.0 * diffuseVal);
                    double[] dArray6 = scratch2[(x - 1) % xx];
                    int n6 = y % yy;
                    dArray6[n6] = dArray6[n6] + diffuseVal;
                    double[] dArray7 = scratch2[x % xx];
                    int n7 = (y + 1) % yy;
                    dArray7[n7] = dArray7[n7] + diffuseVal;
                    double[] dArray8 = scratch2[(x + 1) % xx];
                    int n8 = y % yy;
                    dArray8[n8] = dArray8[n8] + diffuseVal;
                    continue;
                }
                double[] dArray = scratch2[x - xx];
                int n = y - yy;
                dArray[n] = dArray[n] + (scratch[x - xx][y - yy] - 3.0 * diffuseVal);
                double[] dArray9 = scratch2[(x - 1) % xx];
                int n9 = y % yy;
                dArray9[n9] = dArray9[n9] + diffuseVal;
                double[] dArray10 = scratch2[x % xx];
                int n10 = (y - 1) % yy;
                dArray10[n10] = dArray10[n10] + diffuseVal;
                double[] dArray11 = scratch2[(x + 1) % xx];
                int n11 = y % yy;
                dArray11[n11] = dArray11[n11] + diffuseVal;
            }
        }
        for (y = 0; y < yy; ++y) {
            for (x = 0; x < xx; ++x) {
                if (scratch2[x][y] == scratch[x][y]) continue;
                this.world.getPatchAtWrap(x + minx, y + miny).setPatchVariable(vn, (Object)scratch2[x][y]);
            }
        }
    }

    AgentSet getNeighbors(Patch source2) {
        if (source2.pycor == this.world.maxPycor()) {
            if (source2.pycor == this.world.minPycor()) {
                if (source2.pxcor == this.world.maxPxcor() && source2.pxcor == this.world.minPxcor()) {
                    return new ArrayAgentSet(Patch.class, new Agent[0], this.world);
                }
                return new ArrayAgentSet(Patch.class, new Agent[]{this.getPatchEast(source2), this.getPatchWest(source2)}, this.world);
            }
            if (source2.pxcor == this.world.maxPxcor() && source2.pxcor == this.world.minPxcor()) {
                return new ArrayAgentSet(Patch.class, new Agent[]{this.getPatchSouth(source2)}, this.world);
            }
            return new ArrayAgentSet(Patch.class, new Agent[]{this.getPatchEast(source2), this.getPatchSouth(source2), this.getPatchWest(source2), this.getPatchSouthEast(source2), this.getPatchSouthWest(source2)}, this.world);
        }
        if (source2.pycor == this.world.minPycor()) {
            if (source2.pxcor == this.world.maxPxcor() && source2.pxcor == this.world.minPxcor()) {
                return new ArrayAgentSet(Patch.class, new Agent[]{this.getPatchNorth(source2)}, this.world);
            }
            return new ArrayAgentSet(Patch.class, new Agent[]{this.getPatchNorth(source2), this.getPatchEast(source2), this.getPatchWest(source2), this.getPatchNorthEast(source2), this.getPatchNorthWest(source2)}, this.world);
        }
        if (source2.pxcor == this.world.maxPxcor() && source2.pxcor == this.world.minPxcor()) {
            return new ArrayAgentSet(Patch.class, new Agent[]{this.getPatchNorth(source2), this.getPatchSouth(source2)}, this.world);
        }
        return new ArrayAgentSet(Patch.class, new Agent[]{this.getPatchNorth(source2), this.getPatchEast(source2), this.getPatchSouth(source2), this.getPatchWest(source2), this.getPatchNorthEast(source2), this.getPatchSouthEast(source2), this.getPatchSouthWest(source2), this.getPatchNorthWest(source2)}, this.world);
    }

    double observerY() {
        return 0.0;
    }

    double followOffsetY() {
        return 0.0;
    }

    AgentSet getNeighbors4(Patch source2) {
        if (source2.pycor == this.world.maxPycor()) {
            if (source2.pycor == this.world.minPycor()) {
                if (source2.pxcor == this.world.maxPxcor() && source2.pxcor == this.world.minPxcor()) {
                    return new ArrayAgentSet(Patch.class, new Agent[0], this.world);
                }
                return new ArrayAgentSet(Patch.class, new Agent[]{this.getPatchEast(source2), this.getPatchWest(source2)}, this.world);
            }
            if (source2.pxcor == this.world.maxPxcor() && source2.pxcor == this.world.minPxcor()) {
                return new ArrayAgentSet(Patch.class, new Agent[]{this.getPatchSouth(source2)}, this.world);
            }
            return new ArrayAgentSet(Patch.class, new Agent[]{this.getPatchEast(source2), this.getPatchSouth(source2), this.getPatchWest(source2)}, this.world);
        }
        if (source2.pycor == this.world.minPycor()) {
            if (source2.pxcor == this.world.maxPxcor() && source2.pxcor == this.world.minPxcor()) {
                return new ArrayAgentSet(Patch.class, new Agent[]{this.getPatchNorth(source2)}, this.world);
            }
            return new ArrayAgentSet(Patch.class, new Agent[]{this.getPatchNorth(source2), this.getPatchEast(source2), this.getPatchWest(source2)}, this.world);
        }
        if (source2.pxcor == this.world.maxPxcor() && source2.pxcor == this.world.minPxcor()) {
            return new ArrayAgentSet(Patch.class, new Agent[]{this.getPatchNorth(source2), this.getPatchSouth(source2)}, this.world);
        }
        return new ArrayAgentSet(Patch.class, new Agent[]{this.getPatchNorth(source2), this.getPatchEast(source2), this.getPatchSouth(source2), this.getPatchWest(source2)}, this.world);
    }

    Patch getPN(Patch source2) {
        if (source2.pycor == this.world.maxPycor()) {
            return null;
        }
        return this.getPatchNorth(source2);
    }

    Patch getPE(Patch source2) {
        return this.getPatchEast(source2);
    }

    Patch getPS(Patch source2) {
        if (source2.pycor == this.world.minPycor()) {
            return null;
        }
        return this.getPatchSouth(source2);
    }

    Patch getPW(Patch source2) {
        return this.getPatchWest(source2);
    }

    Patch getPNE(Patch source2) {
        if (source2.pycor == this.world.maxPycor()) {
            return null;
        }
        return this.getPatchNorthEast(source2);
    }

    Patch getPSE(Patch source2) {
        if (source2.pycor == this.world.minPycor()) {
            return null;
        }
        return this.getPatchSouthEast(source2);
    }

    Patch getPSW(Patch source2) {
        if (source2.pycor == this.world.minPycor()) {
            return null;
        }
        return this.getPatchSouthWest(source2);
    }

    Patch getPNW(Patch source2) {
        if (source2.pycor == this.world.maxPycor()) {
            return null;
        }
        return this.getPatchNorthWest(source2);
    }
}

