/*
 * Decompiled with CFR 0.152.
 */
package org.nlogo.agent;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import org.nlogo.agent.Agent;
import org.nlogo.agent.AgentSet;
import org.nlogo.agent.ArrayAgentSet;
import org.nlogo.agent.Drawing3D;
import org.nlogo.agent.Exporter3D;
import org.nlogo.agent.Importer;
import org.nlogo.agent.Importer3D;
import org.nlogo.agent.InRadiusOrCone3D;
import org.nlogo.agent.Link;
import org.nlogo.agent.LinkManager3D;
import org.nlogo.agent.Observer;
import org.nlogo.agent.Observer3D;
import org.nlogo.agent.Patch;
import org.nlogo.agent.Patch3D;
import org.nlogo.agent.Protractor3D;
import org.nlogo.agent.RootsTable;
import org.nlogo.agent.TieManager3D;
import org.nlogo.agent.Topology;
import org.nlogo.agent.Topology3D;
import org.nlogo.agent.Torus3D;
import org.nlogo.agent.TreeAgentSet;
import org.nlogo.agent.Turtle;
import org.nlogo.agent.Turtle3D;
import org.nlogo.agent.World;
import org.nlogo.api.AgentException;
import org.nlogo.api.Color;
import org.nlogo.api.ImporterUser;
import org.nlogo.api.Program;
import org.nlogo.api.WorldDimensionException;
import org.nlogo.api.WorldDimensions;
import org.nlogo.api.WorldDimensions3D;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public strictfp final class World3D
extends World
implements org.nlogo.api.World3D {
    Drawing3D drawing;
    int _worldDepth;
    int _maxPzcor;
    int _minPzcor;
    Double _minPzcorBoxed;
    Double _maxPzcorBoxed;
    Double _worldDepthBoxed;
    private double[][][] patchScratch3d;

    @Override
    public org.nlogo.api.Protractor3D protractor3D() {
        return (org.nlogo.api.Protractor3D)((Object)this._protractor);
    }

    public World3D() {
        this.linkManager = new LinkManager3D(this);
        this.tieManager = new TieManager3D(this, this.linkManager);
        this.drawing = new Drawing3D(this);
        this.inRadiusOrCone = new InRadiusOrCone3D(this);
        this._protractor = new Protractor3D(this);
    }

    @Override
    Observer createObserver() {
        return new Observer3D(this);
    }

    @Override
    public void changeTopology(boolean xWrapping, boolean yWrapping) {
        this.topology = new Torus3D(this);
    }

    public void changeTopology(boolean xWrapping, boolean yWrapping, boolean zWrapping) {
        this.topology = new Torus3D(this);
    }

    public double shortestPathZ(double z1, double z2) {
        return ((Topology3D)((Object)this.topology)).shortestPathZ(z1, z2);
    }

    public boolean wrappingAllowedInZ() {
        return true;
    }

    @Override
    public double wrappedObserverZ(double z) {
        z = ((Topology3D)((Object)this.topology)).wrapZ(z - this.followOffsetZ());
        return z;
    }

    @Override
    public double followOffsetZ() {
        return ((Observer3D)this._observer).followOffsetZ();
    }

    @Override
    public void diffuse4(double param, int vn) {
        throw new UnsupportedOperationException();
    }

    @Override
    public int worldDepth() {
        return this._worldDepth;
    }

    @Override
    public int maxPzcor() {
        return this._maxPzcor;
    }

    @Override
    public int minPzcor() {
        return this._minPzcor;
    }

    public Double minPzcorBoxed() {
        return this._minPzcorBoxed;
    }

    public Double maxPzcorBoxed() {
        return this._maxPzcorBoxed;
    }

    public Double worldDepthBoxed() {
        return this._worldDepthBoxed;
    }

    @Override
    public double wrapZ(double z) {
        return Topology.wrap(z, (double)this._minPzcor - 0.5, (double)this._maxPzcor + 0.5);
    }

    public int roundZ(double z) {
        if ((z = ((Topology3D)((Object)this.topology)).wrapZ(z)) > 0.0) {
            return (int)(z + 0.5);
        }
        int intPart = (int)z;
        double fractPart = (double)intPart - z;
        return fractPart > 0.5 ? intPart - 1 : intPart;
    }

    public Patch getPatchAtWrap(double x, double y, double z) {
        int yc;
        double fractPart;
        int intPart;
        int xc;
        x = Topology.wrap(x, (double)this._minPxcor - 0.5, (double)this._maxPxcor + 0.5);
        y = Topology.wrap(y, (double)this._minPycor - 0.5, (double)this._maxPycor + 0.5);
        z = Topology.wrap(z, (double)this._minPzcor - 0.5, (double)this._maxPzcor + 0.5);
        if (x > 0.0) {
            xc = (int)(x + 0.5);
        } else {
            intPart = (int)x;
            fractPart = (double)intPart - x;
            int n = xc = fractPart > 0.5 ? intPart - 1 : intPart;
        }
        if (y > 0.0) {
            yc = (int)(y + 0.5);
        } else {
            intPart = (int)y;
            fractPart = (double)intPart - y;
            int n = yc = fractPart > 0.5 ? intPart - 1 : intPart;
        }
        int zc = z > 0.0 ? (int)(z + 0.5) : ((fractPart = (double)(intPart = (int)z) - z) > 0.5 ? intPart - 1 : intPart);
        int patchid = this._worldWidth * this._worldHeight * (this._maxPzcor - zc) + this._worldWidth * (this._maxPycor - yc) + xc - this._minPxcor;
        return (Patch)this._patches.toArray()[patchid];
    }

    public boolean validPatchCoordinates(int xc, int yc, int zc) {
        return xc >= this._minPxcor && xc <= this._maxPxcor && yc >= this._minPycor && yc <= this._maxPycor && zc >= this._minPzcor && zc <= this._maxPzcor;
    }

    public Patch fastGetPatchAt(int xc, int yc, int zc) {
        return (Patch)this._patches.toArray()[this._worldWidth * this._worldHeight * (this._maxPzcor - zc) + this._worldWidth * (this._maxPycor - yc) + xc - this._minPxcor];
    }

    @Override
    public Patch fastGetPatchAt(int xc, int yc) {
        return this.fastGetPatchAt(xc, yc, 0);
    }

    @Override
    public void createPatches(WorldDimensions dim) {
        WorldDimensions3D d = (WorldDimensions3D)dim;
        this.createPatches(dim.minPxcor(), dim.maxPxcor(), dim.minPycor(), dim.maxPycor(), d.minPzcor(), d.maxPzcor());
    }

    @Override
    public void createPatches(int minPxcor, int maxPxcor, int minPycor, int maxPycor) {
        this.createPatches(minPxcor, maxPxcor, minPycor, maxPycor, 0, 0);
    }

    @Override
    public Program newProgram() {
        return new Program(true);
    }

    @Override
    public Program newProgram(List<String> interfaceGlobals) {
        return new Program(interfaceGlobals, true);
    }

    public void createPatches(int minPxcor, int maxPxcor, int minPycor, int maxPycor, int minPzcor, int maxPzcor) {
        this.patchScratch = null;
        this.patchScratch3d = null;
        this._minPxcor = minPxcor;
        this._maxPxcor = maxPxcor;
        this._minPycor = minPycor;
        this._maxPycor = maxPycor;
        this._minPzcor = minPzcor;
        this._maxPzcor = maxPzcor;
        this._worldWidth = this._maxPxcor - this._minPxcor + 1;
        this._worldHeight = this._maxPycor - this._minPycor + 1;
        this._worldDepth = this._maxPzcor - this._minPzcor + 1;
        this.rootsTable = new RootsTable(this._worldWidth, this._worldHeight);
        this._worldWidthBoxed = this._worldWidth;
        this._worldHeightBoxed = this._worldHeight;
        this._worldDepthBoxed = this._worldDepth;
        this._minPxcorBoxed = this._minPxcor;
        this._minPycorBoxed = this._minPycor;
        this._minPzcorBoxed = this._minPzcor;
        this._maxPxcorBoxed = this._maxPxcor;
        this._maxPycorBoxed = this._maxPycor;
        this._maxPzcorBoxed = this._maxPzcor;
        if (this.program().breeds() != null) {
            Iterator<Object> iter2 = this.program().breeds().values().iterator();
            while (iter2.hasNext()) {
                ((AgentSet)iter2.next()).clear();
            }
        }
        if (this._turtles != null) {
            this._turtles.clear();
        }
        this._turtles = new TreeAgentSet(Turtle.class, "TURTLES", this);
        if (this._links != null) {
            this._links.clear();
        }
        this._links = new TreeAgentSet(Link.class, "LINKS", this);
        int x = this._minPxcor;
        int y = this._maxPycor;
        int z = this._maxPzcor;
        Agent[] patchArray = new Agent[this._worldWidth * this._worldHeight * this._worldDepth];
        this.patchColors = new int[this._worldWidth * this._worldHeight * this._worldDepth];
        Arrays.fill(this.patchColors, Color.getARGBbyPremodulatedColorNumber(0.0));
        this.patchColorsDirty = true;
        int numVariables = this.program().patchesOwn().size();
        this._observer.resetPerspective();
        for (int i = 0; this._worldWidth * this._worldHeight * this._worldDepth != i; ++i) {
            Patch3D patch2 = new Patch3D(this, i, x, y, z, numVariables);
            if (++x == this._maxPxcor + 1) {
                x = this._minPxcor;
                if (--y == this._minPycor - 1) {
                    y = this._maxPycor;
                    --z;
                }
            }
            patchArray[i] = patch2;
        }
        this._patches = new ArrayAgentSet(Patch.class, patchArray, "patches", (World)this);
        this.patchesWithLabels = 0;
        this.patchesAllBlack = true;
        this.mayHavePartiallyTransparentObjects = false;
    }

    @Override
    public void exportWorld(PrintWriter writer, boolean full) {
        new Exporter3D(this, writer).exportWorld(full);
    }

    @Override
    public void importWorld(Importer.ErrorHandler errorHandler, ImporterUser importerUser, Importer.StringReader stringReader, BufferedReader reader) throws IOException {
        new Importer3D(errorHandler, this, importerUser, stringReader).importWorld(reader);
    }

    @Override
    public Turtle getOrCreateTurtle(long id) {
        Turtle turtle2 = this.getTurtle(id);
        if (turtle2 == null) {
            turtle2 = new Turtle3D(this, id);
        }
        return turtle2;
    }

    public double[][][] getPatchScratch3d() {
        if (this.patchScratch3d == null) {
            this.patchScratch3d = new double[this._worldWidth][this._worldHeight][this._worldDepth];
        }
        return this.patchScratch3d;
    }

    @Override
    public WorldDimensions getDimensions() {
        return new WorldDimensions3D(this._minPxcor, this._maxPxcor, this._minPycor, this._maxPycor, this._minPzcor, this._maxPzcor);
    }

    @Override
    public boolean isDimensionVariable(String variableName) {
        return variableName.equalsIgnoreCase("MIN-PXCOR") || variableName.equalsIgnoreCase("MAX-PXCOR") || variableName.equalsIgnoreCase("MIN-PYCOR") || variableName.equalsIgnoreCase("MAX-PYCOR") || variableName.equalsIgnoreCase("MIN-PZCOR") || variableName.equalsIgnoreCase("MAX-PZCOR") || variableName.equalsIgnoreCase("WORLD-WIDTH") || variableName.equalsIgnoreCase("WORLD-HEIGHT") || variableName.equalsIgnoreCase("WORLD-DEPTH");
    }

    @Override
    public WorldDimensions setDimensionVariable(String variableName, int value, WorldDimensions d) throws WorldDimensionException {
        if (variableName.equalsIgnoreCase("MIN-PXCOR")) {
            d.minPxcor_$eq(value);
        } else if (variableName.equalsIgnoreCase("MAX-PXCOR")) {
            d.maxPxcor_$eq(value);
        } else if (variableName.equalsIgnoreCase("MIN-PYCOR")) {
            d.minPycor_$eq(value);
        } else if (variableName.equalsIgnoreCase("MAX-PYCOR")) {
            d.maxPycor_$eq(value);
        } else if (variableName.equalsIgnoreCase("MIN-PZCOR")) {
            ((WorldDimensions3D)d).minPzcor_$eq(value);
        } else if (variableName.equalsIgnoreCase("MAX-PZCOR")) {
            ((WorldDimensions3D)d).maxPzcor_$eq(value);
        } else if (variableName.equalsIgnoreCase("WORLD-WIDTH")) {
            d.minPxcor_$eq(this.growMin(this._minPxcor, this._maxPxcor, value, d.minPxcor()));
            d.maxPxcor_$eq(this.growMax(this._minPxcor, this._maxPxcor, value, d.maxPxcor()));
        } else if (variableName.equalsIgnoreCase("WORLD-HEIGHT")) {
            d.minPycor_$eq(this.growMin(this._minPycor, this._maxPycor, value, d.minPycor()));
            d.maxPycor_$eq(this.growMax(this._minPycor, this._maxPycor, value, d.maxPycor()));
        } else if (variableName.equalsIgnoreCase("WORLD-DEPTH")) {
            WorldDimensions3D wd = (WorldDimensions3D)d;
            wd.minPzcor_$eq(this.growMin(this._minPzcor, this._maxPzcor, value, wd.minPzcor()));
            wd.maxPzcor_$eq(this.growMax(this._minPzcor, this._maxPzcor, value, wd.maxPzcor()));
        }
        return d;
    }

    @Override
    public boolean equalDimensions(WorldDimensions d) {
        return d.minPxcor() == this._minPxcor && d.maxPxcor() == this._maxPxcor && d.minPycor() == this._minPycor && d.maxPycor() == this._maxPycor && ((WorldDimensions3D)d).minPzcor() == this._minPzcor && ((WorldDimensions3D)d).maxPzcor() == this._maxPzcor;
    }

    @Override
    public Patch getPatchAt(double x, double y) throws AgentException {
        return this.getPatchAt(x, y, 0.0);
    }

    @Override
    public Patch3D getPatchAt(double x, double y, double z) throws AgentException {
        int xc = this.roundX(x);
        int yc = this.roundY(y);
        int zc = this.roundZ(z);
        int id = this._worldWidth * this._worldHeight * (this._maxPzcor - zc) + this._worldWidth * (this._maxPycor - yc) + xc - this._minPxcor;
        return (Patch3D)this._patches.toArray()[id];
    }

    @Override
    public Turtle createTurtle(AgentSet breed) {
        return new Turtle3D(this, breed, ZERO, ZERO, ZERO);
    }

    @Override
    public Turtle createTurtle(AgentSet breed, int c, int h) {
        Turtle3D baby = new Turtle3D(this, breed, ZERO, ZERO, ZERO);
        baby.colorDoubleUnchecked(Double.valueOf(5 + 10 * c));
        baby.heading(h);
        return baby;
    }

    @Override
    public Object getDrawing() {
        return this.drawing;
    }

    @Override
    public boolean sendPixels() {
        return false;
    }

    @Override
    void drawLine(double x0, double y0, double x1, double y1, Object color, double size2, String mode) {
        this.drawing.drawLine(x0, y0, 0.0, x1, y1, 0.0, size2, color);
    }

    void drawLine(double x0, double y0, double z0, double x1, double y1, double z1, Object color, double size2) {
        this.drawing.drawLine(x0, y0, z0, x1, y1, z1, size2, color);
    }

    @Override
    public void clearAll() {
        super.clearAll();
        this.drawing.clear();
    }

    @Override
    public void clearDrawing() {
        this.drawing.clear();
    }

    @Override
    public void stamp(Agent agent, boolean erase) {
        if (!erase) {
            this.drawing.stamp(agent);
        }
    }
}

