/*
 * Decompiled with CFR 0.152.
 */
package org.nlogo.api;

import java.awt.Color;
import java.text.DecimalFormat;
import org.nlogo.api.Approximate$;
import org.nlogo.api.Color$;
import org.nlogo.api.LogoList;
import org.nlogo.api.LogoListBuilder;
import org.nlogo.util.Utils$;
import scala.Array$;
import scala.Function1;
import scala.MatchError;
import scala.Predef$;
import scala.ScalaObject;
import scala.Serializable;
import scala.Tuple2;
import scala.UninitializedFieldError;
import scala.collection.TraversableOnce;
import scala.collection.immutable.IndexedSeq$;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.HashMap;
import scala.collection.mutable.HashMap$;
import scala.collection.mutable.StringBuilder;
import scala.reflect.ClassManifest$;
import scala.reflect.Manifest$;
import scala.runtime.BoxesRunTime;
import scala.runtime.DoubleRef;
import scala.runtime.LongRef;
import scala.sys.package$;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class Color$
implements ScalaObject {
    public static final Color$ MODULE$;
    private final int NumHues;
    private final int MaxColor;
    private final String[] ColorNames;
    private final int Black;
    private final double White;
    private final Double BoxedBlack;
    private final Double BoxedWhite;
    private final double[] ColorNumbers;
    private final int[] ColorsRGB;
    private final int[] ARGB_Cache;
    private final Color[] AWT_Cache;
    private final HashMap<Object, Object> rgbMap;
    private final String ColorTranslations;
    private final HashMap<Object, Object> colorTranslations;
    private volatile int bitmap$init$0;

    static {
        new Color$();
    }

    public int NumHues() {
        if ((this.bitmap$init$0 & 1) != 0) {
            return this.NumHues;
        }
        throw new UninitializedFieldError("Uninitialized field: Color.scala: 12".toString());
    }

    public int MaxColor() {
        if ((this.bitmap$init$0 & 2) != 0) {
            return this.MaxColor;
        }
        throw new UninitializedFieldError("Uninitialized field: Color.scala: 13".toString());
    }

    public String[] ColorNames() {
        if ((this.bitmap$init$0 & 4) != 0) {
            return this.ColorNames;
        }
        throw new UninitializedFieldError("Uninitialized field: Color.scala: 16".toString());
    }

    public int Black() {
        if ((this.bitmap$init$0 & 8) != 0) {
            return this.Black;
        }
        throw new UninitializedFieldError("Uninitialized field: Color.scala: 24".toString());
    }

    public double White() {
        if ((this.bitmap$init$0 & 0x10) != 0) {
            return this.White;
        }
        throw new UninitializedFieldError("Uninitialized field: Color.scala: 25".toString());
    }

    public Double BoxedBlack() {
        if ((this.bitmap$init$0 & 0x20) != 0) {
            return this.BoxedBlack;
        }
        throw new UninitializedFieldError("Uninitialized field: Color.scala: 26".toString());
    }

    public Double BoxedWhite() {
        if ((this.bitmap$init$0 & 0x40) != 0) {
            return this.BoxedWhite;
        }
        throw new UninitializedFieldError("Uninitialized field: Color.scala: 27".toString());
    }

    private double[] ColorNumbers() {
        if ((this.bitmap$init$0 & 0x80) != 0) {
            return this.ColorNumbers;
        }
        throw new UninitializedFieldError("Uninitialized field: Color.scala: 29".toString());
    }

    private int[] ColorsRGB() {
        if ((this.bitmap$init$0 & 0x100) != 0) {
            return this.ColorsRGB;
        }
        throw new UninitializedFieldError("Uninitialized field: Color.scala: 40".toString());
    }

    private int[] ARGB_Cache() {
        if ((this.bitmap$init$0 & 0x200) != 0) {
            return this.ARGB_Cache;
        }
        throw new UninitializedFieldError("Uninitialized field: Color.scala: 59".toString());
    }

    private Color[] AWT_Cache() {
        if ((this.bitmap$init$0 & 0x400) != 0) {
            return this.AWT_Cache;
        }
        throw new UninitializedFieldError("Uninitialized field: Color.scala: 67".toString());
    }

    public Color getColor(Object color) {
        Object object;
        block4: {
            block6: {
                Color color2;
                block3: {
                    LogoList logoList;
                    block5: {
                        block2: {
                            object = color;
                            if (!(object instanceof Double)) break block2;
                            color2 = this.AWT_Cache()[(int)((Double)object * (double)10)];
                            break block3;
                        }
                        if (!(object instanceof LogoList)) break block4;
                        logoList = (LogoList)object;
                        LogoList list = logoList;
                        if (!this.gd1$1(list)) break block5;
                        color2 = new Color(((Number)list.get(0)).intValue(), ((Number)list.get(1)).intValue(), ((Number)list.get(2)).intValue());
                        break block3;
                    }
                    LogoList list = logoList;
                    if (!this.gd2$1(list)) break block6;
                    color2 = new Color(((Number)list.get(0)).intValue(), ((Number)list.get(1)).intValue(), ((Number)list.get(2)).intValue(), ((Number)list.get(3)).intValue());
                }
                return color2;
            }
            throw new MatchError(object);
        }
        throw new MatchError(object);
    }

    private HashMap<Object, Object> rgbMap() {
        if ((this.bitmap$init$0 & 0x800) != 0) {
            return this.rgbMap;
        }
        throw new UninitializedFieldError("Uninitialized field: Color.scala: 90".toString());
    }

    public double getColorNumberByIndex(int index) {
        return this.ColorNumbers()[index];
    }

    public String[] getColorNamesArray() {
        return this.ColorNames();
    }

    public String getColorNameByIndex(int index) {
        return this.ColorNames()[index];
    }

    /*
     * WARNING - void declaration
     */
    public int modulateInteger(int color) {
        void var2_2;
        int c = color;
        if ((c < 0 || c >= this.MaxColor()) && (c %= this.MaxColor()) < 0) {
            c += this.MaxColor();
        }
        return (int)var2_2;
    }

    public double modulateDouble(Double color) {
        return this.modulateDouble((double)color);
    }

    /*
     * WARNING - void declaration
     */
    public double modulateDouble(double color) {
        void var3_2;
        double c = color;
        if (c < 0.0 || c >= (double)this.MaxColor()) {
            if ((c %= (double)this.MaxColor()) < 0.0) {
                c += (double)this.MaxColor();
            }
            if (c >= (double)this.MaxColor()) {
                c = 139.9999999999999;
            }
        }
        return (double)var3_2;
    }

    public double findCentralColorNumber(double color) {
        double c = color < 0.0 || color >= (double)this.MaxColor() ? this.modulateDouble(color) : color;
        return ((double)((int)(c / (double)10)) + 0.5) * (double)10;
    }

    public double getClosestColorNumberByARGB(int argb$1) {
        return BoxesRunTime.unboxToDouble(this.rgbMap().get(BoxesRunTime.boxToDouble(argb$1)).getOrElse(new Serializable(argb$1){
            public static final long serialVersionUID;
            private final int argb$1;

            static {
                long l = serialVersionUID = 0L;
            }

            public final double apply() {
                return this.apply$mcD$sp();
            }

            public double apply$mcD$sp() {
                return Color$.MODULE$.org$nlogo$api$Color$$estimateClosestColorNumberByRGB(this.argb$1);
            }
            {
                this.argb$1 = n;
            }
        }));
    }

    public String getClosestColorNameByARGB(int argb) {
        String string;
        DecimalFormat formatter = new DecimalFormat("###.####");
        double d = this.getClosestColorNumberByARGB(argb);
        if (BoxesRunTime.equals(BoxesRunTime.boxToInteger(this.Black()), BoxesRunTime.boxToDouble(d))) {
            string = this.getColorNameByIndex(14);
        } else if (BoxesRunTime.equals(BoxesRunTime.boxToDouble(this.White()), BoxesRunTime.boxToDouble(d))) {
            string = this.getColorNameByIndex(15);
        } else {
            double closest = d;
            int baseColorNumber = (int)this.findCentralColorNumber(closest);
            double difference = closest - (double)baseColorNumber;
            String baseColorName = this.getColorNameByIndex((baseColorNumber - 5) / 10);
            string = difference == 0.0 ? baseColorName : (difference > 0.0 ? new StringBuilder().append((Object)baseColorName).append((Object)" + ").append((Object)formatter.format(StrictMath.abs(difference))).toString() : new StringBuilder().append((Object)baseColorName).append((Object)" - ").append((Object)formatter.format(StrictMath.abs(difference))).toString());
        }
        return string;
    }

    public double getClosestColorNumberByHSB(float h, float s, float b) {
        float hh = BoxesRunTime.unboxToFloat(Predef$.MODULE$.floatWrapper(BoxesRunTime.unboxToFloat(Predef$.MODULE$.floatWrapper(0.0f).max(BoxesRunTime.boxToFloat(h)))).min(BoxesRunTime.boxToFloat(255.0f)));
        float ss = BoxesRunTime.unboxToFloat(Predef$.MODULE$.floatWrapper(BoxesRunTime.unboxToFloat(Predef$.MODULE$.floatWrapper(0.0f).max(BoxesRunTime.boxToFloat(h)))).min(BoxesRunTime.boxToFloat(255.0f)));
        float bb = BoxesRunTime.unboxToFloat(Predef$.MODULE$.floatWrapper(BoxesRunTime.unboxToFloat(Predef$.MODULE$.floatWrapper(0.0f).max(BoxesRunTime.boxToFloat(h)))).min(BoxesRunTime.boxToFloat(255.0f)));
        int argb$3 = Color.HSBtoRGB(h / (float)255, s / (float)255, b / (float)255);
        return BoxesRunTime.unboxToDouble(this.rgbMap().get(BoxesRunTime.boxToDouble(argb$3)).getOrElse(new Serializable(argb$3){
            public static final long serialVersionUID;
            private final int argb$3;

            static {
                long l = serialVersionUID = 0L;
            }

            public final double apply() {
                return this.apply$mcD$sp();
            }

            public double apply$mcD$sp() {
                return Color$.MODULE$.org$nlogo$api$Color$$estimateClosestColorNumberByRGB(this.argb$3);
            }
            {
                this.argb$3 = n;
            }
        }));
    }

    public final double org$nlogo$api$Color$$estimateClosestColorNumberByRGB(int argb$2) {
        LongRef smallestDistance$1 = new LongRef(100000000L);
        DoubleRef closest$1 = new DoubleRef(0.0);
        ((HashMap)this.rgbMap().filter((Function1<Object, Object>)((Object)new Serializable(){
            public static final long serialVersionUID;

            static {
                long l = serialVersionUID = 0L;
            }

            public final boolean apply(Tuple2<Object, Object> tuple2) {
                Tuple2<Object, Object> tuple22 = tuple2;
                return tuple22 != null;
            }
        }))).foreach(new Serializable(argb$2, smallestDistance$1, closest$1){
            public static final long serialVersionUID;
            private final int argb$2;
            private final LongRef smallestDistance$1;
            private final DoubleRef closest$1;

            static {
                long l = serialVersionUID = 0L;
            }

            public final void apply(Tuple2<Object, Object> tuple2) {
                Tuple2<Object, Object> tuple22 = tuple2;
                if (tuple22 != null) {
                    double d = BoxesRunTime.unboxToDouble(tuple22._1());
                    double k = d;
                    int candidate = (int)k;
                    long dist = Color$.MODULE$.org$nlogo$api$Color$$colorDistance(this.argb$2, candidate);
                    if (dist < this.smallestDistance$1.elem) {
                        this.smallestDistance$1.elem = dist;
                        this.closest$1.elem = BoxesRunTime.unboxToDouble(tuple22._2());
                    }
                    return;
                }
                throw new MatchError(tuple22);
            }
            {
                this.argb$2 = n;
                this.smallestDistance$1 = longRef;
                this.closest$1 = doubleRef;
            }
        });
        return closest$1.elem;
    }

    public final long org$nlogo$api$Color$$colorDistance(int argb1, int argb2) {
        int r1 = argb1 >> 16 & 0xFF;
        int g1 = argb1 >> 8 & 0xFF;
        int b1 = argb1 & 0xFF;
        int r2 = argb2 >> 16 & 0xFF;
        int g2 = argb2 >> 8 & 0xFF;
        int b2 = argb2 & 0xFF;
        int rmean = r1 + r2 / 2;
        int rd = r1 - r2;
        int gd = g1 - g2;
        int bd = b1 - b2;
        return ((512 + rmean) * rd * rd >> 8) + 4 * gd * gd + ((767 - rmean) * bd * bd >> 8);
    }

    public int getARGBbyPremodulatedColorNumber(double modulatedColor) {
        return this.ARGB_Cache()[(int)(modulatedColor * (double)10)];
    }

    public final int org$nlogo$api$Color$$computeARGBforCache(int colorTimesTen) {
        int baseIndex = colorTimesTen / 100;
        int r = this.ColorsRGB()[baseIndex * 3];
        int g = this.ColorsRGB()[baseIndex * 3 + 1];
        int b = this.ColorsRGB()[baseIndex * 3 + 2];
        double step = (double)(colorTimesTen % 100 - 50) / 50.48 + 0.012;
        if (step < 0.0) {
            r += (int)((double)r * step);
            g += (int)((double)g * step);
            b += (int)((double)b * step);
        } else if (step > 0.0) {
            r += (int)((double)(255 - r) * step);
            g += (int)((double)(255 - g) * step);
            b += (int)((double)(255 - b) * step);
        }
        return -16777216 + (r << 16) + (g << 8) + b;
    }

    public int getRGBByName(String name) {
        return this.getARGBByIndex(Predef$.MODULE$.refArrayOps((Object[])this.ColorNames()).indexOf(name));
    }

    public int getARGBByIndex(int index) {
        int n;
        int n2 = index;
        switch (n2) {
            default: {
                n = this.ARGB_Cache()[index * 100 + 50];
                break;
            }
            case 14: {
                n = -16777216;
                break;
            }
            case 15: {
                n = -1;
            }
        }
        return n;
    }

    public LogoList getRGBListByARGB(int argb) {
        LogoListBuilder result = new LogoListBuilder();
        result.add(Predef$.MODULE$.double2Double(Approximate$.MODULE$.approximate(argb >> 16 & 0xFF, 3)));
        result.add(Predef$.MODULE$.double2Double(Approximate$.MODULE$.approximate(argb >> 8 & 0xFF, 3)));
        result.add(Predef$.MODULE$.double2Double(Approximate$.MODULE$.approximate(argb & 0xFF, 3)));
        return result.toLogoList();
    }

    public LogoList getRGBAListByARGB(int argb) {
        LogoListBuilder result = new LogoListBuilder();
        result.add(BoxesRunTime.boxToDouble(Approximate$.MODULE$.approximate(argb >> 16 & 0xFF, 3)));
        result.add(BoxesRunTime.boxToDouble(Approximate$.MODULE$.approximate(argb >> 8 & 0xFF, 3)));
        result.add(BoxesRunTime.boxToDouble(Approximate$.MODULE$.approximate(argb & 0xFF, 3)));
        result.add(BoxesRunTime.boxToDouble(Approximate$.MODULE$.approximate(argb >> 24 & 0xFF, 3)));
        return result.toLogoList();
    }

    public int getARGBIntByRGBAList(LogoList rgba) {
        return rgba.size() == 4 ? ((Double)rgba.get(3)).intValue() << 24 | ((Double)rgba.get(0)).intValue() << 16 | ((Double)rgba.get(1)).intValue() << 8 | ((Double)rgba.get(2)).intValue() : 0xFF000000 | ((Double)rgba.get(0)).intValue() << 16 | ((Double)rgba.get(1)).intValue() << 8 | ((Double)rgba.get(2)).intValue();
    }

    public LogoList getHSBListByARGB(int argb) {
        float[] hsb = new float[3];
        Color.RGBtoHSB(argb >> 16 & 0xFF, argb >> 8 & 0xFF, argb & 0xFF, hsb);
        LogoListBuilder result = new LogoListBuilder();
        result.add(BoxesRunTime.boxToDouble(Approximate$.MODULE$.approximate(hsb[0] * (float)255, 3)));
        result.add(BoxesRunTime.boxToDouble(Approximate$.MODULE$.approximate(hsb[1] * (float)255, 3)));
        result.add(BoxesRunTime.boxToDouble(Approximate$.MODULE$.approximate(hsb[2] * (float)255, 3)));
        return result.toLogoList();
    }

    private String ColorTranslations() {
        if ((this.bitmap$init$0 & 0x1000) != 0) {
            return this.ColorTranslations;
        }
        throw new UninitializedFieldError("Uninitialized field: Color.scala: 360".toString());
    }

    private HashMap<Object, Object> colorTranslations() {
        if ((this.bitmap$init$0 & 0x2000) != 0) {
            return this.colorTranslations;
        }
        throw new UninitializedFieldError("Uninitialized field: Color.scala: 361".toString());
    }

    public int translateSavedColor(int color$1) {
        return BoxesRunTime.unboxToInt(this.colorTranslations().get(BoxesRunTime.boxToDouble(color$1)).map(new Serializable(){
            public static final long serialVersionUID;

            static {
                long l = serialVersionUID = 0L;
            }

            public final int apply(int n) {
                return this.apply$mcII$sp(n);
            }

            public int apply$mcII$sp(int v1) {
                return Predef$.MODULE$.int2Integer(v1);
            }
        }).map(new Serializable(){
            public static final long serialVersionUID;

            static {
                long l = serialVersionUID = 0L;
            }

            public final int apply(int n) {
                return this.apply$mcII$sp(n);
            }

            public int apply$mcII$sp(int v1) {
                return Color$.MODULE$.getARGBByIndex(v1);
            }
        }).getOrElse(new Serializable(color$1){
            public static final long serialVersionUID;
            private final int color$1;

            static {
                long l = serialVersionUID = 0L;
            }

            public final int apply() {
                return this.apply$mcI$sp();
            }

            public int apply$mcI$sp() {
                return this.color$1;
            }
            {
                this.color$1 = n;
            }
        }));
    }

    public Double argbToColor(int argb) {
        return Predef$.MODULE$.double2Double(this.getClosestColorNumberByARGB(argb));
    }

    public int getRGBInt(int r, int g, int b) {
        return ((r << 8) + g << 8) + b;
    }

    public int getRGBInt(Object c) {
        block4: {
            int n;
            block3: {
                Object object;
                block2: {
                    object = c;
                    if (!(object instanceof LogoList)) break block2;
                    n = this.getARGBIntByRGBAList((LogoList)object);
                    break block3;
                }
                if (!(object instanceof Double)) break block4;
                n = this.getARGBbyPremodulatedColorNumber((Double)object);
            }
            return n;
        }
        throw package$.MODULE$.error("Can't get RGB color");
    }

    public Color getComplement(Color color) {
        float[] rgb = color.getRGBColorComponents(null);
        return new Color((rgb[0] + 0.5f) % 1.0f, (rgb[1] + 0.5f) % 1.0f, (rgb[2] + 0.5f) % 1.0f);
    }

    private final boolean gd1$1(LogoList logoList) {
        return logoList.size() == 3;
    }

    private final boolean gd2$1(LogoList logoList) {
        return logoList.size() == 4;
    }

    /*
     * WARNING - void declaration
     */
    private Color$() {
        void var3_3;
        void var2_2;
        void var1_1;
        MODULE$ = this;
        this.NumHues = 14;
        this.bitmap$init$0 |= 1;
        this.MaxColor = 10 * this.NumHues();
        this.bitmap$init$0 |= 2;
        this.ColorNames = (String[])((Object[])new String[]{"gray", "red", "orange", "brown", "yellow", "green", "lime", "turquoise", "cyan", "sky", "blue", "violet", "magenta", "pink", "black", "white"});
        this.bitmap$init$0 |= 4;
        this.Black = 0;
        this.bitmap$init$0 |= 8;
        this.White = 9.9;
        this.bitmap$init$0 |= 0x10;
        this.BoxedBlack = Predef$.MODULE$.double2Double(0.0);
        this.bitmap$init$0 |= 0x20;
        this.BoxedWhite = Predef$.MODULE$.double2Double(this.White());
        this.bitmap$init$0 |= 0x40;
        this.ColorNumbers = (double[])Array$.MODULE$.apply(Predef$.MODULE$.wrapDoubleArray(new double[]{5.0, 15.0, 25.0, 35.0, 45.0, 55.0, 65.0, 75.0, 85.0, 95.0, 105.0, 115.0, 125.0, 135.0, this.Black(), this.White()}), Manifest$.MODULE$.Double());
        this.bitmap$init$0 |= 0x80;
        this.ColorsRGB = (int[])Array$.MODULE$.apply(Predef$.MODULE$.wrapIntArray(new int[]{140, 140, 140, 215, 48, 39, 241, 105, 19, 156, 109, 70, 237, 237, 47, 87, 176, 58, 42, 209, 57, 27, 158, 119, 82, 196, 196, 43, 140, 190, 50, 92, 168, 123, 78, 163, 166, 25, 105, 224, 126, 149, 0, 0, 0, 255, 255, 255}), Manifest$.MODULE$.Int());
        this.bitmap$init$0 |= 0x100;
        int[] cache = (int[])((TraversableOnce)Predef$.MODULE$.intWrapper(0).until(this.MaxColor() * 10).map(new anonfun.1(), IndexedSeq$.MODULE$.canBuildFrom())).toArray(Manifest$.MODULE$.Int());
        cache[0] = -16777216;
        cache[99] = -1;
        this.ARGB_Cache = var1_1;
        this.bitmap$init$0 |= 0x200;
        this.AWT_Cache = (Color[])Predef$.MODULE$.intArrayOps((int[])Predef$.MODULE$.intWrapper(0).until(this.MaxColor() * 10).toArray(Manifest$.MODULE$.Int())).map(new anonfun.3(), Array$.MODULE$.canBuildFrom(ClassManifest$.MODULE$.classType(Color.class)));
        this.bitmap$init$0 |= 0x400;
        HashMap map$1 = (HashMap)HashMap$.MODULE$.apply(Nil$.MODULE$);
        Predef$.MODULE$.intWrapper(0).until(this.MaxColor() * 10).foreach$mVc$sp(new anonfun.2(map$1));
        this.rgbMap = var2_2;
        this.bitmap$init$0 |= 0x800;
        this.ColorTranslations = "/system/color-translation.txt";
        this.bitmap$init$0 |= 0x1000;
        HashMap map$2 = (HashMap)HashMap$.MODULE$.apply(Nil$.MODULE$);
        String[] lines2 = Utils$.MODULE$.getResourceAsStringArray(this.ColorTranslations());
        Predef$.MODULE$.refArrayOps((Object[])Predef$.MODULE$.refArrayOps((Object[])Predef$.MODULE$.refArrayOps((Object[])Predef$.MODULE$.refArrayOps((Object[])lines2).map(new anonfun.4(), Array$.MODULE$.canBuildFrom(ClassManifest$.MODULE$.classType(String.class)))).filter(new anonfun.5())).filter(new anonfun.6())).foreach(new anonfun.7(map$2));
        this.colorTranslations = var3_3;
        this.bitmap$init$0 |= 0x2000;
    }
}

