/*
 * Decompiled with CFR 0.152.
 */
package org.nlogo.app;

import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionAdapter;
import java.awt.event.MouseMotionListener;
import javax.swing.JComponent;
import javax.swing.JLayeredPane;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import org.nlogo.api.Editable;
import org.nlogo.app.Events;
import org.nlogo.app.WidgetPanel;
import org.nlogo.app.WindowBar;
import org.nlogo.awt.Coordinates;
import org.nlogo.awt.Mouse;
import org.nlogo.awt.UserCancelException;
import org.nlogo.swing.FileDialog;
import org.nlogo.swing.WrappingPopupMenu;
import org.nlogo.util.Exceptions;
import org.nlogo.window.Events;
import org.nlogo.window.MouseMode;
import org.nlogo.window.Widget;
import org.nlogo.window.WidgetWrapperInterface;

public strictfp class WidgetWrapper
extends JLayeredPane
implements WidgetWrapperInterface,
MouseListener,
MouseMotionListener,
Events.WidgetForegroundedEvent.Handler {
    private static final double PREFERRED_WIDTH_FUDGE_FACTOR = 0.15;
    private boolean verticallyResizable;
    private boolean horizontallyResizable;
    private boolean isNew = false;
    private final MouseListener popupListener = new MouseAdapter(){

        public void mousePressed(MouseEvent e) {
            if (e.isPopupTrigger()) {
                WidgetWrapper.this.doPopup(e);
            }
        }

        public void mouseReleased(MouseEvent e) {
            if (e.isPopupTrigger()) {
                WidgetWrapper.this.doPopup(e);
            }
        }
    };
    private boolean selected = false;
    private boolean isForeground = false;
    private static final Color NON_FOREGROUND_BACKGROUND = new Color(205, 205, 205);
    private final Widget widget;
    private final WidgetPanel interfacePanel;
    private final JComponent glass;
    private final WindowBar topBar;
    private final WindowBar leftBar;
    private final WindowBar rightBar;
    private final WindowBar bottomBar;
    static final int BORDER_N = 10;
    static final int BORDER_S = 9;
    static final int BORDER_E = 9;
    static final int BORDER_W = 9;
    static final int HANDLE_WIDTH = 9;
    private static final int MIN_WIDGET_WIDTH = 12;
    private static final int MIN_WIDGET_HEIGHT = 12;
    private MouseMode mouseMode = MouseMode.IDLE;
    public int startPressX;
    public int startPressY;
    public Rectangle originalBounds;
    private boolean constrainToHorizontal = false;
    private boolean constrainToVertical = false;

    public boolean verticallyResizable() {
        return this.verticallyResizable;
    }

    public boolean horizontallyResizable() {
        return this.horizontallyResizable;
    }

    public boolean isNew() {
        return this.isNew;
    }

    void isNew(boolean isNew) {
        this.isNew = isNew;
    }

    WidgetWrapper(Widget widget, WidgetPanel interfacePanel) {
        this.widget = widget;
        this.interfacePanel = interfacePanel;
        this.setOpaque(true);
        this.verticallyResizable = this.computeVerticallyResizable();
        this.horizontallyResizable = this.computeHorizontallyResizable();
        this.topBar = new WindowBar(WindowBar.Type.TOP, 9, 9, this.verticallyResizable);
        this.leftBar = new WindowBar(WindowBar.Type.SIDE, 0, 0, this.horizontallyResizable);
        this.rightBar = new WindowBar(WindowBar.Type.SIDE, 0, 0, this.horizontallyResizable);
        this.bottomBar = new WindowBar(WindowBar.Type.BOTTOM, 9, 9, this.verticallyResizable);
        this.widgetChanged();
        this.addMouseListener(new MouseAdapter(){});
        this.addMouseMotionListener(new MouseMotionAdapter(){});
        this.glass = new JComponent(){};
        this.glass.setOpaque(false);
        this.glass.addMouseListener(this);
        this.glass.addMouseMotionListener(this);
        widget.addPopupListeners(this.popupListener);
        this.setCursor(Cursor.getDefaultCursor());
        this.setLayout(null);
        this.setBackground(widget.getBackground());
        this.setOpaque(widget.widgetWrapperOpaque());
        this.add((Component)this.glass, JLayeredPane.DRAG_LAYER);
        this.add(widget);
        this.add(this.topBar);
        this.add(this.leftBar);
        this.add(this.rightBar);
        this.add(this.bottomBar);
        this.doLayout();
    }

    public boolean computeVerticallyResizable() {
        return this.widget.getMaximumSize() == null || this.widget.getMaximumSize().height != this.widget.getMinimumSize().height;
    }

    public boolean computeHorizontallyResizable() {
        return this.widget.getMaximumSize() == null || this.widget.getMaximumSize().width != this.widget.getMinimumSize().width;
    }

    public void widgetChanged() {
        this.verticallyResizable = this.computeVerticallyResizable();
        this.horizontallyResizable = this.computeHorizontallyResizable();
        if (this.verticallyResizable()) {
            this.topBar.handles(true);
            this.bottomBar.handles(true);
        } else {
            this.topBar.handles(false);
            this.bottomBar.handles(false);
        }
        if (this.horizontallyResizable()) {
            this.topBar.cornerHandles(true);
            this.bottomBar.cornerHandles(true);
            this.leftBar.handles(true);
            this.rightBar.handles(true);
        } else {
            this.topBar.cornerHandles(false);
            this.bottomBar.cornerHandles(false);
            this.leftBar.handles(false);
            this.rightBar.handles(false);
        }
    }

    public boolean isValidateRoot() {
        return true;
    }

    public boolean selected() {
        return this.selected;
    }

    void selected(boolean selected) {
        this.selected(selected, false);
    }

    void selected(boolean selected, boolean temporary) {
        boolean changed2;
        boolean bl = changed2 = this.selected != selected;
        if (changed2) {
            this.selected = selected;
            Rectangle bounds = this.getBounds();
            if (selected) {
                bounds.x -= 9;
                bounds.width += 18;
                bounds.y -= 10;
                bounds.height += 19;
            } else {
                this.isForeground(false);
                bounds.x += 9;
                bounds.width -= 18;
                bounds.y += 10;
                bounds.height -= 19;
            }
            this.setBounds(bounds);
            if (!temporary) {
                new Events.WidgetSelectedEvent(this.widget, selected).raise(this);
            }
        }
    }

    private void revalidateInterfacePanel() {
        if (this.interfacePanel() != null) {
            this.interfacePanel().revalidate();
        }
    }

    public void setBounds(Rectangle r) {
        this.setBounds(r.x, r.y, r.width, r.height);
    }

    public void setBounds(int x, int y, int width, int height) {
        boolean sizeChanged = this.getWidth() != width || this.getHeight() != height;
        super.setBounds(x, y, width, height);
        if (sizeChanged) {
            this.doLayout();
            this.revalidateInterfacePanel();
        }
    }

    boolean isForeground() {
        return this.isForeground;
    }

    void isForeground(boolean isForeground) {
        this.isForeground = isForeground;
        if (isForeground) {
            this.topBar.setBackground(Color.GRAY);
            this.leftBar.setBackground(Color.GRAY);
            this.rightBar.setBackground(Color.GRAY);
            this.bottomBar.setBackground(Color.GRAY);
            this.topBar.setForeground(Color.BLACK);
            this.leftBar.setForeground(Color.BLACK);
            this.rightBar.setForeground(Color.BLACK);
            this.bottomBar.setForeground(Color.BLACK);
        } else {
            this.topBar.setBackground(NON_FOREGROUND_BACKGROUND);
            this.leftBar.setBackground(NON_FOREGROUND_BACKGROUND);
            this.rightBar.setBackground(NON_FOREGROUND_BACKGROUND);
            this.bottomBar.setBackground(NON_FOREGROUND_BACKGROUND);
            this.topBar.setForeground(Color.GRAY);
            this.leftBar.setForeground(Color.GRAY);
            this.rightBar.setForeground(Color.GRAY);
            this.bottomBar.setForeground(Color.GRAY);
        }
        this.topBar.repaint();
        this.leftBar.repaint();
        this.rightBar.repaint();
        this.bottomBar.repaint();
    }

    void foreground() {
        if (!this.isForeground()) {
            this.isForeground(true);
            new Events.WidgetForegroundedEvent(this.widget).raise(this);
        }
    }

    private Dimension addWrapperBorder(Dimension dim) {
        if (dim == null) {
            return null;
        }
        if (this.widget.needsPreferredWidthFudgeFactor()) {
            dim.width = (int)((double)dim.width * 1.15);
        }
        if (this.getParent() instanceof WidgetPanel && !this.widget.isNote()) {
            WidgetPanel iP = (WidgetPanel)this.getParent();
            dim = iP.zoomer().zoomSize(dim);
        }
        if (this.selected()) {
            dim.width += 18;
            dim.height += 19;
        }
        return dim;
    }

    public Dimension getPreferredSize() {
        Dimension dim = new Dimension(this.widget.getUnzoomedPreferredSize());
        if (this.widget.isNote()) {
            dim = new Dimension(this.widget.getPreferredSize());
        }
        return this.addWrapperBorder(dim);
    }

    public Dimension getMaximumSize() {
        return this.addWrapperBorder(this.widget.getMaximumSize());
    }

    public void doLayout() {
        this.setOpaque(this.widget.widgetWrapperOpaque());
        if (this.selected()) {
            this.topBar.setVisible(true);
            this.leftBar.setVisible(true);
            this.rightBar.setVisible(true);
            this.bottomBar.setVisible(true);
            this.topBar.setBounds(0, 0, this.getWidth(), 10);
            this.widget.setBounds(9, 10, this.getWidth() - 18, this.getHeight() - 19);
            this.leftBar.setBounds(0, 10, 9, this.getHeight() - 10 - 9);
            this.rightBar.setBounds(this.getWidth() - 9, 10, 9, this.getHeight() - 10 - 9);
            this.bottomBar.setBounds(0, this.getHeight() - 9, this.getWidth(), 9);
        } else {
            this.topBar.setVisible(false);
            this.leftBar.setVisible(false);
            this.rightBar.setVisible(false);
            this.bottomBar.setVisible(false);
            this.topBar.setBounds(0, 0, 0, 0);
            this.leftBar.setBounds(0, 0, 0, 0);
            this.rightBar.setBounds(0, 0, 0, 0);
            this.bottomBar.setBounds(0, 0, 0, 0);
            this.widget.setBounds(0, 0, this.getWidth(), this.getHeight());
        }
        this.glass.setBounds(0, 0, this.getWidth(), this.getHeight());
        this.glass.setVisible(this.selected());
    }

    public Widget widget() {
        return this.widget;
    }

    private WidgetPanel interfacePanel() {
        return this.interfacePanel;
    }

    private MouseMode mouseMode() {
        return this.mouseMode;
    }

    private void mouseMode(MouseMode mouseMode) {
        this.mouseMode = mouseMode;
    }

    void doResize(int x, int y) {
        Rectangle bounds = new Rectangle(this.originalBounds);
        switch (this.mouseMode()) {
            case NW: {
                y = StrictMath.max(y, 10 - bounds.y);
                bounds.x += x;
                bounds.width -= x;
                bounds.y += y;
                bounds.height -= y;
                break;
            }
            case NE: {
                y = StrictMath.max(y, 10 - bounds.y);
                bounds.width += x;
                bounds.y += y;
                bounds.height -= y;
                break;
            }
            case SW: {
                bounds.x += x;
                bounds.width -= x;
                bounds.height += y;
                break;
            }
            case W: {
                bounds.x += x;
                bounds.width -= x;
                break;
            }
            case SE: {
                bounds.width += x;
                bounds.height += y;
                break;
            }
            case E: {
                bounds.width += x;
                break;
            }
            case S: {
                bounds.height += y;
                break;
            }
            case N: {
                y = StrictMath.max(y, 10 - bounds.y);
                bounds.y += y;
                bounds.height -= y;
                break;
            }
            default: {
                throw new IllegalStateException();
            }
        }
        if (this.interfacePanel.workspace.snapOn() && !this.interfacePanel.isZoomed()) {
            this.enforceGridSnapSize(bounds);
        }
        this.enforceMinimumSize(bounds);
        this.enforceMaximumSize(bounds);
        this.setBounds(this.widget.constrainDrag(bounds, this.originalBounds, this.mouseMode()));
    }

    public int gridSnap() {
        return this.interfacePanel.workspace.snapOn() ? 5 : 1;
    }

    public void mouseMoved(MouseEvent e) {
    }

    public void mouseClicked(MouseEvent e) {
    }

    public void mouseEntered(MouseEvent e) {
    }

    public void mouseExited(MouseEvent e) {
    }

    public void mousePressed(MouseEvent e) {
        if (e.isPopupTrigger()) {
            this.doPopup(e);
            return;
        }
        if (!Mouse.hasButton1(e)) {
            return;
        }
        this.foreground();
        if (e.getClickCount() == 2) {
            new Events.EditWidgetEvent(null).raise(this);
            return;
        }
        Dimension d = this.getSize();
        int x = e.getX();
        int y = e.getY();
        Point p = Coordinates.convertPointToScreen(e.getPoint(), this);
        this.startPressX = p.x;
        this.startPressY = p.y;
        this.mouseMode(MouseMode.DRAG);
        if (x < 9) {
            if (this.verticallyResizable && y < 10) {
                this.mouseMode(MouseMode.NW);
            } else if (this.verticallyResizable && y > d.height - 9) {
                this.mouseMode(MouseMode.SW);
            } else if (y <= 10 + (d.height - 9 - 10 - 9) / 2 + 9 && y >= 10 + (d.height - 9 - 10 - 9) / 2) {
                this.mouseMode(MouseMode.W);
            }
        } else if (x > d.width - 9) {
            if (this.verticallyResizable && y < 10) {
                this.mouseMode(MouseMode.NE);
            } else if (this.verticallyResizable && y > d.height - 9) {
                this.mouseMode(MouseMode.SE);
            } else if (y <= 10 + (d.height - 9 - 10 - 9) / 2 + 9 && y >= 10 + (d.height - 9 - 10 - 9) / 2) {
                this.mouseMode(MouseMode.E);
            }
        } else if (this.verticallyResizable && y > d.height - 9) {
            if (x <= 9 + (d.width - 9 - 9 + 9) / 2 && x >= 9 + (d.width - 9 - 9 - 9) / 2) {
                this.mouseMode(MouseMode.S);
            }
        } else if (this.verticallyResizable && y < 10 && x <= 9 + (d.width - 9 - 9 + 9) / 2 && x >= 9 + (d.width - 9 - 9 - 9) / 2) {
            this.mouseMode(MouseMode.N);
        }
        if (this.mouseMode() == MouseMode.DRAG) {
            this.interfacePanel().aboutToDragSelectedWidgets(this.startPressX, this.startPressY);
        } else {
            this.aboutToDrag();
        }
    }

    void aboutToDrag() {
        this.selected(false, true);
        this.originalBounds = this.getBounds();
    }

    public void mouseDragged(MouseEvent e) {
        Point p = Coordinates.convertPointToScreen(e.getPoint(), this);
        int x = p.x;
        int y = p.y;
        if (this.mouseMode() == MouseMode.DRAG) {
            if ((e.getModifiers() & 1) == 0) {
                this.constrainToHorizontal = false;
                this.constrainToVertical = false;
            } else {
                if (!this.constrainToHorizontal && !this.constrainToVertical && StrictMath.abs(x - this.startPressX) > StrictMath.abs(y - this.startPressY)) {
                    this.constrainToHorizontal = true;
                } else {
                    this.constrainToVertical = true;
                }
                if (this.constrainToHorizontal) {
                    y = this.startPressY;
                } else if (this.constrainToVertical) {
                    x = this.startPressX;
                }
            }
            this.interfacePanel().dragSelectedWidgets(x - this.startPressX, y - this.startPressY);
        } else if (this.mouseMode() == MouseMode.NE || this.mouseMode() == MouseMode.NW || this.mouseMode() == MouseMode.SE || this.mouseMode() == MouseMode.SW || this.mouseMode() == MouseMode.S || this.mouseMode() == MouseMode.W || this.mouseMode() == MouseMode.E || this.mouseMode() == MouseMode.N) {
            this.doResize(x - this.startPressX, y - this.startPressY);
        }
    }

    void doDrag(int x, int y) {
        this.setLocation(x + this.originalBounds.x, y + this.originalBounds.y);
    }

    public void mouseReleased(MouseEvent e) {
        if (e.isPopupTrigger()) {
            this.doPopup(e);
            return;
        }
        if (Mouse.hasButton1(e)) {
            if (this.mouseMode() == MouseMode.DRAG) {
                this.interfacePanel().dropSelectedWidgets();
            } else if (this.mouseMode() == MouseMode.NE || this.mouseMode() == MouseMode.NW || this.mouseMode() == MouseMode.SE || this.mouseMode() == MouseMode.SW || this.mouseMode() == MouseMode.S || this.mouseMode() == MouseMode.W || this.mouseMode() == MouseMode.E || this.mouseMode() == MouseMode.N) {
                this.doDrop();
            }
            this.mouseMode(MouseMode.IDLE);
        }
    }

    void doDrop() {
        this.selected(true, true);
        new Events.DirtyEvent().raise(this);
        ((WidgetPanel)this.getParent()).zoomer().updateZoomInfo(this.widget);
    }

    private void enforceMinimumSize(Rectangle r) {
        if (this.widget() != null) {
            Dimension minWidgetSize = this.widget().getMinimumSize();
            if (this.getParent() instanceof WidgetPanel) {
                WidgetPanel iP = (WidgetPanel)this.getParent();
                minWidgetSize = iP.zoomer().zoomSize(minWidgetSize);
            }
            if (minWidgetSize == null) {
                minWidgetSize = new Dimension(12, 12);
            }
            if (minWidgetSize.width < 12) {
                minWidgetSize.width = 12;
            }
            if (minWidgetSize.height < 12) {
                minWidgetSize.height = 12;
            }
            switch (this.mouseMode()) {
                case S: {
                    if (r.height >= minWidgetSize.height) break;
                    r.height = minWidgetSize.height;
                    break;
                }
                case SW: {
                    if (r.width < minWidgetSize.width) {
                        r.x -= minWidgetSize.width - r.width;
                        r.width = minWidgetSize.width;
                    }
                    if (r.height >= minWidgetSize.height) break;
                    r.height = minWidgetSize.height;
                    break;
                }
                case SE: {
                    if (r.width < minWidgetSize.width) {
                        r.width = minWidgetSize.width;
                    }
                    if (r.height >= minWidgetSize.height) break;
                    r.height = minWidgetSize.height;
                    break;
                }
                case E: {
                    if (r.width >= minWidgetSize.width) break;
                    r.width = minWidgetSize.width;
                    break;
                }
                case NW: {
                    if (r.width < minWidgetSize.width) {
                        r.x -= minWidgetSize.width - r.width;
                        r.width = minWidgetSize.width;
                    }
                    if (r.height >= minWidgetSize.height) break;
                    r.y -= minWidgetSize.height - r.height;
                    r.height = minWidgetSize.height;
                    break;
                }
                case W: {
                    if (r.width >= minWidgetSize.width) break;
                    r.x -= minWidgetSize.width - r.width;
                    r.width = minWidgetSize.width;
                    break;
                }
                case NE: {
                    if (r.width < minWidgetSize.width) {
                        r.width = minWidgetSize.width;
                    }
                    if (r.height >= minWidgetSize.height) break;
                    r.y -= minWidgetSize.height - r.height;
                    r.height = minWidgetSize.height;
                    break;
                }
                case N: {
                    if (r.height >= minWidgetSize.height) break;
                    r.y -= minWidgetSize.height - r.height;
                    r.height = minWidgetSize.height;
                    break;
                }
                default: {
                    throw new IllegalStateException();
                }
            }
        }
    }

    private void enforceMaximumSize(Rectangle r) {
        if (this.widget() != null) {
            Dimension maxWidgetSize = this.widget().getMaximumSize();
            if (maxWidgetSize == null) {
                return;
            }
            if (maxWidgetSize.height <= 0) {
                maxWidgetSize.height = 10000;
            }
            if (maxWidgetSize.width <= 0) {
                maxWidgetSize.width = 10000;
            }
            if (this.getParent() instanceof WidgetPanel) {
                WidgetPanel iP = (WidgetPanel)this.getParent();
                maxWidgetSize = iP.zoomer().zoomSize(maxWidgetSize);
            }
            switch (this.mouseMode()) {
                case S: {
                    if (r.height <= maxWidgetSize.height) break;
                    r.height = maxWidgetSize.height;
                    break;
                }
                case SW: {
                    if (r.width > maxWidgetSize.width) {
                        r.width = maxWidgetSize.width;
                    }
                    if (r.height <= maxWidgetSize.height) break;
                    r.height = maxWidgetSize.height;
                    break;
                }
                case SE: {
                    if (r.width > maxWidgetSize.width) {
                        r.width = maxWidgetSize.width;
                        r.x = this.getBounds().x + this.getBounds().width - r.width;
                    }
                    if (r.height <= maxWidgetSize.height) break;
                    r.height = maxWidgetSize.height;
                    break;
                }
                case E: {
                    if (r.width <= maxWidgetSize.width) break;
                    r.width = maxWidgetSize.width;
                    r.x = this.getBounds().x + this.getBounds().width - r.width;
                    break;
                }
                case NW: {
                    if (r.width > maxWidgetSize.width) {
                        r.width = maxWidgetSize.width;
                    }
                    if (r.height <= maxWidgetSize.height) break;
                    r.height = maxWidgetSize.height;
                    r.y = this.getBounds().y + this.getBounds().height - r.height;
                    break;
                }
                case W: {
                    if (r.width <= maxWidgetSize.width) break;
                    r.width = maxWidgetSize.width;
                    break;
                }
                case NE: {
                    if (r.width > maxWidgetSize.width) {
                        r.width = maxWidgetSize.width;
                        r.x = this.getBounds().x + this.getBounds().width - r.width;
                    }
                    if (r.height <= maxWidgetSize.height) break;
                    r.height = maxWidgetSize.height;
                    r.y = this.getBounds().y + this.getBounds().height - r.height;
                    break;
                }
                case N: {
                    if (r.height <= maxWidgetSize.height) break;
                    r.height = maxWidgetSize.height;
                    r.y = this.getBounds().y + this.getBounds().height - r.height;
                    break;
                }
                default: {
                    throw new IllegalStateException();
                }
            }
        }
    }

    private void enforceGridSnapSize(Rectangle r) {
        if (this.widget() != null) {
            int newWidth = r.width / 5 * 5;
            int newHeight = r.height / 5 * 5;
            switch (this.mouseMode()) {
                case S: {
                    r.height = newHeight;
                    break;
                }
                case SW: {
                    r.x -= newWidth - r.width;
                    r.width = newWidth;
                    r.height = newHeight;
                    break;
                }
                case SE: {
                    r.width = newWidth;
                    r.height = newHeight;
                    break;
                }
                case E: {
                    r.width = newWidth;
                    break;
                }
                case NW: {
                    r.x -= newWidth - r.width;
                    r.y -= newHeight - r.height;
                    r.width = newWidth;
                    r.height = newHeight;
                    break;
                }
                case W: {
                    r.x -= newWidth - r.width;
                    r.width = newWidth;
                    break;
                }
                case NE: {
                    r.y -= newHeight - r.height;
                    r.width = newWidth;
                    r.height = newHeight;
                    break;
                }
                case N: {
                    r.y -= newHeight - r.height;
                    r.height = newHeight;
                    break;
                }
                default: {
                    throw new IllegalStateException();
                }
            }
        }
    }

    void widgetResized() {
        Rectangle rect = this.getBounds();
        rect.width = this.widget().getWidth();
        rect.height = this.widget().getHeight();
        if (this.selected()) {
            rect.width += 18;
            rect.height += 19;
        }
        super.setBounds(rect);
        this.revalidateInterfacePanel();
    }

    public void handle(Events.WidgetForegroundedEvent e) {
        if (!e.widget.equals(this.widget)) {
            this.isForeground(false);
        }
    }

    public Point getUnselectedLocation() {
        Point result = this.getLocation();
        if (this.selected()) {
            result.x += 9;
            result.y += 10;
        }
        return result;
    }

    Rectangle getUnselectedBounds() {
        Rectangle result = this.getBounds();
        if (this.selected()) {
            result.x += 9;
            result.y += 10;
            result.width -= 18;
            result.height -= 19;
        }
        return result;
    }

    private void doPopup(MouseEvent e) {
        if (this.interfacePanel() != null) {
            WrappingPopupMenu menu = new WrappingPopupMenu();
            Point p = e.getPoint();
            p = this.populateContextMenu(menu, p, (Component)e.getSource());
            if (menu.getSubElements().length > 0) {
                ((JPopupMenu)menu).show((Component)e.getSource(), p.x, p.y);
            }
            e.consume();
        }
    }

    private Point populateContextMenu(JPopupMenu menu, Point p, Component source2) {
        Point location = p;
        if (this.widget().getEditable() instanceof Editable) {
            JMenuItem editItem = new JMenuItem("Edit...");
            editItem.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    WidgetWrapper.this.selected(true);
                    WidgetWrapper.this.foreground();
                    new Events.EditWidgetEvent(null).raise(WidgetWrapper.this);
                }
            });
            menu.add(editItem);
        }
        if (this.selected()) {
            JMenuItem unselectItem = new JMenuItem("Unselect");
            unselectItem.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    WidgetWrapper.this.selected(false);
                    WidgetWrapper.this.interfacePanel().setForegroundWrapper();
                }
            });
            menu.add(unselectItem);
        } else {
            JMenuItem selectItem = new JMenuItem("Select");
            selectItem.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    WidgetWrapper.this.selected(true);
                    WidgetWrapper.this.foreground();
                }
            });
            menu.add(selectItem);
        }
        if (this.widget().deleteable()) {
            JMenuItem deleteItem = new JMenuItem("Delete");
            deleteItem.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    WidgetWrapper.this.interfacePanel().deleteWidget(WidgetWrapper.this);
                }
            });
            menu.add(new JPopupMenu.Separator());
            menu.add(deleteItem);
        }
        if (this.widget().hasContextMenu()) {
            menu.add(new JPopupMenu.Separator());
            location = this.widget().populateContextMenu(menu, p, source2);
            if (this.widget().exportable()) {
                JMenuItem exportItem = new JMenuItem("Export...");
                exportItem.addActionListener(new ActionListener(){

                    public void actionPerformed(ActionEvent e) {
                        try {
                            String exportPath = FileDialog.show(WidgetWrapper.this.widget(), "Export", 1, WidgetWrapper.this.interfacePanel.workspace().guessExportName(WidgetWrapper.this.widget.getDefaultExportName()));
                            WidgetWrapper.this.widget().export(exportPath);
                        }
                        catch (UserCancelException uce) {
                            Exceptions.ignore(uce);
                        }
                    }
                });
                menu.add(exportItem);
            }
            this.widget.addExtraMenuItems(menu);
        }
        return location;
    }
}

