/*
 * Decompiled with CFR 0.152.
 */
package org.nlogo.app;

import java.awt.Color;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.awt.Shape;
import javax.swing.JPanel;
import org.nlogo.awt.Colors;

strictfp class WindowBar
extends JPanel {
    private final Type type;
    private boolean handles;
    private boolean cornerHandles;
    private final int eastBorder;
    private final int westBorder;

    WindowBar(Type type, int eastBorder, int westBorder, boolean handles) {
        this.type = type;
        this.eastBorder = eastBorder;
        this.westBorder = westBorder;
        this.handles = handles;
        this.cornerHandles = true;
        this.setBackground(Color.GRAY);
        this.setOpaque(true);
    }

    public void handles(boolean showHandles) {
        this.handles = showHandles;
    }

    public void cornerHandles(boolean show) {
        this.cornerHandles = show;
    }

    public void paintComponent(Graphics g) {
        super.paintComponent(g);
        g.setColor(this.getBackground());
        switch (this.type) {
            case TOP: {
                this.paintTop(g);
                break;
            }
            case BOTTOM: {
                this.paintBottom(g);
                break;
            }
            case SIDE: {
                this.paintSide(g);
                break;
            }
            default: {
                throw new IllegalStateException("type = " + (Object)((Object)this.type));
            }
        }
    }

    private void paintTop(Graphics g) {
        Rectangle b = this.getBounds();
        if (b.width == 0 || b.height == 0) {
            return;
        }
        int bleed = 5;
        if (this.westBorder == 0) {
            this.drawConvexRect(g, new Rectangle(-5, b.y, b.width + 5, b.height + 5));
        } else {
            this.drawConvexRect(g, new Rectangle(0, b.y, b.width, b.height + 5));
        }
        Shape oldClip = g.getClip();
        g.setClip(this.westBorder - 2, b.height - 3, this.getWidth() - this.eastBorder - this.westBorder + 3, 3);
        this.drawConvexRect(g, new Rectangle(-5, 0, b.width + 10, b.height));
        g.setClip(oldClip);
        if (this.handles) {
            g.setColor(Color.BLACK);
            if (this.cornerHandles) {
                g.fillRect(0, 0, this.westBorder, b.height);
            }
            g.fillRect(this.westBorder + (b.width - this.eastBorder - this.westBorder - 9) / 2, 0, 9, b.height);
            if (this.cornerHandles) {
                g.fillRect(b.width - this.eastBorder, 0, this.eastBorder, b.height);
            }
        }
    }

    private void paintBottom(Graphics g) {
        Shape oldClip = g.getClip();
        Rectangle r = new Rectangle(this.getBounds());
        if (r.width == 0 || r.height == 0) {
            return;
        }
        r.x = 0;
        r.y = -5;
        r.height += 5;
        this.drawConvexRect(g, r);
        r = new Rectangle(this.getBounds());
        r.x = 0;
        r.y = 0;
        g.setClip(this.eastBorder - 1, 0, this.getWidth() - this.eastBorder - this.westBorder + 2, 3);
        this.drawConvexRect(g, r);
        g.setClip(oldClip);
        if (this.handles) {
            Rectangle b = this.getBounds();
            g.setColor(Color.BLACK);
            if (this.cornerHandles) {
                g.fillRect(0, 0, this.westBorder, b.height);
            }
            g.fillRect(this.westBorder + (b.width - this.eastBorder - this.westBorder - 9) / 2, 0, 9, b.height);
            if (this.cornerHandles) {
                g.fillRect(b.width - this.eastBorder, 0, this.eastBorder, b.height);
            }
        }
    }

    private void paintSide(Graphics g) {
        Rectangle r = new Rectangle(this.getBounds());
        if (r.width == 0 || r.height == 0) {
            return;
        }
        r.x = 0;
        r.y = -5;
        r.height += 10;
        this.drawConvexRect(g, r);
        if (this.handles) {
            Rectangle b = this.getBounds();
            g.setColor(Color.BLACK);
            g.fillRect(0, (b.height - 9) / 2, b.width, 9);
        }
    }

    private void drawConvexRect(Graphics g, Rectangle r) {
        g.setColor(Colors.mixColors(this.getForeground(), this.getBackground(), 0.5));
        g.drawRect(r.x, r.y, r.width, r.height);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    strictfp static enum Type {
        TOP,
        BOTTOM,
        SIDE;

    }
}

