/*
 * Decompiled with CFR 0.152.
 */
package org.nlogo.compiler;

import java.io.IOException;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.nlogo.agent.World;
import org.nlogo.api.CompilerException;
import org.nlogo.api.ExtensionManager;
import org.nlogo.api.File;
import org.nlogo.api.NumberParser$;
import org.nlogo.api.Program;
import org.nlogo.api.Token;
import org.nlogo.api.TokenMapperInterface;
import org.nlogo.api.TokenReaderInterface;
import org.nlogo.api.TokenType;
import org.nlogo.api.TokenType$CONSTANT$;
import org.nlogo.api.TokenType$IDENT$;
import org.nlogo.api.TokenType$OPEN_BRACKET$;
import org.nlogo.api.TokenType$OPEN_PAREN$;
import org.nlogo.api.TokenType$REPORTER$;
import org.nlogo.api.TokenType$VARIABLE$;
import org.nlogo.api.TokenizerInterface;
import org.nlogo.compiler.AutoConverter1;
import org.nlogo.compiler.AutoConverter2;
import org.nlogo.compiler.CompilerMain$;
import org.nlogo.compiler.ConstantParser;
import org.nlogo.compiler.ExpressionParser;
import org.nlogo.compiler.ExpressionParser$;
import org.nlogo.compiler.IdentifierParser;
import org.nlogo.compiler.StructureParser;
import org.nlogo.compiler.StructureParserExtras;
import org.nlogo.nvm.CompilerInterface;
import org.nlogo.nvm.CompilerResults;
import org.nlogo.nvm.Procedure;
import org.nlogo.nvm.Workspace;
import org.nlogo.util.Femto$;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.ScalaObject;
import scala.Serializable;
import scala.UninitializedFieldError;
import scala.collection.IterableLike;
import scala.collection.Iterator;
import scala.collection.JavaConverters$;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableLike;
import scala.collection.immutable.Set;
import scala.collection.mutable.StringBuilder;
import scala.runtime.BoxedUnit;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class Compiler$
implements CompilerInterface,
ScalaObject {
    public static final Compiler$ MODULE$;
    private final TokenizerInterface Tokenizer2D;
    private final TokenizerInterface Tokenizer3D;
    private final TokenMapperInterface TokenMapper2D;
    private final Map<String, Procedure> noProcedures;
    private final Set<TokenType> reporterTokenTypes;
    private volatile int bitmap$init$0;

    static {
        new Compiler$();
    }

    public TokenizerInterface Tokenizer2D() {
        if ((this.bitmap$init$0 & 1) != 0) {
            return this.Tokenizer2D;
        }
        throw new UninitializedFieldError("Uninitialized field: Compiler.scala: 16".toString());
    }

    public TokenizerInterface Tokenizer3D() {
        if ((this.bitmap$init$0 & 2) != 0) {
            return this.Tokenizer3D;
        }
        throw new UninitializedFieldError("Uninitialized field: Compiler.scala: 17".toString());
    }

    public TokenMapperInterface TokenMapper2D() {
        if ((this.bitmap$init$0 & 4) != 0) {
            return this.TokenMapper2D;
        }
        throw new UninitializedFieldError("Uninitialized field: Compiler.scala: 18".toString());
    }

    private Map<String, Procedure> noProcedures() {
        if ((this.bitmap$init$0 & 8) != 0) {
            return this.noProcedures;
        }
        throw new UninitializedFieldError("Uninitialized field: Compiler.scala: 22".toString());
    }

    public final TokenizerInterface org$nlogo$compiler$Compiler$$tokenizer(boolean is3D2) {
        return is3D2 ? this.Tokenizer3D() : this.Tokenizer2D();
    }

    @Override
    public CompilerResults compileProgram(String source2, Program program, ExtensionManager extensionManager) throws CompilerException {
        return new CompilerResults(CompilerMain$.MODULE$.compile(source2, None$.MODULE$, program, false, this.noProcedures(), extensionManager), program);
    }

    @Override
    public CompilerResults compileMoreCode(String source2, Option<String> displayName, Program program, Map<String, Procedure> oldProcedures, ExtensionManager extensionManager) throws CompilerException {
        return new CompilerResults(CompilerMain$.MODULE$.compile(source2, displayName, program, true, oldProcedures, extensionManager), program);
    }

    @Override
    public void checkCommandSyntax(String source2, Program program, Map<String, Procedure> procedures, ExtensionManager extensionManager, boolean parse2) throws CompilerException {
        this.checkSyntax(new StringBuilder().append((Object)"to __bogus-name ").append((Object)source2).append((Object)"\nend").toString(), true, program, procedures, extensionManager, parse2);
    }

    @Override
    public void checkReporterSyntax(String source2, Program program, Map<String, Procedure> procedures, ExtensionManager extensionManager, boolean parse2) throws CompilerException {
        this.checkSyntax(new StringBuilder().append((Object)"to-report __bogus-name report ").append((Object)source2).append((Object)"\nend").toString(), true, program, procedures, extensionManager, parse2);
    }

    private void checkSyntax(String source2, boolean subprogram, Program program, Map<String, Procedure> oldProcedures, ExtensionManager extensionManager, boolean parse$1) throws CompilerException {
        TokenizerInterface t = this.org$nlogo$compiler$Compiler$$tokenizer(program.is3D());
        StructureParser.Results results$1 = new StructureParser(t.tokenizeRobustly(source2), None$.MODULE$, program, oldProcedures, extensionManager, t).parse(subprogram);
        IdentifierParser identifierParser$1 = new IdentifierParser(program, this.noProcedures(), results$1.procedures(), !parse$1);
        ((IterableLike)JavaConverters$.MODULE$.collectionAsScalaIterableConverter(results$1.procedures().values()).asScala()).foreach(new Serializable(parse$1, results$1, identifierParser$1){
            public static final long serialVersionUID;
            private final boolean parse$1;
            private final StructureParser.Results results$1;
            private final IdentifierParser identifierParser$1;

            static {
                long l = serialVersionUID = 0L;
            }

            public final Object apply(Procedure procedure) {
                Seq<Token> tokens = this.identifierParser$1.process(((IterableLike)this.results$1.tokens().apply(procedure)).iterator(), procedure);
                return this.parse$1 ? new ExpressionParser(procedure, ExpressionParser$.MODULE$.init$default$2()).parse(tokens) : BoxedUnit.UNIT;
            }
            {
                this.parse$1 = bl;
                this.results$1 = results;
                this.identifierParser$1 = identifierParser;
            }
        });
    }

    @Override
    public String autoConvert(String source2, boolean subprogram, boolean reporter, String version, Object w, boolean ignoreErrors, boolean is3D2) {
        Workspace workspace = (Workspace)w;
        String result1 = new AutoConverter1(this.org$nlogo$compiler$Compiler$$tokenizer(is3D2)).convert(source2, subprogram, reporter, version);
        return new AutoConverter2(workspace, ignoreErrors, this.org$nlogo$compiler$Compiler$$tokenizer(is3D2)).convert(result1, subprogram, reporter, version);
    }

    @Override
    public Object readFromString(String source$1, boolean is3D$1) throws CompilerException {
        return NumberParser$.MODULE$.parse(source$1).right().getOrElse(new Serializable(source$1, is3D$1){
            public static final long serialVersionUID;
            private final String source$1;
            private final boolean is3D$1;

            static {
                long l = serialVersionUID = 0L;
            }

            public final Object apply() {
                return new ConstantParser().getConstantValue(Compiler$.MODULE$.org$nlogo$compiler$Compiler$$tokenizer(this.is3D$1).tokenize(this.source$1).iterator());
            }
            {
                this.source$1 = string;
                this.is3D$1 = bl;
            }
        });
    }

    @Override
    public Object readFromString(String source$2, org.nlogo.api.World world$1, ExtensionManager extensionManager$1, boolean is3D$2) throws CompilerException {
        return NumberParser$.MODULE$.parse(source$2).right().getOrElse(new Serializable(source$2, world$1, extensionManager$1, is3D$2){
            public static final long serialVersionUID;
            private final String source$2;
            private final org.nlogo.api.World world$1;
            private final ExtensionManager extensionManager$1;
            private final boolean is3D$2;

            static {
                long l = serialVersionUID = 0L;
            }

            public final Object apply() {
                return new ConstantParser((World)this.world$1, this.extensionManager$1).getConstantValue(Compiler$.MODULE$.org$nlogo$compiler$Compiler$$tokenizer(this.is3D$2).tokenize(this.source$2).iterator());
            }
            {
                this.source$2 = string;
                this.world$1 = world;
                this.extensionManager$1 = extensionManager;
                this.is3D$2 = bl;
            }
        });
    }

    @Override
    public Double readNumberFromString(String source$3, org.nlogo.api.World world$2, ExtensionManager extensionManager$2, boolean is3D$3) throws CompilerException {
        return (Double)NumberParser$.MODULE$.parse(source$3).right().getOrElse(new Serializable(source$3, world$2, extensionManager$2, is3D$3){
            public static final long serialVersionUID;
            private final String source$3;
            private final org.nlogo.api.World world$2;
            private final ExtensionManager extensionManager$2;
            private final boolean is3D$3;

            static {
                long l = serialVersionUID = 0L;
            }

            public final Double apply() {
                return new ConstantParser((World)this.world$2, this.extensionManager$2).getNumberValue(Compiler$.MODULE$.org$nlogo$compiler$Compiler$$tokenizer(this.is3D$3).tokenize(this.source$3).iterator());
            }
            {
                this.source$3 = string;
                this.world$2 = world;
                this.extensionManager$2 = extensionManager;
                this.is3D$3 = bl;
            }
        });
    }

    @Override
    public Object readFromFile(File currFile, org.nlogo.api.World world, ExtensionManager extensionManager) throws CompilerException, IOException {
        Iterator tokens = Femto$.MODULE$.get(TokenReaderInterface.class, "org.nlogo.lex.TokenReader", new Object[]{currFile, this.org$nlogo$compiler$Compiler$$tokenizer(world.program().is3D())});
        Object result = new ConstantParser((World)world, extensionManager).getConstantFromFile(tokens);
        boolean done = false;
        while (!done) {
            currFile.reader().mark(1);
            currFile.pos_$eq(currFile.pos() + 1L);
            int i = currFile.reader().read();
            if (i != -1 && Character.isWhitespace(i)) continue;
            currFile.reader().reset();
            currFile.pos_$eq(currFile.pos() - 1L);
            done = true;
        }
        return result;
    }

    @Override
    public Map<String, List<Object>> findProcedurePositions(String source2, boolean is3D2) {
        return new StructureParserExtras(this.org$nlogo$compiler$Compiler$$tokenizer(is3D2)).findProcedurePositions(source2);
    }

    @Override
    public Map<String, String> findIncludes(String sourceFileName, String source2, boolean is3D2) {
        return new StructureParserExtras(this.org$nlogo$compiler$Compiler$$tokenizer(is3D2)).findIncludes(sourceFileName, source2);
    }

    @Override
    public boolean isValidIdentifier(String s, boolean is3D2) {
        return this.org$nlogo$compiler$Compiler$$tokenizer(is3D2).isValidIdentifier(s);
    }

    @Override
    public boolean isReporter(String s, Program program, Map<String, Procedure> procedures, ExtensionManager extensionManager) {
        boolean exceptionResult1 = false;
        try {
            TokenizerInterface t = this.org$nlogo$compiler$Compiler$$tokenizer(program.is3D());
            StructureParser.Results results = new StructureParser(t.tokenize(new StringBuilder().append((Object)"to __is-reporter? report ").append((Object)s).append((Object)"\nend").toString()), None$.MODULE$, program, procedures, extensionManager, t).parse(true);
            IdentifierParser identifierParser = new IdentifierParser(program, procedures, results.procedures(), false);
            Procedure proc = (Procedure)((IterableLike)JavaConverters$.MODULE$.collectionAsScalaIterableConverter(results.procedures().values()).asScala()).head();
            Seq<Token> tokens = identifierParser.process(((IterableLike)results.tokens().apply(proc)).iterator(), proc);
            exceptionResult1 = ((TraversableLike)((TraversableLike)((TraversableLike)tokens.tail()).map(new Serializable(){
                public static final long serialVersionUID;

                static {
                    long l = serialVersionUID = 0L;
                }

                public final TokenType apply(Token token) {
                    return token.tyype();
                }
            }, Seq$.MODULE$.canBuildFrom())).dropWhile(new Serializable(){
                public static final long serialVersionUID;

                static {
                    long l = serialVersionUID = 0L;
                }

                public final boolean apply(TokenType tokenType) {
                    TokenType tokenType2 = tokenType;
                    TokenType$OPEN_PAREN$ tokenType$OPEN_PAREN$ = TokenType$OPEN_PAREN$.MODULE$;
                    return !(tokenType2 != null ? !tokenType2.equals(tokenType$OPEN_PAREN$) : tokenType$OPEN_PAREN$ != null);
                }
            })).headOption().exists(this.reporterTokenTypes());
        }
        catch (CompilerException compilerException) {
            exceptionResult1 = false;
        }
        return exceptionResult1;
    }

    private Set<TokenType> reporterTokenTypes() {
        if ((this.bitmap$init$0 & 0x10) != 0) {
            return this.reporterTokenTypes;
        }
        throw new UninitializedFieldError("Uninitialized field: Compiler.scala: 164".toString());
    }

    @Override
    public Token getTokenAtPosition(String source2, int position) {
        return this.org$nlogo$compiler$Compiler$$tokenizer(false).getTokenAtPosition(source2, position);
    }

    @Override
    public Token[] tokenizeForColorization(String source2, ExtensionManager extensionManager, boolean is3D2) {
        return this.org$nlogo$compiler$Compiler$$tokenizer(is3D2).tokenizeForColorization(source2, extensionManager);
    }

    private Compiler$() {
        MODULE$ = this;
        this.Tokenizer2D = Femto$.MODULE$.scalaSingleton(TokenizerInterface.class, "org.nlogo.lex.Tokenizer2D");
        this.bitmap$init$0 |= 1;
        this.Tokenizer3D = Femto$.MODULE$.scalaSingleton(TokenizerInterface.class, "org.nlogo.lex.Tokenizer3D");
        this.bitmap$init$0 |= 2;
        this.TokenMapper2D = Femto$.MODULE$.scalaSingleton(TokenMapperInterface.class, "org.nlogo.lex.TokenMapper2D");
        this.bitmap$init$0 |= 4;
        this.noProcedures = Collections.emptyMap();
        this.bitmap$init$0 |= 8;
        this.reporterTokenTypes = (Set)Predef$.MODULE$.Set().apply(Predef$.MODULE$.wrapRefArray((Object[])new TokenType[]{TokenType$OPEN_BRACKET$.MODULE$, TokenType$CONSTANT$.MODULE$, TokenType$IDENT$.MODULE$, TokenType$REPORTER$.MODULE$, TokenType$VARIABLE$.MODULE$}));
        this.bitmap$init$0 |= 0x10;
    }
}

