/*
 * Decompiled with CFR 0.152.
 */
package org.nlogo.gl.render;

import java.nio.FloatBuffer;
import javax.media.opengl.GL;
import javax.media.opengl.glu.GLU;
import org.nlogo.api.World3D;
import org.nlogo.gl.render.Direction;
import org.nlogo.gl.render.Light;
import org.nlogo.gl.render.ShapeRenderer;
import scala.Array$;
import scala.Predef$;
import scala.ScalaObject;
import scala.collection.Seq;
import scala.math.package$;
import scala.reflect.ScalaSignature;

@ScalaSignature(bytes="\u0006\u0001m3A!\u0001\u0002\u0001\u0017\t\u0001B)\u001b:fGRLwN\\1m\u0019&<\u0007\u000e\u001e\u0006\u0003\u0007\u0011\taA]3oI\u0016\u0014(BA\u0003\u0007\u0003\t9GN\u0003\u0002\b\u0011\u0005)a\u000e\\8h_*\t\u0011\"A\u0002pe\u001e\u001c\u0001aE\u0002\u0001\u0019A\u0001\"!\u0004\b\u000e\u0003\tI!a\u0004\u0002\u0003\u000b1Kw\r\u001b;\u0011\u0005E!R\"\u0001\n\u000b\u0003M\tQa]2bY\u0006L!!\u0006\n\u0003\u0017M\u001b\u0017\r\\1PE*,7\r\u001e\u0005\t/\u0001\u0011)\u0019!C\u00011\u0005IA-\u001b:fGRLwN\\\u000b\u00023A\u0011QBG\u0005\u00037\t\u0011\u0011\u0002R5sK\u000e$\u0018n\u001c8\t\u0011u\u0001!\u0011!Q\u0001\ne\t!\u0002Z5sK\u000e$\u0018n\u001c8!\u0011\u0015y\u0002\u0001\"\u0001!\u0003\u0019a\u0014N\\5u}Q\u0011\u0011E\t\t\u0003\u001b\u0001AQa\u0006\u0010A\u0002eAQ\u0001\n\u0001\u0005\u0002\u0015\n\u0011\u0002^=qK2\u000b'-\u001a7\u0016\u0003\u0019\u0002\"a\n\u0017\u000e\u0003!R!!\u000b\u0016\u0002\t1\fgn\u001a\u0006\u0002W\u0005!!.\u0019<b\u0013\ti\u0003F\u0001\u0004TiJLgn\u001a\u0005\u0006_\u0001!\t\u0001M\u0001\u000bCB\u0004H.\u001f'jO\"$H#A\u0019\u0011\u0005E\u0011\u0014BA\u001a\u0013\u0005\u0011)f.\u001b;\t\u000bU\u0002A\u0011\u0001\u001c\u0002\u0013MDwn\u001e'jO\"$HCB\u00198\t2\u000bf\u000bC\u00039i\u0001\u0007\u0011(A\u0002hYV\u0004\"A\u000f\"\u000e\u0003mR!\u0001\u000f\u001f\u000b\u0005ur\u0014AB8qK:<GN\u0003\u0002@\u0001\u0006)Q.\u001a3jC*\t\u0011)A\u0003kCZ\f\u00070\u0003\u0002Dw\t\u0019q\tT+\t\u000b\u0015#\u0004\u0019\u0001$\u0002\u000b]|'\u000f\u001c3\u0011\u0005\u001dSU\"\u0001%\u000b\u0005%3\u0011aA1qS&\u00111\n\u0013\u0002\b/>\u0014H\u000eZ\u001aE\u0011\u0015iE\u00071\u0001O\u0003)9xN\u001d7e'\u000e\fG.\u001a\t\u0003#=K!\u0001\u0015\n\u0003\u000b\u0019cw.\u0019;\t\u000bI#\u0004\u0019A*\u0002!=\u00147/\u001a:wKJ$\u0015n\u001d;b]\u000e,\u0007CA\tU\u0013\t)&C\u0001\u0004E_V\u0014G.\u001a\u0005\u0006/R\u0002\r\u0001W\u0001\u000eg\"\f\u0007/\u001a*f]\u0012,'/\u001a:\u0011\u00055I\u0016B\u0001.\u0003\u00055\u0019\u0006.\u00199f%\u0016tG-\u001a:fe\u0002")
public class DirectionalLight
extends Light
implements ScalaObject {
    private final Direction direction;

    public Direction direction() {
        return this.direction;
    }

    public String typeLabel() {
        return "Directional";
    }

    public void applyLight() {
        GL gl = this.getGL();
        gl.glEnable(2896);
        if (this.isOn()) {
            gl.glEnable(this.glLightNumber());
            gl.glLightfv(this.glLightNumber(), 4611, FloatBuffer.wrap(this.direction().toFloat4Array()));
        } else {
            gl.glDisable(this.glLightNumber());
        }
    }

    public void showLight(GLU glu, World3D world, float worldScale, double observerDistance, ShapeRenderer shapeRenderer) {
        GL gl = this.getGL();
        gl.glDisable(2896);
        gl.glPushMatrix();
        Direction normalizedDirection = this.direction().normalized();
        int worldMaxExtent = package$.MODULE$.max(world.maxPxcor(), package$.MODULE$.max(world.maxPycor(), world.maxPzcor()));
        float offset = (float)(-2.0 * (double)worldMaxExtent);
        float lightSourceX = offset * Predef$.MODULE$.Float2float(normalizedDirection.x()) * worldScale;
        float lightSourceY = offset * Predef$.MODULE$.Float2float(normalizedDirection.y()) * worldScale;
        float lightSourceZ = offset * Predef$.MODULE$.Float2float(normalizedDirection.z()) * worldScale;
        gl.glTranslatef(lightSourceX, lightSourceY, lightSourceZ);
        gl.glColor4fv(FloatBuffer.wrap(Array$.MODULE$.apply(0.98f, (Seq<Object>)Predef$.MODULE$.wrapFloatArray(new float[]{0.98f, 0.82f, 1.0f}))));
        this.render3DArrow(glu, Predef$.MODULE$.Float2float(normalizedDirection.x()), Predef$.MODULE$.Float2float(normalizedDirection.y()), Predef$.MODULE$.Float2float(normalizedDirection.z()));
        gl.glPopMatrix();
        this.renderPositionHintLines(Predef$.MODULE$.float2Float(lightSourceX), Predef$.MODULE$.float2Float(lightSourceY), Predef$.MODULE$.float2Float(lightSourceZ), Predef$.MODULE$.float2Float(worldScale * (float)world.minPxcor()), Predef$.MODULE$.float2Float(worldScale * (float)world.minPycor()), Predef$.MODULE$.float2Float(worldScale * (float)world.minPzcor()), Predef$.MODULE$.float2Float(worldScale * (float)world.maxPxcor()), Predef$.MODULE$.float2Float(worldScale * (float)world.maxPycor()), Predef$.MODULE$.float2Float(worldScale * (float)world.maxPzcor()));
        shapeRenderer.renderLabel(this.getGL(), this.getLabel(), Predef$.MODULE$.double2Double(47.0), lightSourceX, lightSourceY, lightSourceZ, 1.0f, 12, world.patchSize());
        gl.glEnable(2896);
    }

    public DirectionalLight(Direction direction) {
        this.direction = direction;
    }
}

