/*
 * Decompiled with CFR 0.152.
 */
package org.nlogo.gl.render;

import java.nio.IntBuffer;
import javax.media.opengl.GL;
import org.nlogo.api.DrawingInterface;
import org.nlogo.api.World;
import org.nlogo.gl.render.DrawingRendererInterface;
import org.nlogo.gl.render.TextureRenderer;
import org.nlogo.gl.render.TextureUtils$;
import scala.Array$;
import scala.Predef$;
import scala.ScalaObject;
import scala.UninitializedFieldError;
import scala.reflect.Manifest$;
import scala.reflect.ScalaSignature;

@ScalaSignature(bytes="\u0006\u0001\u001d4A!\u0001\u0002\u0005\u0017\tyAI]1xS:<'+\u001a8eKJ,'O\u0003\u0002\u0004\t\u00051!/\u001a8eKJT!!\u0002\u0004\u0002\u0005\u001dd'BA\u0004\t\u0003\u0015qGn\\4p\u0015\u0005I\u0011aA8sO\u000e\u00011\u0003\u0002\u0001\r!M\u0001\"!\u0004\b\u000e\u0003\tI!a\u0004\u0002\u0003\u001fQ+\u0007\u0010^;sKJ+g\u000eZ3sKJ\u0004\"!D\t\n\u0005I\u0011!\u0001\u0007#sC^Lgn\u001a*f]\u0012,'/\u001a:J]R,'OZ1dKB\u0011AcF\u0007\u0002+)\ta#A\u0003tG\u0006d\u0017-\u0003\u0002\u0019+\tY1kY1mC>\u0013'.Z2u\u0011!Q\u0002A!A!\u0002\u0013Y\u0012!B<pe2$\u0007C\u0001\u000f \u001b\u0005i\"B\u0001\u0010\u0007\u0003\r\t\u0007/[\u0005\u0003Au\u0011QaV8sY\u0012D\u0001B\t\u0001\u0003\u0002\u0003\u0006IaI\u0001\bIJ\fw/\u001b8h!\taB%\u0003\u0002&;\t\u0001BI]1xS:<\u0017J\u001c;fe\u001a\f7-\u001a\u0005\u0006O\u0001!\t\u0001K\u0001\u0007y%t\u0017\u000e\u001e \u0015\u0007%R3\u0006\u0005\u0002\u000e\u0001!)!D\na\u00017!)!E\na\u0001G!)Q\u0006\u0001C\u0001]\u0005!\u0011N\\5u)\ty#\u0007\u0005\u0002\u0015a%\u0011\u0011'\u0006\u0002\u0005+:LG\u000fC\u0003\u0006Y\u0001\u00071\u0007\u0005\u00025w5\tQG\u0003\u00027o\u00051q\u000e]3oO2T!\u0001O\u001d\u0002\u000b5,G-[1\u000b\u0003i\nQA[1wCbL!\u0001P\u001b\u0003\u0005\u001dc\u0005\"\u0002 \u0001\t\u0003y\u0014!\u0004:f]\u0012,'\u000f\u0012:bo&tw\r\u0006\u00020\u0001\")Q!\u0010a\u0001g!)!\t\u0001C\u0005\u0007\u0006i!/\u001a8eKJ$V\r\u001f;ve\u0016$2a\f#F\u0011\u0015)\u0011\t1\u00014\u0011\u00151\u0015\t1\u0001H\u0003\u0015\u0011G.\u00198l!\t!\u0002*\u0003\u0002J+\t9!i\\8mK\u0006t\u0007bB&\u0001\u0001\u0004%I\u0001T\u0001\rIJ\fw/\u001b8h/&$G\u000f[\u000b\u0002\u001bB\u0011ACT\u0005\u0003\u001fV\u00111!\u00138u\u0011\u001d\t\u0006\u00011A\u0005\nI\u000b\u0001\u0003\u001a:bo&twmV5ei\"|F%Z9\u0015\u0005=\u001a\u0006b\u0002+Q\u0003\u0003\u0005\r!T\u0001\u0004q\u0012\n\u0004B\u0002,\u0001A\u0003&Q*A\u0007ee\u0006<\u0018N\\4XS\u0012$\b\u000e\t\u0005\b1\u0002\u0001\r\u0011\"\u0003M\u00035!'/Y<j]\u001eDU-[4ii\"9!\f\u0001a\u0001\n\u0013Y\u0016!\u00053sC^Lgn\u001a%fS\u001eDGo\u0018\u0013fcR\u0011q\u0006\u0018\u0005\b)f\u000b\t\u00111\u0001N\u0011\u0019q\u0006\u0001)Q\u0005\u001b\u0006qAM]1xS:<\u0007*Z5hQR\u0004\u0003\"\u00021\u0001\t\u0013\t\u0017\u0001F2bY\u000e,H.\u0019;f)\u0016DH/\u001e:f'&TX\rF\u00020E\u000eDQ!B0A\u0002MBQAR0A\u0002\u001dCQ!\u001a\u0001\u0005\u0002\u0019\fQa\u00197fCJ$\u0012a\f")
public class DrawingRenderer
extends TextureRenderer
implements DrawingRendererInterface,
ScalaObject {
    private final DrawingInterface drawing;
    private int drawingWidth;
    private int drawingHeight;
    private volatile int bitmap$init$0;

    public void init(GL gl) {
    }

    public void renderDrawing(GL gl) {
        this.calculateTextureSize(gl, this.drawing.isBlank());
        this.renderTexture(gl, this.drawing.isBlank());
    }

    private void renderTexture(GL gl, boolean blank) {
        int width = this.drawing.getWidth();
        int height = this.drawing.getHeight();
        gl.glEnable(3553);
        gl.glDisable(2896);
        gl.glEnable(3042);
        if (!blank) {
            if (this.newTexture) {
                if (this.texture != 0) {
                    gl.glDeleteTextures(1, IntBuffer.wrap((int[])Array$.MODULE$.apply(Predef$.MODULE$.wrapIntArray(new int[]{this.texture}), Manifest$.MODULE$.Int())));
                }
                this.texture = TextureUtils$.MODULE$.genTexture(gl);
                gl.glBindTexture(3553, this.texture);
                TextureUtils$.MODULE$.makeTexture(gl, this.textureSize);
                this.drawing.markDirty();
                this.newTexture = false;
            } else {
                gl.glBindTexture(3553, this.texture);
            }
            gl.glPushMatrix();
            TextureUtils$.MODULE$.setParameters(gl);
            gl.glBlendFunc(770, 771);
            this.renderTextureTiles(gl, width, height, this.textureSize, this.drawing.colors(), this.drawing.isDirty());
            this.drawing.markClean();
            gl.glPopMatrix();
        }
        gl.glEnable(2896);
        gl.glDisable(3042);
        gl.glBindTexture(3553, 0);
    }

    private int drawingWidth() {
        if ((this.bitmap$init$0 & 1) != 0) {
            return this.drawingWidth;
        }
        throw new UninitializedFieldError("Uninitialized field: DrawingRenderer.scala: 49".toString());
    }

    private void drawingWidth_$eq(int n) {
        this.drawingWidth = n;
        this.bitmap$init$0 |= 1;
    }

    private int drawingHeight() {
        if ((this.bitmap$init$0 & 2) != 0) {
            return this.drawingHeight;
        }
        throw new UninitializedFieldError("Uninitialized field: DrawingRenderer.scala: 50".toString());
    }

    private void drawingHeight_$eq(int n) {
        this.drawingHeight = n;
        this.bitmap$init$0 |= 2;
    }

    private void calculateTextureSize(GL gl, boolean blank) {
        int newSize = 0;
        if (!blank && (this.drawing.getWidth() != this.drawingWidth() || this.drawing.getHeight() != this.drawingHeight()) || this.textureSize == 0) {
            newSize = TextureUtils$.MODULE$.calculateTextureSize(gl, this.drawing.getWidth(), this.drawing.getHeight());
            this.newTexture = true;
            this.textureSize = newSize;
            this.tiles = TextureUtils$.MODULE$.createTileArray(this.drawing.getWidth(), this.drawing.getHeight(), this.textureSize);
            this.drawingWidth_$eq(this.drawing.getWidth());
            this.drawingHeight_$eq(this.drawing.getHeight());
        }
    }

    public void clear() {
        this.deleteTexture();
    }

    public DrawingRenderer(World world, DrawingInterface drawing) {
        this.drawing = drawing;
        super(world);
        this.drawingWidth = 0;
        this.bitmap$init$0 |= 1;
        this.drawingHeight = 0;
        this.bitmap$init$0 |= 2;
    }
}

