/*
 * Decompiled with CFR 0.152.
 */
package org.nlogo.gl.render;

import java.nio.FloatBuffer;
import javax.media.opengl.GL;
import javax.media.opengl.glu.GLU;
import org.nlogo.api.World3D;
import org.nlogo.gl.render.LightManager$;
import org.nlogo.gl.render.RGBA;
import org.nlogo.gl.render.ShapeRenderer;
import scala.Array$;
import scala.Function0;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.ScalaObject;
import scala.Serializable;
import scala.UninitializedFieldError;
import scala.collection.Seq;
import scala.collection.mutable.StringBuilder;
import scala.math.package$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.Nothing$;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@ScalaSignature(bytes="\u0006\u0001\u0005]e!B\u0001\u0003\u0003\u0003Y!!\u0002'jO\"$(BA\u0002\u0005\u0003\u0019\u0011XM\u001c3fe*\u0011QAB\u0001\u0003O2T!a\u0002\u0005\u0002\u000b9dwnZ8\u000b\u0003%\t1a\u001c:h\u0007\u0001\u00192\u0001\u0001\u0007\u0015!\ti!#D\u0001\u000f\u0015\ty\u0001#\u0001\u0003mC:<'\"A\t\u0002\t)\fg/Y\u0005\u0003'9\u0011aa\u00142kK\u000e$\bCA\u000b\u0019\u001b\u00051\"\"A\f\u0002\u000bM\u001c\u0017\r\\1\n\u0005e1\"aC*dC2\fwJ\u00196fGRDQa\u0007\u0001\u0005\u0002q\ta\u0001P5oSRtD#A\u000f\u0011\u0005y\u0001Q\"\u0001\u0002\t\u000f\u0001\u0002\u0001\u0019!C\u0001C\u00059\u0011-\u001c2jK:$X#\u0001\u0012\u0011\u0005y\u0019\u0013B\u0001\u0013\u0003\u0005\u0011\u0011vIQ!\t\u000f\u0019\u0002\u0001\u0019!C\u0001O\u0005Y\u0011-\u001c2jK:$x\fJ3r)\tA3\u0006\u0005\u0002\u0016S%\u0011!F\u0006\u0002\u0005+:LG\u000fC\u0004-K\u0005\u0005\t\u0019\u0001\u0012\u0002\u0007a$\u0013\u0007\u0003\u0004/\u0001\u0001\u0006KAI\u0001\tC6\u0014\u0017.\u001a8uA!9\u0001\u0007\u0001a\u0001\n\u0003\t\u0013a\u00023jM\u001a,8/\u001a\u0005\be\u0001\u0001\r\u0011\"\u00014\u0003-!\u0017N\u001a4vg\u0016|F%Z9\u0015\u0005!\"\u0004b\u0002\u00172\u0003\u0003\u0005\rA\t\u0005\u0007m\u0001\u0001\u000b\u0015\u0002\u0012\u0002\u0011\u0011LgMZ;tK\u0002Bq\u0001\u000f\u0001A\u0002\u0013\u0005\u0011%\u0001\u0005ta\u0016\u001cW\u000f\\1s\u0011\u001dQ\u0004\u00011A\u0005\u0002m\nAb\u001d9fGVd\u0017M]0%KF$\"\u0001\u000b\u001f\t\u000f1J\u0014\u0011!a\u0001E!1a\b\u0001Q!\n\t\n\u0011b\u001d9fGVd\u0017M\u001d\u0011\t\u000f\u0001\u0003\u0001\u0019!C\u0001\u0003\u0006iq\r\u001c'jO\"$h*^7cKJ,\u0012A\u0011\t\u0003+\rK!\u0001\u0012\f\u0003\u0007%sG\u000fC\u0004G\u0001\u0001\u0007I\u0011A$\u0002#\u001ddG*[4ii:+XNY3s?\u0012*\u0017\u000f\u0006\u0002)\u0011\"9A&RA\u0001\u0002\u0004\u0011\u0005B\u0002&\u0001A\u0003&!)\u0001\bhY2Kw\r\u001b;Ok6\u0014WM\u001d\u0011\t\u000f1\u0003\u0001\u0019!C\u0001\u001b\u0006Qq\r\\%ogR\fgnY3\u0016\u00039\u00032!F(R\u0013\t\u0001fC\u0001\u0004PaRLwN\u001c\t\u0003%fk\u0011a\u0015\u0006\u0003)V\u000baa\u001c9f]\u001ed'B\u0001,X\u0003\u0015iW\rZ5b\u0015\u0005A\u0016!\u00026bm\u0006D\u0018B\u0001.T\u0005\t9E\nC\u0004]\u0001\u0001\u0007I\u0011A/\u0002\u001d\u001dd\u0017J\\:uC:\u001cWm\u0018\u0013fcR\u0011\u0001F\u0018\u0005\bYm\u000b\t\u00111\u0001O\u0011\u0019\u0001\u0007\u0001)Q\u0005\u001d\u0006Yq\r\\%ogR\fgnY3!\u0011\u0015\u0011\u0007\u0001b\u0001d\u0003\u00159W\r^$M+\u0005\t\u0006bB3\u0001\u0001\u0004%IAZ\u0001\u0006?&\u001cxJ\\\u000b\u0002OB\u0011Q\u0003[\u0005\u0003SZ\u0011qAQ8pY\u0016\fg\u000eC\u0004l\u0001\u0001\u0007I\u0011\u00027\u0002\u0013}K7o\u00148`I\u0015\fHC\u0001\u0015n\u0011\u001da#.!AA\u0002\u001dDaa\u001c\u0001!B\u00139\u0017AB0jg>s\u0007\u0005C\u0003r\u0001\u0011\u0005a-\u0001\u0003jg>s\u0007\"B:\u0001\t\u0003!\u0018A\u0002;ve:|e\u000eF\u0001)\u0011\u00151\b\u0001\"\u0001u\u0003\u001d!XO\u001d8PM\u001aDQ\u0001\u001f\u0001\u0005\u0002Q\fa\u0001^8hO2,\u0007\"\u0002>\u0001\r\u0003!\u0018AC1qa2LH*[4ii\")A\u0010\u0001D\u0001{\u0006I1\u000f[8x\u0019&<\u0007\u000e\u001e\u000b\u000bQy\fY!a\u0007\u0002&\u0005=\u0002BB@|\u0001\u0004\t\t!A\u0002hYV\u0004B!a\u0001\u0002\b5\u0011\u0011Q\u0001\u0006\u0003\u007fNKA!!\u0003\u0002\u0006\t\u0019q\tT+\t\u000f\u000551\u00101\u0001\u0002\u0010\u0005)qo\u001c:mIB!\u0011\u0011CA\f\u001b\t\t\u0019BC\u0002\u0002\u0016\u0019\t1!\u00199j\u0013\u0011\tI\"a\u0005\u0003\u000f]{'\u000f\u001c34\t\"9\u0011QD>A\u0002\u0005}\u0011AC<pe2$7kY1mKB\u0019Q#!\t\n\u0007\u0005\rbCA\u0003GY>\fG\u000fC\u0004\u0002(m\u0004\r!!\u000b\u0002!=\u00147/\u001a:wKJ$\u0015n\u001d;b]\u000e,\u0007cA\u000b\u0002,%\u0019\u0011Q\u0006\f\u0003\r\u0011{WO\u00197f\u0011\u001d\t\td\u001fa\u0001\u0003g\tQb\u001d5ba\u0016\u0014VM\u001c3fe\u0016\u0014\bc\u0001\u0010\u00026%\u0019\u0011q\u0007\u0002\u0003\u001bMC\u0017\r]3SK:$WM]3s\u0011\u001d\tY\u0004\u0001C\u0001\u0003{\tqC]3oI\u0016\u0014\bk\\:ji&|g\u000eS5oi2Kg.Z:\u0015'!\ny$a\u0012\u0002L\u0005=\u00131KA,\u00037\ny&a\u0019\t\u0011\u0005\u0005\u0013\u0011\ba\u0001\u0003\u0007\n\u0011\u0001\u001f\t\u0004\u001b\u0005\u0015\u0013bAA\u0012\u001d!A\u0011\u0011JA\u001d\u0001\u0004\t\u0019%A\u0001z\u0011!\ti%!\u000fA\u0002\u0005\r\u0013!\u0001>\t\u0011\u0005E\u0013\u0011\ba\u0001\u0003\u0007\nA!\\5o1\"A\u0011QKA\u001d\u0001\u0004\t\u0019%\u0001\u0003nS:L\u0006\u0002CA-\u0003s\u0001\r!a\u0011\u0002\t5LgN\u0017\u0005\t\u0003;\nI\u00041\u0001\u0002D\u0005!Q.\u0019=Y\u0011!\t\t'!\u000fA\u0002\u0005\r\u0013\u0001B7bqfC\u0001\"!\u001a\u0002:\u0001\u0007\u00111I\u0001\u0005[\u0006D(\fC\u0004\u0002j\u0001!\t!a\u001b\u0002\u001bI,g\u000eZ3sg\u0011\u000b%O]8x)%A\u0013QNA8\u0003g\n9\bC\u0004\u0000\u0003O\u0002\r!!\u0001\t\u0011\u0005E\u0014q\ra\u0001\u0003S\tA\u0001\u001f3je\"A\u0011QOA4\u0001\u0004\tI#\u0001\u0003zI&\u0014\b\u0002CA=\u0003O\u0002\r!!\u000b\u0002\ti$\u0017N\u001d\u0005\u0007\u0003{\u0002A\u0011\u0001;\u0002-\u0005\u001c8/\u001a:u-\u0006d\u0017\u000e\u001a'jO\"$h*^7cKJDq!!!\u0001\t\u0003\t\u0019)\u0001\u0005hKRd\u0015MY3m+\t\t)\t\u0005\u0003\u0002\b\u00065ebA\u000b\u0002\n&\u0019\u00111\u0012\f\u0002\rA\u0013X\rZ3g\u0013\u0011\ty)!%\u0003\rM#(/\u001b8h\u0015\r\tYI\u0006\u0005\b\u0003+\u0003a\u0011AAB\u0003%!\u0018\u0010]3MC\n,G\u000e")
public abstract class Light
implements ScalaObject {
    private RGBA ambient = new RGBA(Predef$.MODULE$.float2Float(1.0f), Predef$.MODULE$.float2Float(1.0f), Predef$.MODULE$.float2Float(1.0f), Predef$.MODULE$.float2Float(1.0f));
    private RGBA diffuse;
    private RGBA specular;
    private int glLightNumber;
    private Option<GL> glInstance;
    private boolean _isOn;
    private volatile int bitmap$init$0;

    public RGBA ambient() {
        if ((this.bitmap$init$0 & 1) != 0) {
            return this.ambient;
        }
        throw new UninitializedFieldError("Uninitialized field: Lighting.scala: 80".toString());
    }

    public void ambient_$eq(RGBA rGBA) {
        this.ambient = rGBA;
        this.bitmap$init$0 |= 1;
    }

    public RGBA diffuse() {
        if ((this.bitmap$init$0 & 2) != 0) {
            return this.diffuse;
        }
        throw new UninitializedFieldError("Uninitialized field: Lighting.scala: 81".toString());
    }

    public void diffuse_$eq(RGBA rGBA) {
        this.diffuse = rGBA;
        this.bitmap$init$0 |= 2;
    }

    public RGBA specular() {
        if ((this.bitmap$init$0 & 4) != 0) {
            return this.specular;
        }
        throw new UninitializedFieldError("Uninitialized field: Lighting.scala: 82".toString());
    }

    public void specular_$eq(RGBA rGBA) {
        this.specular = rGBA;
        this.bitmap$init$0 |= 4;
    }

    public int glLightNumber() {
        if ((this.bitmap$init$0 & 8) != 0) {
            return this.glLightNumber;
        }
        throw new UninitializedFieldError("Uninitialized field: Lighting.scala: 84".toString());
    }

    public void glLightNumber_$eq(int n) {
        this.glLightNumber = n;
        this.bitmap$init$0 |= 8;
    }

    public Option<GL> glInstance() {
        if ((this.bitmap$init$0 & 0x10) != 0) {
            return this.glInstance;
        }
        throw new UninitializedFieldError("Uninitialized field: Lighting.scala: 86".toString());
    }

    public void glInstance_$eq(Option<GL> option) {
        this.glInstance = option;
        this.bitmap$init$0 |= 0x10;
    }

    public GL getGL() {
        return (GL)this.glInstance().getOrElse(new Serializable(this){
            public static final long serialVersionUID;

            static {
                long l = serialVersionUID = 0L;
            }

            public final Nothing$ apply() {
                return scala.sys.package$.MODULE$.error("Handle to OpenGL interface must be set before attempting to use the light. Use LightManager.addLight() and LightManager.removeLight() to add or remove lights, and be sure LightManager.init() was called.");
            }
        });
    }

    private boolean _isOn() {
        if ((this.bitmap$init$0 & 0x20) != 0) {
            return this._isOn;
        }
        throw new UninitializedFieldError("Uninitialized field: Lighting.scala: 92".toString());
    }

    private void _isOn_$eq(boolean bl) {
        this._isOn = bl;
        this.bitmap$init$0 |= 0x20;
    }

    public boolean isOn() {
        return this._isOn();
    }

    public void turnOn() {
        this.assertValidLightNumber();
        this._isOn_$eq(true);
        GL gl = this.getGL();
        gl.glLightfv(this.glLightNumber(), 4608, FloatBuffer.wrap(this.ambient().toFloat4Array()));
        gl.glLightfv(this.glLightNumber(), 4609, FloatBuffer.wrap(this.diffuse().toFloat4Array()));
        gl.glLightfv(this.glLightNumber(), 4610, FloatBuffer.wrap(this.specular().toFloat4Array()));
        gl.glEnable(this.glLightNumber());
    }

    public void turnOff() {
        this.assertValidLightNumber();
        this._isOn_$eq(false);
        this.getGL().glDisable(this.glLightNumber());
    }

    public void toggle() {
        if (this.isOn()) {
            this.turnOff();
        } else {
            this.turnOn();
        }
    }

    public abstract void applyLight();

    public abstract void showLight(GLU var1, World3D var2, float var3, double var4, ShapeRenderer var6);

    public void renderPositionHintLines(Float x, Float y, Float z, Float minX, Float minY, Float minZ, Float maxX, Float maxY, Float maxZ) {
        GL gl = this.getGL();
        gl.glBegin(1);
        gl.glVertex3f(Predef$.MODULE$.Float2float(x), Predef$.MODULE$.Float2float(y), Predef$.MODULE$.Float2float(z));
        gl.glVertex3f(Predef$.MODULE$.Float2float(x), Predef$.MODULE$.Float2float(y), Predef$.MODULE$.Float2float(minZ));
        gl.glEnd();
        gl.glColor4fv(FloatBuffer.wrap(Array$.MODULE$.apply(0.3f, (Seq<Object>)Predef$.MODULE$.wrapFloatArray(new float[]{0.3f, 0.3f, 1.0f}))));
        gl.glBegin(1);
        if (Predef$.MODULE$.Float2float(x) <= Predef$.MODULE$.Float2float(maxX)) {
            gl.glVertex3f(Predef$.MODULE$.Float2float(minX), Predef$.MODULE$.Float2float(y), Predef$.MODULE$.Float2float(minZ));
            gl.glVertex3f(Predef$.MODULE$.Float2float(x), Predef$.MODULE$.Float2float(y), Predef$.MODULE$.Float2float(minZ));
        }
        if (Predef$.MODULE$.Float2float(x) >= Predef$.MODULE$.Float2float(minX)) {
            gl.glVertex3f(Predef$.MODULE$.Float2float(x), Predef$.MODULE$.Float2float(y), Predef$.MODULE$.Float2float(minZ));
            gl.glVertex3f(Predef$.MODULE$.Float2float(maxX), Predef$.MODULE$.Float2float(y), Predef$.MODULE$.Float2float(minZ));
        }
        if (Predef$.MODULE$.Float2float(y) <= Predef$.MODULE$.Float2float(maxY)) {
            gl.glVertex3f(Predef$.MODULE$.Float2float(x), Predef$.MODULE$.Float2float(minY), Predef$.MODULE$.Float2float(minZ));
            gl.glVertex3f(Predef$.MODULE$.Float2float(x), Predef$.MODULE$.Float2float(y), Predef$.MODULE$.Float2float(minZ));
        }
        if (Predef$.MODULE$.Float2float(y) >= Predef$.MODULE$.Float2float(minY)) {
            gl.glVertex3f(Predef$.MODULE$.Float2float(x), Predef$.MODULE$.Float2float(y), Predef$.MODULE$.Float2float(minZ));
            gl.glVertex3f(Predef$.MODULE$.Float2float(x), Predef$.MODULE$.Float2float(maxY), Predef$.MODULE$.Float2float(minZ));
        }
        if (Predef$.MODULE$.Float2float(x) < Predef$.MODULE$.Float2float(minX) || Predef$.MODULE$.Float2float(x) > Predef$.MODULE$.Float2float(maxX)) {
            if (Predef$.MODULE$.Float2float(y) <= Predef$.MODULE$.Float2float(maxY)) {
                gl.glVertex3f(Predef$.MODULE$.Float2float(x), Predef$.MODULE$.Float2float(minY), Predef$.MODULE$.Float2float(minZ));
                gl.glVertex3f(Predef$.MODULE$.Float2float(x) < Predef$.MODULE$.Float2float(minX) ? Predef$.MODULE$.Float2float(minX) : Predef$.MODULE$.Float2float(maxX), Predef$.MODULE$.Float2float(minY), Predef$.MODULE$.Float2float(minZ));
            }
            if (Predef$.MODULE$.Float2float(y) >= Predef$.MODULE$.Float2float(minY)) {
                gl.glVertex3f(Predef$.MODULE$.Float2float(x), Predef$.MODULE$.Float2float(maxY), Predef$.MODULE$.Float2float(minZ));
                gl.glVertex3f(Predef$.MODULE$.Float2float(x) < Predef$.MODULE$.Float2float(minX) ? Predef$.MODULE$.Float2float(minX) : Predef$.MODULE$.Float2float(maxX), Predef$.MODULE$.Float2float(maxY), Predef$.MODULE$.Float2float(minZ));
            }
        }
        if (Predef$.MODULE$.Float2float(y) < Predef$.MODULE$.Float2float(minY) || Predef$.MODULE$.Float2float(y) > Predef$.MODULE$.Float2float(maxY)) {
            if (Predef$.MODULE$.Float2float(x) <= Predef$.MODULE$.Float2float(maxX)) {
                gl.glVertex3f(Predef$.MODULE$.Float2float(minX), Predef$.MODULE$.Float2float(y), Predef$.MODULE$.Float2float(minZ));
                gl.glVertex3f(Predef$.MODULE$.Float2float(minX), Predef$.MODULE$.Float2float(y) < Predef$.MODULE$.Float2float(minY) ? Predef$.MODULE$.Float2float(minY) : Predef$.MODULE$.Float2float(maxY), Predef$.MODULE$.Float2float(minZ));
            }
            if (Predef$.MODULE$.Float2float(x) >= Predef$.MODULE$.Float2float(minX)) {
                gl.glVertex3f(Predef$.MODULE$.Float2float(maxX), Predef$.MODULE$.Float2float(y), Predef$.MODULE$.Float2float(minZ));
                gl.glVertex3f(Predef$.MODULE$.Float2float(maxX), Predef$.MODULE$.Float2float(y) < Predef$.MODULE$.Float2float(minY) ? Predef$.MODULE$.Float2float(minY) : Predef$.MODULE$.Float2float(maxY), Predef$.MODULE$.Float2float(minZ));
            }
        }
        gl.glEnd();
    }

    public void render3DArrow(GLU glu, double xdir, double ydir, double zdir) {
        GL gl = this.getGL();
        double RADDEG = 57.29578;
        double azimuth = package$.MODULE$.atan2(ydir, xdir) * RADDEG;
        double elevation = package$.MODULE$.acos(zdir) * RADDEG;
        gl.glDisable(2884);
        gl.glPushMatrix();
        gl.glRotated(azimuth, 0.0, 0.0, 1.0);
        gl.glRotated(elevation, 0.0, 1.0, 0.0);
        glu.gluCylinder(glu.gluNewQuadric(), 0.1, 0.1, 1.0, 12, 12);
        gl.glTranslated(0.0, 0.0, 1.0);
        glu.gluCylinder(glu.gluNewQuadric(), 0.3, 0.0, 0.5, 12, 12);
        gl.glPopMatrix();
        gl.glEnable(2884);
    }

    public void assertValidLightNumber() {
        Predef$.MODULE$.assert(this.glLightNumber() >= 16384 || this.glLightNumber() <= 16391, (Function0<Object>)((Object)new Serializable(this){
            public static final long serialVersionUID;
            private final Light $outer;

            static {
                long l = serialVersionUID = 0L;
            }

            public final Nothing$ apply() {
                return scala.sys.package$.MODULE$.error(new StringBuilder().append((Object)"Invalid OpenGL light number: ").append(BoxesRunTime.boxToInteger(this.$outer.glLightNumber())).append((Object)". Light number needs to be between ").append(BoxesRunTime.boxToInteger(16384)).append((Object)" and ").append(BoxesRunTime.boxToInteger(16391)).append((Object)". Use LightManager.addLight() and LightManager.removeLight() to add or remove lights.").toString());
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        }));
    }

    public String getLabel() {
        return new StringBuilder().append((Object)"GL_LIGHT").append(BoxesRunTime.boxToInteger(LightManager$.MODULE$.lightNumbers().indexOf(BoxesRunTime.boxToInteger(this.glLightNumber())))).append((Object)" (").append((Object)this.typeLabel()).append((Object)")").append((Object)(this.isOn() ? "" : " [off]")).toString();
    }

    public abstract String typeLabel();

    public Light() {
        this.bitmap$init$0 |= 1;
        this.diffuse = new RGBA(Predef$.MODULE$.float2Float(1.0f), Predef$.MODULE$.float2Float(1.0f), Predef$.MODULE$.float2Float(1.0f), Predef$.MODULE$.float2Float(1.0f));
        this.bitmap$init$0 |= 2;
        this.specular = new RGBA(Predef$.MODULE$.float2Float(1.0f), Predef$.MODULE$.float2Float(1.0f), Predef$.MODULE$.float2Float(1.0f), Predef$.MODULE$.float2Float(1.0f));
        this.bitmap$init$0 |= 4;
        this.glLightNumber = -1;
        this.bitmap$init$0 |= 8;
        this.glInstance = None$.MODULE$;
        this.bitmap$init$0 |= 0x10;
        this._isOn = true;
        this.bitmap$init$0 |= 0x20;
    }
}

