/*
 * Decompiled with CFR 0.152.
 */
package org.nlogo.gl.render;

import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.IntBuffer;
import javax.media.opengl.GL;
import org.nlogo.gl.render.Renderer;
import scala.Array$;
import scala.Function1;
import scala.Option$;
import scala.Predef$;
import scala.ScalaObject;
import scala.Serializable;
import scala.collection.Seq;
import scala.collection.immutable.Nil$;
import scala.math.package$;
import scala.reflect.ClassManifest$;
import scala.reflect.Manifest$;
import scala.runtime.BoxesRunTime;
import scala.runtime.IntRef;

public final class TextureUtils$
implements ScalaObject {
    public static final TextureUtils$ MODULE$;

    static {
        new TextureUtils$();
    }

    public void makeTexture(GL gl, int size2) {
        gl.glTexImage2D(3553, 0, 6408, size2, size2, 0, 6408, 5121, null);
    }

    public int genTexture(GL gl) {
        int[] tmp = Array$.MODULE$.apply(0, (Seq<Object>)Predef$.MODULE$.wrapIntArray(new int[0]));
        gl.glGenTextures(1, IntBuffer.wrap(tmp));
        return tmp[0];
    }

    public int calculateTextureSize(GL gl, int width$1, int height$1) {
        String glRendererName = gl.glGetString(7937).toUpperCase();
        int maxTextureSize$1 = glRendererName.startsWith("ATI RAGE") ? 256 : (glRendererName.startsWith("ATI RADEON 7500") ? 512 : (glRendererName.startsWith("ATI RADEON 9200") ? 512 : 3379));
        return BoxesRunTime.unboxToInt(scala.package$.MODULE$.Iterator().iterate(BoxesRunTime.boxToInteger(64), new Serializable(){
            public static final long serialVersionUID;

            static {
                long l = serialVersionUID = 0L;
            }

            public final int apply(int n) {
                return this.apply$mcII$sp(n);
            }

            public int apply$mcII$sp(int v1) {
                return v1 * 2;
            }
        }).dropWhile((Function1<Object, Object>)((Object)new Serializable(width$1, height$1, maxTextureSize$1){
            public static final long serialVersionUID;
            private final int width$1;
            private final int height$1;
            private final int maxTextureSize$1;

            static {
                long l = serialVersionUID = 0L;
            }

            public final boolean apply(int size2) {
                return this.apply$mcZI$sp(size2);
            }

            public boolean apply$mcZI$sp(int v1) {
                return (this.width$1 > v1 || this.height$1 > v1) && v1 < (2 + this.maxTextureSize$1) / 2;
            }
            {
                this.width$1 = n;
                this.height$1 = n2;
                this.maxTextureSize$1 = n3;
            }
        })).next());
    }

    public byte[][] createTileArray(int width, int height, int textureSize) {
        int numTiles = (int)package$.MODULE$.ceil((double)width / (double)textureSize) * (int)package$.MODULE$.ceil((double)height / (double)textureSize);
        return (byte[][])Array$.MODULE$.fill(numTiles, new Serializable(){
            public static final long serialVersionUID;

            static {
                long l = serialVersionUID = 0L;
            }

            public final byte[] apply() {
                return (byte[])Array$.MODULE$.apply(Nil$.MODULE$, Manifest$.MODULE$.Byte());
            }
        }, ClassManifest$.MODULE$.arrayType(Manifest$.MODULE$.Byte()));
    }

    public void setParameters(GL gl) {
        gl.glTexParameteri(3553, 10241, 9728);
        gl.glTexParameteri(3553, 10240, 9728);
        gl.glTexParameteri(3553, 10242, 10496);
        gl.glTexParameteri(3553, 10243, 10496);
    }

    public byte[] reuseTexture(GL gl, int tileWidth, int tileHeight, int xOffset, int yOffset, int width, int[] colors, byte[] _bytes) {
        int i = 0;
        IntRef size$1 = new IntRef(tileHeight * tileWidth * 4);
        byte[] bytes = (byte[])Option$.MODULE$.apply(_bytes).filter((Function1<byte[], Object>)((Object)new Serializable(size$1){
            public static final long serialVersionUID;
            private final IntRef size$1;

            static {
                long l = serialVersionUID = 0L;
            }

            public final boolean apply(byte[] byArray) {
                return Predef$.MODULE$.byteArrayOps(byArray).size() == this.size$1.elem;
            }
            {
                this.size$1 = intRef;
            }
        })).getOrElse(new Serializable(size$1){
            public static final long serialVersionUID;
            private final IntRef size$1;

            static {
                long l = serialVersionUID = 0L;
            }

            public final byte[] apply() {
                return new byte[this.size$1.elem];
            }
            {
                this.size$1 = intRef;
            }
        });
        for (int x = xOffset; x < tileWidth + xOffset; ++x) {
            for (int y = yOffset; y < tileHeight + yOffset; ++y) {
                int rgb = colors[x + y * width];
                bytes[i] = (byte)(rgb >> 16);
                bytes[++i] = (byte)(rgb >> 8);
                bytes[++i] = (byte)rgb;
                bytes[++i] = (byte)(rgb >> 24);
                ++i;
            }
        }
        gl.glTexSubImage2D(3553, 0, 0, 0, tileHeight, tileWidth, 6408, 5121, (Buffer)ByteBuffer.wrap(bytes));
        return bytes;
    }

    public void renderEmptyPlane(GL gl, float _sideX, float _sideY, float _sideZ) {
        float sideX = _sideX * (Renderer.WORLD_SCALE / (float)2);
        float sideY = _sideY * (Renderer.WORLD_SCALE / (float)2);
        float sideZ = _sideZ * (Renderer.WORLD_SCALE / (float)2);
        gl.glColor4f(0.0f, 0.0f, 0.0f, 0.5f);
        gl.glBegin(7);
        gl.glNormal3f(0.0f, 0.0f, -1.0f);
        gl.glVertex3f(-sideX, sideY, -sideZ);
        gl.glVertex3f(-sideX, -sideY, -sideZ);
        gl.glVertex3f(sideX, -sideY, -sideZ);
        gl.glVertex3f(sideX, sideY, -sideZ);
        gl.glEnd();
        gl.glColor4f(0.0f, 0.0f, 0.0f, 0.5f);
        gl.glBegin(7);
        gl.glNormal3f(0.0f, 0.0f, -1.0f);
        gl.glVertex3f(sideX, sideY, -sideZ);
        gl.glVertex3f(sideX, -sideY, -sideZ);
        gl.glVertex3f(-sideX, -sideY, -sideZ);
        gl.glVertex3f(-sideX, sideY, -sideZ);
        gl.glEnd();
    }

    public void renderInPlane(GL gl, float _sideX, float _sideY, float _sideZ, float width, float height, float size2, float offsetX, float offsetY) {
        float sideX = _sideX * (Renderer.WORLD_SCALE / (float)2);
        float sideY = _sideY * (Renderer.WORLD_SCALE / (float)2);
        float sideZ = _sideZ * (Renderer.WORLD_SCALE / (float)2);
        gl.glColor4f(1.0f, 1.0f, 1.0f, 1.0f);
        float offsetStretchX = offsetX / size2;
        float offsetStretchY = offsetY / size2;
        float textureStretchX = width / size2 + offsetStretchX;
        float textureStretchY = height / size2 + offsetStretchY;
        gl.glBegin(7);
        gl.glNormal3f(0.0f, 0.0f, -1.0f);
        gl.glTexCoord2f(offsetStretchY, offsetStretchX);
        gl.glVertex3f(-sideX, sideY, -sideZ);
        gl.glTexCoord2f(textureStretchY, offsetStretchX);
        gl.glVertex3f(-sideX, -sideY, -sideZ);
        gl.glTexCoord2f(textureStretchY, textureStretchX);
        gl.glVertex3f(sideX, -sideY, -sideZ);
        gl.glTexCoord2f(offsetStretchY, textureStretchX);
        gl.glVertex3f(sideX, sideY, -sideZ);
        gl.glEnd();
    }

    private TextureUtils$() {
        MODULE$ = this;
    }
}

