/*
 * Decompiled with CFR 0.152.
 */
package org.nlogo.gl.render;

import javax.media.opengl.GL;
import org.nlogo.api.Agent;
import org.nlogo.api.AgentException;
import org.nlogo.api.DrawingInterface;
import org.nlogo.api.Patch;
import org.nlogo.api.Patch3D;
import org.nlogo.api.Perspective;
import org.nlogo.api.Perspective$Follow$;
import org.nlogo.api.Perspective$Ride$;
import org.nlogo.api.Turtle;
import org.nlogo.api.Turtle3D;
import org.nlogo.api.World;
import org.nlogo.api.World3D;
import org.nlogo.gl.render.DrawingRendererInterface;
import org.nlogo.gl.render.GLViewSettings;
import org.nlogo.gl.render.LinkRenderer;
import org.nlogo.gl.render.LinkRenderer3D;
import org.nlogo.gl.render.PatchRenderer3D;
import org.nlogo.gl.render.Renderer;
import org.nlogo.gl.render.TrailRenderer3D;
import org.nlogo.gl.render.TurtleRenderer;
import org.nlogo.gl.render.TurtleRenderer3D;
import org.nlogo.gl.render.WorldRenderer;
import scala.Array$;
import scala.Predef$;
import scala.ScalaObject;
import scala.math.package$;
import scala.reflect.Manifest$;
import scala.reflect.ScalaSignature;

@ScalaSignature(bytes="\u0006\u0001\u0005Mc\u0001B\u0001\u0003\t-\u0011qbV8sY\u0012\u0014VM\u001c3fe\u0016\u00148\u0007\u0012\u0006\u0003\u0007\u0011\taA]3oI\u0016\u0014(BA\u0003\u0007\u0003\t9GN\u0003\u0002\b\u0011\u0005)a\u000e\\8h_*\t\u0011\"A\u0002pe\u001e\u001c\u0001aE\u0002\u0001\u0019A\u0001\"!\u0004\b\u000e\u0003\tI!a\u0004\u0002\u0003\u001b]{'\u000f\u001c3SK:$WM]3s!\t\tB#D\u0001\u0013\u0015\u0005\u0019\u0012!B:dC2\f\u0017BA\u000b\u0013\u0005-\u00196-\u00197b\u001f\nTWm\u0019;\t\u0011]\u0001!\u0011!Q\u0001\na\tQa^8sY\u0012\u0004\"!\u0007\u000f\u000e\u0003iQ!a\u0007\u0004\u0002\u0007\u0005\u0004\u0018.\u0003\u0002\u001e5\t9qk\u001c:mIN\"\u0005\u0002C\u0010\u0001\u0005\u0003\u0005\u000b\u0011\u0002\u0011\u0002\u001bA\fGo\u00195SK:$WM]3s!\ti\u0011%\u0003\u0002#\u0005\ty\u0001+\u0019;dQJ+g\u000eZ3sKJ\u001cD\t\u0003\u0005%\u0001\t\u0005\t\u0015!\u0003&\u0003\u001d!'/Y<j]\u001e\u0004\"!\u0007\u0014\n\u0005\u001dR\"\u0001\u0005#sC^LgnZ%oi\u0016\u0014h-Y2f\u0011!I\u0003A!A!\u0002\u0013Q\u0013A\u0004;veRdWMU3oI\u0016\u0014XM\u001d\t\u0003\u001b-J!\u0001\f\u0002\u0003!Q+(\u000f\u001e7f%\u0016tG-\u001a:feN\"\u0005\u0002\u0003\u0018\u0001\u0005\u0003\u0005\u000b\u0011B\u0018\u0002\u00191Lgn\u001b*f]\u0012,'/\u001a:\u0011\u00055\u0001\u0014BA\u0019\u0003\u00059a\u0015N\\6SK:$WM]3sg\u0011C\u0001b\r\u0001\u0003\u0002\u0003\u0006I\u0001N\u0001\tg\u0016$H/\u001b8hgB\u0011Q\"N\u0005\u0003m\t\u0011ab\u0012'WS\u0016<8+\u001a;uS:<7\u000fC\u00039\u0001\u0011\u0005\u0011(\u0001\u0004=S:LGO\u0010\u000b\bumbTHP A!\ti\u0001\u0001C\u0003\u0018o\u0001\u0007\u0001\u0004C\u0003 o\u0001\u0007\u0001\u0005C\u0003%o\u0001\u0007Q\u0005C\u0003*o\u0001\u0007!\u0006C\u0003/o\u0001\u0007q\u0006C\u00034o\u0001\u0007A\u0007C\u0003C\u0001\u0011\u00053)A\u000bde\u0016\fG/\u001a#sC^Lgn\u001a*f]\u0012,'/\u001a:\u0015\u000b\u0011;5\nT)\u0011\u00055)\u0015B\u0001$\u0003\u0005a!%/Y<j]\u001e\u0014VM\u001c3fe\u0016\u0014\u0018J\u001c;fe\u001a\f7-\u001a\u0005\u0006/\u0005\u0003\r\u0001\u0013\t\u00033%K!A\u0013\u000e\u0003\u000b]{'\u000f\u001c3\t\u000b\u0011\n\u0005\u0019A\u0013\t\u000b5\u000b\u0005\u0019\u0001(\u0002\u0011I,g\u000eZ3sKJ\u0004\"!D(\n\u0005A\u0013!A\u0004+veRdWMU3oI\u0016\u0014XM\u001d\u0005\u0006]\u0005\u0003\rA\u0015\t\u0003\u001bMK!\u0001\u0016\u0002\u0003\u00191Kgn\u001b*f]\u0012,'/\u001a:\t\u000bY\u0003A\u0011I,\u0002%=\u00147/\u001a:wKB+'o\u001d9fGRLg/\u001a\u000b\u00031n\u0003\"!E-\n\u0005i\u0013\"\u0001B+oSRDQ!B+A\u0002q\u0003\"!\u00183\u000e\u0003yS!a\u00181\u0002\r=\u0004XM\\4m\u0015\t\t'-A\u0003nK\u0012L\u0017MC\u0001d\u0003\u0015Q\u0017M^1y\u0013\t)gL\u0001\u0002H\u0019\")q\r\u0001C!Q\u0006\t\"/\u001a8eKJ\u0004\u0016\r^2i'\"\f\u0007/Z:\u0015\u000baK'n\u001c;\t\u000b\u00151\u0007\u0019\u0001/\t\u000b-4\u0007\u0019\u00017\u0002\u0019=,H\u000f\\5oK\u0006;WM\u001c;\u0011\u0005ei\u0017B\u00018\u001b\u0005\u0015\tu-\u001a8u\u0011\u0015\u0001h\r1\u0001r\u0003!1wN\u001c;TSj,\u0007CA\ts\u0013\t\u0019(CA\u0002J]RDQ!\u001e4A\u0002Y\f\u0011\u0002]1uG\"\u001c\u0016N_3\u0011\u0005E9\u0018B\u0001=\u0013\u0005\u0019!u.\u001e2mK\")!\u0010\u0001C!w\u0006Y\"/\u001a8eKJLe\u000eZ5wS\u0012,\u0018\r\u001c)bi\u000eD7\u000b[1qKN$\u0012\u0002\u0017?~\u0003\u000b\t9!!\u0003\t\u000b\u0015I\b\u0019\u0001/\t\u000byL\b\u0019A@\u0002\u000bA\fGo\u00195\u0011\u0007e\t\t!C\u0002\u0002\u0004i\u0011q\u0001U1uG\"\u001cD\tC\u0003ls\u0002\u0007A\u000eC\u0003qs\u0002\u0007\u0011\u000fC\u0003vs\u0002\u0007a\u000fC\u0004\u0002\u000e\u0001!\t%a\u0004\u0002\u0017I,g\u000eZ3s/>\u0014H\u000e\u001a\u000b\b1\u0006E\u00111CA\u000b\u0011\u0019)\u00111\u0002a\u00019\"1\u0001/a\u0003A\u0002EDa!^A\u0006\u0001\u00041\bbBA\r\u0001\u0011\u0005\u00111D\u0001\re\u0016tG-\u001a:Ue\u0006LGn\u001d\u000b\u00041\u0006u\u0001BB\u0003\u0002\u0018\u0001\u0007A\fC\u0004\u0002\"\u0001!\t%a\t\u0002%\u001d,Go\u0011:pgND\u0017-\u001b:D_>\u0014Hm]\u000b\u0003\u0003K\u0001B!EA\u0014m&\u0019\u0011\u0011\u0006\n\u0003\u000b\u0005\u0013(/Y=\t\u000f\u00055\u0002\u0001\"\u0011\u00020\u0005\u0011r-\u001a;X_JdG\rR5nK:\u001c\u0018n\u001c8t)\u0011\t\t$!\u000f\u0011\u000bE\t9#a\r\u0011\u0007E\t)$C\u0002\u00028I\u0011QA\u00127pCRDaaFA\u0016\u0001\u0004A\u0005bBA\u001f\u0001\u0011\u0005\u0013qH\u0001\nO\u0016$\b,W1oIj#B!!\n\u0002B!A\u00111IA\u001e\u0001\u0004\t)%\u0001\u0004ukJ$H.\u001a\t\u00043\u0005\u001d\u0013bAA%5\t1A+\u001e:uY\u0016Dq!!\u0014\u0001\t\u0003\ny%\u0001\bhKR|%/[3oi\u0006$\u0018n\u001c8\u0015\t\u0005\u0015\u0012\u0011\u000b\u0005\t\u0003\u0007\nY\u00051\u0001\u0002F\u0001")
public class WorldRenderer3D
extends WorldRenderer
implements ScalaObject {
    private final World3D world;
    private final PatchRenderer3D patchRenderer;
    private final GLViewSettings settings;

    public DrawingRendererInterface createDrawingRenderer(World world, DrawingInterface drawing, TurtleRenderer renderer, LinkRenderer linkRenderer) {
        return new TrailRenderer3D((World3D)world, (TurtleRenderer3D)renderer, (LinkRenderer3D)linkRenderer);
    }

    public void observePerspective(GL gl) {
        double dz;
        double dy;
        double dx;
        double roll;
        double pitch;
        double heading;
        double z;
        double y;
        double x;
        block8: {
            block7: {
                x = this.observer().oxcor() - this.world.followOffsetX();
                y = this.observer().oycor() - this.world.followOffsetY();
                z = this.observer().ozcor() - this.world.followOffsetZ();
                heading = this.observer().heading();
                pitch = this.observer().pitch();
                roll = this.observer().roll();
                dx = this.observer().dx();
                dy = this.observer().dy();
                dz = this.observer().dz();
                Perspective perspective = this.observer().perspective();
                Perspective$Follow$ perspective$Follow$ = Perspective$Follow$.MODULE$;
                if (!(perspective == null ? perspective$Follow$ != null : !perspective.equals(perspective$Follow$))) break block7;
                Perspective perspective2 = this.observer().perspective();
                Perspective$Ride$ perspective$Ride$ = Perspective$Ride$.MODULE$;
                if (perspective2 != null ? !perspective2.equals(perspective$Ride$) : perspective$Ride$ != null) break block8;
            }
            Turtle3D turtle2 = (Turtle3D)this.observer().targetAgent();
            double distance = this.observer().followDistance();
            if (distance > 0.0) {
                distance += turtle2.size();
            }
            if (this.world.worldDepth() > 1) {
                x -= turtle2.dx() * distance;
                y -= turtle2.dy() * distance;
                z -= turtle2.dz() * distance;
                pitch = -pitch;
                dx = -dx;
                dy = -dy;
            } else {
                double oldx = x;
                double oldy = y;
                double oldz = z;
                x -= distance * package$.MODULE$.sin(package$.MODULE$.toRadians(heading));
                y -= distance * package$.MODULE$.cos(package$.MODULE$.toRadians(heading));
                z = distance * 0.5;
                double exceptionResult1 = 0.0;
                try {
                    exceptionResult1 = -this.world.protractor().towardsPitch(x, y, z, oldx, oldy, oldz, false);
                }
                catch (AgentException agentException) {
                    exceptionResult1 = 0.0;
                }
                pitch = exceptionResult1;
                roll = 0.0;
            }
        }
        gl.glRotated(90.0, -1.0, 0.0, 0.0);
        gl.glRotated(heading, 0.0, 0.0, 1.0);
        gl.glRotated(pitch, package$.MODULE$.cos(package$.MODULE$.toRadians(heading)), -package$.MODULE$.sin(package$.MODULE$.toRadians(heading)), 0.0);
        gl.glRotated(-roll, -dx, -dy, dz);
        gl.glTranslated(-(x * (double)Renderer.WORLD_SCALE), -(y * (double)Renderer.WORLD_SCALE), -(z * (double)Renderer.WORLD_SCALE));
    }

    public void renderPatchShapes(GL gl, Agent outlineAgent, int fontSize, double patchSize) {
        if (this.world.patches() != null) {
            Agent agent;
            if (this.world.worldDepth() > 1) {
                this.patchRenderer.renderPatches(gl, fontSize, patchSize);
            }
            if ((agent = outlineAgent) instanceof Patch) {
                this.patchRenderer.renderOutline(gl, (Patch)agent);
            }
        }
    }

    public void renderIndividualPatchShapes(GL gl, Patch3D patch2, Agent outlineAgent, int fontSize, double patchSize) {
        if (this.world.patches() != null && this.world.worldDepth() > 1) {
            this.patchRenderer.renderIndividualPatch(gl, patch2, fontSize, patchSize);
        }
    }

    public void renderWorld(GL gl, int fontSize, double patchSize) {
        if (this.world.patches() != null) {
            if (this.world.worldDepth() == 1) {
                this.patchRenderer.renderPatchTexture(gl);
            }
            if (this.settings.wireframeOn()) {
                this.renderWorldWireFrame(gl);
            }
        }
    }

    public void renderTrails(GL gl) {
        DrawingRendererInterface drawingRendererInterface = this.drawingRenderer();
        if (drawingRendererInterface instanceof TrailRenderer3D) {
            ((TrailRenderer3D)drawingRendererInterface).renderTrails(gl);
        }
    }

    public double[] getCrosshairCoords() {
        return (double[])Array$.MODULE$.apply(Predef$.MODULE$.wrapDoubleArray(new double[]{this.observer().oxcor() - this.world.followOffsetX(), this.observer().oycor() - this.world.followOffsetY(), this.observer().ozcor() - this.world.followOffsetZ()}), Manifest$.MODULE$.Double());
    }

    public float[] getWorldDimensions(World world) {
        World3D w = (World3D)world;
        return (float[])Array$.MODULE$.apply(Predef$.MODULE$.wrapFloatArray(new float[]{w.worldWidth(), w.worldHeight(), w.worldDepth()}), Manifest$.MODULE$.Float());
    }

    public double[] getXYandZ(Turtle turtle2) {
        Turtle3D t = (Turtle3D)turtle2;
        return (double[])Array$.MODULE$.apply(Predef$.MODULE$.wrapDoubleArray(new double[]{t.xcor(), t.ycor(), t.zcor()}), Manifest$.MODULE$.Double());
    }

    public double[] getOrientation(Turtle turtle2) {
        Turtle3D t = (Turtle3D)turtle2;
        return (double[])Array$.MODULE$.apply(Predef$.MODULE$.wrapDoubleArray(new double[]{t.heading(), t.pitch(), t.roll()}), Manifest$.MODULE$.Double());
    }

    public WorldRenderer3D(World3D world, PatchRenderer3D patchRenderer, DrawingInterface drawing, TurtleRenderer3D turtleRenderer, LinkRenderer3D linkRenderer, GLViewSettings settings) {
        this.world = world;
        this.patchRenderer = patchRenderer;
        this.settings = settings;
        super(world, patchRenderer, drawing, turtleRenderer, linkRenderer, settings);
    }
}

