/*
 * Decompiled with CFR 0.152.
 */
package org.nlogo.hubnet.client;

import java.applet.AppletContext;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.TextListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.net.InetAddress;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.UnknownHostException;
import java.util.List;
import java.util.Map;
import javax.swing.JApplet;
import javax.swing.JFrame;
import org.nlogo.api.CompilerServices;
import org.nlogo.api.I18N;
import org.nlogo.api.Token;
import org.nlogo.awt.EventQueue;
import org.nlogo.awt.Hierarchy;
import org.nlogo.awt.Positioning;
import org.nlogo.editor.AbstractEditorArea;
import org.nlogo.hubnet.client.AppletEditor;
import org.nlogo.hubnet.client.ClientPanel;
import org.nlogo.hubnet.client.ErrorHandler;
import org.nlogo.hubnet.client.LoginCallback;
import org.nlogo.hubnet.client.LoginDialog;
import org.nlogo.hubnet.connection.Ports;
import org.nlogo.swing.ModalProgressTask;
import org.nlogo.swing.OptionDialog;
import org.nlogo.window.AppletAdPanel;
import org.nlogo.window.EditorFactory;
import org.nlogo.window.VMCheck;
import scala.Option;

public strictfp class ClientApplet
extends JApplet
implements ErrorHandler {
    private ClientPanel clientPanel;
    private LoginDialog loginDialog;
    private boolean attemptLogin = true;
    private JFrame appFrame = null;

    public void init() {
        VMCheck.detectBadJVMs();
        EventQueue.invokeLater(new Runnable(){

            public void run() {
                ClientApplet.this.setBackground(Color.white);
                ClientApplet.this.getContentPane().setBackground(Color.white);
                EditorFactory editorFactory = new EditorFactory(){

                    public AbstractEditorArea newEditor(int cols, int rows, boolean disableFocusTraversal) {
                        return this.newEditor(cols, rows, disableFocusTraversal, null);
                    }

                    AbstractEditorArea newEditor(int cols, int rows, boolean disableFocusTraversal, TextListener listener) {
                        return new AppletEditor(rows, cols, disableFocusTraversal);
                    }
                };
                ClientApplet.this.clientPanel = new ClientPanel(editorFactory, ClientApplet.this, new DummyCompilerServices());
                ClientApplet.this.clientPanel.setBackground(Color.white);
                GridBagLayout gridbag = new GridBagLayout();
                GridBagConstraints c = new GridBagConstraints();
                ClientApplet.this.setLayout(gridbag);
                c.gridwidth = 1;
                c.gridheight = 2;
                c.weighty = 1.0;
                gridbag.setConstraints(ClientApplet.this.clientPanel, c);
                ClientApplet.this.add(ClientApplet.this.clientPanel);
                AppletAdPanel panel = new AppletAdPanel(new MouseAdapter(){

                    public void mouseClicked(MouseEvent e) {
                        try {
                            AppletContext context = ClientApplet.this.getAppletContext();
                            context.showDocument(new URL("http://ccl.northwestern.edu/netlogo/"), "_blank");
                        }
                        catch (MalformedURLException ex) {
                            throw new IllegalStateException();
                        }
                    }
                });
                c.anchor = 15;
                gridbag.setConstraints(panel, c);
                ClientApplet.this.add(panel);
                ClientApplet.this.attemptLogin = true;
                ClientApplet.this.go(ClientApplet.this.getDocumentBase().getHost(), true);
            }
        });
    }

    public void start() {
        this.clientPanel.setDisplayOn(true);
    }

    public void stop() {
        this.clientPanel.setDisplayOn(false);
    }

    public void go(final String server, final boolean isApplet) {
        EventQueue.invokeLater(new Runnable(){

            public void run() {
                ClientApplet.this.loginDialog = new LoginDialog(new Frame(), "", server, Ports.DEFAULT_PORT_NUMBER(), isApplet);
                ClientApplet.this.loginDialog.addWindowListener(new WindowAdapter(){

                    public void windowClosing(WindowEvent e) {
                        ClientApplet.this.clientPanel.logout();
                        ClientApplet.this.attemptLogin = false;
                        ClientApplet.this.loginDialog.setVisible(false);
                        if (!isApplet) {
                            System.exit(0);
                        }
                    }
                });
                Positioning.center(ClientApplet.this.loginDialog, null);
                ClientApplet.this.doLogin();
            }
        });
    }

    private void doLogin() {
        if (this.attemptLogin && !this.loginDialog.isVisible()) {
            this.loginDialog.go(new LoginCallback(){

                public void apply(String user, String host, int port) {
                    if (ClientApplet.this.attemptLogin) {
                        ClientApplet.this.login(ClientApplet.this.loginDialog.username(), ClientApplet.this.loginDialog.server(), ClientApplet.this.loginDialog.port());
                    }
                }
            });
        }
    }

    private void login(final String userid, final String hostip, final int port) {
        final String[] error = new String[1];
        ModalProgressTask.apply(Hierarchy.getFrame(this), "Entering...", new Runnable(){

            public void run() {
                Option<String> e = ClientApplet.this.clientPanel.login(userid, hostip, port);
                if (e.isDefined()) {
                    error[0] = e.get();
                }
                ClientApplet.this.clientPanel.requestFocus();
                ClientApplet.this.loginDialog.setVisible(false);
            }
        });
        if (error[0] != null) {
            this.clientPanel.disconnect(error[0]);
            this.handleLoginFailure(error[0]);
        }
    }

    public void destroy() {
        EventQueue.invokeLater(new Runnable(){

            public void run() {
                ClientApplet.this.attemptLogin = false;
                ClientApplet.this.clientPanel.logout();
            }
        });
    }

    public void handleLoginFailure(final String errorMessage) {
        EventQueue.mustBeEventDispatchThread();
        EventQueue.invokeLater(new Runnable(){

            public void run() {
                OptionDialog.show(ClientApplet.this, "Login Failed", errorMessage, new String[]{I18N.guiJ().get("common.buttons.ok")});
            }
        });
    }

    public void handleDisconnect(final String activityName, boolean connected, final String reason) {
        EventQueue.mustBeEventDispatchThread();
        if (connected) {
            EventQueue.invokeLater(new Runnable(){

                public void run() {
                    Object[] ok = new String[]{I18N.guiJ().get("common.buttons.ok")};
                    OptionDialog.show(ClientApplet.this, "", "You have been disconnected from " + activityName + ".\nReason: " + reason, ok);
                }
            });
        }
        this.doLogin();
    }

    public void completeLogin() {
        if (this.appFrame != null) {
            this.appFrame.pack();
            this.appFrame.setVisible(true);
        }
    }

    public static void main(String[] args) {
        System.setProperty("apple.awt.graphics.UseQuartz", "true");
        System.setProperty("apple.awt.showGrowBox", "true");
        VMCheck.detectBadJVMs();
        EventQueue.invokeLater(new Runnable(){

            public void run() {
                final ClientApplet applet2 = new ClientApplet();
                applet2.appFrame = new JFrame("HubNet Client");
                applet2.appFrame.setResizable(false);
                applet2.appFrame.addWindowListener(new WindowAdapter(){

                    public void windowClosing(WindowEvent e) {
                        applet2.stop();
                        System.exit(0);
                    }
                });
                applet2.appFrame.getContentPane().setLayout(new BorderLayout());
                applet2.appFrame.getContentPane().add((Component)applet2, "Center");
                applet2.init();
                applet2.appFrame.pack();
                String host = "";
                try {
                    host = InetAddress.getLocalHost().getHostAddress().toString();
                }
                catch (UnknownHostException ex) {
                    host = "";
                }
                applet2.go(host, false);
            }
        });
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public strictfp class DummyCompilerServices
    implements CompilerServices {
        @Override
        public String autoConvert(String source2, boolean subprogram, boolean reporter, String modelVersion) {
            return source2;
        }

        @Override
        public Object readNumberFromString(String source2) {
            return source2;
        }

        @Override
        public void checkReporterSyntax(String source2) {
        }

        @Override
        public void checkCommandSyntax(String source2) {
        }

        @Override
        public Object readFromString(String source2) {
            return source2;
        }

        @Override
        public boolean isReporter(String s) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean isValidIdentifier(String s) {
            return true;
        }

        @Override
        public boolean isConstant(String s) {
            throw new UnsupportedOperationException();
        }

        @Override
        public Token[] tokenizeForColorization(String s) {
            throw new UnsupportedOperationException();
        }

        @Override
        public Token getTokenAtPosition(String s, int pos) {
            throw new UnsupportedOperationException();
        }

        @Override
        public Map<String, List<Object>> findProcedurePositions(String source2) {
            throw new UnsupportedOperationException();
        }
    }
}

