/*
 * Decompiled with CFR 0.152.
 */
package org.nlogo.hubnet.mirroring;

import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import org.nlogo.api.Link;
import org.nlogo.api.Patch;
import org.nlogo.api.Turtle;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public strictfp class Agent {
    static final long serialVersionUID = 0L;
    final long id;
    final AgentType type;

    public Agent(long id, Class<? extends org.nlogo.api.Agent> agentClass) {
        this.id = id;
        this.type = AgentType.fromAgentClass(agentClass);
    }

    public Agent(DataInputStream is) {
        try {
            this.id = is.readLong();
            this.type = AgentType.fromInt(is.readInt());
        }
        catch (IOException e) {
            throw new IllegalStateException();
        }
    }

    void serialize(DataOutputStream os) throws IOException {
        os.writeLong(this.id);
        os.writeInt(this.type.toInt());
    }

    public byte[] toByteArray() {
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        try {
            this.serialize(new DataOutputStream(bos));
        }
        catch (IOException e) {
            throw new IllegalStateException(e);
        }
        return bos.toByteArray();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public strictfp static enum AgentType {
        TURTLE,
        PATCH,
        LINK,
        OBSERVER;


        public int toInt() {
            switch (this) {
                case TURTLE: {
                    return 0;
                }
                case PATCH: {
                    return 1;
                }
                case LINK: {
                    return 2;
                }
                case OBSERVER: {
                    return 3;
                }
            }
            throw new IllegalStateException();
        }

        public static AgentType fromAgentClass(Class<? extends org.nlogo.api.Agent> agentClass) {
            if (agentClass == null) {
                return OBSERVER;
            }
            if (Turtle.class.isAssignableFrom(agentClass)) {
                return TURTLE;
            }
            if (Patch.class.isAssignableFrom(agentClass)) {
                return PATCH;
            }
            if (Link.class.isAssignableFrom(agentClass)) {
                return LINK;
            }
            return OBSERVER;
        }

        public static AgentType fromInt(int type) {
            switch (type) {
                case 0: {
                    return TURTLE;
                }
                case 1: {
                    return PATCH;
                }
                case 2: {
                    return LINK;
                }
                case 3: {
                    return OBSERVER;
                }
            }
            throw new IllegalStateException();
        }
    }
}

