/*
 * Decompiled with CFR 0.152.
 */
package org.nlogo.hubnet.mirroring;

import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.ByteArrayOutputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import javax.imageio.ImageIO;
import org.nlogo.api.Agent;
import org.nlogo.api.Link;
import org.nlogo.api.Patch;
import org.nlogo.api.Turtle;
import org.nlogo.api.World;
import org.nlogo.api.WorldPropertiesInterface;
import org.nlogo.hubnet.mirroring.AgentPerspective;
import org.nlogo.hubnet.mirroring.ClientWorld;
import org.nlogo.hubnet.mirroring.DiffBuffer;
import org.nlogo.hubnet.mirroring.LinkData;
import org.nlogo.hubnet.mirroring.PatchData;
import org.nlogo.hubnet.mirroring.TurtleData;

public strictfp class ServerWorld {
    private final WorldPropertiesInterface settings;
    private Map<Double, TurtleData> turtles;
    private final Map<Double, PatchData> patches;
    private Map<ClientWorld.LinkKey, LinkData> links;
    private int minPxcor;
    private int minPycor;
    private int maxPxcor;
    private int maxPycor;
    private int fontSize;
    private boolean xWrap;
    private boolean yWrap;
    private AgentPerspective perspective = new AgentPerspective(null, 0L, 0, -1.0, true);
    private boolean shapes;
    private BufferedImage drawing = null;

    public ServerWorld(WorldPropertiesInterface settings) {
        this.settings = settings;
        this.turtles = new HashMap<Double, TurtleData>();
        this.patches = new HashMap<Double, PatchData>();
        this.links = new HashMap<ClientWorld.LinkKey, LinkData>();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized DiffBuffer updateWorld(World world, boolean resetWorld) {
        DiffBuffer buf = new DiffBuffer();
        World world2 = world;
        synchronized (world2) {
            this.updateGeneral(world, buf);
            this.updatePatches(world, buf);
            this.updateTurtles(world, buf);
            this.updateLinks(world, buf);
            this.updateDrawing(world, buf, resetWorld);
        }
        return buf;
    }

    private void updateGeneral(World world, DiffBuffer buf) {
        if (this.minPxcor != world.minPxcor()) {
            this.minPxcor = world.minPxcor();
            buf.addMinX(this.minPxcor);
        }
        if (this.minPycor != world.minPycor()) {
            this.minPycor = world.minPycor();
            buf.addMinY(this.minPycor);
        }
        if (this.maxPxcor != world.maxPxcor()) {
            this.maxPxcor = world.maxPxcor();
            buf.addMaxX(this.maxPxcor);
        }
        if (this.maxPycor != world.maxPycor()) {
            this.maxPycor = world.maxPycor();
            buf.addMaxY(this.maxPycor);
        }
        if (this.fontSize != this.settings.fontSize()) {
            this.fontSize = this.settings.fontSize();
            buf.addFontSize(this.fontSize);
        }
        if (this.xWrap != world.wrappingAllowedInX()) {
            this.xWrap = world.wrappingAllowedInX();
            buf.addWrapX(this.xWrap);
        }
        if (this.yWrap != world.wrappingAllowedInY()) {
            this.yWrap = world.wrappingAllowedInY();
            buf.addWrapY(this.yWrap);
        }
        if (!this.perspective.equals(world.observer().targetAgent(), world.observer().perspective())) {
            this.perspective = new AgentPerspective(world.observer().targetAgent(), world.observer().perspective(), (world.worldWidth() - 1) / 2, true);
            buf.addPerspective(this.perspective);
        }
    }

    private void updatePatches(World world, DiffBuffer buf) {
        for (Agent a : world.patches().agents()) {
            PatchData diffs = this.updatePatch((Patch)a);
            if (diffs == null) continue;
            buf.addPatch(diffs);
        }
    }

    private void updateTurtles(World world, DiffBuffer buf) {
        HashMap<Double, TurtleData> newTurtles = new HashMap<Double, TurtleData>();
        for (Agent a : world.turtles().agents()) {
            Turtle turtle2 = (Turtle)a;
            TurtleData diffs = this.updateTurtle(turtle2);
            if (diffs != null) {
                buf.addTurtle(diffs);
            }
            TurtleData tmp = this.turtles.remove(turtle2.id());
            newTurtles.put(Double.valueOf(turtle2.id()), tmp);
        }
        for (TurtleData turtle3 : this.turtles.values()) {
            buf.addTurtle(new TurtleData(turtle3.id()));
        }
        this.turtles = newTurtles;
    }

    private void updateLinks(World world, DiffBuffer buf) {
        HashMap<ClientWorld.LinkKey, LinkData> newLinks = new HashMap<ClientWorld.LinkKey, LinkData>();
        for (Agent a : world.links().agents()) {
            Link link = (Link)a;
            LinkData diffs = this.updateLink(link);
            if (diffs != null) {
                buf.addLink(diffs);
            }
            ClientWorld.LinkKey key = new ClientWorld.LinkKey(link.id(), link.end1().id(), link.end2().id(), link.getBreedIndex());
            LinkData tmp = this.links.remove(key);
            newLinks.put(key, tmp);
        }
        for (LinkData data : this.links.values()) {
            buf.addLink(new LinkData(data.id));
        }
        this.links = newLinks;
    }

    private PatchData updatePatch(Patch patch2) {
        PatchData pd = new PatchData(patch2.id(), 31, patch2.pxcor(), patch2.pycor(), patch2.pcolor(), patch2.labelString(), patch2.labelColor());
        PatchData bufPatch = this.patches.get(patch2.id());
        if (bufPatch == null) {
            this.patches.put(Double.valueOf(patch2.id()), pd);
            return pd;
        }
        this.patches.put(Double.valueOf(patch2.id()), pd);
        return bufPatch.updateFrom(pd);
    }

    private TurtleData updateTurtle(Turtle turtle2) {
        TurtleData td = new TurtleData(turtle2.id(), 2047, turtle2.xcor(), turtle2.ycor(), turtle2.shape(), turtle2.color(), turtle2.heading(), turtle2.size(), turtle2.hidden(), turtle2.labelString(), turtle2.labelColor(), turtle2.getBreedIndex(), turtle2.lineThickness());
        TurtleData bufTurtle = this.turtles.get(turtle2.id());
        if (bufTurtle == null) {
            this.turtles.put(Double.valueOf(turtle2.id()), td);
            return td;
        }
        return bufTurtle.updateFrom(td);
    }

    private LinkData updateLink(Link link) {
        LinkData data = new LinkData(link.id(), link.end1().id(), link.end2().id(), Short.MAX_VALUE, link.x1(), link.y1(), link.x2(), link.y2(), link.shape(), link.color(), link.hidden(), link.labelString(), link.labelColor(), link.lineThickness(), link.isDirectedLink(), link.isDirectedLink() ? link.linkDestinationSize() : 1.0, link.heading(), link.size(), link.getBreedIndex());
        LinkData bufLink = this.links.get(data.getKey());
        if (bufLink == null) {
            this.links.put(data.getKey(), data);
            return data;
        }
        return bufLink.updateFrom(data);
    }

    private void updateDrawing(World world, DiffBuffer buf, boolean resetWorld) {
        Object obj = world.getDrawing();
        if (obj instanceof BufferedImage) {
            this.drawing = (BufferedImage)obj;
            if (this.drawing != null && (world.sendPixels() || resetWorld)) {
                buf.addDrawing(this.drawing);
                world.markDrawingClean();
            }
        }
    }

    private void serialize(DataOutputStream os) throws IOException {
        int mask = 7679;
        if (this.drawing != null) {
            mask = (short)(mask | 0x200);
        }
        os.writeShort(mask);
        os.writeInt(this.minPxcor);
        os.writeInt(this.minPycor);
        os.writeInt(this.maxPxcor);
        os.writeInt(this.maxPycor);
        os.writeBoolean(this.shapes);
        os.writeInt(this.fontSize);
        os.writeBoolean(this.xWrap);
        os.writeBoolean(this.yWrap);
        this.perspective.serialize(os);
        os.writeInt(this.patches.size());
        for (PatchData patch2 : this.patches.values()) {
            patch2.serialize(os);
        }
        os.writeInt(this.turtles.size());
        for (TurtleData turtle2 : this.turtles.values()) {
            turtle2.serialize(os);
        }
        os.writeInt(this.links.size());
        for (LinkData link : this.links.values()) {
            link.serialize(os);
        }
        if (this.drawing != null) {
            ImageIO.write((RenderedImage)this.drawing, "PNG", os);
        }
    }

    public synchronized byte[] toByteArray() {
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        try {
            this.serialize(new DataOutputStream(bos));
        }
        catch (IOException e) {
            throw new IllegalStateException(e);
        }
        return bos.toByteArray();
    }
}

