/*
 * Decompiled with CFR 0.152.
 */
package org.nlogo.hubnet.server;

import java.io.IOException;
import java.net.DatagramPacket;
import java.net.InetAddress;
import java.net.MulticastSocket;
import java.net.UnknownHostException;
import java.util.Date;
import org.nlogo.hubnet.protocol.DiscoveryMessage;
import org.nlogo.hubnet.protocol.DiscoveryMessage$;
import org.nlogo.hubnet.server.HubNetUtils$;
import org.nlogo.util.Exceptions$;
import scala.ScalaObject;
import scala.UninitializedFieldError;
import scala.collection.mutable.StringBuilder;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0001Y3A!\u0001\u0002\u0001\u0017\t\u0011B)[:d_Z,'/_!o]>,hnY3s\u0015\t\u0019A!\u0001\u0004tKJ4XM\u001d\u0006\u0003\u000b\u0019\ta\u0001[;c]\u0016$(BA\u0004\t\u0003\u0015qGn\\4p\u0015\u0005I\u0011aA8sO\u000e\u00011c\u0001\u0001\r)A\u0011QBE\u0007\u0002\u001d)\u0011q\u0002E\u0001\u0005Y\u0006twMC\u0001\u0012\u0003\u0011Q\u0017M^1\n\u0005Mq!A\u0002+ie\u0016\fG\r\u0005\u0002\u001615\taCC\u0001\u0018\u0003\u0015\u00198-\u00197b\u0013\tIbCA\u0006TG\u0006d\u0017m\u00142kK\u000e$\b\u0002C\u000e\u0001\u0005\u0003\u0005\u000b\u0011\u0002\u000f\u0002\u0011Ut\u0017.];f\u0013\u0012\u0004\"!\b\u0011\u000f\u0005Uq\u0012BA\u0010\u0017\u0003\u0019\u0001&/\u001a3fM&\u0011\u0011E\t\u0002\u0007'R\u0014\u0018N\\4\u000b\u0005}1\u0002\u0002\u0003\u0013\u0001\u0005\u0003\u0005\u000b\u0011\u0002\u000f\u0002\u00135|G-\u001a7OC6,\u0007\u0002\u0003\u0014\u0001\u0005\u0003\u0005\u000b\u0011B\u0014\u0002\u0015A|'\u000f\u001e(v[\n,'\u000f\u0005\u0002\u0016Q%\u0011\u0011F\u0006\u0002\u0004\u0013:$\b\"B\u0016\u0001\t\u0003a\u0013A\u0002\u001fj]&$h\b\u0006\u0003._A\n\u0004C\u0001\u0018\u0001\u001b\u0005\u0011\u0001\"B\u000e+\u0001\u0004a\u0002\"\u0002\u0013+\u0001\u0004a\u0002\"\u0002\u0014+\u0001\u00049\u0003bB\u001a\u0001\u0005\u0004%I\u0001N\u0001\b[\u0016\u001c8/Y4f+\u0005)\u0004C\u0001\u001c:\u001b\u00059$B\u0001\u001d\u0005\u0003!\u0001(o\u001c;pG>d\u0017B\u0001\u001e8\u0005A!\u0015n]2pm\u0016\u0014\u00180T3tg\u0006<W\r\u0003\u0004=\u0001\u0001\u0006I!N\u0001\t[\u0016\u001c8/Y4fA!9a\b\u0001a\u0001\n\u0013y\u0014!C:i_VdGMU;o+\u0005\u0001\u0005CA\u000bB\u0013\t\u0011eCA\u0004C_>dW-\u00198\t\u000f\u0011\u0003\u0001\u0019!C\u0005\u000b\u0006i1\u000f[8vY\u0012\u0014VO\\0%KF$\"AR%\u0011\u0005U9\u0015B\u0001%\u0017\u0005\u0011)f.\u001b;\t\u000f)\u001b\u0015\u0011!a\u0001\u0001\u0006\u0019\u0001\u0010J\u0019\t\r1\u0003\u0001\u0015)\u0003A\u0003)\u0019\bn\\;mIJ+h\u000e\t\u0015\u0003\u0017:\u0003\"!F(\n\u0005A3\"\u0001\u0003<pY\u0006$\u0018\u000e\\3\t\u000bI\u0003A\u0011A*\u0002\u0011MDW\u000f\u001e3po:$\u0012A\u0012\u0005\u0006+\u0002!\teU\u0001\u0004eVt\u0007")
public class DiscoveryAnnouncer
extends Thread
implements ScalaObject {
    private final DiscoveryMessage message;
    private volatile boolean shouldRun;
    private volatile int bitmap$init$0;

    private DiscoveryMessage message() {
        if ((this.bitmap$init$0 & 1) != 0) {
            return this.message;
        }
        throw new UninitializedFieldError("Uninitialized field: DiscoveryAnnouncer.scala: 17".toString());
    }

    private boolean shouldRun() {
        if ((this.bitmap$init$0 & 2) != 0) {
            return this.shouldRun;
        }
        throw new UninitializedFieldError("Uninitialized field: DiscoveryAnnouncer.scala: 18".toString());
    }

    private void shouldRun_$eq(boolean bl) {
        this.shouldRun = bl;
        this.bitmap$init$0 |= 2;
    }

    public void shutdown() {
        this.shouldRun_$eq(false);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void run() {
        MulticastSocket exceptionResult2;
        InetAddress group;
        InetAddress exceptionResult1 = null;
        try {
            group = exceptionResult1 = InetAddress.getByName(HubNetUtils$.MODULE$.SERVER_DISCOVERY_MULTICAST_GROUP());
            exceptionResult2 = null;
        }
        catch (UnknownHostException unknownHostException) {
            this.dump$1(new StringBuilder().append((Object)"could not map the multicast group ").append((Object)HubNetUtils$.MODULE$.SERVER_DISCOVERY_MULTICAST_GROUP()).append((Object)" to an InetAddress").toString(), unknownHostException);
            return;
        }
        try {}
        catch (IOException iOException) {
            this.dump$1(new StringBuilder().append((Object)"Error creating multicast socket to port ").append(BoxesRunTime.boxToInteger(HubNetUtils$.MODULE$.SERVER_DISCOVERY_MULTICAST_PORT())).toString(), iOException);
            return;
        }
        MulticastSocket multicastSocket = exceptionResult2 = new MulticastSocket(HubNetUtils$.MODULE$.SERVER_DISCOVERY_MULTICAST_PORT());
        while (this.shouldRun()) {
            byte[] messageBytes = this.message().toByteArray();
            try {
                multicastSocket.setTimeToLive(63);
                multicastSocket.send(new DatagramPacket(messageBytes, messageBytes.length, group, HubNetUtils$.MODULE$.SERVER_DISCOVERY_MULTICAST_PORT()));
            }
            catch (IOException iOException) {
                this.dump$1("Could not transmit multicast announcement.", iOException);
            }
            try {}
            catch (InterruptedException interruptedException) {
                this.dump$1("Multicast announcement thread interrupted.\n\t", interruptedException);
                continue;
            }
            Thread.sleep(HubNetUtils$.MODULE$.SERVER_DISCOVERY_ANNOUNCE_INTERVAL());
        }
        try {
            multicastSocket.close();
            return;
        }
        catch (RuntimeException runtimeException) {
            Exceptions$.MODULE$.ignore(runtimeException);
        }
    }

    private final void dump$1(String err, Exception ex) {
        System.err.println(new StringBuilder().append((Object)"@ ").append(new Date()).append((Object)" : ").toString());
        System.err.println(new StringBuilder().append((Object)"Error: ").append((Object)err).append((Object)"\n\t").append(ex).toString());
    }

    public DiscoveryAnnouncer(String uniqueId, String modelName, int portNumber) {
        this.message = DiscoveryMessage$.MODULE$.apply(uniqueId, modelName, portNumber);
        this.bitmap$init$0 |= 1;
        this.shouldRun = true;
        this.bitmap$init$0 |= 2;
    }
}

