/*
 * Decompiled with CFR 0.152.
 */
package org.nlogo.lex;

import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.Serializable;
import org.nlogo.api.NumberParser;
import org.nlogo.api.StringUtils;
import org.nlogo.api.Token;
import org.nlogo.api.TokenHolder;
import org.nlogo.api.TokenType;
import org.nlogo.lex.TokenMapper;
import scala.Either;

class TokenLexer {
    public static final int YYEOF = -1;
    private static final int ZZ_BUFFERSIZE = 16384;
    public static final int LITERAL = 4;
    public static final int YYINITIAL = 0;
    public static final int MAGIC_OPEN = 2;
    private static final int[] ZZ_LEXSTATE = new int[]{0, 0, 1, 1, 2, 2};
    private static final String ZZ_CMAP_PACKED = "\b\u0000\u0002\u0005\u0001\u0006\u0002\u0000\u0001\u0004\u0012\u0000\u0001\u0005\u0001\u0003\u0001\u0002\u0005\u0003\u0001\r\u0001\u000e\u0002\u0003\u0001\n\u0001\u0010\u0001\u0011\u0001\u0003\n\u0012\u0001\u0003\u0001\u000f\u0004\u0003\u0001\u0000\u001a\u0003\u0001\u000b\u0001\u0001\u0001\f\u0001\u0003\u0001\u0007\u0001\u0000\r\u0003\u0001\u0003\u0003\u0003\u0001\u0003\u0001\u0003\u0001\u0003\u0006\u0003\u0001\b\u0001\u0000\u0001\t,\u0000\u0001\u0003\n\u0000\u0001\u0003\u0004\u0000\u0001\u0003\u0005\u0000\u0017\u0003\u0001\u0000\u001f\u0003\u0001\u0000\u013f\u0003\u0019\u0000r\u0003\u0004\u0000\f\u0003\u000e\u0000\u0005\u0003\t\u0000\u0001\u0003\u008b\u0000\u0001\u0003\u000b\u0000\u0001\u0003\u0001\u0000\u0003\u0003\u0001\u0000\u0001\u0003\u0001\u0000\u0014\u0003\u0001\u0000,\u0003\u0001\u0000&\u0003\u0001\u0000\u0005\u0003\u0004\u0000\u0082\u0003\b\u0000E\u0003\u0001\u0000&\u0003\u0002\u0000\u0002\u0003\u0006\u0000\u0010\u0003!\u0000&\u0003\u0002\u0000\u0001\u0003\u0007\u0000'\u0003H\u0000\u001b\u0003\u0005\u0000\u0003\u0003.\u0000\u001a\u0003\u0005\u0000\u000b\u0003\u0015\u0000\n\u0003\u0004\u0000\u0002\u0003\u0001\u0000c\u0003\u0001\u0000\u0001\u0003\u000f\u0000\u0002\u0003\u0007\u0000\u0002\u0003\n\u0003\u0003\u0003\u0002\u0000\u0001\u0003\u0010\u0000\u0001\u0003\u0001\u0000\u001e\u0003\u001d\u0000\u0003\u00030\u0000&\u0003\u000b\u0000\u0001\u0003\u0152\u00006\u0003\u0003\u0000\u0001\u0003\u0012\u0000\u0001\u0003\u0007\u0000\n\u0003\u0004\u0000\n\u0003\u0015\u0000\b\u0003\u0002\u0000\u0002\u0003\u0002\u0000\u0016\u0003\u0001\u0000\u0007\u0003\u0001\u0000\u0001\u0003\u0003\u0000\u0004\u0003\u0003\u0000\u0001\u0003\u001e\u0000\u0002\u0003\u0001\u0000\u0003\u0003\u0004\u0000\n\u0003\u0002\u0003\u0013\u0000\u0006\u0003\u0004\u0000\u0002\u0003\u0002\u0000\u0016\u0003\u0001\u0000\u0007\u0003\u0001\u0000\u0002\u0003\u0001\u0000\u0002\u0003\u0001\u0000\u0002\u0003\u001f\u0000\u0004\u0003\u0001\u0000\u0001\u0003\u0007\u0000\n\u0003\u0002\u0000\u0003\u0003\u0010\u0000\t\u0003\u0001\u0000\u0003\u0003\u0001\u0000\u0016\u0003\u0001\u0000\u0007\u0003\u0001\u0000\u0002\u0003\u0001\u0000\u0005\u0003\u0003\u0000\u0001\u0003\u0012\u0000\u0001\u0003\u000f\u0000\u0002\u0003\u0004\u0000\n\u0003\u0015\u0000\b\u0003\u0002\u0000\u0002\u0003\u0002\u0000\u0016\u0003\u0001\u0000\u0007\u0003\u0001\u0000\u0002\u0003\u0001\u0000\u0005\u0003\u0003\u0000\u0001\u0003\u001e\u0000\u0002\u0003\u0001\u0000\u0003\u0003\u0004\u0000\n\u0003\u0001\u0000\u0001\u0003\u0011\u0000\u0001\u0003\u0001\u0000\u0006\u0003\u0003\u0000\u0003\u0003\u0001\u0000\u0004\u0003\u0003\u0000\u0002\u0003\u0001\u0000\u0001\u0003\u0001\u0000\u0002\u0003\u0003\u0000\u0002\u0003\u0003\u0000\u0003\u0003\u0003\u0000\b\u0003\u0001\u0000\u0003\u0003-\u0000\t\u0003\u0015\u0000\b\u0003\u0001\u0000\u0003\u0003\u0001\u0000\u0017\u0003\u0001\u0000\n\u0003\u0001\u0000\u0005\u0003&\u0000\u0002\u0003\u0004\u0000\n\u0003\u0015\u0000\b\u0003\u0001\u0000\u0003\u0003\u0001\u0000\u0017\u0003\u0001\u0000\n\u0003\u0001\u0000\u0005\u0003\u0003\u0000\u0001\u0003 \u0000\u0001\u0003\u0001\u0000\u0002\u0003\u0004\u0000\n\u0003\u0015\u0000\b\u0003\u0001\u0000\u0003\u0003\u0001\u0000\u0017\u0003\u0001\u0000\u0010\u0003&\u0000\u0002\u0003\u0004\u0000\n\u0003\u0015\u0000\u0012\u0003\u0003\u0000\u0018\u0003\u0001\u0000\t\u0003\u0001\u0000\u0001\u0003\u0002\u0000\u0007\u0003:\u00000\u0003\u0001\u0000\u0002\u0003\f\u0000\u0007\u0003\t\u0000\n\u0003'\u0000\u0002\u0003\u0001\u0000\u0001\u0003\u0002\u0000\u0002\u0003\u0001\u0000\u0001\u0003\u0002\u0000\u0001\u0003\u0006\u0000\u0004\u0003\u0001\u0000\u0007\u0003\u0001\u0000\u0003\u0003\u0001\u0000\u0001\u0003\u0001\u0000\u0001\u0003\u0002\u0000\u0002\u0003\u0001\u0000\u0004\u0003\u0001\u0000\u0002\u0003\t\u0000\u0001\u0003\u0002\u0000\u0005\u0003\u0001\u0000\u0001\u0003\t\u0000\n\u0003\u0002\u0000\u0002\u0003\"\u0000\u0001\u0003\u001f\u0000\n\u0003\u0016\u0000\b\u0003\u0001\u0000\"\u0003\u001d\u0000\u0004\u0003t\u0000\"\u0003\u0001\u0000\u0005\u0003\u0001\u0000\u0002\u0003\u0015\u0000\n\u0003\u0006\u0000\u0006\u0003J\u0000&\u0003\n\u0000)\u0003\u0007\u0000Z\u0003\u0005\u0000D\u0003\u0005\u0000R\u0003\u0006\u0000\u0007\u0003\u0001\u0000?\u0003\u0001\u0000\u0001\u0003\u0001\u0000\u0004\u0003\u0002\u0000\u0007\u0003\u0001\u0000\u0001\u0003\u0001\u0000\u0004\u0003\u0002\u0000'\u0003\u0001\u0000\u0001\u0003\u0001\u0000\u0004\u0003\u0002\u0000\u001f\u0003\u0001\u0000\u0001\u0003\u0001\u0000\u0004\u0003\u0002\u0000\u0007\u0003\u0001\u0000\u0001\u0003\u0001\u0000\u0004\u0003\u0002\u0000\u0007\u0003\u0001\u0000\u0007\u0003\u0001\u0000\u0017\u0003\u0001\u0000\u001f\u0003\u0001\u0000\u0001\u0003\u0001\u0000\u0004\u0003\u0002\u0000\u0007\u0003\u0001\u0000'\u0003\u0001\u0000\u0013\u0003\u000e\u0000\t\u0003.\u0000U\u0003\f\u0000\u026c\u0003\u0002\u0000\b\u0003\n\u0000\u001a\u0003\u0005\u0000K\u0003\u0015\u0000\r\u0003\u0001\u0000\u0004\u0003\u000e\u0000\u0012\u0003\u000e\u0000\u0012\u0003\u000e\u0000\r\u0003\u0001\u0000\u0003\u0003\u000f\u00004\u0003#\u0000\u0001\u0003\u0004\u0000\u0001\u0003\u0003\u0000\n\u0003&\u0000\n\u0003\u0006\u0000X\u0003\b\u0000)\u0003W\u0000\u001d\u0003)\u0000\n\u0003\u001e\u0003\u0002\u0000\u0005\u0003\u038b\u0000l\u0003\u0094\u0000\u009c\u0003\u0004\u0000Z\u0003\u0006\u0000\u0016\u0003\u0002\u0000\u0006\u0003\u0002\u0000&\u0003\u0002\u0000\u0006\u0003\u0002\u0000\b\u0003\u0001\u0000\u0001\u0003\u0001\u0000\u0001\u0003\u0001\u0000\u0001\u0003\u0001\u0000\u001f\u0003\u0002\u00005\u0003\u0001\u0000\u0007\u0003\u0001\u0000\u0001\u0003\u0003\u0000\u0003\u0003\u0001\u0000\u0007\u0003\u0003\u0000\u0004\u0003\u0002\u0000\u0006\u0003\u0004\u0000\r\u0003\u0005\u0000\u0003\u0003\u0001\u0000\u0007\u0003t\u0000\u0001\u0003\r\u0000\u0001\u0003\u0082\u0000\u0001\u0003\u0004\u0000\u0001\u0003\u0002\u0000\n\u0003\u0001\u0000\u0001\u0003\u0003\u0000\u0005\u0003\u0006\u0000\u0001\u0003\u0001\u0000\u0001\u0003\u0001\u0000\u0001\u0003\u0001\u0000\u0004\u0003\u0001\u0000\u0003\u0003\u0001\u0000\u0007\u0003\u0003\u0000\u0003\u0003\u0005\u0000\u0005\u0003\u0ebb\u0000\u0002\u0003*\u0000\u0005\u0003\u0005\u0000\u0002\u0003\u0004\u0000V\u0003\u0006\u0000\u0003\u0003\u0001\u0000Z\u0003\u0001\u0000\u0004\u0003\u0005\u0000(\u0003\u0004\u0000^\u0003\u0011\u0000\u0018\u00038\u0000\u0010\u0003\u0200\u0000\u19b6\u0003J\u0000\u51a6\u0003Z\u0000\u048d\u0003\u0773\u0000\u2ba4\u0003\u215c\u0000\u012e\u0003\u0002\u0000;\u0003\u0095\u0000\u0007\u0003\f\u0000\u0005\u0003\u0005\u0000\u0001\u0003\u0001\u0000\n\u0003\u0001\u0000\r\u0003\u0001\u0000\u0005\u0003\u0001\u0000\u0001\u0003\u0001\u0000\u0002\u0003\u0001\u0000\u0002\u0003\u0001\u0000l\u0003!\u0000\u016b\u0003\u0012\u0000@\u0003\u0002\u00006\u0003(\u0000\f\u0003t\u0000\u0005\u0003\u0001\u0000\u0087\u0003\u0013\u0000\n\u0003\u0007\u0000\u001a\u0003\u0006\u0000\u001a\u0003\u000b\u0000Y\u0003\u0003\u0000\u0006\u0003\u0002\u0000\u0006\u0003\u0002\u0000\u0006\u0003\u0002\u0000\u0003\u0003#\u0000";
    private static final char[] ZZ_CMAP = TokenLexer.zzUnpackCMap("\b\u0000\u0002\u0005\u0001\u0006\u0002\u0000\u0001\u0004\u0012\u0000\u0001\u0005\u0001\u0003\u0001\u0002\u0005\u0003\u0001\r\u0001\u000e\u0002\u0003\u0001\n\u0001\u0010\u0001\u0011\u0001\u0003\n\u0012\u0001\u0003\u0001\u000f\u0004\u0003\u0001\u0000\u001a\u0003\u0001\u000b\u0001\u0001\u0001\f\u0001\u0003\u0001\u0007\u0001\u0000\r\u0003\u0001\u0003\u0003\u0003\u0001\u0003\u0001\u0003\u0001\u0003\u0006\u0003\u0001\b\u0001\u0000\u0001\t,\u0000\u0001\u0003\n\u0000\u0001\u0003\u0004\u0000\u0001\u0003\u0005\u0000\u0017\u0003\u0001\u0000\u001f\u0003\u0001\u0000\u013f\u0003\u0019\u0000r\u0003\u0004\u0000\f\u0003\u000e\u0000\u0005\u0003\t\u0000\u0001\u0003\u008b\u0000\u0001\u0003\u000b\u0000\u0001\u0003\u0001\u0000\u0003\u0003\u0001\u0000\u0001\u0003\u0001\u0000\u0014\u0003\u0001\u0000,\u0003\u0001\u0000&\u0003\u0001\u0000\u0005\u0003\u0004\u0000\u0082\u0003\b\u0000E\u0003\u0001\u0000&\u0003\u0002\u0000\u0002\u0003\u0006\u0000\u0010\u0003!\u0000&\u0003\u0002\u0000\u0001\u0003\u0007\u0000'\u0003H\u0000\u001b\u0003\u0005\u0000\u0003\u0003.\u0000\u001a\u0003\u0005\u0000\u000b\u0003\u0015\u0000\n\u0003\u0004\u0000\u0002\u0003\u0001\u0000c\u0003\u0001\u0000\u0001\u0003\u000f\u0000\u0002\u0003\u0007\u0000\u0002\u0003\n\u0003\u0003\u0003\u0002\u0000\u0001\u0003\u0010\u0000\u0001\u0003\u0001\u0000\u001e\u0003\u001d\u0000\u0003\u00030\u0000&\u0003\u000b\u0000\u0001\u0003\u0152\u00006\u0003\u0003\u0000\u0001\u0003\u0012\u0000\u0001\u0003\u0007\u0000\n\u0003\u0004\u0000\n\u0003\u0015\u0000\b\u0003\u0002\u0000\u0002\u0003\u0002\u0000\u0016\u0003\u0001\u0000\u0007\u0003\u0001\u0000\u0001\u0003\u0003\u0000\u0004\u0003\u0003\u0000\u0001\u0003\u001e\u0000\u0002\u0003\u0001\u0000\u0003\u0003\u0004\u0000\n\u0003\u0002\u0003\u0013\u0000\u0006\u0003\u0004\u0000\u0002\u0003\u0002\u0000\u0016\u0003\u0001\u0000\u0007\u0003\u0001\u0000\u0002\u0003\u0001\u0000\u0002\u0003\u0001\u0000\u0002\u0003\u001f\u0000\u0004\u0003\u0001\u0000\u0001\u0003\u0007\u0000\n\u0003\u0002\u0000\u0003\u0003\u0010\u0000\t\u0003\u0001\u0000\u0003\u0003\u0001\u0000\u0016\u0003\u0001\u0000\u0007\u0003\u0001\u0000\u0002\u0003\u0001\u0000\u0005\u0003\u0003\u0000\u0001\u0003\u0012\u0000\u0001\u0003\u000f\u0000\u0002\u0003\u0004\u0000\n\u0003\u0015\u0000\b\u0003\u0002\u0000\u0002\u0003\u0002\u0000\u0016\u0003\u0001\u0000\u0007\u0003\u0001\u0000\u0002\u0003\u0001\u0000\u0005\u0003\u0003\u0000\u0001\u0003\u001e\u0000\u0002\u0003\u0001\u0000\u0003\u0003\u0004\u0000\n\u0003\u0001\u0000\u0001\u0003\u0011\u0000\u0001\u0003\u0001\u0000\u0006\u0003\u0003\u0000\u0003\u0003\u0001\u0000\u0004\u0003\u0003\u0000\u0002\u0003\u0001\u0000\u0001\u0003\u0001\u0000\u0002\u0003\u0003\u0000\u0002\u0003\u0003\u0000\u0003\u0003\u0003\u0000\b\u0003\u0001\u0000\u0003\u0003-\u0000\t\u0003\u0015\u0000\b\u0003\u0001\u0000\u0003\u0003\u0001\u0000\u0017\u0003\u0001\u0000\n\u0003\u0001\u0000\u0005\u0003&\u0000\u0002\u0003\u0004\u0000\n\u0003\u0015\u0000\b\u0003\u0001\u0000\u0003\u0003\u0001\u0000\u0017\u0003\u0001\u0000\n\u0003\u0001\u0000\u0005\u0003\u0003\u0000\u0001\u0003 \u0000\u0001\u0003\u0001\u0000\u0002\u0003\u0004\u0000\n\u0003\u0015\u0000\b\u0003\u0001\u0000\u0003\u0003\u0001\u0000\u0017\u0003\u0001\u0000\u0010\u0003&\u0000\u0002\u0003\u0004\u0000\n\u0003\u0015\u0000\u0012\u0003\u0003\u0000\u0018\u0003\u0001\u0000\t\u0003\u0001\u0000\u0001\u0003\u0002\u0000\u0007\u0003:\u00000\u0003\u0001\u0000\u0002\u0003\f\u0000\u0007\u0003\t\u0000\n\u0003'\u0000\u0002\u0003\u0001\u0000\u0001\u0003\u0002\u0000\u0002\u0003\u0001\u0000\u0001\u0003\u0002\u0000\u0001\u0003\u0006\u0000\u0004\u0003\u0001\u0000\u0007\u0003\u0001\u0000\u0003\u0003\u0001\u0000\u0001\u0003\u0001\u0000\u0001\u0003\u0002\u0000\u0002\u0003\u0001\u0000\u0004\u0003\u0001\u0000\u0002\u0003\t\u0000\u0001\u0003\u0002\u0000\u0005\u0003\u0001\u0000\u0001\u0003\t\u0000\n\u0003\u0002\u0000\u0002\u0003\"\u0000\u0001\u0003\u001f\u0000\n\u0003\u0016\u0000\b\u0003\u0001\u0000\"\u0003\u001d\u0000\u0004\u0003t\u0000\"\u0003\u0001\u0000\u0005\u0003\u0001\u0000\u0002\u0003\u0015\u0000\n\u0003\u0006\u0000\u0006\u0003J\u0000&\u0003\n\u0000)\u0003\u0007\u0000Z\u0003\u0005\u0000D\u0003\u0005\u0000R\u0003\u0006\u0000\u0007\u0003\u0001\u0000?\u0003\u0001\u0000\u0001\u0003\u0001\u0000\u0004\u0003\u0002\u0000\u0007\u0003\u0001\u0000\u0001\u0003\u0001\u0000\u0004\u0003\u0002\u0000'\u0003\u0001\u0000\u0001\u0003\u0001\u0000\u0004\u0003\u0002\u0000\u001f\u0003\u0001\u0000\u0001\u0003\u0001\u0000\u0004\u0003\u0002\u0000\u0007\u0003\u0001\u0000\u0001\u0003\u0001\u0000\u0004\u0003\u0002\u0000\u0007\u0003\u0001\u0000\u0007\u0003\u0001\u0000\u0017\u0003\u0001\u0000\u001f\u0003\u0001\u0000\u0001\u0003\u0001\u0000\u0004\u0003\u0002\u0000\u0007\u0003\u0001\u0000'\u0003\u0001\u0000\u0013\u0003\u000e\u0000\t\u0003.\u0000U\u0003\f\u0000\u026c\u0003\u0002\u0000\b\u0003\n\u0000\u001a\u0003\u0005\u0000K\u0003\u0015\u0000\r\u0003\u0001\u0000\u0004\u0003\u000e\u0000\u0012\u0003\u000e\u0000\u0012\u0003\u000e\u0000\r\u0003\u0001\u0000\u0003\u0003\u000f\u00004\u0003#\u0000\u0001\u0003\u0004\u0000\u0001\u0003\u0003\u0000\n\u0003&\u0000\n\u0003\u0006\u0000X\u0003\b\u0000)\u0003W\u0000\u001d\u0003)\u0000\n\u0003\u001e\u0003\u0002\u0000\u0005\u0003\u038b\u0000l\u0003\u0094\u0000\u009c\u0003\u0004\u0000Z\u0003\u0006\u0000\u0016\u0003\u0002\u0000\u0006\u0003\u0002\u0000&\u0003\u0002\u0000\u0006\u0003\u0002\u0000\b\u0003\u0001\u0000\u0001\u0003\u0001\u0000\u0001\u0003\u0001\u0000\u0001\u0003\u0001\u0000\u001f\u0003\u0002\u00005\u0003\u0001\u0000\u0007\u0003\u0001\u0000\u0001\u0003\u0003\u0000\u0003\u0003\u0001\u0000\u0007\u0003\u0003\u0000\u0004\u0003\u0002\u0000\u0006\u0003\u0004\u0000\r\u0003\u0005\u0000\u0003\u0003\u0001\u0000\u0007\u0003t\u0000\u0001\u0003\r\u0000\u0001\u0003\u0082\u0000\u0001\u0003\u0004\u0000\u0001\u0003\u0002\u0000\n\u0003\u0001\u0000\u0001\u0003\u0003\u0000\u0005\u0003\u0006\u0000\u0001\u0003\u0001\u0000\u0001\u0003\u0001\u0000\u0001\u0003\u0001\u0000\u0004\u0003\u0001\u0000\u0003\u0003\u0001\u0000\u0007\u0003\u0003\u0000\u0003\u0003\u0005\u0000\u0005\u0003\u0ebb\u0000\u0002\u0003*\u0000\u0005\u0003\u0005\u0000\u0002\u0003\u0004\u0000V\u0003\u0006\u0000\u0003\u0003\u0001\u0000Z\u0003\u0001\u0000\u0004\u0003\u0005\u0000(\u0003\u0004\u0000^\u0003\u0011\u0000\u0018\u00038\u0000\u0010\u0003\u0200\u0000\u19b6\u0003J\u0000\u51a6\u0003Z\u0000\u048d\u0003\u0773\u0000\u2ba4\u0003\u215c\u0000\u012e\u0003\u0002\u0000;\u0003\u0095\u0000\u0007\u0003\f\u0000\u0005\u0003\u0005\u0000\u0001\u0003\u0001\u0000\n\u0003\u0001\u0000\r\u0003\u0001\u0000\u0005\u0003\u0001\u0000\u0001\u0003\u0001\u0000\u0002\u0003\u0001\u0000\u0002\u0003\u0001\u0000l\u0003!\u0000\u016b\u0003\u0012\u0000@\u0003\u0002\u00006\u0003(\u0000\f\u0003t\u0000\u0005\u0003\u0001\u0000\u0087\u0003\u0013\u0000\n\u0003\u0007\u0000\u001a\u0003\u0006\u0000\u001a\u0003\u000b\u0000Y\u0003\u0003\u0000\u0006\u0003\u0002\u0000\u0006\u0003\u0002\u0000\u0006\u0003\u0002\u0000\u0003\u0003#\u0000");
    private static final int[] ZZ_ACTION = TokenLexer.zzUnpackAction();
    private static final String ZZ_ACTION_PACKED_0 = "\u0001\u0000\u0001\u0001\u0001\u0000\u0001\u0002\u0001\u0003\u0001\u0004\u0002\u0005\u0001\u0002\u0001\u0006\u0001\u0007\u0001\b\u0001\t\u0001\n\u0001\u000b\u0001\f\u0001\r\u0002\u0004\u0001\u000e\u0001\u0001\u0001\u000f\u0001\u0010\u0001\u0011\u0002\u0010\u0001\u0000\u0001\u0012\u0001\u0000\u0001\u0013\u0001\u0014\u0001\u0015\u0001\u0016";
    private static final int ZZ_UNKNOWN_ERROR = 0;
    private static final int ZZ_NO_MATCH = 1;
    private static final int ZZ_PUSHBACK_2BIG = 2;
    private static final String[] ZZ_ERROR_MSG = new String[]{"Unkown internal scanner error", "Error: could not match input", "Error: pushback value was too large"};
    private Reader zzReader;
    private int zzState;
    private int zzLexicalState = 0;
    private char[] zzBuffer = new char[16384];
    private int zzMarkedPos;
    private int zzCurrentPos;
    private int zzStartRead;
    private int zzEndRead;
    private int yyline;
    private int yychar;
    private int yycolumn;
    private boolean zzAtBOL = true;
    private boolean zzAtEOF;
    private boolean zzEOFDone;
    private final TokenMapper tokenMapper;
    private final String fileName;
    private final boolean allowRemovedPrimitives;
    private StringBuilder literalBuilder = null;
    private int literalStart = -1;
    private int literalNestingLevel = 0;
    private static final TokenType TokenType_EOF = TokenLexer.getTokenType("EOF");
    private static final TokenType TokenType_OPEN_PAREN = TokenLexer.getTokenType("OPEN_PAREN");
    private static final TokenType TokenType_CLOSE_PAREN = TokenLexer.getTokenType("CLOSE_PAREN");
    private static final TokenType TokenType_OPEN_BRACKET = TokenLexer.getTokenType("OPEN_BRACKET");
    private static final TokenType TokenType_CLOSE_BRACKET = TokenLexer.getTokenType("CLOSE_BRACKET");
    private static final TokenType TokenType_OPEN_BRACE = TokenLexer.getTokenType("OPEN_BRACE");
    private static final TokenType TokenType_CLOSE_BRACE = TokenLexer.getTokenType("CLOSE_BRACE");
    private static final TokenType TokenType_CONSTANT = TokenLexer.getTokenType("CONSTANT");
    private static final TokenType TokenType_IDENT = TokenLexer.getTokenType("IDENT");
    private static final TokenType TokenType_COMMAND = TokenLexer.getTokenType("COMMAND");
    private static final TokenType TokenType_REPORTER = TokenLexer.getTokenType("REPORTER");
    private static final TokenType TokenType_KEYWORD = TokenLexer.getTokenType("KEYWORD");
    private static final TokenType TokenType_COMMA = TokenLexer.getTokenType("COMMA");
    private static final TokenType TokenType_COMMENT = TokenLexer.getTokenType("COMMENT");
    private static final TokenType TokenType_VARIABLE = TokenLexer.getTokenType("VARIABLE");
    private static final TokenType TokenType_BAD = TokenLexer.getTokenType("BAD");
    private static final TokenType TokenType_LITERAL = TokenLexer.getTokenType("LITERAL");

    private static int[] zzUnpackAction() {
        int[] result = new int[33];
        int offset = 0;
        offset = TokenLexer.zzUnpackAction(ZZ_ACTION_PACKED_0, offset, result);
        return result;
    }

    private static int zzUnpackAction(String packed, int offset, int[] result) {
        int i = 0;
        int j = offset;
        int l = packed.length();
        while (i < l) {
            int count2 = packed.charAt(i++);
            char value = packed.charAt(i++);
            do {
                result[j++] = value;
            } while (--count2 > 0);
        }
        return j;
    }

    private static TokenType getTokenType(String name) {
        try {
            return (TokenType)Class.forName("org.nlogo.api.TokenType$" + name + "$").getField("MODULE$").get(null);
        }
        catch (IllegalAccessException ex) {
            throw new IllegalStateException(ex);
        }
        catch (NoSuchFieldException ex) {
            throw new IllegalStateException(ex);
        }
        catch (ClassNotFoundException ex) {
            throw new IllegalStateException(ex);
        }
    }

    void beginLiteral() {
        this.literalStart = this.yychar;
        this.literalBuilder = new StringBuilder();
    }

    void addToLiteral() {
        this.literalBuilder.append(this.yytext());
    }

    Token endLiteral() {
        String text = this.literalBuilder.toString();
        this.literalBuilder = null;
        return new Token(text, TokenType_LITERAL, text, this.literalStart, this.literalStart + text.length(), this.fileName);
    }

    Token ident() {
        String text = this.yytext();
        if (this.tokenMapper.isKeyword(text)) {
            return new Token(text, TokenType_KEYWORD, text.toUpperCase(), this.yychar, this.yychar + text.length(), this.fileName);
        }
        if (this.tokenMapper.isCommand(text.toUpperCase()) && (this.allowRemovedPrimitives || !this.tokenMapper.wasRemoved(text.toUpperCase()))) {
            TokenHolder instr = this.tokenMapper.getCommand(text);
            Token tok = new Token(text, TokenType_COMMAND, instr, this.yychar, this.yychar + text.length(), this.fileName);
            instr.token(tok);
            return tok;
        }
        if (this.tokenMapper.isReporter(text) && (this.allowRemovedPrimitives || !this.tokenMapper.wasRemoved(text.toUpperCase()))) {
            TokenHolder instr = this.tokenMapper.getReporter(text);
            Token tok = new Token(text, TokenType_REPORTER, instr, this.yychar, this.yychar + text.length(), this.fileName);
            instr.token(tok);
            return tok;
        }
        if (this.tokenMapper.isVariable(text)) {
            return new Token(text, TokenType_VARIABLE, text.toUpperCase(), this.yychar, this.yychar + text.length(), this.fileName);
        }
        if (this.tokenMapper.isConstant(text)) {
            return new Token(text, TokenType_CONSTANT, this.tokenMapper.getConstant(text), this.yychar, this.yychar + text.length(), this.fileName);
        }
        return new Token(text, TokenType_IDENT, text.toUpperCase(), this.yychar, this.yychar + text.length(), this.fileName);
    }

    TokenLexer(Reader in, TokenMapper tokenMapper, String fileName, boolean allowRemovedPrimitives) {
        this.tokenMapper = tokenMapper;
        this.fileName = fileName;
        this.allowRemovedPrimitives = allowRemovedPrimitives;
        this.zzReader = in;
    }

    TokenLexer(InputStream in, TokenMapper tokenMapper, String fileName, boolean allowRemovedPrimitives) {
        this(new InputStreamReader(in), tokenMapper, fileName, allowRemovedPrimitives);
    }

    private static char[] zzUnpackCMap(String packed) {
        char[] map2 = new char[65536];
        int i = 0;
        int j = 0;
        while (i < 1248) {
            int count2 = packed.charAt(i++);
            char value = packed.charAt(i++);
            do {
                map2[j++] = value;
            } while (--count2 > 0);
        }
        return map2;
    }

    private boolean zzRefill() throws IOException {
        int numRead;
        if (this.zzStartRead > 0) {
            System.arraycopy(this.zzBuffer, this.zzStartRead, this.zzBuffer, 0, this.zzEndRead - this.zzStartRead);
            this.zzEndRead -= this.zzStartRead;
            this.zzCurrentPos -= this.zzStartRead;
            this.zzMarkedPos -= this.zzStartRead;
            this.zzStartRead = 0;
        }
        if (this.zzCurrentPos >= this.zzBuffer.length) {
            char[] newBuffer = new char[this.zzCurrentPos * 2];
            System.arraycopy(this.zzBuffer, 0, newBuffer, 0, this.zzBuffer.length);
            this.zzBuffer = newBuffer;
        }
        if ((numRead = this.zzReader.read(this.zzBuffer, this.zzEndRead, this.zzBuffer.length - this.zzEndRead)) > 0) {
            this.zzEndRead += numRead;
            return false;
        }
        if (numRead == 0) {
            int c = this.zzReader.read();
            if (c == -1) {
                return true;
            }
            this.zzBuffer[this.zzEndRead++] = (char)c;
            return false;
        }
        return true;
    }

    public final void yyclose() throws IOException {
        this.zzAtEOF = true;
        this.zzEndRead = this.zzStartRead;
        if (this.zzReader != null) {
            this.zzReader.close();
        }
    }

    public final void yyreset(Reader reader) {
        this.zzReader = reader;
        this.zzAtBOL = true;
        this.zzAtEOF = false;
        this.zzEOFDone = false;
        this.zzStartRead = 0;
        this.zzEndRead = 0;
        this.zzMarkedPos = 0;
        this.zzCurrentPos = 0;
        this.yycolumn = 0;
        this.yychar = 0;
        this.yyline = 0;
        this.zzLexicalState = 0;
    }

    public final int yystate() {
        return this.zzLexicalState;
    }

    public final void yybegin(int newState) {
        this.zzLexicalState = newState;
    }

    public final String yytext() {
        return new String(this.zzBuffer, this.zzStartRead, this.zzMarkedPos - this.zzStartRead);
    }

    public final char yycharat(int pos) {
        return this.zzBuffer[this.zzStartRead + pos];
    }

    public final int yylength() {
        return this.zzMarkedPos - this.zzStartRead;
    }

    private void zzScanError(int errorCode) {
        String message;
        try {
            message = ZZ_ERROR_MSG[errorCode];
        }
        catch (ArrayIndexOutOfBoundsException e) {
            message = ZZ_ERROR_MSG[0];
        }
        throw new Error(message);
    }

    public void yypushback(int number) {
        if (number > this.yylength()) {
            this.zzScanError(2);
        }
        this.zzMarkedPos -= number;
    }

    public Token yylex() throws IOException {
        int zzEndReadL = this.zzEndRead;
        char[] zzBufferL = this.zzBuffer;
        char[] zzCMapL = ZZ_CMAP;
        block145: while (true) {
            int zzInput;
            int zzMarkedPosL = this.zzMarkedPos;
            this.yychar += zzMarkedPosL - this.zzStartRead;
            int zzAction = -1;
            this.zzCurrentPos = this.zzStartRead = zzMarkedPosL;
            int zzCurrentPosL = this.zzStartRead;
            this.zzState = ZZ_LEXSTATE[this.zzLexicalState];
            block146: while (true) {
                if (zzCurrentPosL < zzEndReadL) {
                    zzInput = zzBufferL[zzCurrentPosL++];
                } else {
                    if (this.zzAtEOF) {
                        zzInput = -1;
                        break;
                    }
                    this.zzCurrentPos = zzCurrentPosL;
                    this.zzMarkedPos = zzMarkedPosL;
                    boolean eof = this.zzRefill();
                    zzCurrentPosL = this.zzCurrentPos;
                    zzMarkedPosL = this.zzMarkedPos;
                    zzBufferL = this.zzBuffer;
                    zzEndReadL = this.zzEndRead;
                    if (eof) {
                        zzInput = -1;
                        break;
                    }
                    zzInput = zzBufferL[zzCurrentPosL++];
                }
                zzInput = zzCMapL[zzInput];
                boolean zzIsFinal = false;
                boolean zzNoLookAhead = false;
                block1 : switch (this.zzState) {
                    case 0: {
                        switch (zzInput) {
                            case 2: {
                                zzIsFinal = true;
                                this.zzState = 4;
                                break block1;
                            }
                            case 3: {
                                zzIsFinal = true;
                                this.zzState = 5;
                                break block1;
                            }
                            case 4: {
                                zzIsFinal = true;
                                zzNoLookAhead = true;
                                this.zzState = 6;
                                break block1;
                            }
                            case 5: 
                            case 6: {
                                zzIsFinal = true;
                                this.zzState = 7;
                                break block1;
                            }
                            case 7: {
                                zzIsFinal = true;
                                this.zzState = 8;
                                break block1;
                            }
                            case 8: {
                                zzIsFinal = true;
                                this.zzState = 9;
                                break block1;
                            }
                            case 9: {
                                zzIsFinal = true;
                                zzNoLookAhead = true;
                                this.zzState = 10;
                                break block1;
                            }
                            case 10: {
                                zzIsFinal = true;
                                zzNoLookAhead = true;
                                this.zzState = 11;
                                break block1;
                            }
                            case 11: {
                                zzIsFinal = true;
                                zzNoLookAhead = true;
                                this.zzState = 12;
                                break block1;
                            }
                            case 12: {
                                zzIsFinal = true;
                                zzNoLookAhead = true;
                                this.zzState = 13;
                                break block1;
                            }
                            case 13: {
                                zzIsFinal = true;
                                zzNoLookAhead = true;
                                this.zzState = 14;
                                break block1;
                            }
                            case 14: {
                                zzIsFinal = true;
                                zzNoLookAhead = true;
                                this.zzState = 15;
                                break block1;
                            }
                            case 15: {
                                zzIsFinal = true;
                                this.zzState = 16;
                                break block1;
                            }
                            case 16: {
                                zzIsFinal = true;
                                this.zzState = 17;
                                break block1;
                            }
                            case 17: {
                                zzIsFinal = true;
                                this.zzState = 18;
                                break block1;
                            }
                            case 18: {
                                zzIsFinal = true;
                                this.zzState = 19;
                                break block1;
                            }
                        }
                        zzIsFinal = true;
                        zzNoLookAhead = true;
                        this.zzState = 3;
                        break;
                    }
                    case 1: {
                        switch (zzInput) {
                            case 3: 
                            case 7: 
                            case 16: 
                            case 17: 
                            case 18: {
                                zzIsFinal = true;
                                this.zzState = 20;
                                break block1;
                            }
                            case 6: {
                                zzIsFinal = true;
                                zzNoLookAhead = true;
                                this.zzState = 21;
                                break block1;
                            }
                        }
                        zzIsFinal = true;
                        zzNoLookAhead = true;
                        this.zzState = 3;
                        break;
                    }
                    case 2: {
                        switch (zzInput) {
                            case 6: {
                                zzIsFinal = true;
                                zzNoLookAhead = true;
                                this.zzState = 23;
                                break block1;
                            }
                            case 8: {
                                zzIsFinal = true;
                                this.zzState = 24;
                                break block1;
                            }
                            case 9: {
                                zzIsFinal = true;
                                this.zzState = 25;
                                break block1;
                            }
                        }
                        zzIsFinal = true;
                        zzNoLookAhead = true;
                        this.zzState = 22;
                        break;
                    }
                    case 4: {
                        switch (zzInput) {
                            case 1: {
                                this.zzState = 26;
                                break;
                            }
                            case 2: {
                                zzIsFinal = true;
                                zzNoLookAhead = true;
                                this.zzState = 27;
                                break;
                            }
                            case 4: 
                            case 6: {
                                break block146;
                            }
                            default: {
                                zzIsFinal = true;
                                break;
                            }
                        }
                        break;
                    }
                    case 5: {
                        switch (zzInput) {
                            case 3: 
                            case 7: 
                            case 16: 
                            case 17: 
                            case 18: {
                                zzIsFinal = true;
                                break block1;
                            }
                        }
                        break block146;
                    }
                    case 7: {
                        switch (zzInput) {
                            case 5: 
                            case 6: {
                                zzIsFinal = true;
                                break block1;
                            }
                        }
                        break block146;
                    }
                    case 8: {
                        switch (zzInput) {
                            case 3: 
                            case 16: 
                            case 17: 
                            case 18: {
                                zzIsFinal = true;
                                this.zzState = 5;
                                break block1;
                            }
                            case 7: {
                                this.zzState = 28;
                                break block1;
                            }
                        }
                        break block146;
                    }
                    case 9: {
                        switch (zzInput) {
                            case 8: {
                                zzIsFinal = true;
                                zzNoLookAhead = true;
                                this.zzState = 29;
                                break block1;
                            }
                        }
                        break block146;
                    }
                    case 16: {
                        switch (zzInput) {
                            case 6: {
                                break block146;
                            }
                            default: {
                                zzIsFinal = true;
                                break;
                            }
                        }
                        break;
                    }
                    case 17: {
                        switch (zzInput) {
                            case 3: 
                            case 7: 
                            case 16: {
                                zzIsFinal = true;
                                this.zzState = 5;
                                break block1;
                            }
                            case 17: {
                                zzIsFinal = true;
                                this.zzState = 18;
                                break block1;
                            }
                            case 18: {
                                zzIsFinal = true;
                                this.zzState = 19;
                                break block1;
                            }
                        }
                        break block146;
                    }
                    case 18: {
                        switch (zzInput) {
                            case 3: 
                            case 7: 
                            case 16: 
                            case 17: {
                                zzIsFinal = true;
                                this.zzState = 5;
                                break block1;
                            }
                            case 18: {
                                zzIsFinal = true;
                                this.zzState = 19;
                                break block1;
                            }
                        }
                        break block146;
                    }
                    case 19: {
                        switch (zzInput) {
                            case 3: 
                            case 7: 
                            case 16: 
                            case 17: 
                            case 18: {
                                zzIsFinal = true;
                                break block1;
                            }
                        }
                        break block146;
                    }
                    case 20: {
                        switch (zzInput) {
                            case 3: 
                            case 7: 
                            case 16: 
                            case 17: 
                            case 18: {
                                zzIsFinal = true;
                                break block1;
                            }
                        }
                        break block146;
                    }
                    case 24: {
                        switch (zzInput) {
                            case 8: {
                                zzIsFinal = true;
                                zzNoLookAhead = true;
                                this.zzState = 30;
                                break block1;
                            }
                        }
                        break block146;
                    }
                    case 25: {
                        switch (zzInput) {
                            case 9: {
                                zzIsFinal = true;
                                zzNoLookAhead = true;
                                this.zzState = 31;
                                break block1;
                            }
                        }
                        break block146;
                    }
                    case 26: {
                        switch (zzInput) {
                            default: 
                        }
                        zzIsFinal = true;
                        this.zzState = 4;
                        break;
                    }
                    case 28: {
                        switch (zzInput) {
                            case 3: 
                            case 16: 
                            case 17: 
                            case 18: {
                                zzIsFinal = true;
                                this.zzState = 5;
                                break block1;
                            }
                            case 7: {
                                zzIsFinal = true;
                                zzNoLookAhead = true;
                                this.zzState = 32;
                                break block1;
                            }
                        }
                        break block146;
                    }
                    default: {
                        this.zzScanError(0);
                    }
                }
                if (!zzIsFinal) continue;
                zzAction = this.zzState;
                zzMarkedPosL = zzCurrentPosL;
                if (zzNoLookAhead) break;
            }
            this.zzMarkedPos = zzMarkedPosL;
            switch (zzAction < 0 ? zzAction : ZZ_ACTION[zzAction]) {
                case 16: {
                    this.addToLiteral();
                }
                case 23: {
                    continue block145;
                }
                case 19: {
                    this.yybegin(4);
                    this.beginLiteral();
                    this.addToLiteral();
                    this.literalNestingLevel = 0;
                }
                case 24: {
                    continue block145;
                }
                case 14: {
                    String text = this.yytext();
                    Either<String, Double> result = NumberParser.parse(text);
                    TokenType resultType = result.isLeft() ? TokenType_BAD : TokenType_CONSTANT;
                    Serializable resultValue = result.isLeft() ? (Serializable)((Object)result.left().get()) : (Serializable)result.right().get();
                    return new Token(text, resultType, resultValue, this.yychar, this.yychar + text.length(), this.fileName);
                }
                case 25: {
                    continue block145;
                }
                case 15: {
                    this.yybegin(0);
                }
                case 26: {
                    continue block145;
                }
                case 4: {
                    return this.ident();
                }
                case 27: {
                    continue block145;
                }
                case 8: {
                    return new Token(this.yytext(), TokenType_COMMA, null, this.yychar, this.yychar + 1, this.fileName);
                }
                case 28: {
                    continue block145;
                }
                case 7: {
                    return new Token(this.yytext(), TokenType_CLOSE_BRACE, null, this.yychar, this.yychar + 1, this.fileName);
                }
                case 29: {
                    continue block145;
                }
                case 20: {
                    ++this.literalNestingLevel;
                    this.addToLiteral();
                }
                case 30: {
                    continue block145;
                }
                case 3: {
                    String text = this.yytext();
                    return new Token(text, TokenType_BAD, "Closing double quote is missing", this.yychar, this.yychar + this.yytext().length(), this.fileName);
                }
                case 31: {
                    continue block145;
                }
                case 13: {
                    String text = this.yytext();
                    return new Token(text, TokenType_COMMENT, null, this.yychar, this.yychar + text.length(), this.fileName);
                }
                case 32: {
                    continue block145;
                }
                case 10: {
                    return new Token(this.yytext(), TokenType_CLOSE_BRACKET, null, this.yychar, this.yychar + 1, this.fileName);
                }
                case 33: {
                    continue block145;
                }
                case 2: {
                    String text = this.yytext();
                    return new Token(text, TokenType_BAD, "This non-standard character is not allowed.", this.yychar, this.yychar + 1, this.fileName);
                }
                case 34: {
                    continue block145;
                }
                case 18: {
                    String text = this.yytext();
                    try {
                        return new Token(text, TokenType_CONSTANT, StringUtils.unEscapeString(text.substring(1, text.length() - 1)), this.yychar, this.yychar + text.length(), this.fileName);
                    }
                    catch (IllegalArgumentException ex) {
                        return new Token(text, TokenType_BAD, "Illegal character after backslash", this.yychar, this.yychar + text.length(), this.fileName);
                    }
                }
                case 35: {
                    continue block145;
                }
                case 22: {
                    this.yybegin(2);
                    TokenHolder cmd = this.tokenMapper.getCommand("__magic-open");
                    Token token = new Token("__magic-open", TokenType_COMMAND, cmd, this.yychar, this.yychar + 3, this.fileName);
                    cmd.token(token);
                    return token;
                }
                case 36: {
                    continue block145;
                }
                case 21: {
                    this.addToLiteral();
                    if (this.literalNestingLevel == 0) {
                        this.yybegin(0);
                        return this.endLiteral();
                    }
                    --this.literalNestingLevel;
                }
                case 37: {
                    continue block145;
                }
                case 12: {
                    return new Token(this.yytext(), TokenType_CLOSE_PAREN, null, this.yychar, this.yychar + 1, this.fileName);
                }
                case 38: {
                    continue block145;
                }
                case 1: {
                    String text = this.yytext();
                    this.yybegin(0);
                    return new Token("\"" + text + "\"", TokenType_CONSTANT, text, this.yychar, this.yychar + text.length(), this.fileName);
                }
                case 39: {
                    continue block145;
                }
                case 6: {
                    return new Token(this.yytext(), TokenType_OPEN_BRACE, null, this.yychar, this.yychar + 1, this.fileName);
                }
                case 40: {
                    continue block145;
                }
                case 17: {
                    this.yybegin(0);
                    return new Token("", TokenType_BAD, "End of line reached unexpectedly", this.yychar, this.yychar, this.fileName);
                }
                case 41: {
                    continue block145;
                }
                case 11: {
                    return new Token(this.yytext(), TokenType_OPEN_PAREN, null, this.yychar, this.yychar + 1, this.fileName);
                }
                case 42: {
                    continue block145;
                }
                case 5: 
                case 43: {
                    continue block145;
                }
                case 9: {
                    return new Token(this.yytext(), TokenType_OPEN_BRACKET, null, this.yychar, this.yychar + 1, this.fileName);
                }
                case 44: {
                    continue block145;
                }
            }
            if (zzInput == -1 && this.zzStartRead == this.zzCurrentPos) {
                this.zzAtEOF = true;
                switch (this.zzLexicalState) {
                    case 4: {
                        this.yybegin(0);
                        return new Token("", TokenType_BAD, "End of file reached unexpectedly", this.yychar, this.yychar, this.fileName);
                    }
                    case 34: {
                        continue block145;
                    }
                }
                return null;
            }
            this.zzScanError(1);
        }
    }
}

